/* rcsid[]="$Header: isvar.h,v 820.1 86/12/04 19:55:48 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1985				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Interphase 2190/Storager driver global definitions.
 */

/*
 * Per controller information
 */
struct is_ctlr {
	char ic_opened;			/* controller has been opened */
	u_char ic_storager;		/* 0 if 2190, 1 if Storager */
	char ic_busy;			/* controller is busy */
	char ic_busy1;			/* ditto, for Storager 2nd reg set */
	char ic_unit;			/* which unit is active, if busy */
	char ic_unit1;			/* ditto, for Storager 2nd reg set */
	int ic_ctlr;			/* controller number */
	struct is_device *ic_addr;	/* controller address */
	struct is_device *ic_addr1;	/* second controller register set,
					   Storager only */
	struct is_param ic_param;	/* per-controller parameter block */
					/* called `iopb' by Interphase */
	struct is_param ic_param1;	/* ditto, for Storager 2nd reg set */
#define IP (ic->ic_param)		/* shorthand for current param block */
#define IP1 (ic->ic_param1)		/* ditto, for Storager 2nd reg set */
	int ic_ndisk;			/* number of disks attached */
	int ic_ntape;			/* number of tapes attached, Storager */
	struct is_disk *ic_disk;	/* linked list of is_disks */
	struct is_tape *ic_tape;	/* linked list of is_tapes */
};


#ifdef ISERRORLOGGING
/*
 * Handydandies for the logging of disk errors according to Ed & Ross' 
 * criteria of 4/21/1986.
 */
#define IPERR_NCLASSES	3
#define IPERR_CLASS1	0
#define IPERR_CLASS2	1
#define IPERR_CLASS3	2
#endif ISERRORLOGGING

/*
 * Per disk information (optional Error-logging stuff included.
 */
struct is_disk {
	int id_ncyl;			/* cylinders, including alternates */
	int id_nhead;			/* number of heads */
	int id_nsec;			/* number of sectors per track */
	int id_nsecpercyl;		/* sectors per cylinder */
	int id_acyl;			/* number of alternate cylinders */
	int id_a_alloc;			/* number of alt tracks allocated */
	int id_gap1;			/* gap 1 (for formatting) */
	int id_gap2;			/* gap 2 (for formatting) */
	int id_intrlv;			/* interleave factor */
	int id_group;			/* group size */
	int id_skew;			/* skew factor */
	char id_cache;			/* cache mode */
	/* begin Storager only fields */
	u_char id_zerolatency;	/* zero latency mode */
	u_char id_drivedesc;	/* Storager uib drive descriptor byte */
	int id_gap3;		/* gap3 size */
	u_char id_bufstep;	/* does drive accept buffered steps? */
	u_char id_stepwidth;	/* step pulse width */
	int id_stepinter;	/* step pulse interval */
	u_char id_headloadtime;	/* head load time */
	u_char id_seektime;	/* track to track seek time */
	u_short id_precomp;	/* write precompensation starting cylinder */
	u_short id_redwrite;	/* reduced write current starting cylinder */
	/* end Storager only */
	struct dk_sizes id_sizes[DK_NSIZES];	/* disk partition table */
	struct buf id_tab;		/* disk ops pending on this drive */
	struct buf id_rbuf;		/* raw io header */
	int id_cyl;			/* current cylinder, for seeking */
	int id_unit;			/* unit number */
	u_char id_err;			/* last controller error */
	struct mb_device *id_md;
	struct is_ctlr *id_ic;		/* points to our controller */
	struct is_disk *id_link;	/* next disk linked to our controller */
#ifdef ISERRORLOGGING
	/*
	 * For storing error totals on a per-disk basis.
	 */
	int isSoftErrors;
	int isFirmErrors[IPERR_NCLASSES];
	int isHardErrors[IPERR_NCLASSES];
#endif ISERRORLOGGING

};

#define id_active id_tab.b_active
#define id_actf id_tab.b_actf
#define id_errcnt id_tab.b_errcnt

/*
 * Id_active contains the state information for overlapped
 * seeks.  As usual, id_active == 0 means not busy.
 */
#define ACTIVE_SEEK		1	/* seeking on drive */
#define ACTIVE_SEEKDONE		2	/* seek done, ready for transfer */
#define ACTIVE_IO		3	/* transfering data */
#define ACTIVE_CMD		4	/* non-data xfer command */

/*
 * Per tape information
 */
struct is_tape {
	struct buf it_rbuf;		/* raw io header */
	int it_active;			/* tape active */
	int it_errcnt;			/* error count */
	int it_unit;			/* unit number */
	u_char it_open;			/* is open */
	u_char it_err;			/* can't recover from last error */
	u_char it_lastiow;		/* last io was a write */
	u_char it_lasterr;		/* error field of last command run */
	daddr_t it_blkno;		/* current block number */
	daddr_t it_nxrec;		/* eof position, if known */
	struct mb_device *it_md;	/* our multibus device */
	struct is_ctlr *it_ic;		/* points to our controller */
	struct is_tape *it_link;	/* next tape linked to our controller */
	struct buf *it_actf;		/* first tape op pending */
	struct buf *it_actl;		/* last tape op pending */
};

/*
 * It_active contains the state information.
 * As usual, it_active == 0 means not busy.
 */
#define ACTIVE_TCMD	1	/* non data-transfer command on drive */
#define ACTIVE_TSICMD	2	/* waiting for status change interrupt */
#define ACTIVE_TIO	3	/* transfering data */


/*
 * We have a problem here, as 2190 and Storager controllers come in
 * at different interrupt levels.  Thus the following.
 */
#define splIS() spl5()


/*
 * Interface to autoconf() and globals.
 */

int isfirstreset(), isprobe(), isslave(), idattach(), itattach();
extern struct mb_ctlr *iscinfo[];
extern struct is_ctlr is_ctlr[];
extern struct is_disk is_disk[];		/* per disk structures */
extern struct is_tape is_tape[];		/* per tape structures */
extern struct mb_device *idinfo[];		/* disk info */
extern struct mb_device *itinfo[];		/* tape info */

extern struct buf iscbuf;			/* buffer for polled commands */

char *is_error();				/* error messages */

	/* debug flags */

#ifdef DEBUG
extern char isdebug;
extern char isidebug;		/* print isintr() actions */
extern char issdebug;		/* print operation in isustart() */
extern char isrdebug;
extern char iscdebug;
extern char isudebug;

extern char isintdebug;
extern char isint1debug;
extern char isint2debug;
extern char isaltdebug;

/*
 * for logging commands
 */

#define IS_NLOG 100
extern u_long is_log[];
extern u_long *is_logp;
#define ISLOG(op, unit, csr) ( \
	is_logp >= is_log+IS_NLOG ? (is_logp = is_log) : 0, \
	(*is_logp++ = (op) << 16 | (unit) << 8 | (csr)))
#else
#define isdebug 0
#define isidebug 0
#define issdebug 0
#define isrdebug 0
#define iscdebug 0
#define isudebug 0
#define ISLOG(op, unit, csr)	0
#endif


	/* tunable constants */

#define RPS 	60			/* should be drive dependent */
#define IS_DMA	64			/* DMA burst */
#define ISTIMEOUTDELAY 100000000	/* how long delay before timing out */

extern char isautomap;			/* automagically map bad tracks */
extern char isforce_open;		/* allow opening unfmtted disk (2190)*/
extern int isretrycnt;			/* software retry count */
extern int isdelayamt;			/* delay after csr read until CLRI */

