static char rcsid[] = "$Header: circbuf.c,v 820.1 86/12/04 19:55:08 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

#include "../s32dev/circbuf.h"
#define CB1PRI 26
#define CB2PRI 26

/*	this version is simpler and more comprehensive,
/*	but it makes intermediate states visible during wrap around.
/*cb1put(cbp,p,l)
/*register struct cb1 *cbp;
/*char *p;
/*register int l;
/*{
/*	while (l>0) {
/*		register int n=cb1room(cbp);
/*		if (n==0) sleep(cbp,CB1PRI);
/*		if (n>l) n=l;
/*		bcopy(p,cbp->cb1buf+cbp->cb1in,n); p+=n; l-=n;
/*		if (256<=(n+=cbp->cb1in)) n=2;  /* wrap-around */
/*		cbp->cb1in=n;
/*	}
/*}
*/

/*	this version is "atomic"; l bytes had better fit.
*/
cb1put(cbp,p,l)
register struct cb1 *cbp;
char *p;
register int l;
{
	register int in=cbp->cb1in;
	while (l>0) {
		register int n=cbp->cb1out-in;
		if (n<=0) n+=256-2;
		/* n==# of chars which would exactly over-fill the buffer */
		--n;
		if (256<(n+in)) n=256-in;  /* wrap-around */
		if (n==0) sleep(cbp,CB1PRI);
		if (n>l) n=l;
		bcopy(p,cbp->cb1buf+in,n); p+=n; l-=n;
		if (256<=(n+=in)) n=2;  /* wrap-around */
		in=n;
	}
	cbp->cb1in=in;
}

cb1get(cbp,p,l)
register struct cb1 *cbp;
char *p;
register int l;
{
	while (l>0) {
		register int n;
		while (0==(n=cbp->cb1in-cbp->cb1out)) sleep(cbp,CB1PRI);
		if (n<0) n=256-cbp->cb1out;  /* wrap-around */
		if (n>l) n=l;
		bcopy(cbp->cb1buf+cbp->cb1out,p,n); p+=n; l-=n;
		if (256<=(n+=cbp->cb1out)) n=2;  /* wrap-around */
		cbp->cb1out=n;
	}
}

cb1peek(cbp,p,l)
register struct cb1 *cbp;
char *p;
register int l;
{
	register int out=cbp->cb1out;
	while (l>0) {
		register int n;
		while (0==(n=cbp->cb1in-out)) sleep(cbp,CB1PRI);
		if (n<0) n=256-out;  /* wrap-around */
		if (n>l) n=l;
		bcopy(cbp->cb1buf+out,p,n); p+=n; l-=n;
		if (256<=(n+=out)) n=2;  /* wrap-around */
		out=n;
	}
}


/* returns number of characters which can be inserted without wrapping */
int
cb1room(cbp)
register struct cb1 *cbp;
{
	register int n=cbp->cb1out-cbp->cb1in;
	if (n<=0) n+=256-2;
	/* n==# of chars which would exactly over-fill the buffer */
	--n;
	if (256<(n+cbp->cb1in)) n=256-cbp->cb1in;  /* wrap-around */
	return(n);
}

/* returns number of characters in buffer */
int
cb1full(cbp)
register struct cb1 *cbp;
{
	register int n=cbp->cb1in-cbp->cb1out;
	if (n<0) n+=256-2;
	return(n);
}

/*	this version is simpler and more comprehensive,
/*	but it makes intermediate states visible during wrap around.
/*cb2put(cbp,p,l)
/*register union cb2 *cbp;
/*char *p;
/*register int l;
/*{
/*	while (l>0) {
/*		register int n=cb2room(cbp);
/*		if (n==0) sleep(cbp,CB2PRI);
/*		if (n>l) n=l;
/*		bcopy(p,cbp->cb2buf+cbp->cb2in,n); p+=n; l-=n;
/*		if (cbp->cb2lwa<=(n+=cbp->cb2in)) n=cbp->cb2fwa;  /* off end */
/*		cbp->cb2in=n;
/*	}
/*}
*/

/*	this version is "atomic"; l bytes had better fit.
*/
cb2put(cbp,p,l)
register union cb2 *cbp;
char *p;
register int l;
{
	register int in=cbp->cb2in;
	while (l>0) {
		register int n=cbp->cb2out-in;
		if (n<=0) n+=cbp->cb2lwa-cbp->cb2fwa;
		/* n==# of chars which would exactly over-fill the buffer */
		--n;
		if (cbp->cb2lwa<(n+in)) n=cbp->cb2lwa-in;  /* off end */
		if (n==0) sleep(cbp,CB2PRI);
		if (n>l) n=l;
		bcopy(p,cbp->cb2buf+in,n); p+=n; l-=n;
		if (cbp->cb2lwa<=(n+=in)) n=cbp->cb2fwa;  /* off end */
		in=n;
	}
	cbp->cb2in=in;
}

cb2get(cbp,p,l)
register union cb2 *cbp;
char *p;
register int l;
{
	while (l>0) {
		register int n;
		while (0==(n=cbp->cb2in-cbp->cb2out)) sleep(cbp,CB2PRI);
		if (n<0) n=cbp->cb2lwa-cbp->cb2out;  /* wrap-around */
		if (n>l) n=l;
		bcopy(cbp->cb2buf+cbp->cb2out,p,n); p+=n; l-=n;
		if (cbp->cb2lwa<=(n+=cbp->cb2out)) n=cbp->cb2fwa;  /* off end */
		cbp->cb2out=n;
	}
}


/* returns number of characters which can be inserted without wrapping */
int
cb2room(cbp)
register union cb2 *cbp;
{
	register int n=cbp->cb2out-cbp->cb2in;
	if (n<=0) n+=cbp->cb2lwa-cbp->cb2fwa;
	/* n==# of chars which would exactly over-fill the buffer */
	--n;
	if (cbp->cb2lwa<(n+cbp->cb2in)) n=cbp->cb2lwa-cbp->cb2in;  /* off end */
	return(n);
}

/* returns number of characters in buffer */
int
cb2full(cbp)
register union cb2 *cbp;
{
	register int n=cbp->cb2in-cbp->cb2out;
	if (n<0) n+=cbp->cb2lwa-cbp->cb2fwa;
	return(n);
}
