/*
 * jam 841101
 */

#include "../h/param.h"
#include "../h/time.h"
#include "../h/kernel.h"
#include "../h/errno.h"
#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"

int timeServer_call();
int timeServer_abort();
int timeServer_exception();

#define RPC_CLASS_TIME	4
#define RPC_TIME_GET	0
#define RPC_TIME_SET	1

rpc_serverClass_t timeServerClass =
{
	0,	"time",		RPC_CLASS_TIME,
	timeServer_call,	timeServer_abort,	timeServer_exception
};

timeServer_init()
{
	rpc_serverAttach(&timeServerClass);
}

timeServer_call(clientConn, clientId, classp, operation, params)
   connection_t *clientConn;
   u_long clientId;
   rpc_serverClass_t *classp;
   u_short operation;
   caddr_t params;
{
	register struct timeval *result;
	register struct timeval *param;
	register int s;

	switch (operation)
	{

	case RPC_TIME_GET:
		result = (struct timeval *)rpc_allocResults(sizeof(*result));
		s = spl6();
		result->tv_sec = time.tv_sec;
		result->tv_usec = time.tv_usec;
		splx(s);
		/* using cookie == 0 breaks already broken time service */
		rpc_return(clientConn, clientId, (caddr_t)result, 0);
		break;

	case RPC_TIME_SET:
		param = (struct timeval *)params;
		setthetime(param);
		/* using cookie == 0 breaks already broken time service */
		rpc_return(clientConn, clientId, NULL, 0);
		break;

	default:
		/* using cookie == 0 breaks already broken time service */
		rpc_error(clientConn, clientId, EREMOTEOPERATION, 0);
		break;

	}
}

timeServer_abort()
{
}

timeServer_exception()
{
}
