#ifndef NO_RPC_STATS

extern struct rpc_statlist
{
	/*
	 * Client side.
	 */
	KSTAT_DCLMSTAT(calls);		/* Calls outstanding */
	KSTAT_DCLMSTAT(callRetries);	/* Call retries */
	KSTAT_DCLSTAT(lostCalls);	/* Calls never responded to */
	KSTAT_DCLMSTAT(callPackets);	/* Call packets allocated */
	KSTAT_DCLSTAT(callAcks);	/* Call acks received */
	KSTAT_DCLSTAT(errorsRecvd);	/* Error packets received */
	KSTAT_DCLSTAT(returnAcksSent);	/* Return acks sent */
	KSTAT_DCLMSTAT(nodesUp);	/* Nodes up */
	KSTAT_DCLSTAT(callsFlushed);	/* Calls flushed by a crash */
	KSTAT_DCLMSTAT(clientsAttached);/* Clients attached to RPC */
	KSTAT_DCLMSTAT(paramPkts);	/* Parameter packets allocated */
	KSTAT_DCLMSTAT(paramBytes);	/* Parameter bytes allocated */
	KSTAT_DCLSTAT(callDaemon);	/* Times call retransmitter ran */

	/*
	 * Server side.
	 */
	KSTAT_DCLSTAT(dupCalls);	/* Duplicate calls received */
	KSTAT_DCLSTAT(dupCallsAck);	/* Duplicate calls --> CALL_ACK */
	KSTAT_DCLSTAT(callsAborted);	/* Calls aborted */
	KSTAT_DCLMSTAT(returnPackets);	/* Return packets allocated */
	KSTAT_DCLSTAT(unknownClass);	/* Calls for unknown classes */
	KSTAT_DCLMSTAT(callsServiced);	/* Calls serviced */
	KSTAT_DCLMSTAT(returnRetries);	/* Return retries */
	KSTAT_DCLSTAT(lostReturns);	/* Returns never responded to */
	KSTAT_DCLSTAT(returnDaemon);	/* Times return retransmitter ran */
	KSTAT_DCLSTAT(returnAcksRecvd);	/* Return acks received */
	KSTAT_DCLSTAT(serverDaemon);	/* Times server daemon ran */
	KSTAT_DCLMSTAT(remoteClients);	/* Remote clients known about */
	KSTAT_DCLMSTAT(serversAttached);/* Servers attached to RPC */
	KSTAT_DCLMSTAT(resultPkts);	/* Result packets allocated */
	KSTAT_DCLMSTAT(resultBytes);	/* Result bytes allocated */

	/*
	 * Both sides.
	 */
	KSTAT_DCLSTAT(inputs);		/* Packets received */
	KSTAT_DCLSTAT(outputs);		/* Packets transmitted */
	KSTAT_DCLSTAT(dropped);		/* Packets dropped */
	KSTAT_DCLSTAT(badpkts);		/* Bad packets received */
} rpc_statlist;

#ifdef RPC_STAT_INIT
struct rpc_statlist rpc_statlist =
{
	/*
	 * Client side.
	 */
	KSTAT_INITMSTAT(calls),		/* Calls outstanding */
	KSTAT_INITMSTAT(callRetries),	/* Call retries */
	KSTAT_INITSTAT(lostCalls),	/* Calls never responded to */
	KSTAT_INITMSTAT(callPackets),	/* Call packets allocated */
	KSTAT_INITSTAT(callAcks),	/* Call acks received */
	KSTAT_INITSTAT(errorsRecvd),	/* Error packets received */
	KSTAT_INITSTAT(returnAcksSent),	/* Return acks sent */
	KSTAT_INITMSTAT(nodesUp),	/* Nodes up */
	KSTAT_INITSTAT(callsFlushed),	/* Calls flushed by a crash */
	KSTAT_INITMSTAT(clientsAttached),/* Clients attached to RPC */
	KSTAT_INITMSTAT(paramPkts),	/* Parameter packets allocated */
	KSTAT_INITMSTAT(paramBytes),	/* Parameter bytes allocated */
	KSTAT_INITSTAT(callDaemon),	/* Times call retransmitter ran */

	/*
	 * Server side.
	 */
	KSTAT_INITSTAT(dupCalls),	/* Duplicate calls received */
	KSTAT_INITSTAT(dupCallsAck),	/* Calls acked */
	KSTAT_INITSTAT(callsAborted),	/* Calls aborted */
	KSTAT_INITMSTAT(returnPackets),	/* Return packets allocated */
	KSTAT_INITSTAT(unknownClass),	/* Calls for unknown classes */
	KSTAT_INITMSTAT(callsServiced),	/* Calls serviced */
	KSTAT_INITMSTAT(returnRetries),	/* Return retries */
	KSTAT_INITSTAT(lostReturns),	/* Returns never responded to */
	KSTAT_INITSTAT(returnDaemon),	/* Times return retransmitter ran */
	KSTAT_INITSTAT(returnAcksRecvd), /* Return acks received */
	KSTAT_INITSTAT(serverDaemon),	/* Times server daemon ran */
	KSTAT_INITMSTAT(remoteClients),	/* Remote clients known about */
	KSTAT_INITMSTAT(serversAttached),/* Servers attached to RPC */
	KSTAT_INITMSTAT(resultPkts),	/* Result packets allocated */
	KSTAT_INITMSTAT(resultBytes),	/* Result bytes allocated */

	/*
	 * Both sides.
	 */
	KSTAT_INITSTAT(inputs),		/* Packets received */
	KSTAT_INITSTAT(outputs),	/* Packets transmitted */
	KSTAT_INITSTAT(dropped),	/* Packets dropped */
	KSTAT_INITSTAT(badpkts),	/* Bad packets received */
};
KSTAT_HEAD(rpc, "RPC");
#endif RPC_STAT_INIT

#define RPC_INCSTAT(name)	KSTAT_INCSTAT(rpc,name)
#define RPC_INCMSTAT(name)	KSTAT_INCMSTAT(rpc,name)
#define RPC_DECMSTAT(name)	KSTAT_DECMSTAT(rpc,name)
#define RPC_ADDMSTAT(name,value) KSTAT_ADDMSTAT(rpc,name,value)
#define RPC_SUBMSTAT(name,value) KSTAT_SUBMSTAT(rpc,name,value)

#else NO_RPC_STATS

#define RPC_INCSTAT(name)
#define RPC_INCMSTAT(name)
#define RPC_DECMSTAT(name)
#define RPC_ADDMSTAT(name,value)
#define RPC_SUBMSTAT(name,value)

#endif NO_RPC_STATS
