/* rcsid[]="$Header: dklabel.h,v 820.1 86/12/04 19:53:18 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
#ifdef s32
 * Format of a VALID SMD disk label
 * Resides in cylinder 0, head 0, sector 0 on each physical drive.
 * Similar to the SUN SMD disk label.  We don't use the physical
 * partition information.
#else
 * Format of a SUN SMD disk label
 * Resides in cylinder 0, sector 0 on each head which is the first
 * head of a physical partition (e.g., heads 0 and 2 for a CDC Lark).
 * dkl_ppart gives the physical partition number (currently only 0 or 1).
 * dkl_bhead must match the head on which the label is found;
 * otherwise the label was probably overwritten by another.
#endif
 *
 * sizeof(struct dk_label) should be 512 (sector size)
 */

/*
 * The binary, machine readable part of the label.
 */
struct dk_blabel {
	/* begin Storager only */
	u_char dkb_zerolatency;	/* zero latency mode */
	u_char dkb_drivedesc;	/* uib drive descriptor byte (byte 18 in uib) */
	u_char dkb_gap3;	/* gap3 size */
	u_char dkb_bufstep;	/* does drive accept buffered steps? */
	u_char dkb_stepwidth;	/* step pulse width */
	u_short dkb_stepinter;	/* step pulse interval */
	u_char dkb_headloadtime;/* head load time */
	u_char dkb_seektime;	/* track to track seek time */
	u_short dkb_precomp;	/* write precompensation starting cylinder */
	u_short dkb_redwrite;	/* reduced write current starting cylinder */
	/* end Storager only */
	u_short dkb_gap1;	/* size of gap 1 */
	u_short dkb_gap2;	/* size of gap 2 */
	u_short dkb_intrlv;	/* interleave factor */
	u_short dkb_skew;	/* skew factor */
	u_short dkb_group;	/* group size */
	u_short dkb_cache;	/* cache mode */
	u_short dkb_ncyl;	/* # of data cylinders */
	u_short dkb_acyl;	/* # of alternate cylinders */
	u_short	dkb_a_alloc;	/* # of alternate tracks allocated */
	u_short dkb_nhead;	/* # of heads in this partition */
	u_short dkb_nsec;	/* # of 512 byte sectors per track */
	struct dk_sizes dkb_sizes[DK_NSIZES];
	u_short dkb_magic;	/* identifies this label format */
	u_short dkb_cksum;	/* xor checksum of sector */
};

struct dk_label {
	char dkl_asciilabel[128];	/* for compatibility */
	char dkl_pad[512 - 128 - sizeof (struct dk_blabel)];
	struct dk_blabel dkl_b;
};
#define dkl_zerolatency dkl_b.dkb_zerolatency
#define dkl_drivedesc dkl_b.dkb_drivedesc
#define dkl_gap3 dkl_b.dkb_gap3
#define dkl_bufstep dkl_b.dkb_bufstep
#define dkl_stepwidth dkl_b.dkb_stepwidth
#define dkl_stepinter dkl_b.dkb_stepinter
#define dkl_headloadtime dkl_b.dkb_headloadtime
#define dkl_seektime dkl_b.dkb_seektime
#define dkl_precomp dkl_b.dkb_precomp
#define dkl_redwrite dkl_b.dkb_redwrite
#define dkl_gap1 dkl_b.dkb_gap1
#define dkl_gap2 dkl_b.dkb_gap2
#define dkl_intrlv dkl_b.dkb_intrlv
#define dkl_skew dkl_b.dkb_skew
#define dkl_group dkl_b.dkb_group
#define dkl_cache dkl_b.dkb_cache
#define dkl_ncyl dkl_b.dkb_ncyl
#define dkl_acyl dkl_b.dkb_acyl
#define dkl_a_alloc dkl_b.dkb_a_alloc
#define dkl_nhead dkl_b.dkb_nhead
#define dkl_nsec dkl_b.dkb_nsec
#define dkl_sizes dkl_b.dkb_sizes
#define dkl_magic dkl_b.dkb_magic
#define dkl_cksum dkl_b.dkb_cksum

#define DKL_MAGIC	0xDABE
