static char rcsid[] = "$Header: cstuff.c,v 820.1 86/12/04 19:53:05 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Miscellaneous things for the kernel.
 */

#ifdef C_QUEUE_STUFF

struct queue
{
	struct queue	*fwd;
	struct queue	*back;
};

unsigned char qdebug = 0;

insque(entry, pred)
   register struct queue *entry,*pred;
{
	if (qdebug & 0x01) checkqueue("start insque", entry);
	if (qdebug & 0x02) showqueue("start insque", entry);
	entry->fwd = pred->fwd;
	entry->back = pred;
	pred->fwd->back = entry;
	pred->fwd = entry;
	if (qdebug & 0x10) checkqueue("end insque", entry);
	if (qdebug & 0x20) showqueue("end insque", entry);
}

struct queue *remque(entry)
   register struct queue *entry;
{
	if (qdebug & 0x04) checkqueue("start remque", entry);
	if (qdebug & 0x08) showqueue("start remque", entry);
	entry->fwd->back = entry->back;
	entry->back->fwd = entry->fwd;
	if (qdebug & 0x40) checkqueue("end remque", entry);
	if (qdebug & 0x80) showqueue("end remque", entry);
	return(entry);
}

checkqueue(msg, head)
   char *msg;
   register struct queue *head;
{
	register struct queue *entry = head;
	register int errors = 0;
	register int count = 100;		/* Maximum length of queue */
	int s = spl7();

	do
	{
		if (entry->fwd->back != entry)
			++errors, printf("entry 0x%x => 0x%x, but 0x%x <= 0x%x\n",
				entry, entry->fwd, entry->fwd->back, entry->fwd);
		entry = entry->fwd;
	} while (entry != head && --count);
	if (count == 0)
		++errors, printf("queue 0x%x too long\n", entry);
	if (errors)
		cdebugger(msg);
	splx(s);
}

showqueue(msg, head)
   char *msg;
   register struct queue *head;
{
	register struct queue *entry = head;
	register int count = 100;		/* Maximum length of queue */
	int s = spl7();

	printf("%s: 0x%x", msg, head);
	do
	{
		printf(" => 0x%x", entry->fwd);
		entry = entry->fwd;
	} while (entry != head && --count);
	if (count == 0)
		printf(" ...");
	printf("\n");
	splx(s);
}
#endif C_QUEUE_STUFF

#ifdef WHITE

int ac_tty;

int vgbdt, pibdt, dispmgrseg;

#endif WHITE
