/* rcsid[]="$Header: defs.h,v 800.1 85/09/24 15:50:36 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

#
/****************************************************************************
						
 	NUNIX DEBUGGER - common definitions
 
*****************************************************************************
			debugger revisions for NUNIX by - J. Test  1/81
****************************************************************************/

#ifdef	KERNEL

/*
 * Use the kernel's own set of include files. 
 */
#include "../../h/param.h"
#include "../../h/dir.h"
#ifdef s32
#include "../../machine/reg.h"
#else s32
#include "../../h/reg.h"
#endif s32
#include "../../h/user.h"
#include "../../usr.include/a.out.h"
#include "../../usr.include/sgtty.h"
#include "../../usr.include/stdio.h"
#include "../../usr.include/signal.h"

#else	KERNEL

/* 
 *Use the regular include files -- 
 * this way adb will probably NOT WORK 
 * (at least not in VALID's scheme --
 * too many things are conditionally defined!)
 * (bog 081985)
 */
#include <sys/param.h>
#include <sys/dir.h>
#ifdef s32
#include <machine/reg.h>
#else s32
#include <sys/reg.h>
#endif s32
#include <sys/user.h>
#include <a.out.h>
#ifdef BOOTSTRAP
#include "/usr/include/sgtty.h"
#include "/usr/include/stdio.h"
#include "/usr/include/signal.h"
#else  BOOTSTRAP
#include <sgtty.h>
#include <stdio.h>
#include <signal.h>
#endif BOOTSTRAP

#endif	KERNEL

#include "mac.h"
#include "mode.h"
#include "head.h"

#define VARB	11
#define VARD	13
#define VARE	14
#define VARM	22
#define VARS	28
#define VART	29

#define COREMAGIC 0140000

#define RD	0
#define WT	1
#define NSP	0
#define	ISP	1
#define	DSP	2
#define STAR	4
#define STARCOM 0200
#define DSYM	7
#define ISYM	2
#define ASYM	1
#define NSYM	0
#define ESYM	(-1)
#define BKPTSET	1
#define BKPTEXEC 2
#define	SYMSIZ	100
#define MAXSIG	20

#define BPT	0x4E42		/* Trap 2, breakpoint instruction */

#define FD	0200
#define	SETTRC	0
#define	RDUSER	2
#define	RIUSER	1
#define	WDUSER	5
#define WIUSER	4
#define	RUREGS	10
#define	WUREGS	11
#define	CONTIN	7
#define	EXIT	8
#define SINGLE	9
#define FROFF	(&(0->fpsr))
#define FRLEN	25
#define FRMAX	6

#define ps	17		/* register offset definitions	*/
#define sp	15
#define pc	16
#define a6	14

#define MAXOFF	0xfff		/* maximum offset from a symbol that seems sensible to display */
#define MAXPOS	80
#define MAXLIN	128
#define EOR	'\n'
#define TB	'\t'
#define QUOTE	0200
#define STRIP	0177
#define LOBYTE	0377
#define EVEN	-2

union
{
	int	I[2];
	long	L;
} itolws;

#define leng(a)		((long)((unsigned)(a)))
#define shorten(a)	((int)(a))
#define itol(a,b)	(itolws.I[0]=(a), itolws.I[1]=(b), itolws.L)
#define itol68(a,b)	((a << 16) | (b & 0xFFFF))

L_INT		inkdot();
SYMPTR		lookupsym();
SYMPTR		symget();
POS		get();
POS		chkget();
STRING		exform();
L_INT		round();
BKPTR		scanbkpt();
VOID		fault();

struct sgttyb	adbtty, subtty;
struct tchars	adbtch, subtch;

/* stuff for -I. bog 850803 */
#define ADBINCLUDES	"/usr/lib/adb"
#define	MAXINCLS	16

#ifdef ADB_DEBUG
extern int adbdebug;	/* enables debugging */
#endif ADB_DEBUG
