/*	pcb.h	4.8	83/03/26	*/

/*
 * SUN software process control block
 */

struct pcb {
	label_t	pcb_regs;	/* saved registers (MUST BE FIRST) */
	int	pcb_sr; 	/* program status word */
	struct	pte *pcb_p0br;	/* pseudo-P0BR for sun */
	int	pcb_p0lr;	/* pseudo-P0LR for sun */
	struct	pte *pcb_p1br;	/* pseudo-P1BR for sun */
	int	pcb_p1lr;	/* pseudo-P1LR for sun */
	int	pcb_szpt; 	/* number of pages of user page table */
	int	*pcb_sswap;
};

#define	AST_USER	0x40000000
#define	TRACE_USER	0x20000000
#define	AST_CLR		0x60000000
#define	PME_CLR		0
#define	AST_NONE	0

#define isaston()	((u.u_pcb.pcb_p0lr & AST_USER) ? 1 : 0)
#define istraceon()	((u.u_pcb.pcb_p0lr & TRACE_USER) ? 1 : 0)
