C   FOR_T2D.FOR
C   FORTRAN test program using tape programming language interface.
C   Reads blocks from tape, writes them to a disk file (this program assumes
C   that 4000-byte blocks were written by the other demo program, FOR_D2T.FOR).
      EXTERNAL FORTAPE
      INTEGER*2 FUN, COUNT
C  Yes, the following is a valid variable name! (Embedded blanks are ignored.)
      LOGICAL MESSAGE DISPLAYED
C   Set up 4000-byte buffer as array of 80-byte "records":
      CHARACTER BUFFER*80(50),OUTFILE*40, STAT*1(16), READY*1
C   First, check whether tape is on-line:
1     FUN=0
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF (STAT(1).EQ.'T') GOTO 2
      PRINT*,'* Tape drive is not on-line--hit any key when ready:'
      READ'(A)',READY
      GOTO 1
2     PRINT*,'* Enter name for output DOS file: '
      READ'(A)',OUTFILE
      OPEN(UNIT=1,FILE=OUTFILE,ERR=66,STATUS='UNKNOWN')
C   Check if tape is at load point:
      FUN=0
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF(STAT(7).EQ.'T') GOTO 101
      PRINT*,'* Rewinding tape--please wait:'
C  Rewind tape:
      FUN=11
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      MESSAGE DISPLAYED=.FALSE.
C  Check status until "busy rewinding" no longer true:
100   FUN=0
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF (STAT(5).NE.'T') GOTO 101
      IF(MESSAGE DISPLAYED) GOTO 100
      PRINT*,'* Still rewinding:'
      MESSAGE DISPLAYED=.TRUE.
      GOTO 100
101   IF (STAT(7).NE.'T') GOTO 901
      PRINT*,'* Reading from tape:'
110   FUN=2
      COUNT=4000
      CALL FORTAPE(FUN,STAT,COUNT,BUFFER)
      IF (STAT(13) .EQ. 'T') GOTO 901
C  Check if tape mark was read (indicates EOF):
      IF (STAT(14).EQ.'T') GOTO 300
      K=1
      DO 200,K=1,50
         WRITE (1,FMT='(A)') BUFFER(K)
200   CONTINUE
      GOTO 110
300   PRINT*,'* File ',OUTFILE,' has been written.'
      CLOSE (1)
      STOP
66    PRINT*,'* Error opening file ',OUTFILE,'--program ending.'
      STOP
901   PRINT*,'* Error from tape routine:'
      PRINT*,STAT
      END

