#include <fcntl.h>
#include <ctype.h>
#include <dos.h>
#include <sys\types.h>
#include <sys\stat.h>
 
#define IONL 0x8000   /* 1 = tape is online */
#define ISPD 0x4000
#define IDBY 0x2000   /* 1 = data busy */
#define IFPT 0x1000   /* 1 = file is write protected */
#define IRWD 0x0800   /* 1 = tape is rewinding */
#define IRDY 0x0400   /* 1 = tape unit is ready */
#define IBOT 0x0200   /* 1 = tape is at load point */
#define IFBY 0x0100   /* 1 = formatter busy */
#define UDMA 0x0080   /* 1 = read/write buffer across 64k boundary */
#define UCMR 0x0040   /* 1 = invalid command */
#define UCNR 0x0020   /* 1 = command issued when tape was not ready */
#define UNRD 0x0010   /* 1 = no buffer overrun on read */
#define IHER 0x0008   /* 1 = unrecoverable read/write error */
#define IFMK 0x0004   /* 1 = file mark detected durring last operation */
#define IEOT 0x0002   /* 1 = end of tape marker detected */
#define ICER 0x0001   /* 1 = soft error durring read operation */
 
/* summary of tapeop functions -
 
command    Description
 
  0        Return status
  1        Write a block
  2        Read a block
  3        Write in edit mode
  4        Read in reverse edit mode
  5        Read in reverse
  6        Write tape mark
  7        Forward space file(s)
  8        Back space file(s)
  9        Forward space block(s)
 10        Back space block(s)
 11        Rewind to load point
 12        Rewind and unload
 13        Set 1600 bpi (default)
 14        Set 3200 bpi
 15        Set fast speed (100 ips)
 16        Set slow speed (25 ips) default
 17        Set long inter-record gap
 18        Set short inter-record gap (default)
 19        Erase fixed length of tape
 20        Erase to EOT (security erase)
 21        Set number of read/write retries
 22        Reset read/write error counts
 23        Return read error count
 24        Return write error count
 25        Test for tape card present (returns count = 1 if true)
 26        Test for unit on line (returns count = 1 if true)
*/
unsigned char iobuff[4096];
unsigned char dosname[32];
int dosfile;
int status,count;
 
main() {
  int x,y,z;
  do {
    printf("ENTER INPUT DOS FILE NAME: "); gets(dosname);
    if (dosname[0] == 0) exit(1);
    dosfile = open(dosname,(O_BINARY | O_RDONLY));
    if (dosfile == -1) printf("DOS FILE OPEN ERROR\n");
    } while (dosfile == -1);
  rew();
  do {
    x = read(dosfile,iobuff,4096);
    count = x;
    if (count != 0) ctape(1,&status,&count,iobuff);
    if ((status & IHER) != 0) {
      printf("PERMANENT TAPE WRITE ERROR\n");
      exit(1); }
    } while (x == 4096);
  close(dosfile);
  ctape(6,&status,&count,iobuff);
  ctape(6,&status,&count,iobuff);
  rew();
  printf("FILE TRANSFERRED TO TAPE\n");
  }
 
rew() {
  ctape(11,&status,&count,iobuff);
  for (;;) {
    ctape(0,&status,&count,iobuff);
    if (((status & IRWD) == 0) || ((status & IBOT) != 0)) return(0);
    }
  }
