/*
 * Find out about remote users
 */
#define RUSERS_MAXUSERLEN 32
#define RUSERS_MAXLINELEN 32
#define RUSERS_MAXHOSTLEN 257

struct rusers_utmp {
	char *ut_user;
	char *ut_line;
	char *ut_host;
	int ut_type;
	int ut_time;
	u_int ut_idle;
};
typedef struct rusers_utmp rusers_utmp;
bool_t xdr_rusers_utmp();


typedef struct {
	u_int utmp_array_len;
	rusers_utmp *utmp_array_val;
} utmp_array;
bool_t xdr_utmp_array();


/*
 * Values for ut_type field above.
 */
#define RUSERS_EMPTY 0
#define RUSERS_RUN_LVL 1
#define RUSERS_BOOT_TIME 2
#define RUSERS_OLD_TIME 3
#define RUSERS_NEW_TIME 4
#define RUSERS_INIT_PROCESS 5
#define RUSERS_LOGIN_PROCESS 6
#define RUSERS_USER_PROCESS 7
#define RUSERS_DEAD_PROCESS 8
#define RUSERS_ACCOUNTING 9

#define RUSERSPROG ((u_long)100002)
#define RUSERSVERS_3 ((u_long)3)
#define RUSERSPROC_NUM ((u_long)1)
extern int *rusersproc_num_3();
#define RUSERSPROC_NAMES ((u_long)2)
extern utmp_array *rusersproc_names_3();
#define RUSERSPROC_ALLNAMES ((u_long)3)
extern utmp_array *rusersproc_allnames_3();

