;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;	These routines are the assembly language routines needed
;	for the BACKUP/RESTORE program written in "C".
;	This code is contained in the file BR3.ASM

PGROUP	GROUP	PROG
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME CS:PGROUP
	PUBLIC	RWRITE

PARMS	STRUC
OLD_BP1	DW	?
RETN1	DW	?
FCB	DW	?
BUF	DW	?
LEN	DW	?
PARMS	ENDS

;	This routine will do a random write to a given fcb.
;	It returns either the count of the number of bytes written
;	or 0 if the request could not be honored.

RWRITE	PROC	NEAR
	PUSH	BP
	MOV	BP,SP

; CHECK FOR ZERO SIZE

	CMP	[BP].LEN,0
	JNE	WSKIP
	MOV	AX,0
	JMP	WEXIT

; SET THE DMA ADDRESS

WSKIP:	MOV	DX,[BP].BUF
	MOV	AH,1AH
	INT	21H

; GET THE FCB, SET THE COUNT AND WRITE

	MOV	DX,[BP].FCB
	MOV	CX,[BP].LEN
	MOV	AH,28H
	INT	21H

; CHECK FOR END OF DISK

	CMP	AL,1
	JNE	WSKIP1
	MOV	AX,0
	JMP	SHORT WEXIT

; RETURN THE LENGTH OF WRITTEN BYTES

WSKIP1:	MOV	AX,[BP].LEN
WEXIT:	POP	BP
	RET
RWRITE	ENDP

;	This routine will do a random read from the disk using the given
;	FCB. It returns the count of the number of bytes read.

	PUBLIC	RREAD

RREAD	PROC	NEAR
	PUSH	BP
	MOV	BP,SP

; CHECK FOR ZERO LENGTH

	CMP	[BP].LEN,0
	JNE	RSKIP
	MOV	AX,0
	JMP	REXIT

; SET THE DMA ADDRESS

RSKIP:	MOV	DX,[BP].BUF
	MOV	AH,1AH
	INT	21H

; GET THE FCB, SET THE COUNT AND READ

	MOV	DX,[BP].FCB
	MOV	CX,[BP].LEN
	MOV	AH,27H
	INT	21H

; RETURN THE LENGTH OF READ BYTES

	MOV	AX,CX	
REXIT:	POP	BP
	RET
RREAD	ENDP
PROG	ENDS

;
;  This routine will return todays date
;
GET_DATE EQU	2AH	; GET DATE FUNCTION
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP
	PUBLIC	TDATE
TDATE	PROC	NEAR

;	GET DATE

	MOV	AH,GET_DATE
	INT	21H

;	GET YEAR

	SUB	CX,1980
	MOV	AX,CX
	MOV	CL,9	; GET YEAR IN THE RIGHT POSITION
	SHL	AX,CL

;	GET DAY AND MONTH

	MOV	CL,5
	MOV	BL,DH
	SUB	BH,BH
	SHL	BX,CL
	SUB	DH,DH
	ADD	DX,BX
	ADD	AX,DX
	RET
TDATE	ENDP
PROG	ENDS
	END
