	PAGE	,132
;	BIOS for the Z-150 computer
;
;
;	Supports 8x512 and 9x512 floppy disk formats
;
;	Supports 4 floppys and 4 fixed disk partitions
;
;	Author:	RJM
;	Date:	9/20/83
;	File:	Z150BIOS.ASM
;

;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
	IF1
%OUT PASS 1 STARTED
	ELSE
%OUT PASS 2 STARTED
	ENDIF

D_2SEC	=	0			; Assemble with 2 sec timeout for disk
					; media check.

DT_STAMP =	0			; Assemble with date/time stamp on disks

DSK_MAXVAL =	2*18			; 2 sec delay on disk changes
TOD_LIM	   =	2*60*18			; 2 min between stamp updates
MIN_SEC	=	8			; Highest sector to update date/time on


	TITLE	MS-DOS 2.00 BIOS for the Z-150 Computer
	SUBTTL	Common definitions

.XLIST
	INCLUDE ..\COMMONS\ASCII.DEF
	INCLUDE ..\COMMONS\DRIVERS.DEF
	INCLUDE ..\COMMONS\FIXED.DEF
	INCLUDE ..\COMMONS\IOCONFIG.DEF
	INCLUDE ..\COMMONS\LOADER.DEF
	INCLUDE ..\COMMONS\MSDOS.DEF
	INCLUDE ..\COMMONS\MACRO.ASM
	INCLUDE ..\COMMONS\Z150BIOS.DEF
	INCLUDE ..\COMMONS\Z150ROM.DEF
.LIST


;	Define the externals in SYSINIT used for initialization

	EXTRN	CURRENT_DOS_LOCATION:WORD, FINAL_DOS_LOCATION:WORD
	EXTRN	DEVICE_LIST:DWORD, MEMORY_SIZE:WORD, DEFAULT_DRIVE:BYTE
	EXTRN	BUFFERS:BYTE, FILES:BYTE
	EXTRN	SYSINIT:FAR, SYSSIZE:BYTE


	SUBTTL	BIOS jump table
	PAGE

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME CS:BIOS, DS:BIOS, SS:BIOS


	ORG	0

BIOS_START LABEL NEAR

;	BIOS Jump table

CONFIG_PTR	LABEL	WORD		; Pointer to configuration stuff after init.
	JMP	NEAR PTR BIOS_INIT	; Initialization code


	SUBTTL	BIOS data definitions
	PAGE

;****************************************************************
;								*
;	Configuration data, used by the CONFIGUR,  program  and	*
;	other user setable variables used to configure the	*
;	hardware.						*
;								*
;****************************************************************
CONFIG_DATA	LABEL	BYTE
BIOS_VER DB	BIOS2_CVER		; Version of the BIOS

	DW	OFFSET IO_TABLES	; Address of ROM I/O tables

	DW	OFFSET FIXED_BPBS	; Offset of Partition BPB's
	DW	OFFSET FIXED_FLAGS	; Offset of partition flags
AUTO_FLAG	LABEL BYTE
	DB	0			; Auto-assign flag. If != 0, will auto-assign
					; at boot time. (Compatible mode)


;***********************************
;				   *
;	END OF CONFIGURATION TABLE *
;				   *
;***********************************


;************************************************************************
;									*
;	This is the configurable data pointed to by the configuration	*
;	table.								*
;									*
;************************************************************************


;	Fixed disk BPB's (Bios parameter blocks).
;	These are the fixed disk BPB's used
;	by the disk I/O code. They are initially set to the
;	maximum format that can be supported.

FIXED_BPBS	LABEL	BYTE
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0F8H, 12, 17, 0, 0, 080H>
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0F8H, 12, 17, 0, 0, 080H>
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0F8H, 12, 17, 0, 0, 080H>
INIT_BPB	LABEL	BYTE
	BPB_STRUC <512, 16, 1, 2, 1024, 65535, 0F8H, 12, 17, 0, 0, 080H>

	ERRNZ	<(OFFSET $ - OFFSET FIXED_BPBS)/(TYPE BPB_STRUC)>,MAX_FIXED

;	Flags for assigned partitions
;	bit 0=0 - not assigned, bit 0=1 partition assigned
;	bit 1=0 - not formatted, bit 1=1 partition formatted
;	bit 2=0 - disk has not changed, bit 2=1 disk has changed
;	bits 3-7 reserved (undefined)
FIXED_FLAGS DB	MAX_FIXED DUP(0)


;*********************************************************
;	Default parallel and serial configuration tables *
;	used by the ROM					 *
;*********************************************************
IO_TABLES LABEL BYTE
PCT1	DB	0		; No remap, no case mapping or parity stripping
	DB	0		; Pad character
	DB	0		; No pad count
	DB	20		; Time out value

PCT2	DB	0
	DB	0
	DB	0
	DB	20

PCT3	DB	0
	DB	0
	DB	0
	DB	20

PRINTER_MAX = ($-PCT1)/PCT_SIZE


SCT1	DB	SCT_DEFAULT+SCT_DTR+SCT_RTS+SCT_DTR_POLAR+SCT_RTS_POLAR
				; Default handshake, compatibility mode
				; DTR and RTS, Hardware
	DB	0		; No attributes
	DB	0		; Pad character
	DB	0		; No pad count
	DB	0		; Flag for DC1/DC3 and ETX/ACK
	DB	0		; Count for ETX/ACK
	DB	101B SHL 5 + 00B SHL 3 + 0B SHL 2 + 11B	; 2400 baud,
				; No parity, 1 stop bit and 8 bit words
	DB	1		; Time out value

SCT2	DB	SCT_DEFAULT+SCT_DTR+SCT_RTS+SCT_DTR_POLAR+SCT_RTS_POLAR
				; Default handshake, compatibility mode
				; DTR and RTS, Hardware
	DB	0
	DB	0
	DB	0
	DB	0
	DB	0
	DB	101B SHL 5 + 00B SHL 3 + 0B SHL 2 + 11B
	DB	1

SERIAL_MAX = ($-SCT1)/SCT_SIZE

;**********************************************************
;							  *
;	End of configurable information pointed to by the *
;	configuration table.				  *
;							  *
;**********************************************************

;	Floppy disk BPB's. These are the floppy disk BPB's used
;	by the disk I/O code. They must be in order of the last
;	two bits of the associated media byte.

FLOPPY_BPBS	LABEL	BYTE
BPB_9X1	BPB_STRUC <512, 1, 1, 2,  64,   9*40, 0FCH, 2, 9, 1, 0, 0>
BPB_9X2	BPB_STRUC <512, 2, 1, 2, 112, 9*40*2, 0FDH, 2, 9, 2, 0, 0>
BPB_8X1	BPB_STRUC <512, 1, 1, 2,  64,   8*40, 0FEH, 1, 8, 1, 0, 0>
BPB_8X2	BPB_STRUC <512, 2, 1, 2, 112, 8*40*2, 0FFH, 1, 8, 2, 0, 0>

	ERRNZ	<(OFFSET $ - OFFSET FLOPPY_BPBS)/(TYPE BPB_STRUC)>,MAX_FLOPPY

	IF	D_2SEC

;
;	Floppy disk timeout tables.  These are used to store the current
;	timer values to determine when the drive was last accessed.

DSK_TIMOUT	LABEL	BYTE
	DD	0
	DD	0
	DD	0
	DD	0

	ENDIF


;**************************************
; Variables used by the disk I/O code *
;**************************************
RETRY_COUNT DB	?		; Location to keep retry count
ONE_DRIVE   DB	0		; One drive flag (1 = 1 drive system)
DRIVE	    DB	?		; Drive number for ROM
	IF	D_2SEC
TIM_PTR	    DW	?		; Pointer to timeout table of last access
	ENDIF
	IF	DT_STAMP
TIM_FLG	    DB	0FFH		; Flag for date/time stamp initialization
TIM_TOD     DD	?		; Current timer for date/time stamp
FIRST_SEC   DW	?		; First sector in I/O request
	ENDIF

NUM_FIXED  DB	?		; Number of fixed drives
NUM_ASSIGN DB	0		; Number of assigned partitions (auto-assign)
CUR_UNIT   DB	?		; Work area for ASSIGN_PART
SKIP_UNIT  DB	?		; Work area for ASSIGN_PART
NUM_FLOPPY DB	?		; Number of floppy drives in the system
DOP_TYPE   DB	?		; Disk operation type (ROM error code)
DOP_VERIFY DB	?		; Verify flag (1 = verify, 0 = no verify)
	ERRNZ	DOP_TYPE,<(DOP_VERIFY-1)>
SEC_CNT    DW	?		; Sector count
OLD_SP1	   DW	?		; Old stack pointer for error exit
OLD_SP2	   DW	?		; Old stack pointer for error exit

;	Error codes returned by the ROM

T_ERR	DB	80H, 40H, 20H, 10H, 09H, 08H, 04H, 03H, 02H, 01H
L_ERR	=	OFFSET $ - OFFSET T_ERR

;	Error codes to return to MS-DOS (1 to 1 map to the table above)

	DB	02H, 06H, 0CH, 04H, 0CH, 04H, 08H, 00H, 0CH, 0CH


;	Message for the imaginary drive on a one drive system
DISK_MSG LABEL	BYTE
	DB	'Place disk '
NEW_DISK DB	0
	DB	' in drive A:.', CC_CR, CC_LF
	DB	'Press any key when ready.', CC_CR, CC_LF+80H


NXT_CHAR DB	0		; Look ahead for special keys (0 = Nothing pending)

COM_BUF	DB	SERIAL_MAX DUP(0)	; Look ahead for serial ports
DATE	DW	?		; BIOS Date storage

;	Packet pointer for the DOS packet

PACKET	DD	?
SS_SAVE	DW	?		; Storage for saving the DOS stack
SP_SAVE	DW	?
RECURLV	DW	-1		; Recursion level

;	BIOS local stack

	DW	128 DUP(?)
STACK_TOP LABEL WORD


;	Linked list of device headers. The following devices are
;	defined:
;		"CON" - Console
;		"AUX" - Auxilliary I/O (Same as COM1)
;		"PRN" - Printer device (Same as LPT1)
;		"CLOCK$" - Clock device
;		DISK - Disk driver
;		"COM1" - Serial communication device 1
;		"COM2" - Serial communication device 2
;		"LPT1" - Printer device 1
;		"LPT2" - Printer device 2
;		"LPT3" - Printer device 3
;		
CON	LABEL	BYTE
	DW	OFFSET AUX		; Double word pointer to next header
	DW	BIOS2_SEG
	DW	8013H			; Special device
	DW	OFFSET CON_STRAT	; Address of strategy routine
	DW	OFFSET CON_INT		; Address of interrupt routine
	DB	"CON     "		; Character device name

	ERRNZ	$,<(CON + TYPE DVH_STRUC)>

AUX	LABEL	BYTE
	DW	OFFSET PRN
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET AUX_STRAT
	DW	OFFSET AUX_INT
	DB	"AUX     "

	ERRNZ	$,<(AUX + TYPE DVH_STRUC)>

PRN	LABEL	BYTE
	DW	OFFSET CLOCK
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET PRN_STRAT
	DW	OFFSET PRN_INT
	DB	"PRN     "

	ERRNZ	$,<(PRN + TYPE DVH_STRUC)>

CLOCK	LABEL	BYTE
	DW	OFFSET DISK
	DW	BIOS2_SEG
	DW	8008H
	DW	OFFSET CLOCK_STRAT
	DW	OFFSET CLOCK_INT
	DB	"CLOCK$  "

	ERRNZ	$,<(CLOCK + TYPE DVH_STRUC)>

DISK	LABEL	BYTE
	DW	OFFSET LPT1
	DW	BIOS2_SEG
	DW	0
	DW	OFFSET DISK_STRAT
	DW	OFFSET DISK_INT
NUM_DISK DB	0, 7 DUP(0)		; Number of units, filled in at boot time

	ERRNZ	$,<(DISK + TYPE DVH_STRUC)>

LPT1	LABEL	BYTE
	DW	OFFSET COM1
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET LPT1_STRAT
	DW	OFFSET LPT1_INT
	DB	"LPT1    "

	ERRNZ	$,<(LPT1 + TYPE DVH_STRUC)>


COM1	LABEL	BYTE
	DW	OFFSET LPT2
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET COM1_STRAT
	DW	OFFSET COM1_INT
	DB	"COM1    "

	ERRNZ	$,<(COM1 + TYPE DVH_STRUC)>


LPT2	LABEL	BYTE
	DW	OFFSET LPT3
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET LPT2_STRAT
	DW	OFFSET LPT2_INT
	DB	"LPT2    "

	ERRNZ	$,<(LPT2 + TYPE DVH_STRUC)>


LPT3	LABEL	BYTE
	DW	OFFSET COM2
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET LPT3_STRAT
	DW	OFFSET LPT3_INT
	DB	"LPT3    "

	ERRNZ	$,<(LPT3 + TYPE DVH_STRUC)>


COM2	LABEL	BYTE
	DW	-1
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET COM2_STRAT
	DW	OFFSET COM2_INT
	DB	"COM2    "

	ERRNZ	$,<(COM2 + TYPE DVH_STRUC)>


	SUBTTL	BIOS initialization data and code
	PAGE


;**************************************************************************
;*	Initialization code and data. This section is overwritten by a disk
;	buffer after initialization
;**************************************************************************
;
DISK_BUF LABEL	BYTE		; Disk buffer after initialization complete
INIT_START LABEL BYTE
	ERRNZ	DISK_BUF,INIT_START

;	Data needed to load MSDOS.SYS
;
DATA_SECTOR	DW	?		; Data start sector
BOOT_BPB	BPB_STRUC	<>	; BPB from boot disk
FAT_SEG		DW	?		; Segment FAT is loaded at
IO_MSG		DB	'I/O erro', 'r'+80H

;	Init table used by the DOS. This table describes
;	the maximum format a unit will take on during operation.
;	The table is initially set up for 4 floppys and 4 fixed
;	disk partitions. At boot time the table is readjusted to
;	show the actual configuration of floppys and fixed disk
;	partitions.

BPB_TABLE LABEL	WORD
	DW	OFFSET BPB_9X2
	DW	OFFSET BPB_9X2
	DW	OFFSET BPB_9X2
	DW	OFFSET BPB_9X2

	ERRNZ	<((OFFSET $ - OFFSET BPB_TABLE)/2)>,MAX_FLOPPY

	DW	OFFSET INIT_BPB
	DW	OFFSET INIT_BPB
	DW	OFFSET INIT_BPB
	DW	OFFSET INIT_BPB

	ERRNZ	<((OFFSET $ - OFFSET BPB_TABLE)/2)>,<(MAX_FLOPPY+MAX_FIXED)>


;	Floppy disk parameter table used by ROM (moved to location
;	 0:570H during boot)
DISK_PARMS LABEL BYTE

	DB	0DFH
	DB	002H
	DB	025H
	DB	002H
	DB	009H
	DB	02AH
	DB	0FFH
	DB	050H
	DB	0F6H
	DB	0DH
	DB	04H
LDPT	=	OFFSET $ - OFFSET DISK_PARMS

;***************************************************************************
;
;	The following two tables are used to calculate parameters to
;	assign the first partition on the first winchester disk.
;
;***************************************************************************

;	"Break" points where disk parameters change on winchester partitions
;	Compatible values used here. 0 <= Part size < MIN_PART is invalid
BREAK	DW	0200H		; <= 256K 
	DW	0800H		; <= 1M
	DW	2000H		; <= 4M
	DW	7FA8H		; <= ~16M
NUM_BREAK	=	(OFFSET $ - OFFSET BREAK) / 2

;	Number of directory entries, one to one correspondence to BREAK vector
DIRS	DW	0040H
	DW	0070H
	DW	0100H
	DW	0200H
	DW	0400H		; For partitions > ~16M

;*
;	CON driver initialization - install INT 29H handler

CON_INIT PROC NEAR
	MOV	DI,29H SHL 2		; Get location of interrupt
	SUB	AX,AX
	MOV	ES,AX
	MOV	AX,OFFSET SPECIAL	; Put offset of special routine
	CLD
	STOSW				;  in interrupt location
	MOV	AX,BIOS2_SEG		; Put segment of interrupt routine
	STOSW				;  in interrupt location
	JMP	SUCESS
CON_INIT ENDP

;*
;	Disk driver initialization - Return the address of a BPB table
;		and the number of units. Also installs INT 1CH handler.
DISK_INIT PROC	NEAR

	MOV	AL,NUM_DISK		; Return the number of units
	MOV	ES:[BX+CIN_UNITS],AL
	MOV	WORD PTR ES:[BX+CIN_BADDR],OFFSET BPB_TABLE	; Return the address of the BPB table
	MOV	WORD PTR ES:[BX+CIN_BADDR+2],CS	; Segment
	JMP	SUCESS

DISK_INIT ENDP


;*	Initialization code. The initialization code is split into two
;	parts; The following part along with the previous data is
;	overwritten by a disk buffer after initialization and should be
;	as large as the largest sector size supported. The part at the
;	end is overwritten when MS-DOS is relocated.
;
BIOS_INIT LABEL FAR

;	Set up a local stack

	MOV	AX,CS
	CLI
	MOV	SS,AX
	MOV	SP,OFFSET STACK_TOP
	STI

	IF	DT_STAMP
;	Initialize date/time from 'stamp' on disk loader image
	
	SUB	AX,AX				; Set data segment to 0
	MOV	DS,AX

	MOV	DI,(LOAD_ADDR+DISK_BPB_OFFSET+TYPE BPB_STRUC)  ; Point to time
	MOV	DX,[DI]				; Get low word
	MOV	CX,[DI+2]			; Get high word
	MOV	AH,TOD_SET			; Set ROM  time
	INT	TIME_OF_DAY_INTR
	MOV	CX,[DI+4]			; Set BIOS date
	MOV	CS:DATE,CX

	ENDIF


;	Move the boot BPB from the loader to a local location

	SUB	AX,AX			; Set up source pointer
	MOV	DS,AX
	MOV	SI,LOAD_ADDR+DISK_BPB_OFFSET

	PUSH	CS			; Set up destination pointer
	POP	ES
	MOV	DI,OFFSET BOOT_BPB

	MOV	CX,TYPE BPB_STRUC
	CLD
	REP	MOVSB

;	Move the floppy disk parameter block to area at paragraph 50H
;	and install a pointer to this block
	
	MOV	ES,AX
	MOV	DI,BIOS_EXTRA SHL 4 + OFFSET BIOS_DPT

	PUSH	CS			; Get source pointer
	POP	DS
	MOV	SI,OFFSET DISK_PARMS
	MOV	AX,DI			; Save address

	MOV	CX,LDPT 		; Get length of table
	REP	MOVSB			; Move table
	MOV	DI,DISK_PARMS_INTR SHL 2	; Address of disk parms.
	STOSW				; Update disk parameter pointer
	SUB	AX,AX
	STOSW
	
;	Ensure print screen inactive, set last accessed drive

TMP	=	BIOS_EXTRA SHL 4 + OFFSET PRT_SCRN_FLAG
	MOV	BYTE PTR ES:[TMP],0

TMP	=	BIOS_EXTRA SHL 4 + OFFSET LAST_DRIVE
	MOV	BYTE PTR ES:[TMP],0

;	Set up for cntl-C on keyboard break

	MOV	DI,BREAK_INTR SHL 2	; Get offset of break
	MOV	AX,OFFSET KB_BREAK
	CLI
	STOSW
	MOV	AX,CS
	STOSW
	STI

;	Set up the configuration table pointer at start of the BIOS

	MOV	CONFIG_PTR,OFFSET CONFIG_DATA

;	Set up the I/O tables for the ROM

	MOV	DI,IO_PARMS_INTR SHL 2		; Offset of pointer
	MOV	AX,OFFSET IO_TABLES		;  Offset of data
	STOSW
	MOV	AX,CS				; Segment
	STOSW

;	Initialize the printer devices

	MOV	CX,ROM_DATA			; Address ROM data for time outs
	MOV	ES,CX
	MOV	DI,OFFSET PRINTER_TIME_OUT

	MOV	SI,OFFSET IO_TABLES

	MOV	CX,PRINTER_MAX		; For the max number of devices
INIT2:
	MOV	DX,PRINTER_MAX		; Get device number
	SUB	DX,CX
	MOV	AH,PIO_INIT		; and initialization code
	INT	PRINTER_IO_INTR  	; Init serial port

	MOV	AL,PCT_TIME_OUT[SI]
	STOSB
	ADD	SI,PCT_SIZE
	LOOP	INIT2			; Next device

;	Initialize the RS232 devices

	MOV	CX,SERIAL_MAX		; For the max number of devices
	MOV	SI,OFFSET SCT1
	MOV	DI,OFFSET SERIAL_TIME_OUT
INIT3:
	MOV	DX,SERIAL_MAX		; Get device number
	SUB	DX,CX
	MOV	AL,SCT_INIT[SI]		; Get initialization parameter
	MOV	AH,SIO_INIT		; and initialization code
	INT	SERIAL_IO_INTR  	; Init serial port

	MOV	AL,SCT_TIME_OUT[SI]
	STOSB
	ADD	SI,SCT_SIZE		; Address next table
	LOOP	INIT3			; Next device

;	Initialize CURRENT_DOS_LOCATION

	CALL	LOAD_DOS		; Load DOS and return address in AX
	MOV	CX,SEG SYSINIT
	MOV	DS,CX
	MOV	CURRENT_DOS_LOCATION,AX

;	Initialize FINAL_DOS_LOCATION

	MOV	AX,OFFSET BIOS_TRANSIENT ; Find first free para. after resident BIOS
	ADD	AX,15			; Adjust to next paragraph
	MOV	CL,4
	SHR	AX,CL
	ADD	AX,BIOS2_SEG
	MOV	FINAL_DOS_LOCATION,AX

;	Initialize MEMORY_SIZE

	INT	MEMORY_SIZE_INTR	; Find memory size
	MOV	CL,6			; Convert from 1k blocks to paragraphs
	SHL	AX,CL
	MOV	MEMORY_SIZE,AX		; Set memory size

;	Initialize DEVICE_LIST pointer to boot devices

	MOV	WORD PTR DEVICE_LIST,OFFSET CON		; CON driver is head of the list
	MOV	WORD PTR DEVICE_LIST+2,CS

	PUSH	CS			; Restore BIOS data
	POP	DS
	PUSH	CS
	POP	ES

;	Reset disk system

	SUB	AH,AH
	INT	DISK_IO_INTR

;	Determine number of floppy drives and set up disk tables

	INT	EQUIPMENT_INTR
	AND	AL,0C0H			; Isolate drive bits
	ROL	AL,1
	ROL	AL,1			; Put drive bits in low bits
	JNZ	INIT4
	MOV	BYTE PTR ONE_DRIVE,1	; Flag one drive system
	INC	AL			; Make one drive look like two
INIT4:
	INC	AL
	MOV	NUM_DISK,AL		; Set driver number of devices
	MOV	NUM_FLOPPY,AL

;	Check for fixed disks

	MOV	AH,DIO_GETPARMS		; Return drive parameters
	MOV	DL,80H			; Fixed disk 0
	INT	DISK_IO_INTR
	JC	INIT5			; No fixed disk controller
	OR	DL,DL			; Test for any drives attached
	JZ	INIT5			; No fixed disks attached.

;	Fixed disks exist, set up for MAX_FIXED partitions

	CMP	AUTO_FLAG,0		; Do we want auto assign?
	JNZ	INIT4A			; Yes, skip
	ADD	NUM_DISK,MAX_FIXED	; Show more drives available
INIT4A:
	MOV	AL,NUM_FLOPPY		; Prepare for updating DOS init. tables
	CMP	AL,MAX_FLOPPY
	JZ	INIT5			; No modification of DOS init. tables needed

;	Set up the DOS init. tables for the fixed disks

	MOV	SI,OFFSET BPB_TABLE+MAX_FLOPPY*2	; Set up source
	SHL	AL,1			; Word index
	CBW
	ADD	AX,OFFSET BPB_TABLE	; Add in base address
	MOV	DI,AX			; Set up destination
	MOV	CX,MAX_FIXED		; MAX_FIXED partitions
	REP	MOVSW			; Update init. table

;	Select the boot drive

INIT5:
	MOV	DL,BYTE PTR BOOT_BPB+BPB_UNIT	; Boot unit boot BPB
	TEST	DL,80H			; Check for fixed disk
	JNZ	INIT5A			; Booting from a fixed disk
	PUSH	DX			; Save boot drive
	XOR	DL,DL			; Flag to skip no drives
	CALL	ASSIGN_PART		; Log in a partition
	POP	DX			; Restore boot drive
	JMP	SHORT INIT6		; Finished, transfer to SYSINIT
INIT5A:
	CMP	AUTO_FLAG,0		; Auto-assign?
	JZ	INIT5B			; No, skip

	INC	NUM_ASSIGN		; Show one more assigned partition
	PUSH	ES
	CALL	ASSIGN_PART		; Look for DOS partitions on other drives
	POP	ES
INIT5B:
	MOV	DL,NUM_FLOPPY		; Set to correct fixed disk unit number
	
;	Do an assign on the fixed disk (copy the boot BPB
;	into the first slot in the FIXED BPB block)

	MOV	SI,OFFSET BOOT_BPB	; Get source offset
	MOV	DI,OFFSET FIXED_BPBS	; Get destination offset
	MOV	CX,TYPE BPB_STRUC	; Get count
	REP	MOVSB			; Set up table
	OR	ES:FIXED_FLAGS,7	; Set assigned flag,formatted flag and
					; changed flag for first fixed disk
	CMP	AUTO_FLAG,0		; Auto-assign?
	JZ	INIT6			; No, skip
	INC	BYTE PTR NUM_DISK	; Show one more drive (boot drive)
INIT6:
	MOV	AX,SEG SYSINIT
	MOV	DS,AX
	INC	DL			; DOS needs to 1 greater drive number
	MOV	DEFAULT_DRIVE,DL	; Select disk

	IF	DT_STAMP
	MOV	CS:TIM_FLG,0		; Allow date/time stamps now
	ENDIF

	JMP	SYSINIT			; Initialize MS-DOS

LINIT = OFFSET $ - OFFSET INIT_START

;	Reserve extra space for disk buffer
;	If Init. code becomes too large then some of it should be moved
;	to the end of the BIOS to be overwritten by DOS.

	IF LINIT GT BIOS_WORK
%OUT Bios init. code is to large to be overwritten for disk buffer
	ELSE
	DB	(BIOS_WORK-LINIT) DUP(0)
	ENDIF

	SUBTTL	Print to console routine
	PAGE


;**	This routine will print a message to the console
;
;	ENTRY:	DX = offset of message in code segment (end
;		     of message has high bit turned on)
;
;	EXIT:	None
;
;	USES:	DX, AL
;
PMSG	PROC	NEAR
	CLD
	XCHG	SI,DX		; Get address of message in index reg.
PMSG1:
	LODS	CS:NXT_CHAR	; Get CS overide on LODSB
	PUSH	AX
	AND	AL,7FH		; Strip high bit
	CALL	OUTCH
	POP	AX
	TEST	AL,80H		; End?
	JZ	PMSG1
	XCHG	DX,SI
	RET

PMSG	ENDP

;	Output the character in AL
;
OUTCH	PROC	NEAR
	PUSH	AX
	PUSH	BX

	MOV	AH,VIO_WTT
	MOV	BL,3
	INT	VIDEO_IO_INTR

	POP	BX
	POP	AX
	RET

OUTCH	ENDP

	SUBTTL	BIOS keyboard break function
	PAGE

;	On break interrupt put CTRL-C in look ahead buffer
;
KB_BREAK:
	MOV	BYTE PTR CS:NXT_CHAR,3

DUMMY_IRET:
	IRET

	SUBTTL	Strategy routine for all interrupts
	PAGE
;**	STRATEGY - This routine will save the packet passed by the DOS.
;		This information will later be used by the appropriate 
;		interrupt routine.
;
STRATEGY PROC FAR

CON_STRAT:
AUX_STRAT:
PRN_STRAT:
CLOCK_STRAT:
DISK_STRAT:
LPT1_STRAT:
LPT2_STRAT:
LPT3_STRAT:
COM1_STRAT:
COM2_STRAT:
	MOV	WORD PTR CS:PACKET,BX
	MOV	WORD PTR CS:PACKET+2,ES
	RET
STRATEGY ENDP


	SUBTTL	Interrput routines
	PAGE
;**	CON_INT - This routine passes the address of a jump
;		table to the common interrupt routine
;
CON_INT LABEL	FAR
	PUSH	SI
	MOV	SI,OFFSET CON_TABLE
	JMP	SHORT COMMON_INT

;**	AUX_INT - This routine passes the address of a jump
;		table and a device number to the common interrupt routine
;
AUX_INT:
COM1_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET COM_TABLE
	MOV	DX,0
	JMP	SHORT COMMON_INT1

COM2_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET COM_TABLE
	MOV	DX,1
	JMP	SHORT COMMON_INT1


;**	These routines pass the address of a jump
;	table and a printer index to the common interrupt routine
;
PRN_INT:
LPT1_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET LPT_TABLE
	MOV	DX,0
	JMP	SHORT COMMON_INT1

LPT2_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET LPT_TABLE
	MOV	DX,1
	JMP	SHORT COMMON_INT1

LPT3_INT:
	PUSH	SI
	PUSH	DX
	MOV	SI,OFFSET LPT_TABLE
	MOV	DX,2
	JMP	SHORT COMMON_INT1

;**	CLOCK_INT - This routine passes the address of a jump
;		table to the common interrupt routine
;
CLOCK_INT LABEL	FAR
	PUSH	SI
	MOV	SI,OFFSET CLOCK_TABLE
	JMP	SHORT COMMON_INT

;**	DISK_INT - This routine passes the address of a jump
;		table to the common interrupt routine
;
DISK_INT LABEL	FAR
	PUSH	SI
	MOV	SI,OFFSET DISK_TABLE
	JMP	SHORT COMMON_INT

	SUBTTL	Common interrupt routine
	PAGE
;*	COMMON_INT:	This is a common entry point for
;	interrupt procedures. It will save all registers,
;	dispatch the function and upon return restore registers
;	and return to the caller.
;
;	ENTRY:	SI - Address table of routines
;		DX - Device index for printers and communications
;		     (entry at COMMON_INT1 only).
;
;	EXIT:	None
;
COMMON_INT:
	PUSH	DX			; Save all registers

COMMON_INT1:
	CLI				; Set up a local stack
	INC	CS:RECURLV		; Bump recursion level, first time through?
	JNZ	COMMON_INT2		;   No, skip
	MOV	CS:SS_SAVE,SS		; Save the DOS stack
	MOV	CS:SP_SAVE,SP
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET STACK_TOP
COMMON_INT2:
	STI

	PUSHF
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	PUSH	DS

	PUSH	CS			; Set up addressing
	POP	DS
	LES	BX,PACKET		; Get address of packet

	MOV	CL,ES:SRH_CMD[BX]	; Get the command index
	SUB	CH,CH
	SHL	CX,1			; Make into a word offset
	ADD	SI,CX			; Index into address table
	JMP	[SI]			; Dispatch routine

COMMON_EXIT:
	LES	BX,CS:PACKET		; Get address of packet back
	OR	AH,SRHS_DON
	MOV	WORD PTR ES:SRH_STAT[BX],AX	; Return status
	POP	DS			; Restore all registers
	POP	ES
	POP	BP
	POP	DI
	POP	CX
	POP	BX
	POP	AX
	POPF

	CLI
	DEC	CS:RECURLV		; Dec recursion level, at bottom?
	JNS	COMMON_EXIT1		;   No, skip
	MOV	SS,CS:SS_SAVE		; Restore the DOS stack
	MOV	SP,CS:SP_SAVE
COMMON_EXIT1:
	STI

	POP	DX
	POP	SI			; Pushed by the initial interrupt routine

	RETF

	SUBTTL	Address tables for driver routines
	PAGE

;	Subroutine table for the "CON" driver.

CON_TABLE LABEL	WORD
	DW	OFFSET CON_INIT		; Init
	DW	OFFSET NO_OP		; Media check
	DW	OFFSET NO_OP		; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET CON_INPUT	; Console input
	DW	OFFSET CON_LOOK		; Console look-ahead
	DW	OFFSET NO_OP		; Console status
	DW	OFFSET CON_FLUSH	; Console flush
	DW	OFFSET CON_OUTPUT	; Console output
	DW	OFFSET CON_OUTPUT	; Console output and verify
	DW	OFFSET NO_OP		; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET UNKNOWN		; IOCTL OUTPUT

;	Subroutine table for the "AUX", "COM1", and "COM2" drivers.

COM_TABLE LABEL	WORD
	DW	OFFSET NO_OP		; Init
	DW	OFFSET NO_OP		; Media check
	DW	OFFSET NO_OP		; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET COM_INPUT	; input
	DW	OFFSET COM_LOOK		; look-ahead
	DW	OFFSET NO_OP		; status
	DW	OFFSET COM_FLUSH	; flush
	DW	OFFSET COM_OUTPUT	; output
	DW	OFFSET COM_OUTPUT	; output and verify
	DW	OFFSET COM_OUT_STAT	; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET UNKNOWN		; IOCTL OUTPUT

;	Subroutine table for the "PRN", "LPT1", "LPT2", and "LPT3" drivers.

LPT_TABLE LABEL	WORD
	DW	OFFSET NO_OP		; Init
	DW	OFFSET NO_OP		; Media check
	DW	OFFSET NO_OP		; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET NO_OP		; input
	DW	OFFSET BUSY		; look-ahead
	DW	OFFSET NO_OP		; status
	DW	OFFSET NO_OP		; flush
	DW	OFFSET LPT_OUTPUT	; output
	DW	OFFSET LPT_OUTPUT	; output and verify
	DW	OFFSET LPT_OUT_STAT	; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET NO_OP		; IOCTL OUTPUT

;	Subroutine table for the CLOCK$ driver

CLOCK_TABLE LABEL WORD
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET UNKNOWN
	DW	OFFSET CLOCK_READ
	DW	OFFSET BUSY
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET CLOCK_WRITE
	DW	OFFSET CLOCK_WRITE
	DW	OFFSET NO_OP
	DW	OFFSET NO_OP
	DW	OFFSET UNKNOWN

;	Subroutine table for the disk driver 

DISK_TABLE LABEL WORD
	DW	OFFSET DISK_INIT	; Init
	DW	OFFSET MEDIA_CHECK	; Media check
	DW	OFFSET BUILD_BPB	; Build BPB
	DW	OFFSET UNKNOWN		; IOCTL INPUT
	DW	OFFSET DISK_READ	; Disk read
	DW	OFFSET BUSY		; Non destructive read
	DW	OFFSET NO_OP		; Status
	DW	OFFSET NO_OP		; Flush
	DW	OFFSET DISK_WRITE	; Write
	DW	OFFSET DISK_WRITE_VERIFY ; Write and verify
	DW	OFFSET NO_OP		; Output status
	DW	OFFSET NO_OP		; Output flush
	DW	OFFSET UNKNOWN		; IOCTL OUTPUT

	SUBTTL	Commonly used exits for driver routines
	PAGE

;	Sucessful operation, clear all flags
SUCESS	PROC	NEAR

	SUB	AH,AH
	JMP	COMMON_EXIT

SUCESS	ENDP

;**	Set the busy status flag to show input queue empty
BUSY	PROC NEAR

	MOV	AH,SRHS_BUI
	JMP	COMMON_EXIT

BUSY	ENDP

;	Unknown command requested
UNKNOWN:
	MOV	AL,SRHS_EUKC		; Unknown command code
	JMP	SHORT ERROR		; Flag error

;	Correct the transfer count and flag error, used only for
;	 R/W packets with CX=Number of blocks/chars left untransferred 
ERRORC:
	LES	BX,CS:PACKET
	SUB	ES:CRW_CNT[BX],CX

;	Flag error
ERROR:
	MOV	AH,SRHS_ERR			; Flag error

;	No operation
NO_OP:
	JMP	COMMON_EXIT
	

	SUBTTL	Console routines
	PAGE

;**	SPECIAL - This routine is the special console output routine.
;		It is accessed by INT 29H

SPECIAL	PROC	FAR
	STI
	CALL	OUTCH
	IRET
SPECIAL ENDP


;**	CON_INPUT - Input a number of characters at the transfer address
;
CON_INPUT PROC	NEAR
	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LES	DI,ES:CRW_TADDR[BX]	; Get transfer address
	CLD

CI1:
	MOV	AL,0			; Clear out next character
	XCHG	NXT_CHAR,AL
	OR	AL,AL			; Was there a char in look-ahead
	JNZ	CI4			; Yes, return it.
CI2:
	MOV	AH,KIO_READ		; Code for input character
	INT	KEYBOARD_IO_INTR
	CMP	AX,CTL_PRTSC		; Check for CTRL-PRTSCR key
	JNZ	CI3
	MOV	AL,CC_DLE		; Map to ctrl-P
CI3:
	CMP	AL,0			; If special key then
	JNZ	CI4
	MOV	NXT_CHAR,AH		; Save scan code
CI4:
	STOSB
	LOOP	CI1
	JMP	SUCESS

CON_INPUT ENDP

;**	CON_LOOK - Do a look ahead on the keyboard buffer
;
;	EXIT:	BUSY flag set if no character available
;		BUSY clear and char if a character available
;	
CON_LOOK PROC	NEAR

	MOV	AL,NXT_CHAR		; See if look ahead has a character
	OR	AL,AL
	JNZ	CL1
	MOV	AH,KIO_LOOK		; Get ROM keyboard status
	INT	KEYBOARD_IO_INTR
	JZ	BUSY			; No char., skip
	OR	AX,AX			; Check for remnants of Ctrl-break
	JNZ	CL0			; Nope, valid character
	MOV	AH,KIO_READ		; Yep, eat this character
	INT	KEYBOARD_IO_INTR
	JMP	CON_LOOK		; Check for another
CL0:
	CMP	AX,CTL_PRTSC		; Check for CTRL-PRTSCREEN key
	JNZ	CL1
	MOV	AL,CC_DLE		; Map to control-P
CL1:
	MOV	ES:CIC_CHAR[BX],AL	; Pass character
	JMP	SUCESS

CON_LOOK ENDP


;**	CON_IN_STAT - Return input status
;		Return BUSY set if char avail
;
;	ENTRY:	DS=CS
;
;	EXIT:	BUSY set if character available
;		BUSY clear if no character
;
;	USES:	None
CON_IN_STAT PROC NEAR

	MOV	AL,NXT_CHAR		; See if look ahead has a character
	OR	AL,AL
	JNZ	BUSY
	MOV	AH,KIO_LOOK		; Get ROM keyboard status
	INT	KEYBOARD_IO_INTR
	JZ	SUCESS			; No char., skip
	JMP	BUSY

CON_IN_STAT ENDP


;**	CON_FLUSH - This routine will flush the console input buffer.
;
;	ENTRY:	None
;
;	EXIT:	None
;
;	USES:	None
;
CON_FLUSH PROC NEAR

	CALL	CF
	JMP	SUCESS

CON_FLUSH ENDP

;	This routine does the actual flush of the console buffer
;	 This routine must save registers since it is called
;	 the disk I/O routine.
CF	PROC	NEAR
	MOV	NXT_CHAR,0		; Flush look ahead

	PUSH	AX			; Save registers (CON_FLUSH used in disk I/O)
	PUSH	DS

	MOV	AX,ROM_DATA		; Point to ROM data
	MOV	DS,AX

	ASSUME	DS:ROM_DATA

	MOV	AX,BUFFER_HEAD		; Get offset of beginning of buffer
	MOV	BUFFER_TAIL,AX		; Get pointer to buffer head

	POP	DS			; Restore all registers

	ASSUME	DS:BIOS

	POP	AX

	RET

CF	ENDP


;**	CON_OUTPUT - Print characters to the screen
;	
CON_OUTPUT PROC	NEAR

	CLD
	MOV	CX,ES:[BX+CRW_CNT]
	LDS	SI,ES:[BX+CRW_TADDR]	; Get the address of characters
CO1:
	LODSB
	MOV	AH,VIO_WTT	; Write teletype
	MOV	BL,3	 	; BL=foreground color
	INT	VIDEO_IO_INTR	; Print char.
	LOOP	CO1
	JMP	SUCESS

CON_OUTPUT ENDP


	SUBTTL	Printer routines
	PAGE

;**	LPT_OUTPUT - This routine will print the character in AL to the
;		printer
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;	EXIT:	None
;
LPT_OUTPUT PROC NEAR

	MOV	CX,ES:[BX+CRW_CNT]	; Get transfer count
	LDS	SI,ES:[BX+CRW_TADDR]	; Get transfer address
LP1:
	MOV	BL,0			; Prepare for retry
	LODSB
LP2:
	MOV	AH,PIO_WRITE		; Print the char in AL
	INT	PRINTER_IO_INTR

	MOV	BH,AL			; Save character
	CALL	LPT_STAT		; Decode printer status
	JNC	LP5			; If error, try one more time

	XOR	BL,1			; Flip retry flag 
	JZ	ERROR1C			; Have already done retry, bail out
	MOV	AL,BH			; Restore the char.
	JMP	SHORT LP2		; Retry the operation
LP5:
	LOOP	LP1
	JMP	SUCESS

LPT_OUTPUT ENDP


;	LPT_OUT_STAT - This procedure returns the LPT device output status
;
;	ENTRY:	ES:BX - Packet pointer
;		DS - BIOS segment
;
;	EXIT:	BUSY set - Printer is busy
;		BUSY clear - Printer not busy
;
LPT_OUT_STAT PROC	NEAR

	MOV	AH,PIO_STATUS		; Do printer status
	INT	PRINTER_IO_INTR

	CALL	LPT_STAT		; Decode status
	JC	ERROR1			; Flag error
LS_EXIT:
	TEST	AH,1 SHL 7		; Is the printer busy?
	JZ	BUSY1
	JMP	SUCESS

LPT_OUT_STAT ENDP

;	LPT_STAT - General routine to decode printer status
;
;	ENTRY:	AH - Printer status returned from ROM
;
;	EXIT:	'C' set - error has occured, AL has MS-DOS error code
;		'C' clear - No error
;
LPT_STAT PROC	NEAR

	MOV	AL,SRHS_EDNR		; Prepare for device not ready
	TEST	AH,1 SHL 0
	JNZ	LPT_ERR			; Error, drive not ready
	MOV	AL,SRHS_EWRF		; Prepare for write fault
	TEST	AH,1 SHL 3		; Test I/O error
	JZ	LPT_NO_ERR		; No error occured
	TEST	AH,1 SHL 5		; Test out of paper
	JZ	LPT_ERR
	MOV	AL,SRHS_ENPP		; No paper error
LPT_ERR:
	STC
	RET

LPT_NO_ERR:
	CLC
	RET

LPT_STAT ENDP


	SUBTTL	Serial routines
	PAGE

;**	COM_INPUT - Auxilliary Input
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	None
;
COM_INPUT PROC NEAR

	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LES	DI,ES:CRW_TADDR[BX]	; Get transfer address
	MOV	SI,DX
	SUB	AL,AL
	XCHG	AL,COM_BUF[SI]		; See if a char. is in the look ahead
	OR	AL,AL
	JNZ	CMI2
CMI1:
	CALL	COM_IN
	JC	CMI3
CMI2:
	STOSB
	LOOP	CMI1
	JMP	SUCESS
CMI3:
	JMP	ERRORC

COM_INPUT ENDP

;**	COM_OUTPUT - Auxilliary output
;
;	ENTRY:	AL - Character to be output
;
;	EXIT:	None
;
;	USES:	AL

COM_OUTPUT PROC NEAR

	MOV	CX,ES:CRW_CNT[BX]	; Get transfer count
	LDS	SI,ES:CRW_TADDR[BX]	; Get transfer address
CMO1:
	LODSB
	MOV	AH,SIO_WRITE		; Char in AL is sent
	INT	SERIAL_IO_INTR
	TEST	AH,1 SHL 7		; Check for time-out
	MOV	AL,SRHS_EWRF		; Prepare for error
	JNZ	ERROR1C			; Error exit
	LOOP	CMO1
	JMP	SUCESS

COM_OUTPUT ENDP

;	Stepping stone jumps for short jumps
BUSY1:	JMP	BUSY
ERROR1: JMP	ERROR
ERROR1C:JMP	ERRORC


;	COM_LOOK - This routine returns a character from the COM device
;
;	ENTRY:	ES:BX - Packet
;		DS - BIOS segment
;
;	EXIT:	BUSY set - no char available
;		BUSY Clear - Char returned in packet
;
COM_LOOK PROC NEAR

	MOV	SI,DX			; Index into look ahead buffer
	MOV	AL,COM_BUF[SI]		; Get look ahead
	OR	AL,AL			; Is there a character?
	JNZ	CIL1			; Yes, jump else
	CALL	COM_STAT		; Get serial status
	TEST	AH,1 SHL 0		; Is data ready?
	JZ	BUSY1			; No, jump else
	TEST	AH,1 SHL 5		;  is data set ready?
	JZ	BUSY1			; No, jump else
	CALL	COM_IN			; Get the character
	JC	ERROR1			; If error in input flag it
	MOV	COM_BUF[SI],AL		; Save character
CIL1:
	MOV	ES:CIC_CHAR[BX],AL	; Return character to DOS
	JMP	SUCESS

COM_LOOK ENDP


;	COM_OUT_STAT - This routine will return the output status
;		of a serial device
;
;	ENTRY:	ES:BX - Packet
;
;	EXIT:	BUSY set - Output request will wait for device
;		BUSY celar - Output request will execute immediately
;
COM_OUT_STAT PROC NEAR

	CALL	COM_STAT		; Get port status
	TEST	AL,1 SHL 5		; DSR asserted?
	JZ	BUSY1			; No, receiver busy
	TEST	AH,1 SHL 5		; Transmitter empty?
	JZ	BUSY1			; No, device busy
	JMP	SUCESS

COM_OUT_STAT ENDP

;	COM_FLUSH - Flush the COM look ahead
COM_FLUSH PROC	NEAR

	MOV	SI,DX			; Get index
	MOV	COM_BUF[SI],0		; Flush look ahead
	JMP	SUCESS

COM_FLUSH ENDP


;	COM_STAT - Common status routine fom COM routines
COM_STAT PROC	NEAR

	MOV	AH,SIO_STATUS		; Return device status
	INT	SERIAL_IO_INTR
	RET

COM_STAT ENDP

;	COM_IN - Common input routine for COM routines
COM_IN	PROC	NEAR

	MOV	AH,SIO_READ		; Read a character
	INT	SERIAL_IO_INTR
	TEST	AH,1 SHL 7		; Test for time out
	JNZ	COM_IN
	TEST	AH,0EH			; Test for errors
	JZ	CMIN1			; No errors jump
	MOV	AL,SRHS_ERDF		; else flag read error
	STC				; Notify caller
	RET
CMIN1:
	CLC				; Sucessful read
	RET

COM_IN	ENDP



	SUBTTL BIOS Disk change status
	PAGE

;*	MEDIA_CHECK - return the disk change status
;		If a floppy 
;		     Check if drive has been accessed within last
;		     2 secs, if so, return no change, else return
;		     don't know.
;		If a fixed disk
;		  1) Check if partition is assigned, if not return
;		     drive not ready else 2)
;		  2) Check formatted flag. If not formatted return drive not ready
;		     else 3)
;		  3) Check for drive changed flag. If not changed then return
;		     disk not changed. If changed flip media byte to ensure
;		     DOS sees different media and return disk changed.
;		     
;	ENTRY:	ES:BX - Pointer to DOS packet
;		DS = CS
;
;	EXIT:	Packet status = Disk change status (-1 disk has changed,
;					  0 don't know,
;					  1 disk has not changed)
;
MEDIA_CHECK PROC NEAR

	MOV	ES:CMC_STAT[BX],CMCS_DKN	; Don't know if disk changed
	MOV	AL,ES:SRH_UNIT[BX]		; Need to check for fixed disk
	CMP	AL,NUM_FLOPPY
	JAE	MC1				; Yes fixed disk, more processing
	
	IF	D_2SEC				; Assemble if 2 sec delay chosen

;	See when floppy was last accessed


	CBW
	MOV	CL,2
	SHL	AX,CL				; Make unit into dword pointer
	MOV	DI,AX
	MOV	CS:WORD PTR TIM_PTR,AX		; Store pointer for later use
	MOV	AH,TOD_GET			; Get time from system
	INT	TIME_OF_DAY_INTR
	CMP	AL,0				; Same day?
	JNZ	MC0				; No
	SUB	DX,CS:WORD PTR DSK_TIMOUT[DI]	; Get number of elapsed ticks
	SBB	CX,CS:WORD PTR DSK_TIMOUT[DI+2]
	JNZ	MC0				; Jump if too many ticks
	CMP	DX,DSK_MAXVAL			; More than DSK_MAXVAL ticks?
	JG	MC0				; Yes
	INC	ES:BYTE PTR CMC_STAT[BX]	; Flag as not changed
MC0:
	ENDIF
	JMP	TIM_RESET			; Reset timer and exit


;	Find correct fixed BPB

MC1:
	SUB	AL,NUM_FLOPPY			; Base at 0 for index
	CBW
	MOV	DI,AX
	MOV	AL,SRHS_EDNR			; Get ready for drive not ready error
	TEST	FIXED_FLAGS[DI],1 SHL 0		; Is disk assigned?
	JZ	MC2
	TEST	FIXED_FLAGS[DI],1 SHL 1		; Is disk formatted?
	JNZ	MC3
MC2:
	JMP	ERROR1

;	Address the BPB for this drive
MC3:
	MOV	AX,DI
	MOV	AH,TYPE BPB_STRUC
	MUL	AH
	ADD	AX,OFFSET FIXED_BPBS
	MOV	SI,AX

	TEST	FIXED_FLAGS[DI],1 SHL 2		; Is disk changed?
	JNZ	MC4
MC35:
	INC	BYTE PTR ES:CMC_STAT[BX]	; Flag as not changed
	JMP	SUCESS
MC4:
	AND	FIXED_FLAGS[DI],NOT (1 SHL 2)	; Make into a valid BPB
MC5:
	DEC	BYTE PTR ES:CMC_STAT[BX]	; Flag as changed
	JMP	SUCESS

MEDIA_CHECK ENDP


	SUBTTL Build BPB for disk
	PAGE
;**	BUILD_BPB
;	  Return the address of a BPB that describes
;	  the requested unit. If a floppy, index off of media byte
;	  If a fixed disk, index off of unit
;
;	ENTRY:	ES:BX - packet
;		DS - BIOS segment
;
;	EXIT:	Packet has pointer to new BPB
;
BUILD_BPB PROC	NEAR

;	Check for a fixed disk

	MOV	AL,ES:SRH_UNIT[BX]
	CMP	AL,NUM_FLOPPY
	JAE	BBPB1			; Get BPB for fixed disk

;	Get BPB for floppy disk

	LDS	SI,ES:CBPB_TADDR[BX]	; Get media byte
	LODSB
	PUSH	CS			; Restore data
	POP	DS

	AND	AL,3			; Index based on FAT bits
	MOV	SI,OFFSET FLOPPY_BPBS	; Get address of BPB
	JMP	SHORT BBPB2

;	Get BPB for fixed disk

BBPB1:
	SUB	AL,NUM_FLOPPY
	MOV	SI,OFFSET FIXED_BPBS	; Get address of fixed BPB's
BBPB2:
	MOV	AH,TYPE BPB_STRUC
	MUL	AH
	ADD	AX,SI

	MOV	WORD PTR ES:CBPB_BADDR[BX],AX	; Return offset and segment
	MOV	WORD PTR ES:CBPB_BADDR[BX+2],CS
	JMP	SUCESS

BUILD_BPB ENDP

	SUBTTL	Disk I/O
	PAGE


;**	DISK I/O - This routine will handle all disk I/O calls
;
;	ENTRY:	ES:BX - pointer to DOS packet 
;		DS = CS
;
;	EXIT:	None
;

DISK_READ LABEL NEAR

	MOV	DOP_TYPE,DIO_READ	; Read operation
	JMP	SHORT DOP1

DISK_WRITE_VERIFY LABEL NEAR
	MOV	DOP_VERIFY,1		; Write with verify
	JMP	SHORT DOP0

DISK_WRITE LABEL NEAR
	MOV	DOP_VERIFY,0		; Write no verify
DOP0:
	MOV	DOP_TYPE,DIO_WRITE	; Write operation
DOP1:
	MOV	CX,ES:CRW_CNT[BX]	; Count of sectors
	CMP	CX,0			; If count = 0 then done
	JNZ	DOP2
	JMP	SUCESS

;	Set up SI to point to disk BPB table

DOP2:
	MOV	SEC_CNT,CX		; Save sector count
	MOV	OLD_SP1,SP		; Save stack for error exit
	MOV	AL,ES:SRH_UNIT[BX]	; Get unit and save
	CMP	AL,NUM_FLOPPY
	JAE	DOP3			; Not a floppy, set up fixed disk

	MOV	DRIVE,AL


;	Address disk parameter table

	MOV	AL,ES:CRW_MBYTE[BX]	; Get the media byte
	AND	AL,3H			; Get the 9 X 512 bit and the 1 side bit
	MOV	AH,TYPE BPB_STRUC
	MUL	AH
	ADD	AX,OFFSET FLOPPY_BPBS
	MOV	SI,AX			; Get pointer to BPB table
	MOV	AL,BYTE PTR BPB_SPT[SI]
	SUB	DX,DX
	MOV	DS,DX

	ASSUME	DS:NOTHING

;	Set the floppy disk parameter table with sectors per track

TMP	=	BIOS_EXTRA SHL 4 + OFFSET BIOS_DPT + 4
	MOV	BYTE PTR DS:[TMP],AL

	PUSH	CS
	POP	DS

	ASSUME	DS:BIOS

	JMP	SHORT DOP5

;	Set up SI to point to Fixed disk BPB

DOP3:
	SUB	AL,NUM_FLOPPY		; Index from 0
	MOV	AH,TYPE BPB_STRUC	; Get offset of correct table
	MUL	AH
	ADD	AX,OFFSET FIXED_BPBS
	MOV	SI,AX			; Get address of BPB

	MOV	AL,BPB_UNIT[SI]		; Get and set unit of partition
	MOV	DRIVE,AL
	
DOP5:
	MOV	CX,SEC_CNT		; Set up sector count in case of error

;	Check if last requested sector lies on this disk

	MOV	DX,ES:CRW_START[BX]

	IF	DT_STAMP
	MOV	CS:FIRST_SEC,DX		; Save first sector for later use
	ENDIF

	MOV	DI,DX			; Start sector
	ADD	DI,CX			; # of sectors
	JC	DOP7			; Bad parms, no such sector

DOP6:
	CMP	DI,BPB_SECS[SI]	; compare to last sector on disk
	JBE	DOP8			; Request OK

DOP7:
	MOV	AL,SRHS_ESNF		; Sector not found error
	JMP	DISK_ERROR1

DOP8:
	ADD	DX,BPB_HIDDEN[SI]	; Add in hidden sectors

;	Check for a one drive system and map if necessary

	MOV	AL,DRIVE		; Check for a fixed disk
	TEST	AL,80H
	JNZ	DOP10			; Not a floppy, no logical drives

	CMP	ONE_DRIVE,1
	JNE	DOP10			; Not a one drive system
	SUB	DI,DI
	MOV	DS,DI			; Address base page

	ASSUME	DS:NOTHING

	MOV	AH,AL			; Save drive
TMP	=	BIOS_EXTRA SHL 4 + OFFSET LAST_DRIVE
	XCHG	DS:[TMP],AH		; Fetch and update last accessed drive
	PUSH	CS			; Restore BIOS data
	POP	DS

	ASSUME	DS:BIOS

	CMP	AL,AH			; Check if accessing same drive
	JZ	DOP9			; Same drive, no mapping

;	Map the imaginary drive and get a disk from the user

	ADD	AL,'A'          	; Map to a drive letter
	MOV	NEW_DISK,AL		; Put in message

	PUSH	DX			; Ask user for a disk
	MOV	DX,OFFSET DISK_MSG
	CALL	PMSG
	POP	DX

	CALL	CF			; Flush input buffer
	SUB	AH,AH			; Wait for a character to be typed
	INT	KEYBOARD_IO_INTR
DOP9:
	MOV	DRIVE,0			; Physical drive 0

;	Calculate track, sector number and head

DOP10:
	CALL	DECODE			; Set necessary regs for call to DOP18
	MOV	DL,DRIVE		; Move drive to DL for ROM

;	Check if transfer lies within this 64K boundry for DMA

	LES	BX,ES:CRW_TADDR[BX]	; Get transfer address
DOP11:
	MOV	AX,ES			; Get 16 bits of transfer address
	PUSH	CX
	MOV	CL,4
	SHL	AX,CL
	MOV	CL,9			; Prepare for next shift operation
	ADD	AX,BX
	NEG	AX			; Find remainder of this 64K
	JNZ	DOP12
	MOV	AH,80H			; Special case, full 64K available
	DEC	CL			; Correct shift count
DOP12:
	SHR	AX,CL			;  this 64K
	POP	CX
	JZ	DOP14			; If none left in this 64K, get 1 sector
	CMP	AX,SEC_CNT		; Can request be honored?
					;  AX <  SEC_CNT Can't service
					;  AX >= SEC_CNT Can service
	JB	DOP13
	MOV	AX,SEC_CNT

;	R/W the requested number of sectors

DOP13:
	CALL	DOP18			; R/W the sectors
	JC	DISK_ERRORL
	CMP	SEC_CNT,0		; Update sector count
	JNZ	DOP14			; R/W across 64kb boundry

DISK_EXIT:
	IF	DT_STAMP

;	Since the date/time stamp routine uses DISK_BUF, we can't
;	do stamping until BIOS initialization has been completed,
;	and TIM_FLG has been set to 0.

	CMP	CS:TIM_FLG,0		; Are stamps allowed?
	JNZ	TIM_RESET		; No
	CALL	UPDATE			; Update date/time stamp on disk

	ENDIF

TIM_RESET:
	IF	D_2SEC

	MOV	DI,CS:WORD PTR TIM_PTR	; Get offset into timout table
	MOV	CS:WORD PTR TIM_PTR,0FFFH	; Make pointer invalid
	MOV	AL,NUM_FLOPPY		; Get number of floppies
	CBW
	MOV	CL,2			; Make an offset
	SHL	AX,CL
	CMP	DI,AX              	; Is it a floppy?
	JGE	DISK_EXIT1		; No
	MOV	AH,TOD_GET		; Get time from ROM
	INT	TIME_OF_DAY_INTR
	MOV	CS:WORD PTR DSK_TIMOUT[DI],DX	; Store low word
	MOV	CS:WORD PTR DSK_TIMOUT[DI+2],CX	; Store high word

DISK_EXIT1:
	ENDIF
	JMP	SUCESS		; All done!

;	Need to R/W 1 sector to cross 64Kb boundry

DOP14:
	CLD				; Clear direction for later use
	PUSH	ES			; Save user buffer area
	PUSH	BX

	CMP	DOP_TYPE,DIO_READ
	JZ	DOP15			; Read one sector

;	Copy user data to internal buffer and write it

	PUSH	ES			; Set up segments for source and dest.
	PUSH	CS
	POP	ES
	POP	DS
	PUSH	SI			; Save disk table pointer
	MOV	SI,BX			; Set up source offset
	MOV	DI,OFFSET DISK_BUF	; Set up dest. offset
	MOV	BX,DI			; Set up X-fer offset for disk write

	PUSH	CX			; Save CX
	MOV	CX,SEC_SIZE/2		; Move 1 sector (512b) of data
	REP	MOVSW
	POP	CX			; Restore CX
	POP	SI			; Restore disk table pointer
	PUSH	CS			; Restore data segment
	POP	DS

	CALL	DOP17			; Write 1 sector
	JC	DISK_ERRORL
	POP	BX			; Restore user buffer
	POP	ES
	ADD	BH,SEC_SIZE SHR 8
	JMP	SHORT DOP16

DISK_ERRORL:
	JMP	DISK_ERROR

;	Read 1 sector, transfer it to the users area and continue

DOP15:
	PUSH	CS			; Set up BIOS transfer address
	POP	ES
	MOV	BX,OFFSET DISK_BUF
	CALL	DOP17
	JC	DISK_ERRORL
	POP	DI			; restore user transfer address
	POP	ES

	PUSH	SI			; Save disk pointer table
	MOV	SI,OFFSET DISK_BUF
	PUSH	CX			; Save CX
	MOV	CX,SEC_SIZE/2		; Move 1 sector of data to user
	REP	MOVSW
	POP	CX			; restore CX
	POP	SI			; Restore disk table pointer

	MOV	BX,DI			; Update user address
DOP16:
	CMP	SEC_CNT,0		; All done?
	JZ	DISK_EXITL
	JMP	DOP11
DISK_EXITL:
	JMP	DISK_EXIT

;*	Read/Write sectors
;
;	Entry:
;		AX - count of sectors to R/W (1 if entering at DOP17)
;		CH - Track number
;		CL - Sector number
;		DL - Drive
;		DH - Head number
;		ES:BX - transfer address
;		DS:SI - BPB of disk
;		DOP_TYPE - Code to pass the ROM for read or write
;
;	Exit:
;		'C' set, a disk error has occured
;		'C' clear, operation sucessful
;		AX,
;		BX (updated load address),
;		CX (updated track and sector),
;		DH (updated head number),
;		DI.
;
DOP17:
	MOV	AX,1			; R/W 1 Sector
DOP18:
	MOV	OLD_SP2,SP		; Save old stack for quick error exit
	MOV	RETRY_COUNT,NUM_RETRY
	PUSH	AX			; Save count
	MOV	AL,BYTE PTR BPB_SPT[SI]	; Get sectors per track
	PUSH	CX
	AND	CL,3FH
	SUB	AL,CL			; How many sectors left on this track?
	POP	CX
	INC	AL
	CBW				; Clear high byte
	POP	DI			; Restore count
	CMP	DI,AX			; See if request will fit in this track	
	JAE	DOP19			; Yes, fulfill request
	MOV	AX,DI			; No, get remainder of this track

;	Do the actual disk read/write

DOP19:
	PUSH	AX			; Save count
	MOV	AH,DOP_TYPE		; Pass operation type
	INT	DISK_IO_INTR		; Call ROM
	JC	RETRY			; Retry on error
	POP	AX			; Restore count

;	Check for verify

	CMP	WORD PTR DOP_TYPE,1 SHL 8 + DIO_WRITE ; Check for verify-write
	JNZ	DOP20
	PUSH	AX
	MOV	AH,DIO_VERIFY		; Verify sectors
	INT	DISK_IO_INTR
	JC	RETRY
	POP	AX

DOP20:
	SUB	SEC_CNT,AX		; Update sector count

	MOV	AH,AL			; Copy sector count to AH
	SHL	AH,1			; Turn into 512 byte sectors
	ADD	BH,AH			; Update load address
	SUB	AH,AH			; Fix up sector count

	SUB	DI,AX			; Update count

;	Update head, track and sector

DOP21:
	PUSH	BX			; Free up a register
	MOV	BH,CL			; Get Cylinder in BX
	ROL	BH,1
	ROL	BH,1
	AND	BH,3
	MOV	BL,CH

	AND	CL,3FH			; Isolate sector bits
	ADD	CL,AL			; Get new sector to start at
	CMP	CL,BYTE PTR BPB_SPT[SI]	; Check if beyond end of track
	JBE	DOP22			; No, skip
	MOV	CL,1			; Past end, now at sector 1
	INC	DH
	CMP	DH,BYTE PTR BPB_HEADS[SI]
	JB	DOP22
	SUB	DH,DH			; Back to head zero
	INC	BX			; Next track
DOP22:
	ROR	BH,1			; Set up track and sector registers
	ROR	BH,1
	OR	CL,BH
	MOV	CH,BL
	POP	BX			; Restore transfer address

	CMP	DI,0			; Operation done?
	JNZ	DOP23
	CLC
	RET
DOP23:
	MOV	AX,DI			; Update remaining sector count
	JMP	DOP18			; Continue

RETRY:
	PUSH	AX			; Save return code
	MOV	AH,DIO_RESET		; Reset disk system
	INT	DISK_IO_INTR
	POP	AX			; Restore return
	CMP	AH,TIME_OUT		; Test for disk time out
	JZ	RETRY1
	DEC	RETRY_COUNT
	JZ	RETRY1
	POP	AX			; Restore count and
	JMP	DOP19			;  try again
RETRY1:
	MOV	SP,OLD_SP2		; Restore stack to entry conditions
	STC				; Show error
	RET

;	Retry error has occured. Get the ROM error code and map to
;	an MS-DOS error code.

DISK_ERROR:
	PUSH	CS			; Set up addressing
	POP	ES
	MOV	AL,AH			; Code in AL for scan
	MOV	CX,L_ERR		; Length of table
	MOV	DI,OFFSET T_ERR
	CLD
	REPNZ	SCASB
	MOV	AL,[DI+(L_ERR-1)]	; Get the mapped error code

;*	Disk error
;
;	Entry: AL - Error code
;	       SEC_CNT - Count of sectors not yet done
;
DISK_ERROR1:
	MOV	CX,SEC_CNT		; Return the number of sectors left to transfer
	MOV	SP,OLD_SP1		; Pop the stack to entry conditions
	JMP	ERRORC


	IF	DT_STAMP
;	Routine to update date/time stamp on a disk.
;	If no update has been made for at least 2 min,
;	the current date/time is written to the boot loader
;	of the disk that was just accessed.
;
;	Entry:	DS:SI - Pointer to BPB for disk
;		DRIVE - Drive number for ROM
;		FIRST_SEC - First sector of previous disk operation
;
;	Exit:	None
;

UPDATE	PROC	NEAR
	CMP	CS:FIRST_SEC,MIN_SEC	; Is sector in range?
	JNC	UPDT_EXIT		; No
	MOV	AH,TOD_GET		; Get time from ROM
	INT	TIME_OF_DAY_INTR
	PUSH	CX			; Save time
	PUSH	DX
	CMP	AL,0			; New day?
	JNZ	UPDT 			; Yes
	SUB	DX,CS:WORD PTR TIM_TOD	; Get elapsed time
	SBB	CX,CS:WORD PTR TIM_TOD[2]
	JNZ	UPDT			; More than TOD_LIM has passed
	CMP	DX,TOD_LIM
	JL 	NO_UPDT			; Time is not up yet
UPDT:
	MOV	CS:DOP_TYPE,DIO_READ	; Prepare to read loader sector
	CALL	RWSEC			; Read it
	JC	NO_UPDT			; Ignore if error
	CMP	CS:WORD PTR (DISK_BUF+3),'DZ'  ; Check loader version
	JNZ	NO_UPDT			; Wrong version
	CMP	CS:BYTE PTR (DISK_BUF+5),'S'   ; More version check
	JNZ	NO_UPDT			; Wrong version
	POP	DX			; Restore time
	POP	CX
	MOV	DI,OFFSET DISK_BUF	; Point to disk buffer
	MOV	CS:[DI+LOADER_DATE_OFFSET],DX     ; Store time
	MOV	CS:[DI+2+LOADER_DATE_OFFSET],CX
	MOV	AX,CS:DATE				  ; Store date
	MOV	CS:[DI+4+LOADER_DATE_OFFSET],AX
	MOV	CS:WORD PTR TIM_TOD,DX	; Reset timer with current time
	MOV	CS:WORD PTR TIM_TOD[2],CX
	MOV	CS:DOP_TYPE,DIO_WRITE	; Prepare to re-write sector
	CALL	RWSEC			; Write it
	RET	         		; Done
NO_UPDT:
	POP	DX			; Clean stack
	POP	CX
UPDT_EXIT:
	RET
UPDATE	ENDP


;	Routine to read or write sector 0 (boot loader) on the last 
;	drive accessed.
;
;	Called from UPDATE

RWSEC 	PROC	NEAR
	PUSH	ES			; Save pointer to DOS packet
	PUSH	BX
	PUSH	CS			; Load ES with code segment pointer
	POP	ES
	SUB	DX,DX			; Sector 0
	ADD	DX,BPB_HIDDEN[SI]	; Add hidden sectors
	CALL	DECODE			; Get head, sector and cylinder
	MOV	DL,CS:DRIVE		; Drive number for ROM
	MOV	BX,OFFSET DISK_BUF	; Set transfer address
	CALL	DOP17			; Perform the I/O
	POP	BX			; Restore pointer to DOS packet
	POP	ES
	RET
RWSEC	ENDP

	ENDIF


;	DECODE - This routine will take a MS-DOS logical sector number
;		and decode it into head sector and cylinder for the
;		given disk.
;
;	ENTRY:	DX - Logical sector number
;		DS:SI - Pointer to BPB for this disk
;
;	EXIT:	CH - Cylinder number
;		CL - Sector number
;		DH - Head
;
;	USES:	AX
;
DECODE	PROC	NEAR

	PUSH	BX
	MOV	BX,DX
	SUB	AX,AX
	XCHG	AX,DX			; AX = Start sector
	DIV	WORD PTR BPB_SPT[SI]	; divide by sectors per track
	INC	DL			; DL = Sector #, AX = track
	MOV	CL,DL			; Move sector into CL for ROM
	SUB	DX,DX
	DIV	WORD PTR BPB_HEADS[SI]
	MOV	DH,DL			; Put head into DH for ROM
	AND	AH,3			; Ensure only two high bits for cyl.
	ROR	AH,1			; Move high cyl. bits to left side of byte
	ROR	AH,1
	OR	CL,AH			; Set sector and cyl. high bits
	MOV	CH,AL			; Low part of cyl. for ROM
	MOV	DL,BL			; Restore DL
	POP	BX
	RET

DECODE	ENDP


	SUBTTL Clock functions
	PAGE
;**	This routine will save the date passed by the system for later use
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	None
;

CLOCK_WRITE PROC NEAR

	LES	BX,ES:CRW_TADDR[BX]	; Get transfer address
	MOV	AX,ES:[BX]		; Get days
	MOV	DATE,AX			; Save the date count
	MOV	CX,ES:[BX+2]		; Get time
	MOV	DX,ES:[BX+4]


;**	This routine will set the current time in the BIOS.
;
;	ENTRY:	CH - Hours (0-23)
;		CL - Minutes (0-59)
;		DH - Seconds (0-59)
;		DL - Hundredths of seconds (0-99)
;

	MOV	AL,60			; Multiply hours*60
	MUL	CH
	SUB	CH,CH			; Add in minutes
	ADD	AX,CX
	MOV	BX,DX			; Save parameters
	MOV	CX,60			; minutes*60
	MUL	CX
	MOV	CL,BH			; Add in seconds
	ADD	AX,CX
	ADC	DX,0

	PUSH	BX			; Save parameters
	MOV	CX,100			; Seconds * 100
	CALL	MULT
	POP	BX
	SUB	BH,BH
	ADD	AX,BX			; Add in hundredths of seconds
	ADC	DX,0
	MOV	CX,TICCNT		; Multiply by clock frequency/20
	CALL	MULT
	SUB	AX,AX			; Ignore low 16 bits (divide by 65536)
	XCHG	AX,DX
	XCHG	AX,CX
	MOV	BX,5			; Find number of tics (32 bit divide)
	DIV	BX
	XCHG	AX,CX
	DIV	BX

	MOV	DX,AX			; Move parameter into correct register
	MOV	AH,TOD_SET		; Set TOD
	INT	TIME_OF_DAY_INTR
	JMP	SUCESS

;*	This routine will do a 32 bit X 16 bit multiply
;
;	ENTRY:	DX:AX - 32 bit multiplicand
;		CX - 16 bit multiplier
;
;	EXIT:	CX:DX:AX - 48 bit result
;
;	USES:	AX, BX, CX, DX
MULT	PROC	NEAR

	MOV	BX,DX			; Save high 16 bits
	MUL	CX			; Multiply low 16 bits
	PUSH	DX			; Save high part of result
	XCHG	AX,BX			; Save low part of result and get high multiplicand
	MUL	CX			; Multiply high 16 bits
	MOV	CX,DX			; Save high part of result
	MOV	DX,AX			; Move middle part of result to correct reg.
	POP	AX			; Get carry out of low multiply
	ADD	DX,AX			; correct middle part of result
	ADC	CX,0			; Correct high part if necessary
	MOV	AX,BX			; restore low part of result
	RET

MULT	ENDP

CLOCK_WRITE ENDP

	SUBTTL	BIOS Return date and time function
	PAGE

;**	This routine will return the current date and time.
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	Modified transfer address giving date and time info.

CLOCK_READ	PROC	NEAR

	PUSH	BX			; Save BX

	MOV	AH,TOD_GET		; Get time of day
	INT	TIME_OF_DAY_INTR

	ADD	CS:DATE,AX		; Update the day
	XCHG	AX,CX			; Get high part of tic in DX and low in AX
	XCHG	AX,DX
	MOV	CX,5			; Multiply times 5
	CALL	MULT

	MOV	CX,TICCNT		; Divide DX:AX by TICCNT
	DIV	CX
	MOV	BX,AX
	SUB	AX,AX
	DIV	CX
	MOV	DX,BX			; DX:AX = Time in hundredths of seconds

	MOV	CX,200			; Divide by 200 so result fits in 16 bits
	DIV	CX
	XCHG	AX,DX
	MOV	CL,100			; Find hundredths of seconds
	DIV	CL
	MOV	BX,AX			; BH = hundredths, BL = part of seconds

	MOV	AX,DX
	SUB	DX,DX
	MOV	CX,30			; Find the rest of seconds
	DIV	CX
	SHL	DL,1
	ADD	BL,DL			; BL = seconds

	SHL	CL,1			; 60 min/hr
	DIV	CL
	MOV	CX,AX			; put hrs. and mins. in the right regs.
	XCHG	CL,CH
	MOV	DX,BX			; Put secs. and secs/100 in right regs.
	XCHG	DL,DH
	MOV	AX,CS:DATE		; Return days

	POP	BX			; Restore BX
	LES	BX,ES:CRW_TADDR[BX]	; Get address of packet
	MOV	ES:[BX],AX		; Return days
	MOV	ES:[BX+2],CX		; Return time
	MOV	ES:[BX+4],DX
	JMP	SUCESS

CLOCK_READ	ENDP

	SUBTTL	BIOS Initialization code
	PAGE

;***************************************************************
;   INITIALIZATION CODE
;	This code will be overwritten by
;	the DOS when SYSINIT relocates it.
;***************************************************************

BIOS_TRANSIENT	LABEL	NEAR

;	LOAD_DOS - This routine will load the DOS from the MS-DOS
;		file system.
;
;	ENTRY:	None
;
;	EXIT:	AX - Paragraph the DOS is currently at
;
;	USES:	All
;
LOAD_DOS	PROC	NEAR

;	Locate the first free paragraph after the BIOS and SYSINIT

	MOV	AX,OFFSET SYSSIZE	; Get size of SYSINIT
	ADD	AX,15			; Bias for paragraph
	MOV	CL,4			; Turn into paragraph size
	SHR	AX,CL
	ADD	AX,SEG SYSINIT		; Add in base segment
	MOV	FAT_SEG,AX		; Save FAT segment

;	Locate the first FAT and read it in

	MOV	SI,OFFSET BOOT_BPB	; Point to the boot BPB
	MOV	AX,BPB_RES[SI]		; Get the number of reserved sectors
	ADD	AX,BPB_HIDDEN[SI]	; Add in number of hidden sectors
	MOV	DATA_SECTOR,AX		; Save FAT sector for now
	MOV	DOP_TYPE,DIO_READ	; Set read operation for entire procedure
	CALL	LOAD_FAT
	JC	IO_ERROR

;	Locate the first directory sector

	MOV	AL,BPB_NFATS[SI]	; Get the number of FAT's
	CBW
	MUL	BPB_FATSECS[SI]		; Times number of sectors in a FAT
	ADD	DATA_SECTOR,AX		; Add to current preceding count

;	Locate the paragraph past the FAT to load the DOS at

	MOV	AX,SEC_SIZE		; Find the number of bytes in a FAT
	MUL	BPB_FATSECS[SI]
	MOV	CL,4			; Turn into paragraph (no bias needed)
	SHR	AX,CL
	ADD	AX,FAT_SEG
	
;	Load in the first directory sector and get the first allocation unit

	MOV	ES,AX
	SUB	BX,BX			; At offset 0
	MOV	DX,DATA_SECTOR		; Sector number in DX for decoding
	CALL	DECODE
	MOV	DL,BPB_UNIT[SI]		; Pass unit and
	CALL	DOP17			; Read one directory sector
	JC	IO_ERROR

;	Update DATA_SECTOR to actually contain the first data sector number

	MOV	AX,DE_SIZE		; Size of a directory entry times
	MUL	BPB_DIRENTS[SI]		; Number of directories
	ADD	AX,SEC_SIZE-1		; Fudge it to ensure full sector allocation
	ADC	DX,0			; Just in case it is over 16 bits
	MOV	BX,SEC_SIZE		; Divide by sector size in bytes
	DIV	BX			; AX = Number of directory sectors
	ADD	DATA_SECTOR,AX		; DATA_SECTOR correct now

;	Prepare to load the DOS

	MOV	AX,ES:[DE_SIZE+DE_START]	; Get the first group number from the MSDOS.SYS entry
	SUB	BX,BX			; Load at offset 0


;	Load the DOS

LD1:
	PUSH	AX			; Save group number
	CALL	GROUP_TO_SECTOR		; Translate to sector number
	MOV	DX,AX			; In DX for decoding
	CALL	DECODE
	MOV	DL,BPB_UNIT[SI]		; Pass unit for disk I/O
	MOV	AL,BPB_SPAU[SI]		; Read in a groups worth
	CBW
	CALL	DOP18			; Do the actual read
	JC	IO_ERROR
	POP	AX			; Restore group number
	PUSH	DS			; Save DS
	MOV	DS,FAT_SEG		; Point to FAT
	CALL	NEXT_GROUP		; Get the next group
	POP	DS			; Restore DS
	CMP	AX,0FFFH		; Last link in FAT?
	JNZ	LD1			; No, read in this group

;	Done, return paragraph of the DOS

	MOV	AX,ES			; Return DOS paragraph in AX
	RET				; Yes, DOS loaded

LOAD_DOS	ENDP

;	IO_ERROR - This routine will display a message when
;		a disk error has occured.
IO_ERROR	PROC	NEAR

	MOV	DX,OFFSET IO_MSG
	CALL	PMSG
STALL:
	JMP	STALL

IO_ERROR	ENDP
	
;	LOAD_FAT - This routine will load a FAT into memory.
;
;	ENTRY:	AX - Sector number of FAT
;		DS:SI - Pointer to BPB
;		FAT_SEG - Segment to load the FAT at
;
;	EXIT:	'C' set, can not read FAT
;		'C' clear, FAT read and in memory
;
;	USES:	AX, BX, CX, DX, ES, DI 
;
LOAD_FAT	PROC	NEAR

	MOV	ES,FAT_SEG
	MOV	CL,BPB_NFATS[SI]	; Prepare for multiple FAT's
	SUB	CH,CH
	MOV	DX,AX			; Sector number in DX
LF1:
	PUSH	CX			; Save number of FAT'S left
	PUSH	DX			; Save sector number
	SUB	BX,BX			; Load at offset 0
	CALL	DECODE			; Decode the sector number
	MOV	DL,BPB_UNIT[SI]		; Pass the unit number
	MOV	AX,BPB_FATSECS[SI]	; Read in an entire FAT
	CALL	DOP18			; Do the actual read
	JNC	LF2			; Carry clear, no error, exit
	POP	DX			; Else restore the sector number and
	ADD	DX,BPB_FATSECS[SI]	; try the next FAT
	POP	CX
	LOOP	LF1
	STC				; Can't read any FAT's, error
	RET
LF2:
	POP	DX
	POP	CX
	RET

LOAD_FAT	ENDP
		

;	NEXT_GROUP - This routine will return the next group
;		in the FAT link given the current group
;
;	ENTRY:	AX - last group number
;		DS - Segment of FAT
;
;	EXIT:	AX = next group number
;
;	USES:	None
;
NEXT_GROUP	PROC	NEAR

	PUSH	BX			; Free up a couple of registers
	PUSH	DX
	MOV	DX,3			; Group number times 3/2 to get index
	MUL	DX
	SHR	AX,1			; Note, 'C' shows odd or even
	MOV	BX,AX			; Set up index
	MOV	AX,[BX]			; load next group number
	JC	NG1			; Jump and decode group if odd
	AND	AX,0FFFH		; Else decode like this
	JMP	SHORT NG2
NG1:
	SHR	AX,1			; Decode odd group
	SHR	AX,1
	SHR	AX,1
	SHR	AX,1
NG2:
	POP	DX			; Restore registers
	POP	BX
	RET

NEXT_GROUP	ENDP


;	GROUP_TO_SECTOR - This routine will take a group number and
;		decode it to get a sector number for disk I/O
;
;	ENTRY:	AX - Group number
;		DS:SI - Pointer to BPB for this disk
;		DATA_SECTOR - Sector number of the first data sector
;
;	EXIT:	AX - Sector corresponding to given group
;
;	USES:	None
;
GROUP_TO_SECTOR	PROC	NEAR

	PUSH	DX			; Save a register
	SUB	AX,2			; Base group number at 0
	MOV	DL,BPB_SPAU[SI]		; multiply times sectors per group
	SUB	DH,DH
	MUL	DX
	ADD	AX,DATA_SECTOR		; Add base data sector
	POP	DX
	RET

GROUP_TO_SECTOR ENDP

;	ASSIGN_PART - This routine will attempt to assign a DOS partition
;		partition from the first winchester disk if AUTO_FLAG is
;		0, else it will assign one partition from each unit except
;		the unit in DL.
;
;	ENTRY:	DS - Same as CS
;		DL - Unit to skip
;
;	EXIT:	None
;
;	USES:	All
;
ASSIGN_PART	PROC	NEAR

	MOV	SKIP_UNIT, DL		; Save unit to skip

;	Is a winchester controller and drive(s) in the system?

	MOV	AH,DIO_GETPARMS		; Get winchester parameters
	MOV	DL,80H			; Of first winchester
	INT	DISK_IO_INTR
	JC	ASSIGN_EXITS		; If not sucessful, exit

	OR	DL,DL			; Any drives attached?
	JNZ	ASSIGN_OK		; Yes, do assign
ASSIGN_EXITS:
	JMP	ASSIGN_EXIT

ASSIGN_OK:

;	Go through each unit looking for the DOS partition

	MOV	NUM_FIXED,DL		; Save number of units
	MOV	BYTE PTR CUR_UNIT,0	; Init to first unit
	CMP	AUTO_FLAG,0		; Auto-assign?
	JNZ	ASSIGN_LOOP		; Yes, skip
	MOV	NUM_FIXED,1		; Just do one unit
	MOV	SKIP_UNIT,0		; Don't skip it

ASSIGN_LOOP:

;	Load the boot sector of the winchester

	MOV	CX,1			; Sector 1, cylinder 0
	MOV	DX,0080H		; Next winchester disk, head 0
	ADD	DL,CUR_UNIT		; Make it the next unit number
	CMP	DL,SKIP_UNIT		; Do we want this unit?
	JZ	NEXT_UNITS		; No, skip
	SUB	BX,BX			; At (now) unused memory
	MOV	ES,FAT_SEG
	MOV	DOP_TYPE,DIO_READ	; Do a read
	PUSH	AX
	PUSH	CX
	MOV	AL,NUM_ASSIGN
	MOV	CL,TYPE BPB_STRUC
	MUL	CL			; Get offset into table in AX
	MOV	SI,OFFSET FIXED_BPBS	; Disk I/O needs a BPB
	ADD	SI,AX
	MOV	AL,CUR_UNIT		; Get unit number
	ADD	AL,80H
	MOV	BYTE PTR BPB_UNIT[SI],AL
	POP	CX
	POP	AX
	CALL	DOP17			; Read one sector
	JC	NEXT_UNITS		; If an error then don't do assign
	CMP	WORD PTR ES:[SEC_SIZE-2],0AA55H	; Is table valid?
	JZ	ASSIGN_LOCATE		; Yes, locate DOS partition
NEXT_UNITS:
	JMP	NEXT_UNIT

ASSIGN_LOCATE:

;	Locate a DOS partition

	MOV	SI,SEC_SIZE-(MAX_FIXED*TYPE P_ENT+2) ; Address the part table
	MOV	CX,MAX_FIXED		; Must find DOS partition in MAX_FIXED entries
AP1:
	CMP	BYTE PTR ES:OS_ID[SI],DOS_ID	; Is this a DOS partition?
	JZ	AP2			; Yes, continue
	ADD	SI,TYPE P_ENT		; No, Check next entry
	LOOP	AP1
	JMP	NEXT_UNIT		; No DOS partitions on the disk, exit
AP2:
	CALL	SET_BPB			; Calculate BPB parameters
	JC	NEXT_UNIT		; Exit on error

;	Check if the partition has been formatted by loading the boot
;	sector and comparing the BPB there to the one calculated.

	MOV	AL,NUM_ASSIGN
	MOV	CL,TYPE BPB_STRUC
	MUL	CL				; AX = offset into FIXED_BPBS
	MOV	DH,BYTE PTR ES:BOOT_FLAG[SI+1]	; Head number of boot
	MOV	DL,80H				; Drive number of boot
	ADD	DL,CUR_UNIT
	MOV	CX,WORD PTR ES:BOOT_FLAG[SI+2]	; Cylinder and sector
	SUB	BX,BX			; Load at unused FAT_SEG memory
	MOV	SI,OFFSET FIXED_BPBS	; Pass BPB
	ADD	SI,AX			; Point to right one
	MOV	AL,CUR_UNIT		; Get unit number
	ADD	AL,80H
	MOV	BYTE PTR BPB_UNIT[SI],AL	; Set unit in BPB
	CALL	DOP17			; Read boot sector
	JC	NEXT_UNIT		; If error then exit
	CMP	ES:[SEC_SIZE-2],0AA55H	; Is this a valid sector?
	JNZ	AP3			; No, exit

;	Compare BPB's and see if the disk is formatted

	MOV	AL,NUM_ASSIGN
	MOV	CL,TYPE BPB_STRUC
	MUL	CL
	MOV	SI,OFFSET FIXED_BPBS	; Yes, compare BPB's
	ADD	SI,AX
	MOV	DI,DISK_BPB_OFFSET
	MOV	CX,OFFSET BPB_MBYTE - OFFSET BPB_SECSZ
	CLD
	REP	CMPSB
	JNZ	AP3			; BPB's are different before MBYTE
	INC	SI
	INC	DI			; Skip media byte
	MOV	CX,TYPE BPB_STRUC - OFFSET BPB_FATSECS
	REP	CMPSB			; Compare the rest of BPB
	JNZ	AP3			; BPB's different, don't flag formatted
	MOV	BL,NUM_ASSIGN
	XOR	BH,BH
	OR	FIXED_FLAGS[BX],1 SHL 2 + 1 SHL 1	; Flag partition as formatted and changed
AP3:
	MOV	BL,NUM_ASSIGN
	XOR	BH,BH
	OR	FIXED_FLAGS[BX],1 SHL 0	; Flag partition as assigned
	CMP	AUTO_FLAG,0		; Auto-assign?
	JZ	NEXT_UNIT		; No, skip
	INC	BYTE PTR NUM_ASSIGN
	INC	BYTE PTR NUM_DISK	; Update number of drives
NEXT_UNIT:
	INC	BYTE PTR CUR_UNIT	; Point to next unit
	MOV	DL,BYTE PTR CUR_UNIT
	CMP	DL,BYTE PTR NUM_FIXED	; See if there are more disks
	JAE	ASSIGN_EXIT		; No more, exit
	JMP	ASSIGN_LOOP

ASSIGN_EXIT:
	RET

ASSIGN_PART	ENDP

;	SET_BPB - This routine will set up the next winchester disk BPB
;	given SI pointing to the entry in the partition table. This routine
;	assumes that the following entries in the BPB are already set:
;	BPB_SECSZ, BPB_RES, BPB_NFATS, BPB_MBYTE, BPB_SPT and BPB_UNIT
;
;	ENTRY:	ES:SI - Points to a DOS partition table entry
;
;	EXIT:	ES:SI Unchanged
;		If 'C' set, parameters could not be calculated
;		If 'C' clear, FIXED_BPB has valid parameters for given part.
;
;	USES:	All
;
SET_BPB	PROC	NEAR

;	Set the number of heads

	MOV	BL,CUR_UNIT
	XOR	BH,BH
	MOV	DL,80H			; Do first winchester disk
	ADD	DL,BL			; Make it current
	MOV	AH,DIO_GETPARMS		; Get the number of heads
	INT	DISK_IO_INTR
	JNC	SET_BPB1
	JMP	BAD_PART		; If error then do not assign
SET_BPB1:
	INC	DH			; Correct head count
	SUB	DL,DL
	XCHG	DH,DL
	PUSH	AX
	PUSH	CX
	MOV	AL,NUM_ASSIGN		; Get unit number
	MOV	CL,TYPE BPB_STRUC	; Get size of BPB
	MUL	CL			; Get offset into BPB table
	MOV	DI,OFFSET FIXED_BPBS	; Point to table
	ADD	DI,AX			; Point to correct entry
	POP	CX
	POP	AX
	MOV	WORD PTR BPB_HEADS[DI],DX	; Save in BPB

;	Set the number of sectors per track

	AND	CX,03FH			; Isolate sector per track bits
	MOV	WORD PTR BPB_SPT[DI],CX

;	Set the hidden sectors

	MOV	AX,WORD PTR ES:REL_SEC[SI]	; Get the number of hidden sectors
	MOV	WORD PTR BPB_HIDDEN[DI],AX	; Set number of hidden sectors in BPB

;	Set the partition size

	MOV	AX,WORD PTR ES:PART_SIZE[SI]	; Get the size of the part.
	CMP	AX,MIN_PART		; Is it below the minimum partition?
	JB	BAD_PART		; Yes, exit with error
	MOV	WORD PTR BPB_SECS[DI],AX	; No, set part. size into BPB

;	Determine the necessary cluster factor and number of directory entries

	PUSH	DI			; Save pointer to BPB
	SUB	DI,DI			; Create index
SB1:
	CMP	AX,BREAK[DI]		; Check if at a break point
	JBE	SB2			; Have correct info. now
	INC	DI			; Not there yet, try next one
	INC	DI
	CMP	DI,NUM_BREAK*2		; Have we done all breaks?
	JB	SB1			; No, try next one

;	Set the number of directory entries into the BPB

SB2:
	MOV	CX,DIRS[DI]		; Get number of directory entries
SB3:
	MOV	BX,DI			; Save DI
	POP	DI			; Restore BPB pointer
	MOV	WORD PTR BPB_DIRENTS[DI],CX	; Save in BPB

;	Calculate cluster factor

	PUSH	DI
	MOV	DI,BX			; Restore old DI
	SHR	DI,1			; Get correct index
	MOV	CX,DI			; Into CL
	MOV	BL,1			; CLF = 2 ** CL
	SHL	BL,CL
SET_CLF:
	POP	DI			; Restore BPB pointer
	MOV	BYTE PTR BPB_SPAU[DI],BL	; Save cluster factor

;	Determine number of FAT sectors required

	DEC	BL			; Use cluster factor - 1 to ensure enough
	SUB	BH,BH
	ADD	BX,AX			; Add number of sectors
	SHR	BX,CL			; Divide by cluster factor
	INC	BX
	AND	BL,NOT 1		; Do 3/2 (bytes/cluster) * clusters
	MOV	AX,BX
	SHR	AX,1
	ADD	AX,BX
	ADD	AX,SEC_SIZE-1		; Bias for entire sector
	SHR	AH,1			; Divide by sector size (512)
	MOV	BYTE PTR BPB_FATSECS[DI],AH	; Save FAT sectors in BPB
	CLC
	RET

BAD_PART:
	STC			; Can not assign partition
	RET

SET_BPB	ENDP

BIOS_END LABEL NEAR

BIOS_LENGTH	=	OFFSET BIOS_END - OFFSET BIOS_START

BIOS	ENDS
	END

