Page	60,132
Title	-Appointment Scheduler Routines
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 11_Dec_85
;
;
%Out	Appt.asm
page
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Io.lit
;	Icon.lit	
;	Pequ.lit
;	Pdata.lit
;
	.xlist
	Include	..\Rom\Rom.lit
	Include ..\Rom\Intr.lit
	Include ..\Io\io.lit
	Include Icon.lit	
	Include Pequ.lit
	Include Pdata.lit
	.list

; Macro Definitions
;------------------

	.sall
RW	MACRO
	CALL	BATRW
	ENDM

RO	MACRO
	CALL	BATRO
	ENDM


page
;======================================================================
PhNovRam Segment At (0F110h)
;===========================
;	1) Battery Backup RAM Allocation
;	2) Use the routines RHOLE and RERASE to allocate and de-allocate from
;	   RAMBOT up to the end of battery RAM.
;
	Extrn	BAT1ST: Byte	; First location in battery RAM
	Extrn	CHKSUM: Byte	; Checksum on battery RAM contents
	Extrn	ALMTIME:Word	; Time of next alarm Hi-Byte=hour, Lo-Byte=min.
	Extrn	ALMYR:  Byte	; Year as offset from 1985 (i.e. 1986 = 1)
	Extrn	ALMMD:  Word	; Month and day
	Extrn	ALMPEND:Byte	; Alarm pending counter
	Extrn	AREACD: Byte	; Current area code
	Extrn	PREFIX: Byte	; Dial prefix up to 11 digit prefix
	Extrn	CALTIM: Byte	; Call time (hrs, min, sec)
	Extrn	REDIAL: Byte	; Re-dial number ( 64 char re-dial buffer)
	Extrn	RAMTOP: Word	; Pointer to first byte of stored data
	Extrn	APP1ST: Word	; Pointer to first appointment record
	Extrn	RAMBOT: Byte	; Starting location of stored data

PhNovRam	EndS

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:PhNovRam, es:PhNovRam

	extrn	DFlags:byte
	extrn	Disp_Day:byte
	extrn	Disp_Month:byte
	extrn	Disp_Year:word
	extrn	Moda1:word
	extrn	Minute_Count:Word
	extrn	Last_Task_ID:Byte

	extrn	beep:near
	extrn	Put_String_n:Near
	extrn	Put_String_Imm:Near
	extrn	Put_String:Near
	extrn	Put_chr:Near
	extrn	Put_Ascii:Near

	extrn	Out_Morrow_6845:Near

	; Externals in PUTIL.ASM
	extrn	BATRO:Near
	extrn	BATRW:Near
	extrn	BLANK:Near
	extrn	CI:Near
	extrn	CO:Near
	extrn	CURSOR:Near
	extrn	DISHRS:Near
	extrn	DISMIN:Near
	extrn	Init_Dflags:Near
	extrn	KEYS:Near
	extrn	No_Zero_Supp:Near
	extrn	REMAIN:Near
	extrn	RERASE:Near
	extrn	Revbar:Near
	extrn	RHOLE:Near
	extrn	RSIZE:Near
	extrn	RSUM:Near
	extrn	SCLEAR:Near
	extrn	Set_Norm_Att:Near
	extrn	Set_Rev_Att:Near
	extrn	Zero_Supp:Near

;----------------------------------------------------------------------
; Fixed Data Area (21_May_85)
;----------------------------
;
; Keystroke Dispatch Table
;-------------------------
;
APPKEY	DW	KF4		; Appointments keystrokes
	DW	APPDEL
	DW	KF5
	DW	APPALM
	DW	BS
	DW	APPBS
	DW	KLEFT
	DW	APPLFT
	DW	KRIGHT
	DW	APPRGT
	DW	KUP
	DW	APPUP
APPKEX:	DW	CR		; Keystrokes when cursor in top row of AM
	DW	APPCR
	DW	KDOWN
	DW	APPDWN
	DW	KF1
	DW	APPPRV
	DW	KF2
	DW	APPNXT
	DW	KF3
	DW	APPINS
	DW	KF10
	DW	APPXIT
	DW	0
	DW	APPCHG

subttl	Appointment Calendar
page
;---------------------------------------------------------------------------
; Initialize
;-----------
PUBLIC	APPT
APPT:
	pushreg	<ds,es>		; save our segments!!!!!
	SUB	SP,MAXRAM	; allocate stack space for local vaiables
	MOV	BP,SP		; to be accessed based on BP
	mov	ax,2		; select proper video mode
	int	Video_IO_Intr
	call	Init_Dflags	; clear dflags 

	XOR	AL,AL		
	MOV	REDISP[BP],AL	; set for appointment re-display 
	MOV	TIMER[BP],AL	; set timer to off 

	RW
	MOV	[ALMPEND],AL	; clear alarm pending flag
	RO

	CALL	ALMNXT		; Determine when next alarm is. Set
				; ALMPEND true if any alarms are set,
				; and finally, set alarm time

	MOV	DX,60		; set cursor position of Remaining memory display
	MOV	REMCUR[BP],DX

;------------------------------------------------------------------------
; Initialize Month, Day, and Year for appointment day
;
;---------------------

	mov	ah,2eh		; get displayed date
	int	Time_of_Day_Intr

	CALL	CONVYR		; compute year as offset from 1985
APP0:	MOV	CALYR[BP],CL	; Store year, month, & day
	MOV	CALMO[BP],dh
	MOV	CALDAY[BP],dl

page
;-------------------------------------------------------------------
; Fill out OUTLINE table with appointments for the specified day.
;
; The outline table will contain the hours of appointments for a given day,
; as well as a pointer to the Message corresponding to the time.  If no
; appointments are scheduled for one of the default times (6 AM to 5 PM)
; the pointer will be null.  Using this outline, it is then very easy to
; display the appointments for the day.
;------------------------
APP0A:	MOV	DI,OUTLINE		; pointer to calendar outline area
	MOV	SI,[APP1ST]		; pointer to first appointment
	MOV	CX,17-06+1		; Screen has every hour from 0600 to 1700
	MOV	DX,0600H		; starting time for display

Test_For_Outline:
	CALL	Chk_Appt_Day		; check if appointment record pointed to by
					; si is on displayed date.
	JZ	Appt_Day_OK		; if (appointment is for displayed day)
					;    then insert it in the outline
					; else
	JB	Next_Appt		; if (appointment is for an earlier day) then get Next Appt
	JCXZ	Draw_Scrn		; if (Outline has all default times in it)
					;    AND (no more appts. exist for this day)
					;    then Draw the screen
					; else
	JMP	SHORT Save_Null_Msg	;   Fill rest of outline with nulls

Next_Appt:				; appointment is for an earlier day so
	call	Get_Next_Appt		;    point to the next record.
	jmp	short Test_For_Outline	;    and check it


Appt_Day_OK:
	CALL	Add_2_Outline	; Store appointment in outline table
	CMP	AX,DX		; if (Appt was not for default time)
	JA	Save_Null_Msg	;    then replace with nul message, and nul terminator
				; else
	ADD	DI,4		;    appointment was for earlier time so...
				;    leave appt in outline, advance outline insert pointer...
	CMP	AX,DX		;    if ( appt wasn't for a default time)
	JNZ	Next_Appt	;       then get next appointment and check it
				;    else
	INC	DH		;      Message was for a default time so Next default time
	LOOP	Next_Appt	;      and check next appointment

; At this point, all default times have been filled, but appts. exist for
; after the latest default time. (i.e. after 5 PM) so...
	JMP	SHORT APP8	; get rest of appts. before displaying appts.


Save_Null_Msg:
	MOV	[DI+BP],DX		; Store default time in outline
	MOV	WORD PTR [DI+BP+2],0	; and null pointer

APP6:	INC	DH			; Next default time
	ADD	DI,4			; next outline entry
	LOOP	Test_For_Outline	; if (all default times not put in outline)
					;    then keep going
					; else
					;    Get appointments for after last default time

APP7:	CALL	Chk_Appt_Day		; check if next appt. goes in outline
	JNZ	Draw_Scrn		; if (Appt. is for later day) then done, so display appts.
	CALL	Add_2_Outline		; else Put appt. in outline
	ADD	DI,4			; next outline entry
APP8:	CALL	Get_Next_Appt		; next appt record
	JMP	SHORT APP7		; loop until appt found for later day

page
;------------------------------------------------------------------------
; ouline now filled out, ready to initialize screen
;----------------------
Draw_Scrn:
	MOV	WORD PTR [DI+BP],-1 	; Show where end of outline is with -1 in outline

;------------------------------------------------------------------------- 
; Display Appointments
;-----------------------
	CALL	SCLEAR			; Clear screen,attribute, and home cursor
	mov	bl,normal		; select normal attribute
	call	Put_String_Imm		; label function keys

	; Function key and AM/PM labels for Appointment scheduler

	db	30,2,24,'< DAY    DAY >  INSERT  ERASE   ALARM',31,73,'EXIT'
	db	30,3,0,'AM',31,43,'PM',eos

	CALL	Show_Date		; Display current date on top line

	MOV	BYTE PTR RAMCHG[BP],1	; indicate that RAM changed to force
					; recalc of remaining memory
	CALL	REMAIN			; display remaining memory

	MOV	SI,OUTLINE	; Display screen calendar
	MOV	DX,0100H	; initial cursor position
	XOR	CX,CX		; reset # of AM and PM entries on screen to 0

Disp_Outline:
	MOV	BX,[SI+BP]	; get an appointment time
	INC	BX		; If -1, then done displaying appointments for this day
	JNZ	L_Disp_Outline	; if Time wasn't -1 then display time and message
	jmp	APP18		; else, outline displayed, so start processing

L_Disp_Outline:
	DEC	BX			; get back original time
	CALL	Disp_Appt		; display a message on screen
	INC	DH			; Next line
	ADD	SI,4			; point to next record
	JMP	SHORT Disp_Outline	; and continue displaying
page
;------------------------------------------------------------------------
; Disp_Appt:	Display the appointment corresponding to the outline entry
;		pointed to by SI.
;	ON ENTRY:
;		BH = Hour
;		BL = Minute
;		DX = Location to display appt (Row, Column)
;		CL = # of AM appts on screen
;		CH = # of PM entries on screen
;
;-----------------------------

Disp_Appt:
	CMP	BH,12			; if This is an AM entry
	JB	AM_Row			;    then use AM display
					; else
	INC	CH			;    increment # of PM entries
	OR	DL,DL			;    If (current column is <> 0) 
	JNZ	Disp_Appt_Dx		;       then Display appt. and time at (DX)
	MOV	DX,100H+40		;    else, set dx for location of 1st PM Appt.
	MOV	DI,SI			; Save first PM appointment
	JMP	SHORT Disp_Appt_Dx	; and display time and message at (dx)

AM_Row:	INC	CL			; this is an AM entry so inc AM count

;---------------------------------------------------------------------------
; Disp_Appt_Dx:   Display a time and message at position (DX)
;	ON ENTRY:   DX = Starting (ROW, COLUMN) for time and appt
;		    BX = Time of message (Hour,Minute)
;		    SI --> points to entry in outline containg time
;			   of appt. and pointer into NovRam to Text
;--------------------

Disp_Appt_Dx:
	CALL	CURSOR		; Move cursor to COL/ROW in dx
	call	Zero_Supp	; suppress zeroes when displaying hours
	MOV	AL,BH		; Get hours to AL
	CALL	DISHRS		; display them
	MOV	AL,':'		; seperate from minutes with a colon
	call	co
	call	No_Zero_Supp	; turn off zero suppression
	MOV	AL,BL		; get minutes of message time and display them
	CALL	DISMIN
	PUSH	CX		; save # of am and pm entries
	MOV	CH,-1		; initial character count
	MOV	BX,[SI+BP+2]	; get pointer to message from outline table
	OR	BX,BX		; test if null message
	JZ	Blank_Rest	; if null, then nothing to display so blank entire line
				; else
; check alarm indicator bit
	ADD	BX,5		; assume No alarm
	MOV	AL,' '		; and be ready to put out a space
	TEST	BYTE PTR [BX],10000000B	; test alarm bit
	JZ	No_Alarm	; if (ALARM is set)
	MOV	AL,ALARM	; then put up alarm indicator
No_Alarm:
	call	co		; display alarm indicator or a space
	MOV	CL,[BX]		; get size of message
	AND	CL,7FH		; mask off alarm indicator
	MOV	CH,CL		; and set message length
	JZ	Blank_Rest	; if no message for this time then blank rest
				; of line

;---------------------------------------------------------------------------
; Put up appt. text bx -> message, cl = ch = length
;   On entry, BX points to first byte (Length) of appt. record
;----------------------

Put_Appt_Msg:
	INC	BX		; Get next char from appt record
	MOV	AL,[BX]		; get a character
	CALL	CO		; display it
	DEC	CL		; update chars to be displayed
	JNZ	Put_Appt_Msg	; if more chars then loop

;-------------------------------------------------------------------------
; Blank rest of line
;-----------------------

Blank_Rest:
	MOV	CL,APMSIZ	; get maximum length of message
	SUB	CL,CH		; compute number of blanks to put out
	XOR	CH,CH
	CALL	BLANK		; and display that number of blanks
	POP	CX		; get back AM/PM count
	RET			; and return

page
;-------------------------------------------------------------------------
; Display current month and day on screen
;	On entry, CALMO = Month, CALDAY = Day
;-----------------------
Show_Date:				
	MOV	AL,CALMO[BP]	; get the month
	mov	dx,20		; set position for displaying month
	mov	bl,normal
	push	di
	CALL	Put_String_n	; display the month
	inc	dl		; skip a space
	call	cursor		; set new cursor position
	pop	di
	call	Zero_Supp	; suppress zeroes
	MOV	AL,CALDAY[BP]	; get the day
	mov	bl,normal
	call	Put_Ascii	; display it
	ret


;-------------------------------------------------------------------------
; Add_2_Outline  Adds an appointment into the outline
; 	On Entry:	SI points to the Appointment record to be added
;			DI points to the location in the outline to put
;			   the Appt info.
;-----------------

Add_2_Outline:
	MOV	AX,[SI+3]	; Get time of appt
	XCHG	AL,AH		; Convert time to proper form
	MOV	[DI+BP],AX	; Store time in outline
	MOV	[DI+BP+2],SI	; Store Pointer to message text in outline
	RET


page
;--------------------------------------------------------------------------
; After displaying the screen for the day, execution starts here
;
;--------------------------

APP18:	MOV	AMPM[BP],CX	; Store number of AM and PM entries on screen
	MOV	SI,DI		; SI --> first PM entry
APP19:	MOV	DX,100H+40+6	; Initialize cursor at first PM entry

	MOV	BYTE PTR EDPOS[BP],0	; clear edit buffer

;-----------------------------------------------------------------------
; The following functions expect the register to contain the following:
;
;	DH = outline row
;	DL = outline column
;	DI -> current entry in outline table or zero if on AM line
;		( AM Line is the line the cursor is on when inserting appts.
;		  for before 6 AM.)
;	SI -> first PM entry in outline table
;----------------------------

APP20:	CALL	APBAR		; Bar at entry to indicate editing

; Process Keystroke

; Note: On entry, IF DH = 0, then user is inserting an appt. for before
;       6 AM, so it must use a restricted dispatch table

APP21:	MOV	BX,OFFSET APPKEY	; get Dispatch table for keys
	OR	DH,DH			; If (inserting for before 6 AM)
	JNZ	APP22			; then
	MOV	BX,OFFSET APPKEX	; Use restricted dispatch table
APP22:	JMP	KEYS

page
;-------------------------------------------------------------------------
; Key handling routines vectored to through KEYS

;-------------------------------
; Down
;-------------------------------

APPDWN:	MOV	AX,AMPM[BP]	; GET Number of entries in each column to AX
	CMP	DL,40		; check if in PM column
	JB	APPDW0		; if in PM column,
	MOV	AL,AH		; make AL the # of PM entries
				; else, AL = # of AM entries
APPDW0:	CMP	DH,AL		; If ROW = # Entries, then at last entry in column
	JZ	APP21		; so Just ignore the key
				; else
	CALL	APMOVE		; Turn this bar off
	INC	DH		; Next line
	OR	DI,DI		; IF (NOT at AM row of screen)
	JZ	APPDW1		; then
	ADD	DI,4		;    Point to next record
	JMP	SHORT APP20	;    put bar over it and get another key
				; else
APPDW1:	MOV	DI,OUTLINE	;    pointing to first entry in outline table
	JMP	SHORT APP20	; display bar, and get another key

page
;--------------------------
; Up
;--------------------------

APPUP:	XOR	AL,AL		; Top Row for AM column is Row 0
	CMP	DL,40		; If (NOT in AM Column)
	JB	APPU0		; then
	INC	AL		;   Top Row for PM Column is 1

APPU0:	CMP	DH,AL		; if Already in Top Row
	JZ	APP21		; then just ignore the key
				; else
	CALL	APMOVE		;    Turn bar on current row off
	DEC	DH		;    Up a line
	JZ	APPU1		;    if Row now Zero, then must be in AM Column
	SUB	DI,4		;    Else, go back one outline entry
	JMP	SHORT APP20	;          and get the next key

; Note: When At 'AM' row, there is no outline entry, so we need special handling
APPU1:	XOR	DI,DI		; At very top of screen on AM line
	JMP	SHORT APP20	; Turn on bar, get next key

page
;--------------------------
; Left
;--------------------------

APPLFT:	CMP	DL,40		; If Already in AM column
	JB	APP21		; then ignore the key
	CALL	APMOVE		; else, remove the current bar
	SUB	DL,40		; set new column
	MOV	AL,AMPM[BP]	; Get number of AM entries on screen
	push	si		; Set si to point to outline temporarily
	mov	si,outline
	CMP	DH,AL		; If Below last AM entry
	JBE	APPLF0		; 
	MOV	DH,AL		; then Move to last AM line

; compute new outline pointer

APPLF0:	MOV	AL,DH		
	CBW			
	DEC	AX
	SHL	AX,1
	SHL	AX,1
	ADD	AX,si
	MOV	DI,AX
	pop	si		; restore original si
	JMP	SHORT APP20	; put up new bar and get next key

page
;--------------------------
; Right
;--------------------------

APPRGT:	CMP	DL,40		; Already right?
	JAE	APP21

	CALL	APMOVE		; Move to PM
	ADD	DL,40

	MOV	AL,AMPM[BP+1]	; Not below last PM entry?
	CMP	DH,AL
	JBE	APPRG0

	MOV	DH,AL		; Move to last PM line

APPRG0:	push	si
	jmp	APPLF0		; compute the new pointer and get next key

page
;--------------------------
; Carriage Return
;--------------------------

APPCR:	CMP	DL,40		; If (On PM entries) OR (NOT bottom of AM Entries)
	JAE	APPC0		;    then handle exactly like Down key
	CMP	DH,AMPM[BP]
	JNZ	APPC0

	CALL	APMOVE		; Get rid of current bar
	MOV	DI,SI		; Point to 1st PM entry outline entry
	JMP	APP19		; reset cursor, and get next key

APPC0:	JMP	APPDWN

page
;--------------------------
; Error
;--------------------------

APPERX:	POP	DI		; POP stack before beeping
	POP	SI

APPERR:	CALL	BEEP		; Beep when out of memory
	call	remain
APPER0:	JMP	APP21		; ignore the key

page
;--------------------------
; Change Appointment
;--------------------------

APPCHG:	OR	DH,DH		; If (on 'AM' Line) OR (a control char)
	JZ	APPER0		; then ignore the key
	CMP	AL,' '
	JB	APPER0
				; else
	CMP	BYTE PTR EDPOS[BP],APMSIZ	; if (Beyond right end of message)
	JZ	APPER0				; then ignore the key
	PUSH	SI		; save appt record pointer and outline ptr
	PUSH	DI
	CALL	APMESG		; If a  message already exist for this time
	JNZ	APPCH2		; then don't create a dummy message
	MOV	CX,APMSIZ	; else 
	CALL	APPCH5		;  try to create an empty message
	JNC	APPERX		; if (NO ROOM) then restore stack, beep, and get next key
	MOV	DI,SI		; DI -> empty message
	INC	DI		; point to text portion of message

APPCH0:	RW
	MOV	AL,' '		; Initially all blank
APPCH1:	INC	SI		; put in a blank message for this time
	MOV	[SI],AL
	LOOP	APPCH1
	RO
	MOV	CL,APMSIZ	; of maximum length

APPCH2:	CMP	EDPOS[BP],CL	; if beyond end of message?
	JB	APPCH3		; then
				; Expand message to maximum size
	MOV	SI,DI		; point to end of appt test
	ADD	SI,CX
	PUSH	CX		; save current length
	MOV	AL,APMSIZ	; compute how many bytes worth of storage are needed
	SUB	AL,CL
	MOV	CL,AL
	CALL	APHOLE		; make a hole that big
	POP	AX		; if No room for expansion
	JNC	APPERX		; then restore stack, beep, get next key
				; else
	MOV	DI,SI		; Just in case adjusted
	SUB	DI,AX

	MOV	AL,APMSIZ	; Get length of new message 
	CALL	APLENG		; and set it in Appt record

	DEC	SI		; blank new appt area
	JMP	SHORT APPCH0	

APPCH3:	MOV	AL,KEYCHR[BP]	; Get char that started this
	MOV	BL,EDPOS[BP]	; and position in edit buffer
	XOR	BH,BH

	RW
	MOV	[DI+BX],AL	; Overwrite char in RAM
	RO
	CALL	CO		; display it on screen
	INC	BL		; next buffer position
	MOV	EDPOS[BP],BL	; set edit position
	POP	DI		; restore stack
	POP	SI

	CALL	RSUM		; Re-checksum  check whole screen redisplay
	SHR	BYTE PTR REDISP[BP],1	; check whole screen redisplay
	JC	APPCH4		; if Screen doesn't need to be re-displayed
	JMP	APP21		; then get next key
APPCH4:	CALL	BEEP		; else Beep
	JMP	APP0A		;   and Redisplay whole screen

;----------------------------------------------------------------------------
; This routine tries to create a new message for the time in the outline 
; pointed to by DI
;-------------------

APPCH5:				; New appointment record
	MOV	AX,[DI+BP]	; Find closest appointment
	CALL	APFIND

	PUSH	CX
	ADD	CX,6		; Try to create a new entry cx:= total length of record
	CALL	APHOLE
	POP	CX
	JNC	APPCH6		; if no room for more appts then return
				; else
	MOV	[DI+BP+2],SI	; put record pointer into outline 
	MOV	AL,CALYR[BP]	; Store date & time in appt record
	RW
	MOV	[SI],AL
	MOV	AL,CALMO[BP]
	INC	SI
	MOV	[SI],AL
	MOV	AL,CALDAY[BP]
	INC	SI
	MOV	[SI],AL
	MOV	AX,[DI+BP]
	INC	SI
	MOV	[SI],AH
	INC	SI
	MOV	[SI],AL
	INC	SI
	MOV	[SI],CL		; store length and Alarm status in record
	RO
	STC			; indicate succesful at adding record
APPCH6:	RET			; and return

page
;--------------------------
; Delete
;--------------------------

APPDEL:	PUSH	DI
	PUSH	SI
	CALL	APMESG		; check for an appt for selected time
	JNZ	APPDE0		; if appt doesn't exist,
	OR	DI,DI		; then check if 'AM' Row
	JZ	APPDEA		; if on AM, then there's nothing to erase
	MOV	BX,[DI+BP]	; else Get hours from outline
	XCHG	BH,BL
	JMP	SHORT APPD0A
APPDEA:	POP	SI		; Nothing to erase
	POP	DI
	JMP	APP21		; next key

APPDE0:	MOV	SI,DI		; get Time from appt record
	SUB	SI,6		; 
	MOV	BX,[SI+3]	; into BX
	ADD	CX,6		; Delete appointment record from battery RAM
	CALL	APERASE		; erase the record
APPD0A:	OR	BH,BH		; If (NOT EVEN HOUR)
	JNZ	APPDE1		; then remove it from outline
				; else, just clear it
	CMP	BL,6		; If it's not a default hour between 6 and 17:00
	JB	APPDE1
	CMP	BL,17
	JA	APPDE1		; then remove it
	DEC	DL		; Erase alarm
	CALL	CURSOR
	CALL	Set_Norm_Att	; set normal video attribute
	MOV	AL,' '		
	CALL	CO		; clear alarm character
	CALL	Set_Rev_Att
	MOV	CX,APMSIZ	; Erase message area
	CALL	BLANK
	INC	DL		; Put cursor at start of message...
	CALL	APPDE9		; ...re-checksum, and update free RAM display

	POP	SI
	POP	DI
	MOV	WORD PTR [DI+BP+2],0	; put null ptr in outline for this time
	JMP	APP21			; next key

APPDE1:	POP	SI		; Not a default time, so remove from outline
	POP	DI
	PUSH	DI
APPDE2:	MOV	AX,[DI+BP+4]	; Remove from outline
	MOV	[DI+BP],AX
	ADD	DI,2
	INC	AX		; test if end of oultine
	JNZ	APPDE2		; not end so move next outline item
	POP	DI		; Redisplay screen to close up erasure
	PUSH	SI
	PUSH	DI		
	PUSH	DX
	CALL	Set_Norm_Att	; set normal video
	MOV	SI,DI
	SUB	DL,6		; starting column
	XOR	CX,CX
APPDE4:	MOV	BX,[SI+BP]	; Get an outline entry
	INC	BX		; IF (End Of Outline) OR ( End of AM Row)
	JZ	APPDE5
	DEC	BX
	CMP	dl,40		; test if PM
	jae	appd4A		; if PM then don't check if end of AM row
	CMP	BH,12
	JZ	APPDE5		;   then clear line at bottom of current column
				; else
Appd4A:	CALL	Disp_Appt	;    Display line
	ADD	SI,4		;    Next outline entry
	INC	DH		;    next hour
	JMP	SHORT APPDE4	;    Loop for end of outline or AM column

APPDE5:	MOV	BX,CX		; Erase last line
	CALL	CURSOR		; set cursor
	MOV	CX,APMSIZ+6	; length to erase
	CALL	BLANK		; erase it
	POP	DX
	POP	DI
	POP	SI
	OR	BX,BX		; if (end of outline)
	JNZ	APPDE6		; then
	SUB	DI,4		;    Move to last real entry in outline
	DEC	DH		;    Go back one row
APPDE6:	MOV	AX,AMPM[BP]	; adjust number of AM or PM entries
	CMP	DL,40		; if deleting PM entry
	JB	APPDE7		; then
	DEC	AH		;   Decrement PM entry count
	JMP	SHORT APPDE8	; else
APPDE7:	DEC	AL		;   Decrement AM entry count
	SUB	SI,4		;   move SI to point to last AM entry
APPDE8:	MOV	AMPM[BP],AX	; Restore number of AM and PM entries

	CALL	APPDE9		; New cursor
	JMP	APP20		; next key

APPDE9:
	MOV	BYTE PTR EDPOS[BP],0	; Clear edit buffer
	CALL	CURSOR			; reset cursor
	CALL	RSUM			; re-checksum
	call	REMAIN			; display free space
	ret

page
;--------------------------
; Alarm
;--------------------------

APPALM:	PUSH	DI
	PUSH	SI
	CALL	APMESG		; If Null Message
	JNZ	APPAL0		; then
	XOR	CX,CX		; Create a null record
	CALL	APPCH5
	JNC	APPAL2		; if no room then error
	MOV	DI,SI		; else
	INC	DI

APPAL0:	MOV	AL,10000000B	; Toggle alarm bit
	RW
	XOR	[DI-1],AL
	RO
	TEST	[DI-1],AL

	MOV	CL,' '		; Off or on?
	JZ	APPAL1
	MOV	CL,ALARM
APPAL1:	CALL	RSUM		; Re-checksum
	PUSH	DX
	PUSH	CURPOS[BP]	; Save cursor
	DEC	DL		; Change alarm indicator on record
	CALL	CURSOR		; dispaly alarm status
	CALL	Set_Norm_Att
	MOV	AL,CL
	CALL	CO
	CALL	Set_Rev_Att
	POP	DX		; Restore cursor
	CALL	CURSOR
	POP	DX
	CALL	ALMNXT		; Determine next alarm
	POP	SI
	POP	DI
	JMP	APP21		; next key

APPAL2:	JMP	APPERX		; report error and get next key

page
;--------------------------
; Backspace
;--------------------------

APPBS:	MOV	AL,EDPOS[BP]	; If Cursor at position 0 for current message
	OR	AL,AL
	JNZ	APPB0
	MOV	AL,APMSIZ	;     then Wrap around to right side
APPB0:	DEC	AL		; set new position
	MOV	EDPOS[BP],AL	; save it
	PUSH	DX		; Update cursor
	ADD	DL,AL
	CALL	CURSOR
	POP	DX
	JMP	APP21		; next key

page
;--------------------------
; Insert
;--------------------------

APPINS:	MOV	AX,AMPM[BP]	; AM or PM?
	CMP	DL,40
	JB	APPIN0
	MOV	AL,AH

APPIN0:	CMP	AL,HITE-2	; No more room on the screen?
	JZ	APPI0X
	MOV	BX,AX
	OR	DI,DI		; On AM bar?
	JZ	APPI0B
	MOV	AX,[DI+BP]	; Can't insert after 11:59pm
	CMP	AX,173BH 
	JZ	APPI0X
	INC	AL		; Add 1 minute
	CMP	AL,60
	JB	APPI0A
	INC	AH		; Next hour
	XOR	AL,AL
APPI0A:	CMP	AX,[DI+BP+4]	; Only 1 minute between this time & next?
	JZ	APPI0X
	JMP	SHORT APPI0C
APPI0B:	CMP	WORD PTR OUTLINE[BP],0 ; Can't insert before midnight
	JNZ	APPI0C
APPI0X:	CALL	BEEP		; Trying to go back a day
	JMP	APP21		; next key

APPI0C:	PUSH	SI
	PUSH	DI
	PUSH	DX
	PUSH	BX
	SUB	DL,6		; Blank the new line
	INC	DH
	CALL	CURSOR
	CALL	Set_Norm_Att
	MOV	CX,APMSIZ+5
	CALL	BLANK

	MOV	SI,DI		; Not AM line?
	OR	SI,SI
	JNZ	APPIN2

	MOV	SI,OUTLINE-4	; First AM entry

APPIN2:	POP	AX
	ADD	SI,4		; Done moving lines down?
	CMP	DH,AL
	JA	APPIN3

	PUSH	AX
	INC	DH		; Next line

	MOV	BX,[SI+BP]	; Re-display line
	CALL	Disp_Appt
	JMP	SHORT APPIN2

APPIN3:	POP	DX		; Now ask for time
	POP	DI
	CALL	APMOVE
	INC	DH

	SUB	DL,6		; Cursor to hours spot

	OR	DI,DI		; Not top AM line?
	JNZ	APPI3B

	MOV	DI,OUTLINE	; New entry is first in table
	XOR	SI,SI
	MOV	CX,[DI+BP]
	JMP	SHORT APPI3C

APPI3B:	MOV	AX,[DI+BP]	; Result must be between SI and CX times
	INC	AL
	MOV	SI,AX
	ADD	DI,4
	MOV	CX,[DI+BP]

APPI3C:	MOV	BX,SI		; Initialize entered time
	XOR	BL,BL

	MOV	AX,SI		; Same hour?
	CMP	AH,CH
	JZ	APPIN7

	OR	CL,CL		; Not XX:00 for 2nd time?
	JNZ	APPI3D

	INC	AH		; Only 1 hr difference?
	CMP	AH,CH
	JZ	APPIN7
	JMP	SHORT APPI3D

APPI3A:	CALL	BEEP
APPI3D:	MOV	BH,12		; PM?
	CMP	DL,40
	JAE	APPIN4

	XOR	BH,BH		; AM

APPIN4:	CALL	APP13A		; Get hours
	OR	AL,AL		; Zero?
	JZ	APPI3A
	CMP	AL,12		; Hour too big?
	JA	APPI3A
	JNZ	APPIN6		; Not 12:XX AM?
	XOR	AL,AL		; Convert to 0:00 in 24 hr format

APPIN6:	ADD	BH,AL		; Add in PM offset

	MOV	AX,SI		; Too small?
	CMP	BH,AH
	JB	APPI3A

	CMP	BX,CX		; Too large?
	JAE	APPI3A
	JMP	SHORT APPIN9

APPIN7:	CALL	CURSOR		; We know hours, so display them
	call	Zero_Supp	; suppress zeroes
	MOV	AL,BH
	CALL	DISHRS

APPIN9:	ADD	DL,2		; Colon between hours and minutes
	MOV	AL,':'
	push	bx
	mov	bl,normal
	call	Put_Chr
	pop	bx
	JMP	SHORT APPI10

APPI9A:	CALL	BEEP
APPI10:	CALL	APPI14		; Now get minutes
	CMP	AL,60
	JAE	APPI9A
	MOV	BL,AL		; BH:BL = new HH:MM
	INC	BL
	CMP	BX,SI		; Below or same as previous appointment?
	JBE	APPI9A
	DEC	BL
	CMP	BX,CX		; Above or same as next appointment?
	JAE	APPI9A
	PUSH	DI		; Make room in outline table for new entry
	MOV	CX,OUTEND+2-4
	MOV	SI,CX
	SUB	CX,DI
	MOV	DI,OUTEND+2
APPI12:	DEC	SI
	DEC	DI
	MOV	AL,[SI+BP]
	MOV	[DI+BP],AL
	LOOP	APPI12
	POP	DI
	ADD	DL,3		; Store time, null pointer
	MOV	[DI+BP],BX
	MOV	WORD PTR [DI+BP+2],0
	POP	SI
	CMP	DL,40		; Add 1 to number of AM or PM entries
	MOV	AX,100H
	JA	APPI13
	MOV	AX,1		; Adjust addr of first PM for insertion of AM
	ADD	SI,4

APPI13:	ADD	AMPM[BP],AX
	JMP	APP20

APP13A:				; Get hours
	MOV	AL,2
	CALL	REVBAR

	PUSH	BX
APP13B:	
	CALL	CI		; Not a digit?
	CMP	AL,' '
	JZ	APP13D
	SUB	AL,'0'
	CMP	AL,10
	JAE	APP13B

	CMP	AL,2		; Can't be 10, 11, or 12?
	JAE	APP13C

	CALL	APPI16		; Echo and continue
	JMP	SHORT APP14A

APP13C:	MOV	BL,AL		; Blank, then hours
	MOV	AL,' '
	CALL	CO

	MOV	AL,BL		; Echo & we're done
	CALL	APPI16
	JMP	SHORT APP14B

APP13D:	CALL	CO		; Echo blank, get 2nd digit
	XOR	AL,AL
	JMP	SHORT APP14A

APPI14:				; Get 2-digit minutes to AL
	MOV	AL,2
	CALL	REVBAR

	PUSH	BX
	CALL	APPI15		; 10s digit
APP14A:	mov	bl,10
	mul	bl
	MOV	BL,AL

	CALL	APPI15		; 1s digit
	ADD	BL,AL

APP14B:	MOV	AL,BL		; Result to AL
	POP	BX
	RET

APPI15:				; Get numeric digit
	CALL	CI
	SUB	AL,'0'
	CMP	AL,10
	JAE	APPI15

APPI16:
	PUSH	AX		; Echo
	ADD	AL,'0'
	CALL	CO
	POP	AX
	RET

page
;--------------------------
; Exit
;--------------------------

APPXIT:	CALL	APMOVE		; (Force stripping of trailing blanks)

	ADD	SP,MAXRAM	; Make stack same as original & return
	popreg	<es,ds>		; restore segments
	RET			; return to clock screen


page
;--------------------------
; Next Day
;--------------------------

APPNXT:	CALL	APPNX1		; Increment day
	INC	DL

	CALL	MODAY		; Not past end of month?
	CMP	DL,AL
	JBE	APPNX0

	MOV	DL,1		; Next month
	INC	DH

	CMP	DH,12		; Not past end of year?
	JBE	APPNX0

	MOV	DH,1
	INC	CL		; Next year

APPNX0:	JMP	APP0		; Display appointments

APPNX1:				; Year, month & day to CL, DH & DL
	CALL	APMOVE
	MOV	CL,CALYR[BP]
	MOV	DH,CALMO[BP]
	MOV	DL,CALDAY[BP]
	RET

page
;--------------------------
; Previous Day
;--------------------------

APPPRV:	CALL	APPNX1		; Decrement day, not before start of month?
	DEC	DL
	JNZ	APPPR1

	DEC	DH		; Not previous year?
	JNZ	APPPR0

	SUB	CL,1		; Trying for before 1985?
	JC	APPPR2

	MOV	DH,12		; December

APPPR0:	CALL	MODAY		; Get last day of month
	MOV	DL,AL

APPPR1:	JMP	APP0		; Display appointments

APPPR2:	MOV	DX,0101H	; January 1, 1985
	XOR	CL,CL
	JMP	SHORT APPPR1

page
;-------------------------------------------------------------------------
; Point to Appointment Message in NovRAM that is pointed to by DI in outline
; table.
;
;	On entry: DI -> entry in outline table
;
;	On exit:  DI -> appointment message
;		  CX = number of bytes in message
;		  Z flag set if null pointer
;--------------------

APMESG:
	XOR	CX,CX
	OR	DI,DI		; On AM line in table?
	JZ	APMES0

	MOV	AX,[BP+DI+2]	; No pointer to a record?
	OR	AX,AX
	JZ	APMES0

	ADD	AX,5		; Get count byte
	MOV	DI,AX
	MOV	CL,[DI]
	AND	CL,01111111B
	INC	DI
APMES0:	RET


;---------------------------------------------------------------------------
; Move to Another Appointment
;
;	On entry: DI -> outline table where moving FROM
;-------------------------

APMOVE:
	PUSH	CX
	PUSH	SI
	PUSH	DI
	CALL	Set_Norm_Att	; Turn off bar over message
	CALL	APBARX
	CALL	APMESG		; No appointment message?
	JZ	APMOV3
	JCXZ	APMOV3
	PUSH	DI
	ADD	DI,CX		; Scan backwards for trailing blanks
	MOV	SI,DI
	MOV	AL,' '
APMOV0:	DEC	SI
	CMP	AL,[SI]
	LOOPZ	APMOV0
	INC	SI
	SUB	DI,SI		; CX = number of trailing blanks
	MOV	CX,DI
	POP	DI		; Null message now?
	MOV	AX,SI
	SUB	AX,DI
	JZ	APMOV1

APMO0A:	PUSH	AX
	CALL	APERASE		; Erase blanks & change length
	POP	AX
	CALL	APLENG
	JMP	SHORT APMOV2

APMOV1:	TEST	BYTE PTR [DI-1],10000000B ; Alarm set?
	JNZ	APMO0A

	SUB	SI,6		; Erase whole appointment
	ADD	CX,6
	CALL	APERASE

	POP	DI		; Null pointer now
	PUSH	DI
	MOV	WORD PTR [DI+BP+2],0

APMOV2:	CALL	RSUM		; New checksum

APMOV3:	CALL	REMAIN		; Display remaining RAM

	MOV	BYTE PTR EDPOS[BP],0 ; Will be at first position in line
	POP	DI
	POP	SI
	POP	CX
	RET


page
;---------------------------------------------------------------------------
; Display Appointment Message in Reverse Video Bar
;
;	Entries:  APBAR if reverse video bar
;		  APBARX if video attribute pre-set
;
;	On entry: DI -> outline table
;----------------------

APBAR:
	CALL	Set_Rev_Att

APBARX:
	PUSH	CX
	PUSH	DI
	CALL	CURSOR		; Move cursor to start of message

	OR	DI,DI		; Not AM line of screen?
	JNZ	APBARA

	MOV	CX,APMSIZ	; Turn off bar & redisplay date
	CALL	BLANK
	PUSH	DX
	PUSH	SI
	CALL	Show_Date	; display date
	POP	SI
	POP	DX
	JMP	SHORT APBAR2

APBARA:	CALL	APMESG		; Null entry?
	MOV	AX,APMSIZ
	JZ	APBAR1
	JCXZ	APBAR1

	SUB	AX,CX		; Determine how many blanks at end of message

	PUSH	AX		; Display message
APBAR0:	MOV	AL,[DI]
	INC	DI
	CALL	CO
	LOOP	APBAR0
	POP	AX

APBAR1:	MOV	CX,AX		; Blank rest of message
	CALL	BLANK

APBAR2:	CALL	CURSOR		; Cursor back to start
	POP	DI
	POP	CX
	RET

page
;--------------------------------------------------------------------------
; New Appointment Message Length
;
;	On entry: DI -> first char in message
;		  AL contains new size
;
;	On exit:  AL contains new size with alarm bit maintained
;----------------------------

APLENG:
	MOV	AH,[DI-1]
	AND	AH,10000000B
	OR	AL,AH
	RW
	MOV	[DI-1],AL
	RO
	RET


;-----------------------------------------------------------------------
; Find Appointment
;
;	On entry: CALYR, CALMO, & CALDAY contain the year, month, & day
;		  AX contains the time (AH=hr, AL=min)
;
;	On exit:  Z flag set if found
;		  SI -> found record (or following record if not found)
;		  AX still contains the time
;------------------------

APFIND:
	PUSH	DX
	MOV	SI,[APP1ST]	; Point to first record
APFIN0:	CALL	Chk_Appt_Day		; Wrong date?
	JA	APFIN2
	JB	APFIN1

	MOV	DX,[SI+3]	; Wrong time?
	XCHG	DH,DL
	CMP	DX,AX
	JA	APFIN2
	JZ	APFIN3

APFIN1:	CALL	Get_Next_Appt
	JMP	SHORT APFIN0

APFIN2:	OR	DL,1		; NZ when not found

APFIN3:	POP	DX
	RET

;-------------------------------------------------------------------------
; Check Date
;
;	On entry: SI -> appointment record
;		  CALYR, CALMO, & CALDAY contain date to be checked
;
;	On exit:  Z set if equal
;		 CY set if record below CAL date
;-----------------------

Chk_Appt_Day:
	PUSH	DX
	MOV	DX,[SI]		; Wrong year?
	CMP	DL,CALYR[BP]
	JNZ	CHK_0
	CMP	DH,CALMO[BP]	; Wrong month?
	JNZ	CHK_0
	MOV	DL,[SI+2]	; Wrong day?
	CMP	DL,CALDAY[BP]

CHK_0:	POP	DX
	RET

page
;----------------------------------------------------------------------
; Next Appointment Record
;
;	On entry: SI -> appointment record
;
;	On exit:  SI -> next record
;--------------------------

Get_Next_Appt:
	PUSH	DX
	MOV	DL,[SI+5]	; Next record
	AND	DL,01111111B
	XOR	DH,DH
	ADD	DX,6
	ADD	SI,DX
	POP	DX
	RET


;----------------------------------------------------------------------
; Erase Appointment Data
;
;	On entry: SI -> spot in battery RAM
;		  CX contains number of bytes to be erased
;---------------------

APERASE:
	CALL	RERASE		; Erase RAM

	PUSH	DI
	MOV	DI,OUTLINE	; Scan table for pointers above erasure
APERA0:	CMP	WORD PTR [DI+BP],-1
	JZ	APERA2

	CMP	[DI+BP+2],SI	; Pointer not affected?
	JBE	APERA1

	SUB	[DI+BP+2],CX	; Adjust pointer

APERA1:	ADD	DI,4		; Next outline entry
	JMP	SHORT APERA0

APERA2:	POP	DI
	RET

;--------------------------------------------------------------------------
; Insert Appointment Data
;
;	On entry: SI -> spot in battery RAM
;		  CX contains number of bytes to be inserted
;
;	On exit:  CY if successful
;----------------------------

APHOLE:
	CALL	RHOLE		; No insert error?
	JC	APHOL2

	PUSH	CX
	PUSH	SI		; Any appointments?
	MOV	SI,[APP1ST]
	CMP	BYTE PTR [SI],-1
	JNZ	APHOL0

	POP	SI		; Oops
APHOLA:	POP	CX
	CLC
	RET

APHOL0:	MOV	AX,[SI]		; Oldest appointment not on this date?
	CMP	AL,CALYR[BP]
	JNZ	APHO0A
	CMP	AH,CALMO[BP]
	JNZ	APHO0A
	MOV	AL,[SI+2]
	CMP	AL,CALDAY[BP]
	JNZ	APHO0A

	MOV	BYTE PTR REDISP[BP],1 ; Redisplay whole screen after this

APHO0A:	MOV	CL,[SI+5]	; Erase oldest appointment to make room
	AND	CL,01111111B
	XOR	CH,CH
	ADD	CX,6
	CALL	APERASE

	MOV	AX,SI		; Where appointment was

	POP	SI		; Adjust erasure point if above oldest
	CMP	SI,AX
	JB	APHOLA
	JE	APHOL1
	SUB	SI,CX
APHOL1:	POP	CX
	JMP	SHORT APHOLE

APHOL2:	PUSH	DI
	MOV	DI,OUTLINE	; Scan table for pointers above insertion
APHOL3:	CMP	WORD PTR [DI+BP],-1
	JZ	APHOL5

	CMP	[DI+BP+2],SI	; Pointer not affected?
	JB	APHOL4

	ADD	[DI+BP+2],CX	; Adjust pointer

APHOL4:	ADD	DI,4		; Next outline entry
	JMP	SHORT APHOL3

APHOL5:	POP	DI
	STC
	RET


page
;--------------------------------------------------------------------------
; Convert Year
;
;	On entry: CX contains year (1985, 1986, etc)
;
;	On exit:  CX contains year offset from 1985 (0 =1985)
;-----------------------

CONVYR:
	SUB	CX,1985		; If (Year >= 1985 )
	JNC	CONVY0		; then return
				; else,		
	XOR	CX,CX		;   Force to 1985
CONVY0:	RET			; and return


;--------------------------------------------------------------------------
; Determine Next Appointment Alarm
;	This routine is called on PIVOT Initialization, and then, on
;	entry to the appointment scheduler.  It returns after setting
;	ALMTIME to the time of the next appointment with an alarm that
;	is scheduled for at least five minutes past time of entering.
;------------------------

PUBLIC	ALMNXT
ALMNXT:
	push	cx
	push	dx
	mov	ax,Minute_Delay		; set delay for minute scan
	mov	Minute_Count,ax
	MOV	AH,2AH		; Get current date, CX=yr, DH=mo, DL=day
	PUSH	BP
	INT	1AH
	POP	BP
	CALL	CONVYR		; convert year to offset from 1985

	PUSH	CX		; save year offset
	PUSH	DX		; save Month and day
	MOV	AH,2CH		; get time ch=hr, cl=minutes, dh=seconds
	PUSH	BP
	INT	1AH
	POP	BP
	MOV	BX,CX		; save time
	POP	DX		; get back month and day
	POP	CX		; and year offset
	
;bx = time, dx=month and day, cx= year offset from 1985

	ADD	BL,5		; alarms are 5 minutes before appointments
	CMP	BL,60		; if minutes greater than 60,
	JB	ALMNX0

	XOR	BL,BL		; reset minutes
	INC	BH		; next hour
	CMP	BH,24		; if hour out of range
	JB	ALMNX0
	XOR	BH,BH		; reset hours
	INC	DL		; and bump date
	CALL	MODAY		; get # of days in month to al
	CMP	DL,AL		; if date is for next month
	JBE	ALMNX0
	MOV	DL,1		; reset to 1st day of month
	INC	DH		; bump the month
	CMP	DH,12		; if month is out of range
	JBE	ALMNX0
	MOV	DH,1		; reset month and 
	INC	CL		; go to the next year

;bx = time, dx=month and day, cx= year offset from 1985
;
ALMNX0:	MOV	SI,[APP1ST]	; search appointment list for first alarm
ALMNX1:	MOV	AX,[SI]		; get an appointment
	INC	AL		; If end of table, then no alarms are set
	JZ	ALMNX6

	TEST	BYTE PTR [SI+5],10000000B ; if alarm bit is set....
	JNZ	ALMNX3		; check if time is right for this alarm

ALMNX2:	CALL	Get_Next_Appt		; get pointer to next appointment
	JMP	SHORT ALMNX1	; and check it


ALMNX3:	DEC	AL		; appt with alarm selected found. Is it OK?
	CMP	AL,CL		; check if correct year
	JB	ALMNX2		; if not, then go to next appt.
	CMP	AH,DH		; compare month
	JB	ALMNX2		; if no match, then next appt.

	CMP	[SI+2],DL	; Wrong day?
	JB	ALMNX2		; then next appt.

; Month, day, year are ok is the time right?

	MOV	AX,[SI+3]	; Wrong time?
	CMP	AL,BH
	JB	ALMNX2
	CMP	AH,BL
	JB	ALMNX2


;time is right, so pull time out of appointment record

	XCHG	AL,AH		; AH=hr, AL=min
	MOV	CL,[SI]		; CL=yr
	MOV	DX,[SI+1]	; day and month
	XCHG	DH,DL		; DH=mo, DL=day


	SUB	AL,5		; Alarm comes on 5 minutes early so adjust
	JNC	ALMNX5

	ADD	AL,60		; Time & date underflow handling
	SUB	AH,1
	JNC	ALMNX5
	MOV	AH,23
	DEC	DL
	JNZ	ALMNX5
	DEC	DH
	JNZ	ALMNX4
	MOV	DH,12
	SUB	CL,1
	JC	ALMNX6
ALMNX4:	CALL	MODAY
	MOV	DL,AL

ALMNX5:	RW
	MOV	[ALMYR],CL	; Store alarm point
	MOV	[ALMMD],DX
	JMP	SHORT ALMNX8

; no alarms pending, so set ALMPEND to false
ALMNX6:	RW
	MOV	AX,-1		; No alarm (-1)

	XOR	CL,CL		; Was alarming every minute?
	XCHG	[ALMPEND],CL
	OR	CL,CL
	JNZ	ALMNX8

	CMP	[ALMTIME],AX	; Same alarm as before?
	JNZ	ALMNX8
	RO
	JMP	SHORT ALMNX9

ALMNX8:	MOV	[ALMTIME],AX	; Store alarm time & re-checksum
	RO
	CALL	RSUM

ALMNX9:	pop	dx
	pop	cx
	RET

;--------------------------------------------------------------------------
; Determine Days in a Month
;
;	On entry: DH = month
;		  CL = year (offset 1985)
;
;	On exit;  AL = number of days in month
;-----------------------

MODAY:
	MOV	BL,DH			; move month to BL
	XOR	BH,BH			; Offset into table
	ADD	BX,OFFSET MODA1-1	; use table in CLK.ASM
	MOV	AL,CS:[BX]		; get number of days in normal year

	CMP	DH,2			; If month is February
	JNZ	MODA0			; then

	TEST	CL,3			; If this is NOT a leap year
	JZ	MODA0

	inc	AL			; add the Leap day

MODA0:	RET

PAGE	
;-------------------------------------------------------------------------
Minute	Proc	near	; (23_May_85)
;------------------------------------
; This subroutine is called by the time of day interrupt.  Every minute,
; it will check for scheduled alarms.
; If an alarm is imminent (within five minutes of the alarm time), an
; alarm message is put on the screen while beeping once a second.
;---------------------
ASSUME	CS:Monitor_Segment, DS:Monitor_Segment, es:Monitor_Segment

PUBLIC	MINUTE
	dec	cs:Minute_Count	; update delay counter for minute timer
	jnz	Minutret	; IF (Minute_Count .NE. 0)  then return
	mov	ax,Minute_Delay	; Else Reset time delay and check for appointments
	mov	cs:Minute_Count,ax

ASSUME	CS:Monitor_Segment, DS:PhNovRam, ES:PhNovRam
	
	push	es
	MOV	AX,BATBASE	; Get data segment of battery RAM
	MOV	DS,AX
	MOV	ES,AX
	cmp	[ALMPEND],0	; If ( pending alarms )
	JZ	MINUTA
	call	beep		; 	then alert user

	RW
	DEC	[ALMPEND]	; 	Decrement minute counter & re-checksum
	RO
	CALL	RSUM
;
MINUTA:	cmp	[ALMTIME],-1	; If (NO alarms exist)  
	jz	MINUT0		;    Then return
				; Else

;----------------------------------------------------------------------------
; Check if time and date match ALMTIME,  ALMMD, and ALMYR
;-------
	push	cx
	MOV	AH,2CH		; Get time of day
	INT	1AH

	CMP	CX,[ALMTIME]	; if (time doesn't match )
	JNZ	MINUT1		;	then return
				; Else

	MOV	AH,2AH		; Get date
	INT	1AH
	CMP	DX,[ALMMD]	; If (Date doesn't match Alarm date )
	JNZ	MINUT1		;      then return
				; Else
	CALL	CONVYR		; Convert year to offset from 1985
	CMP	CL,[ALMYR]	; If (Year .EQ. Alarm Year)
	jnz	Minut1
	call	Appt_Alert	; 	then Alert User to alarm

Minut1:
	pop	cx
Minut0:				; Else
	pop	es
MINUTRET:
	RET			;     return

;--------------------------------------------------------------------------
; CHANGE TO ALARM TASK HERE!
;----------
Appt_Alert:
	mov	ah,Alarm_Int	; Next task is Appointment alarm
	mov	al,NMI_Regenerate
	call	Out_Morrow_6845	; generate new task request
	ret			; return to TOD Interrupt handler main line

Minute	EndP

page
;---------------------------------------------------------------------
Alarm_Service	Proc	; (23_May_85)
;------------------------------------
;This task is started when the time of Day matches an alarm time.
; 
;-----------------------
ASSUME	CS:Monitor_Segment, DS:PhNovRam, ES:PhNovRam
public	Alarm_Service

	SUB	SP,MINTOP	; Set base of local variables
	MOV	BP,SP
	CALL	RSIZE		; Check battery RAM
	JZ	MINUT2		; if (Ram was corrupt)
	JMP	MINUT9		; 	then Return
				; else
MINUT2:	RW
	MOV	[ALMTIME],-1	; Turn off alarm time
	MOV	[ALMPEND],0	; and beep counter
	RO

	push	ds
ASSUME	DS:Monitor_Segment,	Es:PhNovRam
	mov	ax,Monitor_Segment
	mov	ds,ax

;------------------------------------------------------------------
; Put up message on screen
;--------------------------
;	mov	ax,0		; select Alpha 40x25 video mode
;	Int	Video_IO_Intr

	xor	dx,dx		; put message on line 1
	MOV	SI,OFFSET ALMMSG

;--------------------------------------------------------------------------
; we have to set attributes in Dflags and in bl, since this has to be
;  mode independent
;


	MOV	Bl,reverse	; select reverse video
	mov	ah,Dflags
	push	ax
	mov	dflags,rev_chr
	call	Put_String	; put up message
	pop	ax
	mov	Dflags,ah

	POP	DS		; back to NovRam
ASSUME	DS:PhNovRam,	ES:PhNovRam

	MOV	BL,10		; Beep up to 10 times

MINUT4:	MOV	CX,0FFFFH/24	; 1 sec delay counter

MINUT5:	MOV	AH,1		; While (Not 10 seconds elapsed AND NO Key hit)
	INT	16H		;    get Keyboard Status
	JNZ	MINUT6		;    if (KeyPressed) then check for escape
	LOOP	MINUT5		; 

	call	beep		;    beep

	DEC	BL		;    Check if 10 seconds passed
	JNZ	MINUT4		; loop

;-----------------------------------------------------------------------
; 10 seconds are up, no key hit, so set to beep every minute for 10 minutes
;------------------

	MOV	AL,10		; Beep once/min for next 10 minutes
	JMP	SHORT MINU6A

;-------------------------------------------------------------------------
; User pressed a key so no beeping needed
;------------------

MINUT6:	XOR	AH,AH		; Get the key
	INT	16H
	SUB	AL,ESC		; If ( key .NE. Escape)
	JNZ	MINUT5		;	then keep beeping till 10 secs up
				; Else, it was escape, leave al = 0 for
				;  no beeps on the minute.

MINU6A:	push	ax		; preserve beep count
	CALL	ALMNXT		; Determine next alarm
	pop	ax		; get back beep count
	RW
	MOV	[ALMPEND],AL	; save beeps remaining
	RO
	CALL	RSUM		; re-checksum RAM

MINUT9:	ADD	SP,MINTOP	; Return to interrupt handler


;------------------------------------------------------
; exit task here!!!!!!!!!!!

	mov	ah,Last_Task_ID	; Return to previous task
	add	ah,2
	mov	al,NMI_Regenerate
	call	Out_Morrow_6845	; generate new task request
	mov	cx,500

AS_Self:loop	AS_Self		; hang around until old task re-activated
	ret

ALMMSG	DB	"APPOINTMENT: CHECK SCHEDULE OR PRESS ESC",eos

Alarm_Service	EndP


Monitor_Segment	ENDS

	END
