/* -----------------------------------------------------------------

	These are the Mindset bios call routines for interrupt 0eeh.

----------------------------------------------------------------- */

#include <cuser.inc>

/* --------------------- INTERRUPT EE ------------------------ */

/* ---------------------- set_display_device -----------------------------*/
set_display_device(device)
	char device;				/* bit 0 = mon if 1, bit 1 = black&white */
{
	struct regs myregs;

	myregs.ax = 0x0200 + device;
	callbios(ms_i_int, &myregs);
	return;
}

/* ----------------------- set_sync_mode --------------------------------*/
set_sync_mode(sync_mode)
    char sync_mode;            /* set/clear: genlock, interlace, fixed phase*/
{
    struct regs myregs;

    myregs.ax = 0x0600 + sync_mode;
    callbios(ms_i_int, &myregs);
    return;
}


/* ----------------------- set_display_int ------------------------------*/
set_display_int(linenum)
    char linenum;              /* display pixel line generating interrupt */
{
    struct regs myregs;

    myregs.ax = 0x0700 + linenum;
    myregs.bx = 0;             /* no diagnostic marker displayed */
    callbios(ms_i_int, &myregs);
    return;
}

/* ------------------------ joystick -------------------------------------*/
joystick(a_switch, b_switch, a_x, a_y, b_x, b_y)
int	*a_x, *a_y, *b_x, *b_y;		/* changes to x and y coordinates */
char *a_switch, *b_switch;		/* switch status */
								/* bit 0 = up switch, bit 1 = down switch */
								/* bit 2 = left switch, bit 3 = right */
								/* bit 4 = button 1, bit 5 = button 2 */
								/* 1 means switch is closed */
{
	struct regs myregs;

	myregs.ax = 0x1f00;
	callbios(ms_i_int, &myregs);
	*a_switch = ~(myregs.ax);				/* reverse the sense so that */
	*b_switch = ~(myregs.ax) >> 8;			/* 1 means switch closed */
	*a_x = myregs.bx;
	*a_y = myregs.cx;
	*b_x = myregs.dx;
	*b_y = myregs.si;
	return;
}

/* ----------------------------- set_led -------------------------------*/
set_led(on_off)
	char on_off;				/* 0 = off, 1 = on */
								/* bit 0 = green led, bit 1 = yellow led */
{
	struct regs myregs;

	myregs.ax = 0x2200 + on_off;
	callbios(ms_i_int, &myregs);
	return;
}

/* -------------------------- sound_mode ---------------------------------*/
sound_mode(mode, module_bits)
	char mode;						/* mode 0, 1, 2, or 3 */
									/* mode 0 = music */
									/* mode 1 = sound effects / music */
									/* mode 2 = max voice music */
									/* mode 3 = direct data */
	char module_bits;				/* bit 0 = on board, bit 1 = stereo */
{
	struct regs myregs;

	myregs.ax = 0x2400 + module_bits;
	myregs.bx = (1 << (mode));
	callbios(ms_i_int, &myregs);
	return;
}

/* -------------------------- sound_regs ---------------------------------*/
sound_regs(module_bits, mask1, mask2, soundtable)
	char module_bits;			/* bit 0 = on board, bit 1 = stereo */
	int	mask1, mask2;			/* mask saying which sound regs to write */
								/* mask 1 for on board, mask 2 for stereo */
	int soundtable;				/* offset of table of values for output */
{
	struct regs myregs;

	myregs.ax = 0x2500 + module_bits;
	myregs.bx = mask1;
	myregs.cx = mask2;
	myregs.si = soundtable;
	myregs.es = data_seg();
	callbios(ms_i_int, &myregs);
	return;
}

/* ------------------------- sound_data --------------------------------*/
sound_data(module_bits, data1, data2)
	char	module_bits;			/* bit 0 = on board, bit 1 = stereo */
	char data1, data2;				/* data for on board, data2 for stereo */
{
	struct regs myregs;

	myregs.ax = 0x2600;
	myregs.bx = (data2 << 8) + data1;
	callbios(ms_i_int, &myregs);
	return;
}

/* -------------------------- stereo_check -----------------------------*/
char stereo_check()
{
	struct regs myregs;

	myregs.ax = 0x2700;
	callbios(ms_i_int, &myregs);
	return(myregs.ax);				/* 2 if stereo module present */
}

/* ---------------------------- enable_beeper --------------------------*/
enable_beeper(on_off)
	char on_off;					/* 1 to enable beeper, 0 to disable */
{
	struct regs myregs;

	myregs.ax = 0x3600 + on_off;
	callbios(ms_i_int, &myregs);
	return;
}

/* ---------------------------- test_beeper --------------------------*/
test_beeper()
{
	struct regs myregs;

	myregs.ax = 0x3700;
	callbios(ms_i_int, &myregs);
	return(myregs.ax);
}

/* --------------------------- set_beeper --------------------------------*/
set_beeper(on_off)
	char on_off;					/* 1 to turn beeper on, 0 to turn off */
{
	struct regs myregs;

	myregs.ax = 0x3800 + on_off;
	callbios(ms_i_int, &myregs);
	return;
}
