/*	COLOR1.C -	program to display 16x16 combinations of 2-colors dithered	*/
/*				Pressing any key when colors displayed exits program.		*/
#include	<cuser.inc>
										/* define RGB/composite color bits	*/
#define	black		0x0000 + 0000
#define	dkblue		0x1000 + 0500
#define	dkgreen		0x2000 + 0050
#define	dkcyan		0x3000 + 0550
#define	dkred		0x4000 + 0005
#define	dkmagent 	0x5000 + 0505
#define	dkyellow	0x6000 + 0055
#define	dkwhite		0x7000 + 0555
#define	dkgray		0x8000 + 0222
#define	blue 		0x9000 + 0700
#define	green		0xa000 + 0070
#define	cyan 		0xb000 + 0770
#define	red  		0xc000 + 0007
#define	magenta		0xd000 + 0707
#define	yellow		0xe000 + 0077
#define	white		0xf000 + 0777

/******************************** C O L O R 1 . C ***************************/

main()
{
										/* define integer variables			*/
int	dummy, x_org, y_org,x_inc,y_inc,ecolor,ocolor;
	
static int palette[16] = {
 black, dkgray, dkwhite, white,  dkblue, blue, dkcyan, cyan, dkgreen, green,
 dkmagent, magenta, dkred, red, dkyellow, yellow  
	};									/* define MINDSET color palette		*/


static struct xypair square[] = {
		{ 0, 0},	{ 18, 0},	{ 18, 11},	{ 0, 11},
	};									/* define color block size			*/

static struct xypair outlines[] = {
		{ 18, 11},	{ 306, 11},	{ 306, 187},	{ 18, 187},	{ 18, 11}
	};									/* define outline points			*/
	
	set_screen_mode(2);                 /* MINDSET mode=2 320x200x16 colors */
	fill_dest_buffer(0);                /* erase display with black pixels	*/

	set_palette(0, 0, 16, &palette, data_seg());
										/* set up 16 color palette			*/
	
	x_org = 0;							/* origin = (0,0), upper left screen*/
	y_org = 0;
	x_inc = 18;							/* incremental step sizes for x,y	*/
	y_inc = 11;

	x_org = x_inc;						/* draw ecolor bar at top of screen */

	for(ecolor = 0; ecolor < 16; ecolor++)
		{
	   	blt_polygon(0,4,ecolor,ecolor,x_org+(x_inc*ecolor),y_org,
                    &square, data_seg());   
							/* id, count, evencolor, oddcolor, x0, y0, data */
		}

	x_org = 0;
	y_org = y_inc;						/* draw ocolor bar on left side		*/

	for(ocolor = 0; ocolor < 16; ocolor++)
		{
	   	blt_polygon(0,4,ocolor,ocolor,x_org,y_org+(y_inc*ocolor),
                    &square, data_seg());   
							/* id, count, evencolor, oddcolor, x0, y0, data */
		}


	x_org = x_inc;
										/* draw 2-color dithered blocks		*/
	for(ecolor = 0; ecolor < 16; ecolor++)
		{

		for(ocolor = 0; ocolor < 16; ocolor++)
			{
		   	blt_polygon(0,4,ecolor,ocolor,x_org+(x_inc*ecolor),
					y_org+(y_inc*ocolor),&square,data_seg());              
							/* id, count, evencolor, oddcolor, x0, y0, data */

			}
		}

	x_org = 0;							/* set display origin to (0,0)		*/
	y_org = 0;

	blt_polyline(0,0,7,3,x_org,y_org,&outlines,data_seg());
										/* draw white outline around colors	*/


	get_kb_char(&dummy);				/* wait for user to press a key	*/
	set_screen_mode(3);                 /* set MINDSET mode 640x200x4 colors*/
	set_ibm_mode(2);	                /* set IBM character mode w/cursor	*/
	exit();
}										/* exit COLOR1.C					*/

							
setibmmode(video_mode) 		/* set IBM video display mode  */ 
int video_mode;				/* argument for BIOS call      */
	{
	struct regs myregs;		/* structure from CUSER.INC    */
	myregs.ax = video_mode;	/* set 80186 register AX = mode*/
	callbios(i_io_int, &myregs);	/* actual call to BIOS */
	return;
	}
	