title Character expansion routines

name bltchar

pgroup group prog
prog segment byte public 'prog'
assume cs:pgroup

public bltchar

include macro186.inc

;------------------------------------------------------------------------------
;
;	bltchar
;
;	as called from a c program:
;		xpos = bltchar(chr, size, color, xorigin, yorigin, &font_desc);
;	passed:
;
;		chr - Ascii character
;		size - pixel duplication multiplier
;		color - color mask of character (word wide)
;		xorigin - x position of character (top left corner)
;		yorigin - y position of character
;		font_desc - descriptor of 1 bit per pixel font
;	returned:
;		xpos - x origin beyond character
;
;	destroys ax, bx, cx, dx, si, di
;
;------------------------------------------------------------------------------

; equates for offsets into font descriptor
extra_white equ 1;
raster_height equ 4;
raster_width equ 6;
raster_offset equ 8;
raster_seg equ 10;
first_char equ 12;
last_char equ 13;

; equates for offsets into char part of font descriptor
char_xpos equ 0;
char_xsize equ 2;
char_ysize equ 3;


bltchar proc near


	push	bp		;save old bp
	mov	bp, sp
	push	es

;blt the character point by point
	mov	dx,[bp + 6]			;Get x and y size
	mov	cs:bltword + 6,dx
	mov	cs:bltword + 8,dx
	mov	ax,[bp + 8]			;get color
	mov	cs:bltword,ax
	mov	si,[bp + 10]			;Get x position
	mov	di,[bp + 12]			;get y position
	mov	bx, [bp + 14]			;get font descriptor pointer

; get ax as offset of char info for this char
	mov	ax, ss:[bp + 4]			;get ASCII of character
	mov	cl, [bx + first_char]		;first char in font
	cmp	al, cl
	jb	char_out_of_range
	cmp	al, [bx + last_char]
	jbe	char_in_range
char_out_of_range:
	mov	al, [bx + extra_white]
	xor	ah, ah
	add	si, ax				;skip for white space
	jmp	finish_no_change
char_in_range:
	sub	al, cl				;ax is index
	xor	ah, ah
	shl	ax, 1				;4 bytes per char
	shl	ax, 1				;4 bytes per char
	add	ax, 14				;beyond the font stuff
	add	ax, bx				;into the table

	mov	es, [bx + raster_seg]		;es is the raster segment
assume es:nothing
	mov	bp, [bx + raster_offset]	;es:[bp] is the font

;blt character loop
	xchg	ax, bx
	mov	cl, [bx + char_ysize]		;number of scan lines tall
	xchg	ax, bx

loop_1:	push	si				;save x origin
	push	ax				;save char info pointer
	push	bx				;save font info pointer

; get x size of char for pixel count, and get xpos and byte of char
	mov	bx, ax				;bx is now index to char info
	xor	ch, ch				;Set bit count to zero.

loop_2:
	push	bx				;save the char info index
	test	ch, 7				;time for a new byte ?
	jnz	old_byte			;not yet.

; get next byte in the raster
	mov	ax, [bx + char_xpos]		;ax is offset of char in raster
	cmp	ax, 0ffffh			;is there a char in the raster?
	jnz	char_in_font			;yes. ok

; no char in the font - just compute next position
no_char:
	pop	bx
	pop	bx
	pop	ax
	pop	si
	jmp	finish_anyway

; Char is in font - get the data
char_in_font:
	shr	ax, 1				;change x into byte offset
	shr	ax, 1				;(x must be multiple of 8)
	shr	ax, 1
	mov	bl, ch				;x pixel count so far
	xor	bh, bh				;add 1 byte for each 8 pixels
	shr	bx, 1
	shr	bx, 1
	shr	bx, 1
	add	ax, bx				;get byte n of this character
	add	ax, bp				;add start of raster
	mov	bx, ax				;pointer must be in bx
	mov	al, es:[bx]			;get the byte

old_byte:
	shl	al,1				;Get bit
	jnc	no_blt				;If 0 no blt

	push	ax				;Perform the BLt
	push	bx
	push	cx
	push	es
	mov	ax,cs				;set up pointer to blt
	mov	es,ax
assume es:prog
	mov	bx,offset bltword
	mov	cx,1				;one blt
	mov	ah,9				;blt copy word
	int	0efh
	pop	es
	pop	cx
	pop	bx
	pop	ax

no_blt:	add	si,dx				;add size to x origin
	inc	ch				;Next bit
	pop	bx
	cmp	ch, [bx + char_xsize]		;enough bits ?
	jnz	loop_2

	add	di,dx				;add size to scan line
	pop	bx				;recover font info pointer
	pop	ax				;recover char info pointer
	pop	si				;recover x origin
	add	bp, [bx + raster_width]		;move to next line of raster
	dec	cl				;one more scan line done
	jnz	loop_1

finish_anyway:
	xor	dh, dh
	mov	dl, [bx + extra_white]		;skip for white space
	add	si, dx
	mov	bx, ax				;get char info pointer
	mov	dl, [bx + char_xsize]
	add	si, dx				;add x size to x origin
finish_no_change:
	mov	ax, si				;return the value

	pop	es
	pop	bp
	ret

bltchar endp

; blt copy word descriptor
bltword	dw	5 dup (0)

prog ends
end

