#include <stdio.h>
#include <ctype.h>
#include <sgtty.h>

char *charnames[] = {
	"intr",
	"quit",
	"start",
	"stop",
	"eof",
	"brk",
	0
};

char *ascnames[34] = {
	"nul",
	"soh",
	"stx",
	"etx",
	"eot",
	"enq",
	"ack",
	"bel",
	"bs",
	"ht",
	"lf",
	"vt",
	"ff",
	"cr",
	"so",
	"si",
	"dle",
	"dc1",
	"dc2",
	"dc3",
	"dc4",
	"nak",
	"syn",
	"etb",
	"can",
	"em",
	"sub",
	"esc",
	"fs",
	"gs",
	"rs",
	"us",
	"del",
	0
};

main(argc, argv)
register argc;
register char **argv;
{
	register i;
	char tc[6];

	if (ioctl(1, TIOCGETC, tc) < 0)
		exit(1);
	if (argc == 1) {
		i = 0;
		for (;;) {
			fprintf(stderr, "%s = ", charnames[i]);
			prchar(tc[i]);
			if (charnames[++i])
				fprintf(stderr, "; ");
			else
				break;
		}
		fprintf(stderr, "\n");
		exit(0);
	}
	while (--argc > 0) {
		if ((i = lookup(charnames, *++argv)) < 0) {
			fprintf(stderr, "Unknown keyword %s\n", *argv);
			break;
		}
		if (--argc > 0)
			tc[i] = rdchar(*++argv);
	}
	ioctl(1, TIOCSETC, tc);
	exit(1);
}

lookup(table, word)
register char **table;
register char *word;
{
	register n;
	for (n = 0; *table; n++, table++)
		if (strcmp(*table, word) == 0)
			return(n);
	return(-1);
}

prchar(c)
register c;
{
	c = toascii(c);
	if (isprint(c))
		fprintf(stderr, "'%c' ", c);
	else if (c == 0x7f)
		fprintf(stderr, "del");
	else
		fprintf(stderr, "%s", ascnames[c]);
}

rdchar(s)
register char *s;
{
	register i;

	if (strlen(s) == 1)
		return(*s);
	if (*s == '^')
		return(s[1] & 0x1f);
	if ((i = lookup(ascnames, s)) < 0)
		return(*s);
	if (i == 32)
		return(0x7f);
	return(i);
}
