
 x * x Welcome to the CodeView debugger.  This window will be enlarged
 x * x using the CONTROL-U command.  The session enters CONTROL-U
 x * x automatically.
 y y y y y y  y y y y y y y y y

 x * x The sample session will enter the CodeView commands automatically.
 x * x Text, such as the information you are now reading, will appear
 x * x in the dialog (lower) window.  When the sample session enters a
 x * x CodeView dialog command, it can be seen as an intensified line in
 x * x the following window of text.  The highlighted words, PRESS SPACEBAR
 x * x will appear on the last line of text in the lower right corner of
 x * x this window.  When you are ready, press the SPACEBAR to continue
 x * x with the sample session.
 x * x                                                               xPRESS SPACEBAR  ;" x


 x * x The purpose of this sample session is to demonstrate some of
 x * x CodeView's features by debugging the program "COUNT.EXE".  It
 x * x is recommended that you have the IBM BASIC Compiler/2 Compile,
 x * x Link, and Run manual opened to Chapter 7, "Debugging Your Program
 x * x with CodeView", while running the sample session.
 x * x                                                               xPRESS SPACEBAR  ;" x


 x * x Some CodeView commands will display output in the dialog window.
 x * x This will be on a separate line following the sample session
 x * x text.  The sample session takes about 20 to 30 minutes to
 x * x complete.  You can exit from the sample session at any time by
 x * x pressing Ctrl-Break and then Enter.  This will bring you to
 x * x the CodeView dialog window prompt (>).  From here, type the
 x * x CodeView Quit command (Q) and press Enter to return to the sample
 x * x session demonstration menu.  Remember, press the SPACEBAR when you
 x * x are ready to continue.
 x * x                                                               xPRESS SPACEBAR  ;" x


 x * x The line at the top of the screen is the menu bar.  It shows titles
 x * x of menus and commands that can be activated with the keyboard or the
 x * x mouse.  Titles followed by an exclamation point represent commands.
 x * x Other titles are menus.

 x * x The window below the menu bar is the display window.  Now the window
 x * x shows the first few lines of the BASIC source program COUNT.BAS, but
 x * x it can also show disassembled code.

 x * x The window at the bottom of the screen is the dialog window.  Dialog
 x * x commands are entered at the prompt (>).                       xPRESS SPACEBAR  ;" x


 x * x There are three ways to enter commands in CodeView:
 x * x     - Press command keys
 x * x     - Select from menus
 x * x     - Enter dialog command lines

 x * x This session enters commands for you using all these methods.
 x * x Remember, all you have to do is press the SPACEBAR.  All the
 x * x commands are entered automatically.                           xPRESS SPACEBAR  ;" x


 x * x In addition there are two ways to open and select from menus:
 x * x     - Press command keys
 x * x     - Use the Mouse

 x * x This session does not use the mouse.  Refer to the IBM BASIC
 x * x Compiler/2 Compile, Link, and Run manual for information on
 x * x using CodeView with a mouse.                                  xPRESS SPACEBAR  ;" x


 x * x When CodeView is started, the cursor is in the dialog window.  During
 x * x the session the cursor will need to be in the display window.  The
 x * x F6 key is used to toggle between the Dialog window and the Display
 x * x window.                                                       xPRESS SPACEBAR  ;" x
 @

 x * x There are several ways to execute code, but the simplest way is
 x * x to execute one source line at a time.  The Trace command does
 x * x this with the Trace dialog command (T) or the F8 function key.

 x * x To start debugging, trace through the first instruction by using
 x * x the F8 key to execute the Trace command.                      xPRESS SPACEBAR  ;" x
 B

 x * x The reverse-video line (blue on color monitors), marks the line
 x * x about to be executed.  This time the Trace dialog command is used
 x * x instead of the F8 key.  The dialog command is more powerful
 x * x since it allows you to specify the number of times you want to
 x * x Trace.  The next example traces three times.                  xPRESS SPACEBAR  ;" x
 xT 3 x


 x * x Note that sometimes several lines of source code are executed
 x * x for one Trace command.  This happens because CodeView skips over
 x * x comments, data declarations, and other source lines that do not
 x * x correspond to executable code.

 x * x The next few statements open the file COUNT.TXT and read in the
 x * x first line of text.  Let's execute to the source line where the
 x * x first character is read.  One way to go there is by pressing the
 x * x DOWN ARROW key until the cursor is on the desired line...     xPRESS SPACEBAR  ;" x
 y P y P y P y P y P y P y P y P y P y P y P y P y P y P y P y

 x * x Then the F7 key is pressed.  F7 is like a 'goto' command.  It
 x * x executes to the source line containing the cursor.            xPRESS SPACEBAR  ;" x
 A

 x * x Before going further, let's examine some of the variables in
 x * x the program.  The PgUp key can be used to scroll back to the
 x * x initialization code in the program.                           xPRESS SPACEBAR  ;" x
 I y I y

 x * x The COMMAND$ function returns the parameters the command line used
 x * x to call the program in the variable C$.  When CodeView was started
 x * x the parameter COUNT.TXT was passed to the program COUNT.

 x * x C$ can be evaluated by selecting the Evaluate option from the
 x * x View menu.  Press Alt-V to open the View menu.  Press the DOWN
 x * x ARROW key until the highlight is on the Evaluate selection  and
 x * x press ENTER.  A dialog box will open asking for an expression.
 x * x The result will be displayed in the Dialog window.            xPRESS SPACEBAR  ;" x
 / y y P y P y P y P y P y
 y y yC$ y y y


 x * x The variable LINES contains the number of lines that have been
 x * x read.  At this point the value of LINES should be 1.  Another method
 x * x of evaluating expressions is the Display Expression dialog command.
 x * x The command character is a '?' followed by an argument consisting
 x * x of the expression being evaluated, in this case LINES.  Again, the
 x * x results are displayed in the Dialog window.                   xPRESS SPACEBAR  ;" x
 x? lines x


 x * x Before going any further, the Current Location command is used to
 x * x put the highlighted current location line back in the display window.
 x * x The command character is a period.                            xPRESS SPACEBAR  ;" x
 x. x


 x * x The rest of the program will be run using the Go command.  Since there
 x * x are no breakpoints set, execution will continue to the end of the
 x * x program.  The output should tell us if there are any errors in the
 x * x program.  The Go command will be invoked with the F5 key.  The message
 x * x 'Program terminated normally' will appear in the dialog window.
 x * x                                                               xPRESS SPACEBAR  ;" x
 ?

 x * x The F4 key can be used to switch from the CodeView screen to the
 x * x output screen.  The output screen shows the results of the COUNT
 x * x program.  Note the totals counted by the program.  In particular,
 x * x note the number of characters counted. Press the SPACEBAR to
 x * x return to the Codeview display window.                        xPRESS SPACEBAR  ;" x
 >

 x * x The COUNT.TXT file says there are 630 characters in the file.  Our
 x * x program says there are only 618 characters.  A good rule for
 x * x debugging is that most errors occur at the boundaries.  In this case,
 x * x the miscounting of words probably happens when the program reads in
 x * x either the first characters of a buffer, or when it reads the last
 x * x characters.  There are other possibilities, but let's start by
 x * x checking the boundaries.

 x * x First, the program is restarted by selecting the Restart option from
 x * x the Run menu ...                                              xPRESS SPACEBAR  ;" x
  y y P y y P y


 x * x The current location line disappears, indicating that we are at the
 x * x beginning of the program before executing any code.  Rather than go
 x * x through the preliminary part of the program again, we'll go directly
 x * x to the section of the code which processes the characters in the
 x * x buffer...                                                     xPRESS SPACEBAR  ;" x
 xG .12 x

 x * x The Trace dialog command (T), allows an optional argument which
 x * x specifies the number of times the Trace command runs before stopping.
 x * x The next 3 lines are executed with the Trace dialog command.  xPRESS SPACEBAR  ;" x
 xT 3 x


 x * x The variable POSITION now points to the first character in the string
 x * x that has been read in.  The next line assigns the first character in
 x * x the string to CHAR$.  Once that is done, the program is ready to start
 x * x analyzing each character. Let's trace to that point.          xPRESS SPACEBAR  ;" x
 xT 5 x


 x * x Several Watch statements can be entered to view data or memory as
 x * x the program runs.  Watch statements are specifications that describe
 x * x expressions or areas of memory to watch.  When any of them are used,
 x * x a Watch window is opened and the value specified by the statement
 x * x is displayed in the window.                                   xPRESS SPACEBAR  ;" x


 x * x The three Watch statements are:
 x * x     - Watch
 x * x     - Watchpoint
 x * x     - Tracepoint

 x * x The Watch and Tracepoint commands have two forms:
 x * x     - Memory
 x * x     - Expression                                              xPRESS SPACEBAR  ;" x

 x * x The memory form of the Watch command is followed by a letter indicating
 x * x the size to be watched--for example, WI (Watch Integers), or WS (Watch
 x * x Short Real).  The expression form is followed by a question mark (W?)
 x * x and indicates a BASIC expression.

 x * x The expression form of the Watch statement can be specified with
 x * x menus, but the memory form of these commands can only be entered
 x * x with dialog command lines.                                    xPRESS SPACEBAR  ;" x


 x * x The first Watch statement is for the variable A$ which contains the
 x * x data that has been read in from the file COUNT.TXT.  To use the
 x * x menu form of the Watch statement, the Add Watch option is selected
 x * x from the Watch menu.  Notice that a Watch window is created at the
 x * x top of the screen and the variable A$ is displayed in the window.
 x * x                                                               xPRESS SPACEBAR  ;" x
  y y P y y
A$ y y

 x * x Next, the expression form of the Watch command is used to watch the
 x * x variable CHAR$.                                               xPRESS SPACEBAR  ;" x
 xW? char$ x


 x * x CHAR$ seems to have no value, but a look at the characters that have
 x * x been read in shows why.  The first two characters are space characters.

 x * x Finally a tracepoint is set on the variable CHARS, which will contain
 x * x the number of characters counted.  A tracepoint expression describes
 x * x a memory location that will be checked for changes.  When the value
 x * x at that location changes, program execution stops.  The value will
 x * x change and the break will be taken every time we count a new
 x * x character.  The command is entering by selecting the Tracepoint
 x * x option from the Watch menu...                                 xPRESS SPACEBAR  ;" x
  y y P y y P y y P y
 y yCHARS y y y


 x * x Note that the tracepoint expressions are highlighted in the Watch
 x * x window to distinguish them from watch expressions.  Watchpoint
 x * x expressions (not used in this session) are also highlighted.  xPRESS SPACEBAR  ;" x


 x * x So far we haven't counted any characters, so the value of CHARS
 x * x is 0.  At this point, we don't care how the characters are counted,
 x * x we just want to see if it comes up with the right amounts.  Instead
 x * x of tracing through step by step, the Go command is used to execute
 x * x until a new character is counted.                             xPRESS SPACEBAR  ;" x
 ?
 x * x The break occurs as soon as the value of CHARS changes from 0 to 1.
 x * x Note that the value of CHAR$ is C, the first letter in the string
 x * x A$.  Looking at the display, you can see that we skipped over the
 x * x two spaces and started counting at C.  Let's count a few more.  F5
 x * x is pressed (for Go).                                          xPRESS SPACEBAR  ;" x
 ?

 x * x 'O' is the second character . .                               xPRESS SPACEBAR  ;" x
 ?
 x * x 'U' is the third . . .                                        xPRESS SPACEBAR  ;" x
 ?
 x * x 'N' is the fourth . . .                                       xPRESS SPACEBAR  ;" x
 ?

 x * x And 'T' is the fifth.  The next character is a space.  Will it be
 x * x counted?                                                      xPRESS SPACEBAR  ;" x
 ?

 x * x The space is not counted.  The program skips to 'i', just what we
 x * x wanted.  We could continue tracing like this, but if the first few
 x * x letters are right, the rest will probably be okay too.

 x * x Now, let's check the end of the buffer.  To do this, we'll start
 x * x over from the beginning.  First, the Watch window will be cleared
 x * x using the Delete Watch command (Y).  The command character 'Y' is a
 x * x mnemonic for Yank.  If an asterisk is supplied as an argument to the
 x * x command, all Watch statements are deleted.                     xPRESS SPACEBAR  ;" x
 xY * x


 x * x Next, the Restart dialog command will be used to restart the program.
 x * x The command letter is 'L' for Load, but it should not be confused
 x * x with the Load selection from the File menu because that selection
 x * x only loads a source file without restarting the program.      xPRESS SPACEBAR  ;" x
 xL x


 x * x The variable L contains the length of the first data item read in
 x * x by the file.  For the first line, the value of L is 63.  This means
 x * x that we need to do about 62 iterations of the counting loop.  The
 x * x best way to do this is to set a breakpoint with a pass count of
 x * x 62.  In other words, we'll execute through the breakpoint 62 times
 x * x before stopping.                                              xPRESS SPACEBAR  ;" x


 x * x Line 15, just after a new character is read, is a good place to set
 x * x the breakpoint.  First, let's scroll down a few lines in the display
 x * x window.  The DOWN ARROW key is pressed to move the cursor to the
 x * x desired line.                                                 xPRESS SPACEBAR  ;" x
 y P y P y P y P y P y P y P y P y P y P y P y P y P y P y P y


 x * x The command letters for the Breakpoint Set command are BP.
 x * x The first argument to the command is '.15'.  The dot indicates
 x * x that we want to set a breakpoint at line 15 of the current
 x * x source file, not address 15.  The second argument to the command is
 x * x the pass count - 62.                                          xPRESS SPACEBAR  ;" x
 xBP .15 62 x


 x * x As soon as the command is entered, line 15 becomes highlighted to
 x * x indicate that it has a breakpoint.  Now the Go command is executed.
 x * x This could take a few seconds since breakpoints slow program
 x * x execution.                                                    xPRESS SPACEBAR  ;" x
 xG x


 x * x Execution stops on the breakpoint line.  Some Watch statements need
 x * x to be added to monitor the program.  The first Watch statement is for
 x * x the variable POSITION which indicates how many characters (including
 x * x blanks) have been read.  Note that the memory form of the command
 x * x is used with an Integer type specifier.                       xPRESS SPACEBAR  ;" x
 xWI position x


 x * x The value of POSITION indicates that we are about to examine the
 x * x 62nd character.

 x * x The last Watch statements are for A$ (the data that has been read)
 x * x CHARS (the number of characters), and CHAR$ (the current character).
 x * x                                                               xPRESS SPACEBAR  ;" x
 xW? A$ x
 xW? CHARS x
 xW? CHAR$ x

 x * x The program is at the next to the last character of A$,'e'.  The
 x * x character count is 48.  When the Go command is entered, the program
 x * x should read in the last character, 's', and increment the value of
 x * x CHARS to 49.                                                  xPRESS SPACEBAR  ;" x
 xG x


 x * x If we look at the values in the Watch window, the program did not
 x * x analyze the last character, instead the next line of data was read
 x * x in by the program.                                            xPRESS SPACEBAR  ;" x


 x * x The value of the variable POSITION is used to determine whether
 x * x the last character has been read.  Notice that the program tests
 x * x for the end of the line with the following statement:

 x * x IF POSITION>=L THEN...

 x * x To prevent skipping the last character, when POSITION=L, the program
 x * x should read:

 x * x IF POSITION>L THEN...                                         xPRESS SPACEBAR  ;" x


 x * x To be sure this is the problem, let's make a change within CodeView to
 x * x test our theory.  First, let's Restart the program . . .      xPRESS SPACEBAR  ;" x
 xL x


 x * x When a program is Restarted, CodeView retains previous breakpoints,
 x * x but the pass count is set to 1.  We need to reset the breakpoint with
 x * x a pass count of 62 before the program is run.                 xPRESS SPACEBAR  ;" x
 xBP .15 62 x
 xG x


 x * x Rather than watch the error occur again, the variable L can be
 x * x incremented so the program does not think it is at the end of the
 x * x buffer.  This can be done by evaluating the expression `LET L=L+1'.

 x * x Evaluating BASIC expressions to change the value of variables is a
 x * x useful technique.  You can set variables or even execute functions,
 x * x but watch out for the side effects.                           xPRESS SPACEBAR  ;" x
 / y y P y P y P y P y P y
LET L=L+1 y y y


 x * x The Go command will run the program to the breakpoint.        xPRESS SPACEBAR  ;" x
 xG x


 x * x Incrementing the value of L made the results correct for the first
 x * x buffer of data.  The program was skipping over the last character in
 x * x every line.  Since there are 13 lines in the file, but only 12 lines
 x * x of text, the character count was off by 12.  The temporary fix will
 x * x make the character count off by 11 when the program is run.

 x * x Before executing the rest of the program, the breakpoint will be
 x * x deleted.
 x * x                                                               xPRESS SPACEBAR  ;" x
 xBC * x
 xG x


 x * x Let's check the program output again with F4.  The results should show
 x * x a character count of 619 this time.  Remember to press the SPACEBAR
 x * x to return to the CodeView display window.                    xPRESS SPACEBAR  ;" x
 >
 x * x Incrementing the value of L only fixed the character count for the
 x * x first line of data.  To make a permanent fix, modify the incorrect
 x * x IF statement, recompile, and relink.

 x * x This ends our session.  The Quit command (Q) is entered to exit
 x * x CodeView and return to DOS.                                   xPRESS SPACEBAR  ;" x
 xQ x


