            PAGE ,132

; Source: ADD.ASM
; Fri, 23-Jan-1987, 13:27:24
;
; Routine that adds two integers.
;
;  The BASIC call is:
;
;     Add X%, Y%, Sum%
;
;     WHERE:
;
;        X%, Y%  = the numbers to add.
;        Sum%    = the result.


X           EQU     12           ; BP offsets for parameters
Y           EQU     10
SUMSeg      EQU      8
SUMOfs      EQU      6

TestSub     SEGMENT  WORD PUBLIC 'CODE'
            ASSUME   cs:TestSub
            PUBLIC   Add

Add         PROC     FAR
            PUSH     BP                ; Save base pointer
            MOV      BP,SP             ; Get our own
            PUSH     ES

            MOV      AX,[BP+SUMSeg]    ; Get segmented address to
            MOV      ES,AX             ; return summed value in
            MOV      SI,[BP+SUMOfs]

            MOV      AX,[BP+X]         ; Sum X and Y
            ADD      AX,[BP+Y]

            MOV      [ES:SI],AX        ; Save in output variable

            POP      ES                ; Restore segment register
            POP      BP                ; Restore base pointer
            RET      8                 ; Return

Add         ENDP
TestSub     ENDS
            END
