/*===============================================================*
 *   Version 1.3        YHDMD.C                                  *
 *                      Media Determination for the PC/AT hard   *
 *                      disk driver.                             *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *                                                               *
 *   1.01      5-01-85 pjp     check DKASR for error returns     *
 *   1.02      851120  reb     added drive types 16 thru 22      *
 *                             plus the code to read cmos for    *
 *                             the correct type.                 *
 *   1.03      860130  reb     reversed drive selection logic    *
 *                             in dpudmdb()                      *
 *   1.1       08/13/86 mei    Metaware port. Disk errors OR'd   *
 *				with ED_DISK.			 *	
 *   1.2       860821   reb    Metaware work around for BYTE in  *
 *                             arithmetic no being converted     *
 *			       correctly for a subtract          *
 *   1.3	9/16/86	DR-K   add dkyfindpud() to return PUD for*
 *				soecified unitnumber		 *
 *===============================================================*
 */


/******************************************************************************
*
*   This module will attempt to read in the boot sector if the install
*   flag indicates that this is pationioned media the partition table
*   will be used to get to the first partition and read in the boot
*   sector for that partition. Once this is accomplished the bpb in
*   this boot record ( the first sector in this partition ) will be used
*   to fill in the ldd for this logical unit (same physical unit )
*   The above scenario will be repeated for all the partitions in the
*   inital boot sectors partition table. If the install flag indicates
*   non-partitioned media it will be assumed that the inital boot record
*   contains a bpb that will be used for filling in the one ldd that
*   describes this media. If no boot record, partition table, and/or
*   bpb is present then a default ldd and  mdb are used to descricribe
*   the media. In this particular case a hardware register is used to
*   reference a likely default configuration. One can assume that
*   a format and/or write sytem area is going to take place in this case.
*
******************************************************************************/

#include    "portab.h"
#include    "system.h"
#include    "ymd.h"
#include    "yio.h"
#include    "ydk.h"
#include    "yhd.h"

/*
*  forward declarations
*/

ERROR   phd_DetermineMedia() ;
ERROR   hd_dmphyio() ;
ERROR   dpudmdb();
ERROR	dkyfindpud();

/*
*  external declarations
*/

EXTERN  LONG    phd_recal() ;
EXTERN  LONG    phd_io() ;
EXTERN  WORD    getcmos() ;
EXTERN  PROC    movie() ;
EXTERN  LONG    phd_setparm() ;
EXTERN  VOID	dkybp2ld();

/***************************************************************************
*   local defines
*/

/******************************************************************************
*   Global Data
*/


GLOBAL  BYTE    parts = 0 ;     /* partition table indecese and state switch */
GLOBAL  BYTE    phydrvno = 0 ;      /* physical drive no of this partition */

/******************************************************************************
*  local data structures
******************************************************************************/

PTE PTEA[maxphydrv][maxparts]; /* partition table per physical unit */


PUD puda[ ] =
{
            /*  TYPE    1       */
    306,        /*  max cyl for i/o     */
    128,        /*  pre-comp cyl #      */
    305,        /*  landing zone        */
      4,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    2       */
    615,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    615,        /*  landing zone        */
      4,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    3       */
    615,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    615,        /*  landing zone        */
      6,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    4       */
    940,        /*  max cyl for i/o     */
    512,        /*  pre-comp cyl #      */
    940,        /*  landing zone        */
      8,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */


            /*  TYPE    5       */
    940,        /*  max cyl for i/o     */
    512,        /*  pre-comp cyl #      */
    940,        /*  landing zone        */
      6,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    6       */
    615,        /*  max cyl for i/o     */
    616,        /*  pre-comp cyl #      */
    615,        /*  landing zone        */
      4,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    7       */
    462,        /*  max cyl for i/o     */
    256,        /*  pre-comp cyl #      */
    511,        /*  landing zone        */
      8,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    8       */
    733,        /*  max cyl for i/o     */
    734,        /*  pre-comp cyl #      */
    733,        /*  landing zone        */
      5,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    9       */
    900,        /*  max cyl for i/o     */
    902,        /*  pre-comp cyl #      */
    901,        /*  landing zone        */
     15,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */


            /*  TYPE    10      */
    820,        /*  max cyl for i/o     */
    821,        /*  pre-comp cyl #      */
    820,        /*  landing zone        */
      3,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    11      */
    855,        /*  max cyl for i/o     */
    856,        /*  pre-comp cyl #      */
    855,        /*  landing zone        */
      5,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    12      */
    855,        /*  max cyl for i/o     */
    856,        /*  pre-comp cyl #      */
    855,        /*  landing zone        */
      7,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    13      */
    306,        /*  max cyl for i/o     */
    128,        /*  pre-comp cyl #      */
    319,        /*  landing zone        */
      8,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    14      */
    733,        /*  max cyl for i/o     */
    734,        /*  pre-comp cyl #      */
    733,        /*  landing zone        */
      7,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */


            /*  TYPE    15      */
    733,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    732,        /*  landing zone        */
      5,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */


            /*  TYPE    16      */
    612,        /*  max cyl for i/o     */
    000,        /*  pre-comp cyl #      */
    663,        /*  landing zone        */
      5,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    17      */
    977,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    977,        /*  landing zone        */
     05,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */


            /*  TYPE    18      */
    977,        /*  max cyl for i/o     */
    978,        /*  pre-comp cyl #      */
    977,        /*  landing zone        */
      7,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    19      */
    1024,       /*  max cyl for i/o     */
    512,        /*  pre-comp cyl #      */
    1023,       /*  landing zone        */
      7,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    20      */
    733,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    732,        /*  landing zone        */
      5,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */

            /*  TYPE    21      */
    733,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    732,        /*  landing zone        */
      7,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0,        /*  nop         */


            /*  TYPE    22      */
    733,        /*  max cyl for i/o     */
    300,        /*  pre-comp cyl #      */
    733,        /*  landing zone        */
      5,        /*  # heads         */
     17,        /*  sectors/track       */
      0,        /*  seek rate       */
      0         /*  nop         */
} ;



/******************************************************************************
*  phd_DetermineMedia -
*   Synchronous interface to hd_md code.  Call this routine from
*   synchronous code only.
*/
ERROR   phd_DetermineMedia( u )
LUTE    *u ;
{

    PTE *ptep ;
    WORD    len ;
    BYTE    *ptr ;
    BYTE    *buffer ;
    IORB    *i ;
    LDD *l ;

    ULONG   nsecs ;
    ULONG   relsec ;

    ERROR   r ;         /*  return code         */


    /*  check install flags for non-partitioned media       */

    i = &u->lu_iorb ;
    l = u->lu_lddp ;

    if( !(u->lu_iflag & 0x0100) )
    {
        /*  next drive, if previous partitions on this one  */
        if( parts )
        {
            parts=0 ;
            ++phydrvno ;
        }
    }

    if( parts >= maxparts )
    {   parts = 0 ;     /* reinit partition/physical device ctr */
        ++phydrvno ;        /* next phy dev on partition overflow */
    }

    if( (r = dpudmdb( u ) ) != NULLPTR )      /* default pud & mdb        */
        return( r ) ;

    u->lu_driveno = phydrvno ;

    /* Allocate memory for disk read buffer         */

    buffer = (BYTE *) SALLOC((LONG)(HDMAXREC)) ;
    if( ! buffer )
        return( ED_DISK | E_POOL ) ;  /* not a driver E_CODE  */

    if( parts )     /* parts not zero already read MBR */
        goto hd_dm3 ;   /* finish partitioning */

/******************************************************************************
*  hd_dm0 -
*   the recal to get the heads back to track 0.  Seeks won't do,
*   because the disk may not be formatted. if non-partitioned media
*   we are finished.
*/

hd_dm0:

    if( (r = hd_dmphyio( u , phd_recal ) ) != NULLPTR )   /*  track 0     */
        goto bad_exit ;

    /*  check install flags for non-partitioned media       */

    if( !(u->lu_iflag & 0x0100) )
    {
        /*  inc phydrvno, reset parts for next entry    */
        /*  into determine media routine            */
        /*  default values to ldd               */

        l->ld_endssn = l->ld_mdb.md_nsecs - 1L ;
        l->ld_stssn = 0 ;

        parts = 0 ;
        ++phydrvno ;
        goto good_exit ;
    }

/*   the Master Boot Record read.       */


    i->io_op = DKREAD ;
    i->io_totnsecs = 1 ;
    i->io_stssn = 0L ;

    i->io_buffer = (LONG)buffer ;

    phd_setparm( u ) ;      /*851111 reb */

    if( ( r = hd_dmphyio( u , phd_io ) ) != NULLPTR )
        goto bad_exit ;


/*  Save a copy of the partition table for our reference.   */

    len = maxparts * sizeof(PTE) ;
    ptr = buffer + l->ld_mdb.md_secsiz - len - 2 ;
    movie( &PTEA[phydrvno][0] , ptr , len ) ;

/***************************************************************************
* hd_dm3 - index the partition table for DOS type partitions then read
* the bootsector for each of these partitions to setup the ldd.
* For raw(CPM) partitions use partition table information to partially fill
* what we can into the default mdb. If we run out of partitions in this table
* start over with new physical drive.
*/

hd_dm3:
    while(1)
    {
        ptep = &PTEA[phydrvno][parts];
        switch( ptep->sysird )
        {
            case 0:     /* invalid partition    */
            {
                if( ++parts >= maxparts)
                {
                    if( (r = dpudmdb( u ) ) != NULLPTR )
                        goto bad_exit ;

                    u->lu_driveno = phydrvno ;
                    goto hd_dm0 ;
                }
                else continue;
            }
            case 1:     /* DOS partition 1.5 byte fats */
            {
                l->ld_mdb.md_format = MDDOS ;
                i->io_op = DKREAD ;
                i->io_totnsecs = 1 ;
                i->io_stssn = ptep->relsec ;
                i->io_buffer = (LONG)buffer ;
                phd_setparm(u) ;        /*851111 reb set up for multisector io */

                if( ( r = hd_dmphyio( u , phd_io ) ) != NULLPTR )
                    goto bad_exit ;
                break ;
            }

            case 4:     /* DOS partition 2.0 byte fats */
            {
                l->ld_mdb.md_format = MDDOSX ;
                i->io_op = DKREAD ;
                i->io_totnsecs = 1 ;
                i->io_stssn = ptep->relsec ;
                i->io_buffer = (LONG)buffer ;
                phd_setparm( u ) ;      /*851111 reb set up for multisector io */
                if( ( r = hd_dmphyio( u , phd_io ) ) != NULLPTR )
                    goto bad_exit ;
                break ;
            }
            default:    /* non-DOS partition    */
            {
                nsecs = PTEA[phydrvno][parts].nsecs ;
                relsec = PTEA[phydrvno][parts].relsec ;

                l->ld_mdb.md_nsecs = nsecs ;
                l->ld_stssn = l->ld_mdb.md_hidden = relsec ;
                l->ld_endssn = relsec + nsecs - 1L ;

                ++parts ;
                goto good_exit ;
            }
        }
    break ;
    }


/*************************************************************************
 *  we have read the first sector of the DOS partition, check for errors,
 *  setup new ldd from bpb in this partition's boot record, increment the
 *  number of partitions initalized.
 */

    if(!( 0xf8 == *(buffer+21) ) )  /* validate bpb */
    {
        ++parts ;
        r = (ED_DISK | E_UNKNOWNMEDIA) ;
        goto bad_exit ;
    }
    else
    {
        dkybp2ld( l , buffer ) ;

        l->ld_endssn = PTEA[phydrvno][parts].nsecs - 1L ;

        l->ld_endssn +=
            l->ld_stssn =
                l->ld_mdb.md_hidden =
                    PTEA[phydrvno][parts].relsec ;

        ++parts ;
        /* goto good_exit (fall through)    */
    }

good_exit:
    r = E_SUCCESS ;

bad_exit:
    SFREE( buffer ) ;
    return( r ) ;
}


/******************************************************************
 * hd_dmphyio -  do physical level function
 *
 */

ERROR   hd_dmphyio( u , rtnaddr )
LUTE    *u ;
LONG    (*rtnaddr)() ;
{
    ENUM    e ;
    LONG    r ;

    e = FLAGEVENT( u->lu_ioflagno , 0L ) ;
    if(( r = DKASR( rtnaddr , u , 0L )) < 0L)
    {
        FLAGSET( u->lu_ioflagno , u->lu_pdaddr , r ) ;
        return( r ) ;
    }
    SUPIF( F_WAIT , e ) ;
    return( SUPIF( F_RETURN , e ) ) ;
}


/****************************************************************
 * dpudmdb - create a default pud and mdb by whatever means possible
 *
 */

ERROR dpudmdb( u )
LUTE    *u ;
{
    LONG	r ;
    UBYTE   value ;
    LDD	       *l ;
    PUD	     *pud ;


    if( parts >= maxparts )  {
        parts = 0 ;         /* reinit partition/physical device ctr */
        ++phydrvno ;        /* next phy dev on partition overflow */
    }

    if ( (r = dkyfindpud(phydrvno,u)) != E_SUCCESS) return(r);

    pud = u->lu_pudp ;

    /*  create mdb/ldd from pud values              */

    l = u->lu_lddp ;

    l->ld_mdb.md_secsiz = 512 ;     /* hard coded for pc... */
    l->ld_mdb.md_1sec = 0 ;         /* for non-partitioned  */
    l->ld_mdb.md_nsecs = (ULONG)
            (pud->pu_maxcyl * pud->pu_nheads * pud->pu_sectors) ;
    l->ld_mdb.md_sectrk = pud->pu_sectors ;
    l->ld_mdb.md_secblk = 8 ;       /* hard coded for pc... */
    l->ld_mdb.md_nfats = 0 ;
    l->ld_mdb.md_nfrecs = 0 ;
    l->ld_mdb.md_dirsize = 0 ;
    l->ld_mdb.md_nheads = pud->pu_nheads ;
    l->ld_mdb.md_format = MDCPM ;       /* assume raw non-partitioned*/
    l->ld_mdb.md_hidden = 0 ;
    l->ld_mdb.md_syssize = 0 ;


    return( E_SUCCESS ) ;
}

/***********************************************************************
 *	dkyfindpud - Get the drive type from CMOS, and set the proper
 *			PUD index.
 */

ERROR dkyfindpud(drive,u)
BYTE	drive;
LUTE    *u ;
{
    UBYTE   value ;

    if( drive > maxphydrv-1 )  { /* check for bad phy dev #  */
        return( ED_DISK | E_UNITNO ) ;
    }

    /*  user hardware register to determine if physical device  */
    /*  attached and if so type of device           */

    value = getcmos( HDCMOSVAL ) ;

    if(value == 0) {
         return (ED_DISK | E_UNITNO) ;
    }

    value = (( value  >> (drive ? 0 : 4 )) & 0xf ) ;

    if (value == 0xf)  {
        value = getcmos( drive ? HD1CMOSVAL : HD0CMOSVAL ) ;
    }

    if( !(value) )  {
        return( ED_DISK | E_UNITNO ) ;
    }

    u->lu_pudp = &puda[--value] ; /* no 0 type in array   */

    return(E_SUCCESS);
}


