
/***************************** getcmos.c ********************************/ 

#include	"portab.h"

#define	CMOSCMD		0x70	/*  CMOS command port address		*/
#define	CMOSDATA	0x71	/*  CMOS data port address		*/
#define CMOSDIAG	0x0e	/*  address diagnostic byte in cmos	*/
#define	CMOSLOWBATTERY	0x80	/*  1 = CMOS has lost power		*/
#define	CMOSBADCHKSUM	0x40	/*  1 = bad check sum in CMOS RAM	*/

EXTERN	BYTE	INP() ;
EXTERN	VOID	OUTP() ;

/*****************************************************************************
*  getcmos -
*	get the value in the cmos ram requested.
*	return:	if >= 0 then value requested
*		if <  0 then error (cmos battery down, checksum error)
*/

WORD	getcmos( offset )
BYTE	offset ;
{
	BYTE	temp ;

	OUTP( CMOSCMD , CMOSDIAG ) ;	/*  point to ram location for diag	*/
	temp = INP( CMOSDATA ) ;	/*  get cmos diag byte			*/
	if(  temp & ( CMOSLOWBATTERY | CMOSBADCHKSUM )  )
		return( -1 ) ;

	OUTP( CMOSCMD , offset ) ;	/*  select desired byte		*/
	return( INP( CMOSDATA )  ) ;
}

