/*======================================================================*
 *   Version 2.1       Serial PORT Driver				*
 *			HEADER file					*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   3/26/85 11:20 DR-K	shortened port_tbl to spec		*
 *   1.02   4/26/85 17:51 DR-K	define PTM_PARITY mask			*
 *   1.03   6/12/85 14:24 DR-K	delete DH and DPB use IO.H instead	*
 *   2.0    3/14/86 13:54 RFW   added CDSELECT struct for port driver   * 
 *   2.1    9/18/86 09:20 RFW	Defined PTx_TYPE,PTx_BAUD, PTx_MODE and *
 *				PTx_CTRL for setting the default values *
 *				of the PORT_TBL structure for each port.*
 *======================================================================*/

/************************************************************************/
/* NOTE: Change these values in order to Modify the default PORT TABLE  */
/* values. PTx_TYPE is set to a value from the Port Type Defines found  */
/* below. PTx_BAUD baud rate index for Port 0 and Port 1 is set by 	*/
/* indexing into BD Baud Rate Values defined below; such as define 	*/
/* PT0_BAUD to 7 is for 1200 baud. You start counting at 0 which is 	*/
/* BD50 or 50 baud and count through 15	which is BD19200 or 19200 baud. */
/* The PTx_MODEs are set to a combination of the Port Mode Defines found*/
/* below. PTx_CTRL is set to a combination of the Port Control Defines  */
/* also found below.							*/
/************************************************************************/

/* Port 0 PORT_TBL default defines */
#define PT0_TYPE   PTT_SERIAL	/* Set the default TYPE of port for port 0 */
#define PT0_BAUD   14		/* Set the default baud rate for port 0 */ 
				/* Set default MODE for port 0 */
#define PT0_MODE   PTM_NOPAR + PTM_1STOP + PTM_LENGTH 
				/* Set default PORT CONTROL for port 0*/
#define PT0_CTRL   PTC_TXENAB + PTC_RXENAB + PTC_DTR + PTC_RTS

/* Port 1 PORT_TBL default defines */
#define PT1_TYPE   PTT_SERIAL	/* Set the default TYPE of port for port 1 */
#define PT1_BAUD   14		/* Set the default baud rate for port 1 */ 
				/* Set the default MODE for port 1 */
#define PT1_MODE   PTM_NOPAR + PTM_1STOP + PTM_LENGTH
				/* Set the default PORT CONTROL for port 1 */
#define PT1_CTRL   PTC_TXENAB + PTC_RXENAB + PTC_DTR + PTC_RTS

/**************************************************************************/

#define	ERROR		LONG	/* type of error code returns	*/
#define EMASK		LONG

#define E_IllUnitno	-1020

/****************************************************************/
/*  PORT Driver  dependent type definitions 			*/
/****************************************************************/

/*
 *  Port Get/Set Structure
 */
#define	PORT_TBL	struct PortInfoTable
PORT_TBL
{
	WORD	pt_type ;		/*  type of port - see below	*/
	WORD	pt_state ;		/*  not used			*/
	BYTE	pt_baud ;		/*  see BD defines below	*/
	BYTE	pt_mode ;		/*  serial mode of operation	*/
	BYTE	pt_control ;
	BYTE	pt_1fill ;
} ;

/* Port Type Defines */

#define	PTT_UNDEFINED	0x00
	/*  not used							*/
#define	PTT_SERIAL	0x01
	/*  typical serial i/o device					*/
#define	PTT_CHAR	0x02
	/*  fixed char i/o dev						*/
#define	PTT_PARALLEL	0x04
	/*  typical parallel port i/o device				*/

/*  BD - Baud Rate values */

#define		BDINVALID	0x0000		/* index of baudtab[] */
#define		BD50		0x0900		/* 0 */    
#define		BD75		0x0600		/* 1 */
#define		BD110		0x0417		/* 2 */
#define		BD134		0x0359		/* 3 */
#define		BD150		0x0300		/* 4 */
#define		BD300		0x0180		/* 5 */
#define		BD600		0x00C0		/* 6 */
#define		BD1200		0x0060		/* 7 */
#define		BD1800		0x0040		/* 8 */
#define		BD2000		0x003A		/* 9 */
#define		BD2400		0x0030		/* 10 */
#define		BD3600		0x0020		/* 11 */
#define		BD4800		0x0018		/* 12 */
#define		BD7200		0x0010		/* 13 */
#define		BD9600		0x000C		/* 14 */
#define		BD19200		0x0006		/* 15 */

/* Port Mode Defines */

#define	PTM_LENGTH		0x03
#define		PTM_L5		0x00
#define		PTM_L6		0x01
#define		PTM_L7		0x02
#define		PTM_L8		0x03

#define	PTM_STOP		0x0c
#define		PTM_XSTOP	0x00
#define		PTM_1STOP	0x04
#define		PTM_12STOP	0x08
#define		PTM_2STOP	0x0c

#define PTM_PARITY	        0x30		/* mask */
#define	PTM_NOPAR		0x00
#define PTM_PENAB		0x10
#define	PTM_PEVEN		0x20

/* port control defines */

#define	PTC_DTR			0x01	
					/* rw: data term ready	   */
#define	PTC_RTS			0x02
					/* rw: req to send	   */
#define	PTC_TXENAB	    	0x04	
					/* rw: 1 = enable transmit */
#define	PTC_RXENAB		0x08	
					/* rw: 1 = enable receive  */
#define	PTC_XONXOFF		0x10	
					/* rw: 1 = enable ^s^q log */
#define	PTC_DSR			0x20	
					/* r:  1 = data set ready  */
#define	PTC_DCD			0x40	
					/* r:  1 = dcd active	   */

#define	CDSELECT   struct	SelectConDrvStruct
CDSELECT
{
	BYTE	unitno;		/* unit number 			*/
	BYTE	cdse_two;	/* unused			*/
	WORD	cdse_three;	/* unused			*/
	LONG	kbd_pin;	/* address of KEYBOARD ASR	*/
	LONG	m_pin;		/* address of MOUSE ASR		*/
	LONG	mbut_pin;	/* address of BUTTON ASR	*/
	LONG	PConId;		/* Physical Console Id		*/
};

