/*======================================================================*
 *   Version 2.8	Console Driver					*
 *			AT Keyboard Scan code to character translate	*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *    .00  09/13/84       BVH   first written				*
 *    .50   2/02/85	  DR-K  spec changes,ireset,sys req.,alts,wind	*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   3/21/85 15:47 DR-K  Sys REQ, SAlt fixes/changes		*
 *   1.02   4/17/85  8:26 DR-K	return state codes correctly		*
 *   1.03   4/24/85 16:00 DR-K	control Ins(0) returns HELP (2000)	*
 *   1.04   5/03/83 13:08 DR-K	return XSHIFT state code also		*
 *   1.05   6/12/85 14:38 DR-K	change DEL from 0x8A(2s0A) back to 0x7F	*
 *   1.06   6/25/85 11:39 DR-K	Sys REQ now returns (0x200b)		*
 *   1.07   6/26/85  1:45 DR-K	change key_itran to c_keyinit() add new *
 *				 keyboard detect and setvec		*
 *   1.08   7/23/85 16:03 DR-K	fix SNUM test to above xB0 not xA0	*
 *   1.09   8/14/85 15:34 DR-K	set/send LED_state on toggles		* 
 *   1.10   8/15/85  9:53 DR-K  setup state-machine answering keyboard	*
 *				 command ACK				*
 *   2.0    10/9/85 26:10 DR-K	if scroll lock key pressed when control *
 *				 key is down then return(KBREAK)	*
 *   2.1    12/4/85	  DR-K	control ],[,\ were wrong values		*
 *   2.2    12/9/85	  DR-K	change int vector up to x69 from 9	*
 *   2.3     1/8/86	  DR-K	normal ACSII characters return no state	*
 *				 bits except the ALT state		*
 *   2.4     1/8/86	  DR-K	extend key_table to x58	for F11 and F12	*
 *   2.5    1/10/86	  DR-K	all x2snn codes return no shift state	*
 *   2.6    5/16/86	  DR-K	set local flag (key_ledcom) that we have*
 *				sent a LED command, for ack handler	*
 *   2.7   06/11/86	  mei	High C port.				* 
 *   2.8    8/13/86	  DR-K	include decimal point 0xC3 in num lock  *
 *				test.					*
 *   2.9    9/04/86	  DR-K	cleanup for non-executed code sections	*
 *======================================================================*/

/*****************************************************************
*	This file contains three items:
*
*	1) KEYS, an array of character codes indexed by scan code,
*	2) c_keyinit() a function to initialize scan code trans-
*	   lation, and
*	3) KEY_TRAN, a routine that produces 16 bit characters
*	   from scan codes.
******************************************************************/

/*
 *  09/30/86 PKB
 *  references to CDOS, Concurrent or Concurrent DOS changed to FlexOS
 */

#include "portab.h"

#if METAWARE 
#define ICDRVKB
#include "protos.h"
#endif

#define BASE	0x60	/* keyboard port */

EXTERN	VOID	ireset(), setvec();
EXTERN	WORD	ckb_intrp();
EXTERN	VOID	OUTP();

WORD key_state = 0;
WORD key_shift = 0;
BYTE led_state = 0;
WORD key_ledcom = 0;

#define	KERR	0x0000		/* Error return on illegal or
				   non-ASCII key code.		*/
#define	K_ACK	0x00FA		/* return code from a command	*/

#define	SLSHIFT	0x0001		/* Shift code for LEFT SHIFT	*/
#define	SRSHIFT	0x0002		/* Shift code for RIGHT SHIFT	*/
#define	SCAPS	0x0004		/* Shift code for CAPS LOCK	*/
#define	SNUM	0x0008		/* Shift code for NUM LOCK	*/
#define	SCTRL	0x0020		/* Shift code for CTRL key	*/
#define	SALT	0x0040		/* Shift code for ALT key	*/
#define	SSCROLL	0x0080		/* Shift code for SCROLL key	*/

#define	XCTRL	0x0100		/* State code for CTRL key	*/
#define	XALT	0x0200		/* State code for ALT key	*/
#define	XSHIFT	0x0400		/* State code for SHIFT key	*/

#define	TOG	0xFE		/* Translated code for TOGGLEs	*/
#define	SPE	0xFD		/* Translated code for SHIFTs	*/
#define	ILL	0xFC		/* Translated code for ILLEGALs	*/
#define	FUN	0xFB		/* Translater code for FUNKEYS	*/

#define HELP	0x2000
#define WIND	0x2001		/* */
#define PREV	0x2003		/* */
#define NEXT	0x2002		/* */
#define	KBREAK	0x2005
 
#define	KEYTAB	struct t_keytab

KEYTAB
{
    BYTE kunshift, kshift;
};

KEYTAB keys[0x59] = {

/* 0x */

    ILL, ILL,
    0x1B,0x1B,	/* ESCAPE */
    '1', '!',	/* 1 - ! */
    '2', '@',	/* 2 - @ */
    '3', '#',	/* 3 - # */
    '4', '$',	/* 4 - $ */
    '5', '%',	/* 5 - % */
    '6', '^',	/* 6 - ^ */
    '7', '&',	/* 7 - & */
    '8', '*',	/* 8 - * */
    '9', '(',	/* 9 - ( */
    '0', ')',	/* 0 - ) */
    '-', '_',	/* - - _ */
    '=', '+',	/* = - + */
    0x08,0x7F,	/* BACKSPACE */
    0x09,0x99,	/* TAB - BACKTAB */

/* 1x */

    'q', 'Q',	/* Q */
    'w', 'W',	/* W */
    'e', 'E',	/* E */
    'r', 'R',	/* R */
    't', 'T',	/* T */
    'y', 'Y',	/* Y */
    'u', 'U',	/* U */
    'i', 'I',	/* I */
    'o', 'O',	/* O */
    'p', 'P',	/* P */
    '[', '{',	/* [ - { */
    ']', '}',	/* ] - } */
    0x0D,0x0D,	/* ENTER */
    SPE, SCTRL,	/* CONTROL */
    'a', 'A',	/* A */
    's', 'S',	/* S */

/* 2x */

    'd', 'D',	/* D */
    'f', 'F',	/* F */
    'g', 'G',	/* G */
    'h', 'H',	/* H */
    'j', 'J',	/* J */
    'k', 'K',	/* K */
    'l', 'L',	/* L */
    ';', ':',	/* ; - : */
    '\'','\"',	/* ' - " */
    '`','~',	/* ` - ~ */
    SPE,SLSHIFT,/* LEFT SHIFT */
    '\\','|',	/* \ - | */
    'z', 'Z',	/* Z */
    'x', 'X',	/* X */
    'c', 'C',	/* C */
    'v', 'V',	/* V */

/* 3x */

    'b', 'B',	/* B */
    'n', 'N',	/* N */
    'm', 'M',	/* M */
    ',', '<',	/* , - < */
    '.', '>',	/* . - > */
    '/', '?',	/* / - ? */
    SPE,SRSHIFT,/* RIGHT SHIFT */
    0xC6,0x84,	/* KEYPAD *, PRINT SCREEN */
    SPE,SALT,	/* ALT */
    ' ',' ',	/* SPACE */
    TOG,SCAPS,	/* CAPS LOCK */
    FUN, 1,	/* F1 */
    FUN, 2,	/* F2 */
    FUN, 3,	/* F3 */
    FUN, 4,	/* F4 */
    FUN, 5,	/* F5 */

/* 4x */

    FUN, 6,	/* F6 */
    FUN, 7,	/* F7 */
    FUN, 8,	/* F8 */
    FUN, 9,	/* F9 */
    FUN, 10,	/* F10 */
    TOG,SNUM,	/* NUM LOCK */
    TOG,SSCROLL,/* SCROLL LOCK */
    0x98,0xB7,	/* HOME, KEYPAD 7 */
    0x90,0xB8,	/* UP ARROW, KEYPAD 8 */
    0x94,0xB9,	/* PAGE UP, KEYPAD 9 */
    0xC2,0xC2,	/* KEYPAD - */
    0x92,0xB4,	/* LEFT ARROW, KEYPAD 4 */
    0xB5,0xB5,	/* KEYPAD 5 */
    0x93,0xB6,	/* RIGHT ARROW, KEYPAD 6 */
    0xC4,0xC4,	/* KEYPAD PLUS */
    0x88,0xB1,	/* END, KEYPAD 1 */

/* 5x */

    0x91,0xB2,	/* DOWN ARROW, KEYPAD 2 */
    0x95,0xB3,	/* PAGE DOWN, KEYPAD 3 */
    0x89,0xB0,	/* INSERT, KEYPAD 0 */
    0x7F,0xC3,	/* DELETE, KEYPAD PERIOD */
    0x8B,0x8B,	/* SYS REQ */
    0x07,0x07,	/* 55 no key so ring a bell */
    0x07,0x07,	/* 56 no key so ring a bell */
    FUN, 11,	/* F11 */
    FUN, 12	/* F12 */
};

/*************************************************************************
*	C_KEYINIT
*
*	Initialize scan code translation.
**************************************************************************/

VOID c_keyinit()
{
	key_state = key_shift = 0;
	setvec(ckb_intrp,0x69 );		/* setup our interrupt vector #9 */
}

/************************************************************************
*	KEY_TRAN
*
*	Given a scan code, with the parity bit set if just released,
*	return the 16 bit FlexOS equivalent.
*************************************************************************/

key_tran(sc)
WORD sc;
{
    WORD release, shiftval, unshiftval, temp;

    if ((sc == K_ACK ) && ( key_ledcom > 0 ) )	/* keyboard is replying to a command */
	{
	   OUTP( BASE, led_state );	/* set the LED display */ 
	   key_ledcom = 0; 
	   return(0);	/* nothing else to do here */
	}
    release = sc & 0x80;	/* Key released if parity bit set.	*/
    sc &= 0x7F;			/* Get the scan code, apart from parity	*/

    if(sc > 0x58) return(0);	/* There are limits...			*/

    shiftval = keys[sc].kshift & 0xFF; /* Shifted value of this key.	*/
    unshiftval = keys[sc].kunshift & 0xFF; /* Unshifted value of key.	*/

    switch(unshiftval){
    case TOG:			/* If this is a toggle key...		*/
	if(release) return(0);	/* If releasing it, no effect.		*/
				/* if this TOG is Scroll Lock and the	*/
				/* control key is down then return BREAK*/
	if( (key_state & SCTRL) && (shiftval == SSCROLL) )
		return(KBREAK);
	key_state ^= shiftval;	/* Toggle the effect.			*/

	switch(shiftval){	/* Now, figure out the Toggle Code	*/
	case SCAPS:
	    temp = 0; led_state ^= 4; break;
	case SNUM:
	    temp = 3; led_state ^= 2; break;
	case SSCROLL:
	    temp = 2; led_state ^= 1; break;
	default: return(0);
	}
	key_ledcom = 1;				/* set our local flag that we */
	OUTP( BASE, 0xED );			/* sent a set LED command */
	return(0x3000 | ((key_state & shiftval) ? 0x100 : 0) | temp);

    case SPE:			/* If this is a special key...		*/
				/* Toggle the state.			*/
	if(release) key_state &= ~shiftval;
	else key_state |= shiftval;

	key_shift = 0;		/* Update the SHIFT status		*/
	if(key_state & SCTRL) key_shift |= XCTRL;
	if(key_state & (SLSHIFT | SRSHIFT)) key_shift |= XSHIFT;
	if(key_state & SALT) key_shift |= XALT;

	switch(shiftval){	/* Again, figure out the Toggle Code	*/
	case SRSHIFT:
	    temp = 0x10; break;
	case SLSHIFT:
	    temp = 0x11; break;
	case SCTRL:
	    temp = 0x13; break;
	case SALT:
	    temp = 0x14; break;
	default: return(0);
	}
	return(0x3000 | ((release) ? 0 : 0x100) | temp);

    case FUN:			/* Are we talking function keys?	*/
	return((!release) ?	/* Only if just pressing it.		*/
	    0x1000 | key_shift | shiftval :
	    0);			/* Otherwise, null character.		*/

    case ILL:			/* Not a proper key at all!		*/
	return(0);		/* An error on thee, knave!		*/

    default:			/* Must be a normal character.		*/
	if(release) return(0);	/* Ignore if just releasing it.		*/

/************************************************************************
   If this key is a DEL and CONTROL and ALT are also pressed, then the 
   user is requesting the system be re-booted.
*************************************************************************/

    if( (unshiftval == 0x7F) && (key_state & SCTRL) && (key_state & SALT) )
		ireset();

/************************************************************************
   If the ALT key is pressed, then this character might be our special
    WINDow key, so pass it back to Resource Manager to handle.
*************************************************************************/

	if( (key_shift & XALT) && (unshiftval == 0xC4) )
		return( WIND );

/************************************************************************
   If the CONTROL key is pressed, then check if this is the special
    PREVious or NEXT window keys (defined at top).
************************************************************************/
	if(key_state & SCTRL)
	    switch (unshiftval)
		{
		case 0xC2 : return( PREV );
		case 0xC4 : return( NEXT );
		case 0x89 : return( HELP ); 
		case '['  : return( '['-'@');
		case 0x5c : return( 0x1c );
		case ']'  : return( ']'-'@');
		default: if(shiftval >= '@' && shiftval <= '_')
				return(shiftval-'@');
		}

/************************************************************************
   Letters are special cases. They can be lower case, upper case, or
   control characters. This block takes care of two special cases.

   1) The control key is pressed. Return the correct ASCII control code,
      regardless of the state of the SHIFT or CAPS LOCK keys.

   2) If the CAPS LOCK key is on, SHIFTS have the opposite effect.

   Otherwise, letters are treated like any other character.
*************************************************************************/

	if(shiftval >= 'A' && shiftval <= 'Z'){
	    if(key_state & SCAPS){
		temp = shiftval;
		shiftval = unshiftval;
		unshiftval = temp;
		}
	    }

/************************************************************************
If the NUMS LOCK key is on, then the same sort of operation (as the CAPS
LOCK key) is performed on the digit keys on the numeric keypad. The test
in the first line tests to see if the key hit has a KEYPAD NUMERIC shift,
which is easier than testing the unshifted modes. Again, this only works
on the digit keys, and the decimal point key.
*************************************************************************/

	else if( (key_state & SNUM) && 
		((shiftval >= 0xB0 && shiftval <= 0xB9) || shiftval == 0xC3) )
	    {
	    temp = shiftval;
	    shiftval = unshiftval;
	    unshiftval = temp;
	    }

/************************************************************************
Just plain 'ol characters, here. Return their shifted or unshifted value,
depending on the state of the SHIFT. By this time in the processing, the
value of the CAPS LOCK key is nil. Ignore all this (SHIFTing) if the
CONTROL key is depressed.
*************************************************************************/

	temp = ((key_shift & XCTRL) ? unshiftval :
	    (key_shift & XSHIFT) ? shiftval : unshiftval);

/************************************************************************
If the high bit of the character is set, then it REALLY is a FlexOS
DOS `Special' character.  On a normal character never pass the XSHIFT
state code back.
*************************************************************************/

	return( (temp & 0x80) ?
			(0x2000 | ( (key_shift & ~XSHIFT) | (temp & 0x7F) ) ) :
			(temp | (key_shift & XALT)) );
    }
}
