#define OLDMOUSE 0	/* if = 1 do it in the old way with buildin mouse,
			   if = 0 do it in the new way with mouse driver */
/*======================================================================*
 *   Version 4.3	Console Driver					*
 *			Main Code Section				*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *   1.00   3/19/85  8:12 DR-K  Added this intro to files		*
 *   1.01   4/18/85 10:26 DR-K	INIT flag defines			*
 *   1.02   4/24/85  8:30 DR-K	c_special move offset into delim	*
 *   1.03   5/06/85 ??:?? DR-K	moved the BASE define to icdrv.h	*
 *   1.04   5/16/85 15:34 DR-K	correct sd to cdrv unitno in enQ not deQ*
 *   1.05   5/30/85 16:40 DR-K	set v_mode in special(create) if WRAP	*  
 *   1.06   6/12/85 10:41 DR-K	redo c_get/c_set/getset for full fields *
 *				 include io.h not pd.h, MAXcdUNIT = 3	*
 *				 use DPBLK rather than DPB		*
 *   1.07   6/24/85 14:23 DR-K	put c1to2copy into cptbl[6+7], and	*
 *				 c2to1copy into cptbl[5]		*
 *   1.08   6/26/85 11:44 DR-K	put the flagget,flagrel,c_wflag[] back	*
 *				 add MXPD,mxinit(),mxuninit()		*
 *   1.09   6/27/85 10:16 DR-K	add c_keyinit() to c_init, correct cptbl*
 *   1.10   7/24/85 22:22 DR-K	asrwait() availabl;e so remove c_wflag[]*
 *				 and single escape stuff		*
 *   1.11   7/30/85  9:33 DR-K	c_enQ is passed in LONGs now		*
 *   1.12   8/20/85 15:49 DR-K	define/set global Curs_Top,Curs_Bott	* 
 *   2.0    10/2/85 12:44 DR-K	special#3 does not reset PCFRAME bit	*
 *   2.1   10/16/85 14:40 DR-K	set graphic and bitmap flags of contab	*
 *   2.2   10/23/85 10:37 DR-K	do separate salloc for vcid, not tack it*
 *				 on end of char/attribute planes. And	*
 *				 check for salloc() return errors	*
 *   2.3   11/04/85 09:37 RFW   added to c_special function 4 for	*
 *				 changing the virtual console size as	*
 *				 required and reprogramming the crt	*
 *				 controller to the proper mode when on	*
 *				 the top. changed c_init to mapphys 32k	*
 *   2.4   11/19/85	DR-K	c_special(2) changes any size to 25x80	*
 *   2.5   11/20/85	DR-K	recast for portability. 		*
 *   2.6   11/22/85	gat	In special#2, just return frame address.*
 *   2.7    12/5/85	DR-K	special#1 needs to sfree(VCBLK)		*
 *   2.8     1/7/86	DR-K	fix salloc error detect in special#2	*
 *   2.9    2/27/86	DR-K	add hardware scroll support to special2	*
 *   2.A    3/20/86	DR-K	fix special3 to clear modebit PCframe so*
 *				DOS fe can use/clear Phys Frame		*
 *   2.B    3/28/86	DR-K	fix escape key handler when repeat key is*
 *				held down				*
 *   2.C    3/30/86     RFW     Added mouse support "rattail" etc. 	*
 *   2.D    4/22/86	DR-K	condition subdriver needed for a mouse	*
 *				request from init with contab's sets	*
 *				remove the panic calls			* 
 *   2.E   06/11/86	mei	High C port.				*
 *   2.F   06/30/86     RFW     Add hardware scroll support special4 for*
 *				the physical VCBLK to top of buffer.	*
 *   3.0   07/08/86     BVH	Added EGA card support. 		*
 *   3.1   07/30/86     mei     c_special case 4:   &= ~IMGRAPHIC       *
 *   3.2    8/01/86	DR-K	free plane memory if salloc(vcid) error *
 *				in special(0)				*
 *   3.3   08/04/86	cpg	Removed MOUSE Req. flag from con tab    *
 *   3.4   08/07/86	BVH	Allocate more memory for EGA Mode 14	*
 *   3.5   08/12/86	BVH	Don't zero out screen memory on graphic	*
 *   3.6   08/12/86	DR-K	fix flush's bad [unitno] for sub-driver	*
 *   3.7   08/14/86     mei	some VOIDs for Metaware. Common protos OK*
 *   3.8   09/09/86     RFW	Fixed bug in m_deQ() for Metaware, also *
 *				changed getset() to work properly.      *
 *   3.9   09/18/86	RFW	Changed CTE contab[MAXcdUNIT] array to  *
 *				use predefined values to set the CONSOLE*
 *				DEVICES default configuration. You modify*
 *				them in the file ICDRV.H now.		*
 *   4.0   10/24/86	RFW	Reversed the Parmameters for the mouse  *
 *				ASR's to match whats in the documentation*
 *   4.1   10/27/86	KJ	Added the Hercules Card			*
 *   4.2   11/26/86	BVH	Fix port defs for EGA; fix charrom prob.*
 *   4.3   03/02/87	KJ	added loadable MOUSE DRIVER and call the*
 *				subdriver via the dvrif() call for DSEG *
 *======================================================================*/
/*      INCLUDES                                                        */

pragma off (list);	/* turn off listing */

#include "portab.h"
#include "system.h"
#include "io.h"  
#include "icdrv.h"
#include "ega.h"

#if PROTOS 
#define ICDRV
#include "protos.h"
#endif

pragma pop (list);	/* turn list flag to previos state */

#define  INP    inp
#define  OUTP   outp
#define  DATAPORT       0x60    /* keyboard data port */
#define	 STATPORT	0x64	/* keyboard stat port */
#define  CMDPORT        0x64    /* keyboard command port */
#define  RIntrp_REG     0x61    /* keyboard Reciever interupt port */
#define  USRPORT        0x63    /* keyboard user select port */
#define	 MONOPORT	0x3B4	/* monochrome display board port */
#define	 COLORPORT	0x3D4	/* color/graphics controller port */
#define  GRAPHSZ	0x4000  /* size of a Graphic screen */
#define  SCRNSZ		0x8000L /* size of the physical screen mapphysed */   
 
EXTERN  OUTP();         /* for asm language port routines */
EXTERN  INP();
EXTERN	WORD	getcmos();
EXTERN	VOID	ch2fill();
EXTERN	VOID	ch1fill();
EXTERN	VOID	_bfill();
EXTERN	VOID	_bmovt(), PCHScrol(), _bzero();
EXTERN	LONG	panic(), mxuninit(), asrwait();
EXTERN  LONG	dvrif();	/* call subdriver, set DATA SEGMENT */

/************************************************************************/
/* forward referenced functions                                         */
/************************************************************************/
GLOBAL  LONG
        c_init(),
        c_subdrvr(),
        c_uninit(),
        c_select(),
        c_flush(),
        c_copy(),
        c_write(),
        c_get(),
        c_set(),
        c_special();

GLOBAL  VOID	video_init();		/* initialize video controller to */
					/* the desired modes */ 
GLOBAL	VOID	c_deQ(), 
		c_enQ(), 
		rattail();
GLOBAL  UWORD   conv8(), conv16();
	VOID	getset();
	VOID	load_port();
	VOID	get_chrom();

EXTERN	LONG	mapphys();
EXTERN	LONG	e_timer();
EXTERN	WORD	key_tran();
EXTERN	VOID	c_keyinit();

/* these functions are used in c_copy() */
VOID	b1to1copy();
VOID	b1to2copy();
VOID	b2to1copy();
VOID	b2to2copy();
VOID	b2alter();
VOID	c2to2copy();
VOID	c1to2copy();
VOID	c2to1copy();
VOID	c1to1copy();
VOID	c2alter();
VOID	b1alter();
VOID	ch2fill();
VOID	ch1fill();

/************************************************************************/
/* local initializations                                                */
/************************************************************************/

#define MAXcdUNIT 3
#define FLAGVAL  0

/************************************************************************/
/*      Driver header                                                   */
/*  This header must be the first structure in the data segment         */
/*   so, don't put any data generating code before this section         */
/************************************************************************/

DH  c_dh =
{       DVR_CON,MAXcdUNIT,FLAGVAL,
        c_init,
        c_subdrvr,
        c_uninit,
        c_select,
        c_flush,
        c_copy,
        c_write,
        c_get,
        c_set,
        c_special,
        0L,0L,0L,0L,0L
};

typedef VOID	(*PINPTR)();

PINPTR	ckb_pin[MAXcdUNIT];

GLOBAL	LONG	pcon[MAXcdUNIT]	;/* stores Physical Console ID for R-M	*/
GLOBAL	VCBLK	*pcb[MAXcdUNIT] ;/* Physical Virtual console data blocks */

GLOBAL  LONG    screenAD = 0;    /* stores address of screen memory */
GLOBAL	WORD	CRTbase ;	/* base port address of CRT controller chip */
GLOBAL	WORD	Curs_Top;	/* top scan line for cursor to display	*/
GLOBAL	WORD	Curs_Bott;	/* bottom scan line of cursor display	*/

WORD    ckb_intrp();             /* froward ref the interupt routine */
BYTE    escflg[MAXcdUNIT]  = {0,0,0};	/* if conv8 got an esc char */
BYTE    ranupd[MAXcdUNIT]  = {0,0,0};	/* if update is running */
LONG	c_rmflg[MAXcdUNIT] = {0,0,0};	/* a write flag per unit*/
LONG	c_mxid[MAXcdUNIT]  = {0,0,0};	/* an mx region per unit*/
BYTE	cd_units[MAXcdUNIT];	/*conman's unitno indexed by sub-driver's */
BYTE    sd_units[MAXcdUNIT];    /*sub-driver's unitno indexed by drvr_unitno */
DH      *sd_hdr[MAXcdUNIT];     /* stores drvr headers of sub-drivers   */
WORD	c_hardware;		/* Type of graphics adapter we have	   */
				/* 0=EGA				   */
				/* 1=CGA Color graphics adapter 40 columns */
				/* 2=CGA color graphics adapter 80 columns */
				/* 3=MGA monochrome or Hercules Display    */
LONG	baseaddr[2];
WORD	*chsets;		/* Pointer to Rom character sets for EGA */

   /******very temp for diag*****/
UBYTE	k1,k2,k3 ;		/* type of keyboard found */


/************************************************************************/
/*      console parameters                                              */
/*      here are the parameters that the calls to c_get will return     */
/*      they are up front hereand in order for speed of byte copying.   */
/************************************************************************/

/*** NOTE: Initialize all our default parameters in ICDRV.h ***/

CTE     contab[MAXcdUNIT] = 
{
/*    row,   cols,    flgs,   pl,     att,    ext,    CC,    nfks,    buts,
	  serial,    mr,    mc,pcf,conv8,conv16, */
/*    --- This Values are set in the File 'ICDRV.H' -----   */

{ CT0_ROW,CT0_COL,CT0_FLGS,CT0_PL,CT0_ATT,CT0_EXT,CT0_CC,CT0_NFKS,CT0_BUTS,
	CT0_SNUM,CT0_MR,CT0_MC,  0,   0L,    0L},

{ CT1_ROW,CT1_COL,CT1_FLGS,CT1_PL,CT1_ATT,CT1_EXT,CT1_CC,CT1_NFKS,CT1_BUTS,
	CT1_SNUM,CT1_MR,CT1_MC,  0,   0L,    0L},

{ CT2_ROW,CT2_COL,CT2_FLGS,CT2_PL,CT2_ATT,CT2_EXT,CT2_CC,CT2_NFKS,CT2_BUTS,
	CT2_SNUM,CT2_MR,CT2_MC,  0,   0L,    0L},

} ;

/*
 *	Define the copy information table used to supply the
 *	correct byte copy routine and interleave factor (1 or 2)
 *	used to calculate starting copy positions and row increments.
 */

CPBLK	cptbl[] =
{
	{ b2to2copy, ch2fill, b2alter, 2, 2 },	/* VFRAME to VFRAME */
	{ b2to1copy, ch1fill, b1alter, 2, 1 },	/* VFRAME to UFRAME */
	{ b1to2copy, ch2fill, b2alter, 1, 2 },	/* UFRAME to VFRAME */
	{ b1to1copy, ch1fill, b1alter, 1, 1 },	/* UFRAME to UFRAME */
	{ c2to2copy, ch2fill, c2alter, 2, 2 },	/* VFRAME to rowbuffer */
	{ c2to1copy, ch1fill, b1alter, 2, 1 },	/* rowbuffer to UFRAME */
	{ c1to2copy, ch2fill, c2alter, 1, 2 },	/* UFRAME to rowbuffer */
	{ c1to1copy, ch1fill, b1alter, 1, 1 },	/* UFRAME to UFRAME */
};


/* We must let WILARD the RAT run around now.*/ 
#define MAXINB 128

#if OLDMOUSE
#define PACKRATQ struct PackRatINQ

PACKRATQ
{
	WORD 	Qtail;
	WORD	Qnose;
	WORD 	Qstarted;	/* if its = 1 the ASR is scheduled */
	WORD	deltax;		/* Delta X from Mouse */
	WORD	deltay;		/* Delta Y form Mouse */
	WORD 	mstate;		/* State we're in during receipt of a packet */
	WORD 	Q[MAXINB];      /* Delta x&y's saved here 	   */
	LONG 	ratbut;		/* Previous Mouse button state */
	PINPTR  m_pin;
	PINPTR  mbut_pin;
};
GLOBAL PACKRATQ *mdev[MAXcdUNIT];

BYTE    xbut_tbl[] = { 0,4,2,6,1,5,3,7};

#endif	/********   end if oldmouse **************/

/************************************************************************/
/*      c_init                                                          */
/************************************************************************/

LONG    c_init(unitno)

        WORD	unitno;
{
	BYTE	dtype;		/* temp type of display (mono or graphic) */
	CDMAPPB *mempb,mpb ;	/* for making absolute memory address ours */

	mempb = &mpb ;
        if (unitno > MAXcdUNIT) return( E_IllUnitno );
        /***if (vcid[unitno]->?????)    *****/
        /***     return(E_EXISTS);      ****/

	if (unitno == BITMAP)	/* the first unit through here gets to be */
	{			/* the memory-mapped video		  */

	   if(  (dtype = getcmos(0x14))  < 0  )	  /* read the CMOS RAM */
		panic(ED_CON | E_CRC) ;

	   switch( c_hardware = (dtype >> 4) & 3 )
		{		/* set the console table approprieately */
		case 0:		/* EGA Card */
			contab [unitno].CT_rows = 25;
				/* say that we can do graphic stuff */
			contab[unitno].CT_flags |= COLOR + GRAPHIC;
			mempb->physaddr = 0xA0000L;
			mempb->length   = 0x10000L;
			baseaddr[0] = mapphys(mempb,1);

			mempb->physaddr = 0xC0000L;
			mempb->length   = 0x04000L;
			chsets = (WORD *)mapphys(mempb,1);

			mempb->physaddr = 0xb8000L;
			CRTbase = COLORPORT;
			Curs_Top = 6;
			Curs_Bott = 7;
			break;
		case 1:		/* Color Card with 40 columns */
			contab[unitno].CT_cols = 40;	/* fall thru */
		case 2:		/* Color Card with 80 Columns */
			contab[unitno].CT_rows = 25;
				/* say that we can do graphic stuff */
			contab[unitno].CT_flags |= COLOR + GRAPHIC;
			mempb->physaddr = 0x0B8000L ;
			CRTbase = COLORPORT ;
			Curs_Top  = 6;
			Curs_Bott = 7;
			break;
		case 3: 	/* Monochrome Display or Hercules card */
			contab[unitno].CT_rows = 25;
				/* say that we can do graphic stuff */
			contab[unitno].CT_flags |= GRAPHIC;
			mempb->physaddr = 0x0B0000L ;
			CRTbase = MONOPORT ;
			Curs_Top  = 0x0B;
			Curs_Bott = 0x0C;
		}
	   contab[unitno].CT_flags |= PCT_BITMAP;
	   mempb->length = SCRNSZ;			/*RFW*/
	   baseaddr[1] = screenAD =  mapphys(mempb,1);

	   c_keyinit();	/* initialize the keyboard */
#if OLDMOUSE
	   if (contab[unitno].CT_flags & MOUSE)	   /* needs a port for mouse */
		return( ((LONG) DVR_PORT << 16) + DVR_CON);
	    else
           	return( (LONG) DVR_CON );

#else
	   if (contab[unitno].CT_flags & MOUSE)	   /* needs a mousedriver */
		return( ((LONG) DVR_MOUSE << 16) + DVR_CON);
	    else
           	return( (LONG) DVR_CON );

#endif	/*******     end if OLDMOUSE    *****************/

	}
	else	/* this is another unit */
	{
                /* we need a PORT subdriver */
        return( ((LONG) DVR_PORT << 16) + DVR_CON );
	}
}

/************************************************************************/
/*      c_subdrvr                                                       */
/************************************************************************/

LONG    c_subdrvr(pb)

        DPBLK     *pb;

{	/** January 1987 KJ added testing for valid subdriver  **/
	DH	*sub_head;
	BYTE	unit;

	if ((unit = (BYTE) pb->dp_unitno) > MAXcdUNIT)
		return (E_IllUnitno);

	sub_head = (DH *) pb->dp_swi;	/* get address of the subdriver */

					/* test if there no other subdriver */
/***	if (sd_hdr[unit] != 0L )	not working with unload and new load
***		return (E_EXISTS);	20/febr/1986  KJ   ***/
					/* check if the subdriver is a mouse
					   or port driver, else return error */
	if ((sub_head->dh_dtype == DVR_MOUSE) || (sub_head->dh_dtype == DVR_PORT))
	{
	    if (sub_head->dh_dtype == DVR_MOUSE)	/* set mouse flag */
		contab[unit].CT_flags |= MOUSE;

		/* save the sub-driver's header and  parameters */
	    cd_units[pb->dp_option] = pb->dp_unitno ;	/* drvr unitno */
	    sd_hdr[unit]   = (DH *) pb->dp_swi ;	/* header address */
	    sd_units[unit] = pb->dp_option ;		/* sub-drvr unitno */
	    return(E_SUCCESS);
	}
	else return (E_MISMATCH);
}

/************************************************************************/
/*      c_uninit                                                        */
/************************************************************************/

LONG    c_uninit(unitno)
        BYTE    unitno;
{
        DPBLK     upb,*pb;

	if ( unitno == BITMAP ) return(E_SUCCESS);

    /* else call the sub-drives flush(this unitno) */
	pb = &upb;
        pb->dp_unitno = sd_units[unitno];



/**	WARNING:	chanced Febr/23/1987  KJ
**		that call above works only for linked in drivers, because
**		they have the same DATA SEGMENT, panics with loadable drivers
**        return( (*sd_hdr[unitno]->dh_flush)(pb) );
************/
	/* so I try it in this way, to get the datasegment via dvrif()  */
	return (dvrif (sd_hdr[unitno], (*sd_hdr[unitno]->dh_flush), pb));
}

/************************************************************************/
/*      c_select                                                        */
/************************************************************************/

LONG    c_select(pb)

        CDSELECT	*pb ;
{
	CDSPECIAL	*spb,sb ;
        BYTE    unitno;

        unitno = pb->unitno ;
	spb = &sb ;

    if (pcon[unitno] == 0L)	/* test if the first time for this unit,
				   else it is a select call for the 
				   mouse subdriver from cm_install case = 2,
				   then skip over this hardware init code */
    {
	/** do the physical allocation and initialisation only one time */
	pcon[unitno] = pb->PConId ;
        ckb_pin[unitno] = (PINPTR) pb->kbd_pin ;

	if (unitno == BITMAP)
	    {
		spb->cds_flags = PL0GIVEN ;
		spb->cds_pl0 = (BYTE *) screenAD ;
	    }
	else
	    {
		spb->cds_pl0 = 0L;
		spb->cds_flags = PHYSCON ;
	    }
	/* call the special 'create VC' function to allocate memory */
	spb->cds_unit = unitno ;
	spb->cds_option = 0 ;	/* create */
	spb->cds_rows = contab[unitno].CT_rows ;
	spb->cds_cols = contab[unitno].CT_cols ;
	pcb[unitno] = (VCBLK *) c_special( spb );
    }	/*  end of physical initialisation and allocation */

	if ( unitno == BITMAP )
	{
		/* enable Interrupt 2 in PIC 1 for keyboard int */
	    OUTP( 0x21 , INP(0x21) & 0x0fd );

		/* test if a mouse subdriver is available at this point */

	    if(!(contab[unitno].CT_flags & MOUSE))
		return( E_SUCCESS);

		pb->kbd_pin = NULLPTR;		/* zero out the keyboard pin */
		/*  send the address of dorat and rattail to the mousedriver */
		/* 	pb->m_pin     is a ptr to  dorat()	*/
		/* 	pb->mbut_pin  is a ptr to  ratbut()	*/
		/* 	pb->PConId    is a ptr to DLE struc of console	*/
	}
	else		/* if not a local bitmap screen */
	{
		/* Get a flag for c_write to return evnum to resource manager*/
		c_rmflg[unitno] = flagget();
		/* Init an MXPD for c_write and update to lock eash other */
		c_mxid[unitno] = mxinit();
	        pb->kbd_pin = (LONG) c_enQ ;
		pb->PConId = (LONG) pcb[unitno];
	}
        pb->unitno = sd_units[unitno] ;

		/* check if valid subdriver then call subdriver's select */

	if (sd_hdr[unitno] == 0L)	/* is there a valid DH pointer */
	    return (E_CONFLICT);
	if (sd_hdr[unitno]->dh_dtype != DVR_MOUSE)
	    return (E_CONFLICT);

	/* if valid DRIVER HEADER found call subdriver's select  */

/**	WARNING:	chanced Febr/23/1987  KJ
**		that call above works only for linked in drivers, because
**		they have the same DATA SEGMENT, panics with loadable drivers
**	return( (*sd_hdr[unitno]->dh_select) (pb) );
************/
	/* so I try it in this way, to get the datasegment via dvrif()  */
	return (dvrif (sd_hdr[unitno], (*sd_hdr[unitno]->dh_select), pb));
}

/************************************************************************/
/*      c_flush                                                         */
/************************************************************************/

LONG    c_flush(pb)

        DPBLK     *pb;

{
        LONG    r;
	BYTE	unit;
	DPBLK	spb;

	unit = pb->dp_unitno ;
	if ( unit == BITMAP )
	{
	/* Febr/25/1987 KJ  test if it is a MOUSE or VDI subdriver to unlink */
	    if (sd_hdr[unit]->dh_dtype != DVR_MOUSE)
		return(E_SUCCESS);	/* return if no MOUSE subdriver */
					/* clear mouse flag in console table */
	    contab[unit].CT_flags &= (BYTE) (MOUSE ^ 0xFF);
	    pb->dp_unitno = sd_units[unit] ;
	    return ( dvrif(sd_hdr[unit], (*sd_hdr[unit]->dh_flush), pb) );
	}
    /* for serial terminal,  call the sub-drives flush(this unitno) */
	pb->dp_unitno = sd_units[unit] ;

/**	WARNING:	chanced Febr/23/1987  KJ
**		that call above works only for linked in drivers, because
**		they have the same DATA SEGMENT, panics with loadable drivers
**        if ( ( r = (*sd_hdr[unit]->dh_flush)(pb) ) != NULLPTR )
************/

        if ( ( r = dvrif( sd_hdr[unit], (*sd_hdr[unit]->dh_flush), pb)) != NULLPTR )
		return(r);

		/* free our flags */
	if ( (c_rmflg[unit] = flagrel(c_rmflg[unit]) ) != NULLPTR ) 
	    return( c_rmflg[unit] );
		/* UnInit the MXPB region */
	if ( (c_mxid[unit] = mxuninit(c_mxid[unit]) ) != NULLPTR ) 
	    return( c_mxid[unit] );

        /**** call special delete VC to sfree the memory *********/
	spb.dp_unitno	= unit ;
	spb.dp_option	= 1 ;	/* delete this VC */
	spb.dp_swi	= (LONG)pcb[unit] ;
	return( c_special( &spb ) );
}

/************************************************************************/
/*      c_get								*/
/*									*/
/*		Get table information about console driver.		*/
/*									*/
/************************************************************************/

LONG	c_get(pb)
REG DPBLK	*pb;
{
	BYTE	*buff;		/* ptr to user's buffer */

	buff = pb->dp_buffer;

	if ( pb->dp_flags & DPF_UADDR )
	{
		mapu(pb->dp_pdaddr);
		buff = (BYTE *) saddr(buff);
	}

	getset(&contab[pb->dp_unitno],buff,(WORD)pb->dp_bufsiz);

	if ( pb->dp_flags & DPF_UADDR )
		unmapu();

	return(E_SUCCESS);
}

/****************************************************************/
/*      c_set                					*/
/*								*/
/*		Set table information about console driver.	*/
/*								*/
/****************************************************************/

LONG	c_set(pb)
REG DPBLK	*pb;
{
	BYTE	*buff;			/* ptr to user's buffer */

	buff = pb->dp_buffer;

	if ( pb->dp_flags & DPF_UADDR )
	{
		mapu(pb->dp_pdaddr);
		buff = (BYTE *) saddr(buff);
	}

	getset(buff,&contab[pb->dp_unitno],(WORD)pb->dp_bufsiz);

	if ( pb->dp_flags & DPF_UADDR )
		unmapu();

	return(E_SUCCESS);
}


/************************************************************************/
/*      c_special                					*/
/************************************************************************/
	 	
LONG	c_special(pb)
	DPBLK	*pb;
{
	CDSPECIAL	*spb;
	BYTE	unit,pl,*temp,*p0,*p1,*p2,*p3	;/* temp vars */
	VCBLK	*vcid;
	FRAME	*f;
	WORD	nrows,ncols;
	UWORD	psize;		/* KJ   Changed from WORD to UWORD */
	WORD 	flag,vsize,vmode,use,att; /*RFW*/
	BYTE	mode;
	LONG	r		;/* retc and plane memory size */

	unit = pb->dp_unitno ;

    switch (pb->dp_option )
    {
    case 0:	/********** Create a Virtual Console ******/
    {
	spb = (CDSPECIAL *) pb ;
	ncols = spb->cds_cols ;
	nrows = spb->cds_rows ;
	psize = nrows * ncols ;
	pl = contab[unit].CT_planes ;
	if ( spb->cds_flags & PL0GIVEN) temp = spb->cds_pl0 ;
	   else temp = (BYTE *) salloc ( (LONG) (psize * (pl & 1))
				      + (psize * ((pl >>1) &1) )
				      + (psize * ((pl >>2) &1) )
				      + ( (spb->cds_flags & PHYSCON) ? psize : 0) );
	if (temp == 0) return(ED_CON | E_MEMORY);
	p0 = p1 = p2 = p3 = NULLPTR;
	if (pl &1) temp = (p0 = temp) + psize;
			/*can there ever not be a character plane ??? */
	if (pl &2) { temp += psize; p1 = p0 + 1 ; }
	if (pl &4) temp = (p2 = temp) + psize;
	if (spb->cds_flags & PHYSCON)	/*if this is to be a physical console*/
	    {				/* create and zero a dirty plane */
		temp = (p3 = temp) + psize;
		_bfill( p3, psize, 0);
	    }
	if ( (vcid =(VCBLK *) salloc((LONG)sizeof(VCBLK))) ==0)
		{
			 return(ED_CON | E_MEMORY);
		}
	_bfill( vcid, sizeof(VCBLK), 0); 
	f = (FRAME *) vcid ;
	f->fr_pl[0] = p0 ;
	f->fr_pl[1] = p1 ;
	f->fr_pl[2] = p2 ;
	vcid->v_dirty = p3;
	f->fr_nrow = nrows ;
	f->fr_ncol = ncols ;
	f->fr_use = pl ;
	vcid->v_att = 0x07;
	vcid->v_mode |= ( (NOWRAP) ? 0 : WRAPM );
	if ( (spb->cds_flags & PL0GIVEN) && !(contab[unit].CT_flags & COLOR) )
		vcid->v_mode |= PCFRAME ;

/* RFW  Set the default v_imode in the VCBLK */
	if((ncols == 40) && (nrows == 25)) vcid->v_imode = 0;
	/* default otherwise is 80x25 character screen */
	else if (contab[unit].CT_flags & COLOR) 
	     vcid->v_imode = 2;		
	else vcid->v_imode = 7;		/* monochrome screen */	 


	if (pl &1) ch2fill(p0,psize,0x20); /* fill character plane = spaces */
	if (pl &2) ch2fill(p1,psize,0x07); /* fill attribute plane = B+W    */
	if (pl &4) ch1fill(p2,psize,0x00); /* fill extension plane = nothing*/
	return((LONG) vcid );
    }
    case 1:  /******* Delete a Virtual Console *******/
    {
	if ( ( f = (FRAME *) pb->dp_swi ) == NULLPTR )
		f = (FRAME *) pcb[unit] ;
		/* give back the memory */
	r = sfree( (BYTE *) f->fr_pl[0] );
	r = sfree( f );
	return(E_SUCCESS);
    }
    case 2:   				/** Convert our optimized Virtual **/
    {					/** console into a PC look-alike **/
	if ( ( vcid = (VCBLK *) pb->dp_swi ) == NULLPTR )
		vcid = (VCBLK *) pcb[unit] ;
	vcid->v_mode |= PCFRAME ;
	f = (FRAME *) vcid;
	if (contab[unit].CT_flags & IMGRAPHIC) return ((LONG)f->fr_pl[0]);
	if ( vcid->v_ptop != 0 ) 	/* not at physical top of buffer */
	    {
		vcid->v_ptop = 85;	/* make it big so block move happens */
		PCHScrol(vcid);
	    }
	if ( vcid->v_top != 0 )
	   {
		psize = vcid->v_top * f->fr_ncol * 2 ;
		if ((temp = (BYTE *) salloc((LONG)psize) ) == NULLPTR )
			return(ED_CON | E_MEMORY);
		_bmovt( f->fr_pl[0], temp, psize );	/* move top to temp */
		_bmovt( (f->fr_pl[0] + psize), f->fr_pl[0],
			    ((f->fr_nrow * f->fr_ncol * 2) - psize) );	/* move top to temp */
		_bmovt( temp,(f->fr_pl[0] + ((f->fr_nrow * f->fr_ncol * 2) - psize)),
			psize );	/* move temp to bottom */
		vcid->v_top = 0;
		sfree ( (BYTE *) temp );
	   }
			/* we check that we have 25rows and 80cols */
	if ( (f->fr_nrow != 25) || (f->fr_ncol != 80) )
	    {
			/* but not the physical */
		if (!(pb->dp_swi)) return( ED_CON | E_MEMORY );
			/* need to create a 25x80 character/attribute plane */
		if ((temp = (BYTE *) salloc( (LONG) 4000 ) ) == NULLPTR )
					return( ED_CON | E_MEMORY );
			/* copy this data to the new frame */
		psize = f->fr_nrow * f->fr_ncol * 2;
		_bmovt( f->fr_pl[0],temp,psize);
			/* sfree the old and install new pointers */
		sfree( (BYTE *) f->fr_pl[0] );
		f->fr_pl[0] = temp;
		f->fr_pl[1] = temp +1 ;
		/* may cause problems with wmex and small 20x20 windows */
	    }
	return( (LONG) f->fr_pl[0] );
     }
    case 3:	/* Convert to an optimized Virtual **/
     {				    /** Console from a PC look-alike **/
	if ( ( vcid = (VCBLK *) pb->dp_swi ) == NULLPTR )
		vcid = (VCBLK *) pcb[unit] ;
	vcid->v_mode &= ~PCFRAME ;
	return(E_SUCCESS);
     }

/***********************************RFW**************************************/
/***	Change the virtual console and reinit the video if needed. 	  ***/
/***    40x25 chaacter screens only supported if rows and cols equal      ***/
/***	40x25. Graphic screens must have the GRAPHIC flag set and the     ***/
/***    unit must also support graphics. The Video mode is kept in the    ***/
/***    VCBLK structure as v_imode a byte able to support 255 different   ***/
/***    type of video settup. The first eight are currently used to 	  ***/
/***	support the PC-DOS int10 screen modes. 				  ***/
/***									  ***/
/***		Graphics virtual frame and video adapter init             ***/
/****************************************************************************/

/* Initialize the video adapter and allocate the proper size
   virtual console.
*/

case 4:
   {
	flag = pb->dp_flags;
	spb = (CDSPECIAL *)pb;
	nrows = spb->cds_rows;
	ncols = spb->cds_cols;

/* Get the Physical Console VCBLK for the current unit. */

	vcid = (VCBLK *)pcb[unit];

/* If the top of the physical buffer isn't the top of the screen, then
   make the top line number so far out of range that the console driver
   won't have any choice but to make the two values coincide.
*/
	if(vcid->v_ptop != 0){
	    vcid->v_ptop = 85;
	    PCHScrol(vcid);
	    }

	vcid = (VCBLK *) pb->dp_pdaddr;
	f = (FRAME *) vcid;
	r = (LONG)f->fr_pl[0];

/* Find the size of the virtual screen to allocate. Graphics screens are all
   16K, so we can just use a constant for that. Except, of course, for EGA
   Graphics Mode 14, which needs 64K (as do all the extended EGA Graphics
   modes, really). But since PSIZE is a WORD value, and I've tried fixing all
   the references and side effects and given up, I just go straight to the
   "salloc()" and catch it there. So it's okay that we use a constant here.

   NOTE: With the Hercules card the size of bitplane is 32Kbyte.

   Character screens can have up to three planes, so find out how many planes
   we need to allocate (same as the number of bits set in the lower three bits
   of the physical console plane count), and multiply it by the size of one
   plane, and hope to God that it doesn't go over 64K.
*/
	if(flag & GRAPHIC)
	    psize = GRAPHSZ;		/* for the Hercules you need 8000H */
	else{
	    vsize = nrows * ncols;
	    pl = contab[unit].CT_planes;
	    psize = vsize * ((pl & 1) + ((pl & 2) != 0) + ((pl & 4) != 0));
	    }

/* Find out what mode we have to go into to satisfy the request for a color
   or monochrome screen, graphics or text, and big enough to hold the
   requested number of rows and columns. Note that if you WANT a 40x25 screen,
   you've gotta ask for exactly that, or it'll just give you half the standard
   80x25 substitute.

   Mode	Type*	Colors	Alpha	  Res	Monitor**
   ==== ====	======	=====	=======	=======
     0	A/N	  16	40x25	320x200	C,E
     1	A/N	  16	40x25	320x200	C,E	Note that the equivalent dis-
     2	A/N	  16	80x25	640x200	C,E	play on an Extended Graphics
     3	A/N	  16	80x25	640x200	C,E	Monitor of a CGA mode may have
     4	 G	   4	40x25	320x200	C,E	a higher resolution.
     5	 G	   4	40x25	320x200	C,E
     6	 G	   2	80x25	640x200	C,E
     7	A/N	   4	80x25	720x350	M
     8   G         2    80x25   720x348 M	KJ added for Hercules card
    13	 G	  16	40x25	320x200	C,E
    14	 G	  16	80x25	640x200	C,E
    15  APA	   4	80x25	640x350	M
    16	APA	 4/16	80x25	640x350	E

   * A/N = Alpha Numeric			** C = Color Display
     G   = Graphic				   M = Monochrome Display
     APA = Beats me.				   E = Extended Graphics Display
*/
	if(!(flag & GRAPHIC))		/* Text mode */
	  {
	    if((flag & COLOR) && (contab[unit].CT_flags & COLOR))
		mode = ((ncols==40) && (nrows==25)) ? 1 : 3;
	    else{
		if((ncols == 40) && (nrows == 25))
		    mode = 0;
		else if((contab[unit].CT_flags & COLOR) && (ncols == 80))
		    mode = 2;
		else
		    mode = 7;
		}
	    }
	else if((contab[unit].CT_flags & GRAPHIC) && (flag & GRAPHIC))
		/** KJ Graphics Mode **/
	    {
	    if(ncols == 640) mode = (c_hardware) ? 6 : 14;
	      else if (flag & COLOR) mode = 4;
	        else mode = 5;
	    if (c_hardware == 3)
	      {
		mode  = 8;		/* KJ Hercules card */
		psize = 0x8000;
	      }
	    }
	else return(ED_CON | E_IMPLEMENT);  /* can't do as requested */
 
/* Save some important information for when we return to the current mode. */

	use = f->fr_use;
	att = vcid->v_att;
	vmode = vcid->v_mode;
 
/* Free the current virtual console (Why?) */

	if((r = sfree((BYTE *)f->fr_pl[0])) != E_SUCCESS) return(r); 

	p0 = p1 = p2 = p3 = NULLPTR; /*RFW*/ 

/* If we're switching to an Extended Graphics mode, then allocate 64K
   instead of the rather puny 16K that the CGA card uses. Superiority comes
   expensive, I guess.
   For the Hercules card allocate 32 KByte !!!
*/
	temp = (BYTE *)salloc( (mode > 8) ? 0x10000L : (LONG)psize );

	if(temp == 0L) return(ED_CON | E_MEMORY);  

	if(!(flag & GRAPHIC)){
	    if (pl &1) temp = (p0 = temp) + psize;
	    if (pl &2) { temp += psize; p1 = p0 + 1 ; }
	    if (pl &4) temp = (p2 = temp) + psize;
	    }
	else{
	    p0 = temp;	 
	    p1 = p0 +1;	/* set the frame pointer for plane 1 ?? */
	    }

	f->fr_pl[0] = p0;
	f->fr_pl[1] = p1;
	f->fr_pl[2] = p2;
	f->fr_nrow = nrows;
	f->fr_ncol = ncols;
	f->fr_use = use;	
	r = (LONG)p0;			/* set the return address */
	vcid->v_mode = vmode;
	vcid->v_att = att;

	if(flag & GRAPHIC) _bzero(p0,psize);    
	else{
	    if(pl &1) ch2fill(p0,vsize/2,0x20);		/* Character plane */
	    if(pl &2) ch2fill(p0,p0,vsize/2,att);	/* Attribute plane */	
	    if(pl &4) ch1fill(p0,(nrows * ncols),0x00); /* Third plane	   */
	    }

	vcid->v_imode = mode; /* save the valid mode in the VCBLK */

	if(flag & 0x400){		/* full screen on top */
	    pcb[unit]->v_imode = mode;
	    video_init(mode);	
	    if( ((mode > 3) && (mode < 7)) || (mode ==8))
		contab[unit].CT_flags |= IMGRAPHIC;
	    else
		contab[unit].CT_flags &= ~IMGRAPHIC;
	    }
	
	if(flag & 0x400) r = screenAD;	
	return(r); 	
    }
/*****************************END RFW****************************************/

    case 0x13:
    case 0x93:
     {			/** Call a PORT driver to Get/Set table **/
	if ( unit > MAXcdUNIT ) return(E_IllUnitno);
	if ( unit == BITMAP ) return(ED_CON | E_IMPLEMENT);
	pb->dp_unitno = sd_units[unit];
	return( (*sd_hdr[unit]->dh_special)(pb) );
     }
 
  } /*end of case*/
  return(ED_CON | E_IMPLEMENT);
}

/************************* end of main routines *****************************/
/************************* start of sub-routines ****************************/

#if OLDMOUSE
LONG m_deQ(unit,mq) /* take the mouse delta's out of the Queue */

LONG 		unit;
PACKRATQ	*mq;
{

	while ((mq->Qnose != mq->Qtail) && (mq->Qstarted) )
	{
	     (*mq->m_pin)(mq->Q[mq->Qnose],mq->Q[mq->Qnose+1],pcon[unit]);
	     mq->Qnose = mq->Qnose + 2;
	     if(mq->Qnose >= MAXINB) mq->Qnose = 0;
	     mq->Qstarted--;
	}
	return(E_SUCCESS);
}

VOID rattail(ch,unit)	/* Get the mouse input tail and produce packets */

	LONG ch;
	LONG unit; 		
{

WORD     mch;	/* temp copy of ch */
PACKRATQ *mq;	/* ptr to a mouse input queue */
	mq = (PACKRATQ *) mdev[(BYTE) unit];   /* For this unit */
	if((mch = ch & 0xF8) != 0x80) 
	{
 	     if(ch & 0x80) ch |= 0xFF00;	/* sign extend it */
	     if((mch = ch) < 0) mch = -mch;
	     if(mch >= 64) 			/* delta too large -- exit */
	     {
 	        mq->mstate = 0;		/* Start looking all over */
	     } 
	}
	else 					/* Must be the SYNC byte */
	{
	      mch = xbut_tbl[~ch & 0x7]; /* translate the button bits */
	      if(mch != mq->ratbut)      /* not if buttons haven't changed */
	      {
		 mq->ratbut = (LONG)mch;	/*save the buttons away */
	         doasr(mq->mbut_pin,pcon[cd_units[(UWORD)unit]],(LONG)mch,200);
	      }
	      mq->mstate = 1;		/* so now we look for the delta's */
	      return;
	}
	switch (mq->mstate++) {
		case 1: mq->deltax = ch; 	/* get the first xdelta */
			break;
		case 2: mq->deltay = ch;	/* get the first ydelta */
			break;
					/* sum the two xdelta's */
		case 3: mq->deltax = (mq->deltax + ch);
			break;
					/* sum the two ydelta's */
		case 4: mq->Q[mq->Qtail++] = mq->deltax;
			mq->Q[mq->Qtail++] = (-(mq->deltay + ch));
			if(mq->Qtail >= MAXINB) mq->Qtail = 0;
			mq->mstate = 0;
			if (!(mq->Qstarted))
			{
			    doasr(m_deQ,(LONG)cd_units[(UWORD)unit],mq,200);
			}
			mq->Qstarted++;
			break;
		default:
			mq->mstate = 0;
			break;
		}

}
#endif 	/***********  end of OLDMOUSE stuff  *******/

VOID c_deQ(ch,unitno)	/* this is the ASR that passes keyboard characters */
	LONG	ch,unitno;	/* to the Resource Manager's pin address   */
{
	UWORD	ch16 ;

	if ( unitno == BITMAP ) (*ckb_pin[unitno])(pcon[unitno],(LONG)ch);
	  else if ( (ch16 = conv8((BYTE)ch,&escflg[unitno]) ) != NULLPTR )
			(*ckb_pin[unitno])(pcon[unitno],(LONG)ch16);
}

VOID	c_enQ(ch,unitno)	/* called in ISR context by Port Driver */
	LONG	ch;		/* keyboard input interrupt via pin addr */
	LONG	unitno;
{
	doasr(c_deQ,ch,(LONG)cd_units[(UWORD)unitno],200);
}

WORD ckb_intrp()
{
	WORD	ch ;

   if ( (ch = key_tran(INP(DATAPORT)) ) != NULLPTR )
	    doasr(c_deQ,(LONG)ch,(LONG)BITMAP,200);
    OUTP(0x20,0x20);		/* nonspecific EOI */
    return(TRUE); 		/* do a dispatch */
}

GLOBAL	WORD	esc_again = FALSE;	/* boolean to watch for double entry */
GLOBAL  LONG	c_emask = 0L;		/* into asrwait */

GLOBAL	BYTE	stksave[96];	/* stack save area for asrwait during ESCwait */

UWORD	conv8(ch8,flag)	/*convert an 8-bit character into a 16-bit character */
UBYTE	ch8;
UBYTE	*flag;	/* The low nibble controls what type of conversion is to */
		/* be done. 0=VT52.					 */
		/* The hi two bits signal that this is not the first call */
		/* to conv8, the first call returned a zero meaning that */
		/* more info was needed before total conversion.	 */
		/* conv8 will set these hi bits for you to the number of */
		/* times re-entered.					 */
{
	UWORD	ch16 = 0;
	UBYTE	f = *flag ;

	if ( f & 0x0F )		/* this is some other kind of terminal */
	    return((UWORD) ch8); /* return straight characters		*/
	else
	   {
	   f >>= 6;	/* check bits 6+7 for control flow */
	   switch(f)
		{
		case 0: if (ch8 != 0x1b) ch16 = (UWORD) ch8 ;
			else
			   {
				*flag = 0x40 ;
				if (c_emask) 	/* re-entering with yet another escape character */
				   {		/* with one delay/asrwait outstanding, so flag it*/
					esc_again = TRUE;	/* and go away, knowing that we'll*/
					break;			/* return later to handle it */
				   }
				do
				    {
					esc_again = FALSE;	/* clear possible flag */
					c_emask = e_timer(0L,0,33L);	/* 30th sec */
					asrwait(c_emask,stksave);
				    }
				while (esc_again);
				c_emask = 0L;
				if (*flag == 0x40)
				  {
					ch16 = 0x1B;
					*flag = 0;
				  }
			   }
			break;
		case 1: *flag = 0;	/*single ESC */
			switch(ch8)
			{
				case 0x1b: ch16 = 0x1b;
					  *flag = 0x40 ; break;
				case '0': *flag = 0xC0 ; break;
				case '?': *flag = 0x80 ; break;
				case 'A': ch16 = 0x2010 ; break;
				case 'B': ch16 = 0x2011 ; break;
				case 'C': ch16 = 0x2013 ; break;
				case 'D': ch16 = 0x2012 ; break;
				case 'S': ch16 = 0x1001 ; break;
				case 'T': ch16 = 0x1002 ; break;
				case 'U': ch16 = 0x1003 ; break;
				case 'V': ch16 = 0x2004 ; break;
				case 'W': ch16 = 0x2000 ; break;
				case 'P': ch16 = 0x2001 ; break;
				case 'Q': ch16 = 0x2002 ; break;
				case 'R': ch16 = 0x2003 ; break;
				case '~': ch16 = 0x2000 ; break;
			}
			break;

		case 3: *flag = 0;	/* ESC 0 x */
			switch(ch8)
			{
				case 'I': ch16 = 0x1009 ; break;
			}
			break;

		case 2:	*flag = 0;	/* ESC ? x */
			switch(ch8)
			{
				case 'p': ch16 = 0x2030 ; break;
				case 'q': ch16 = 0x2031 ; break;
				case 'r': ch16 = 0x2032 ; break;
				case 's': ch16 = 0x2033 ; break;
				case 't': ch16 = 0x2034 ; break;
				case 'u': ch16 = 0x2035 ; break;
				case 'v': ch16 = 0x2036 ; break;
				case 'w': ch16 = 0x2037 ; break;
				case 'x': ch16 = 0x2038 ; break;
				case 'y': ch16 = 0x2039 ; break;
				case 'M': ch16 = 0x200D ; break;
				case 'I': ch16 = 0x202C ; break;
				case 'm': ch16 = 0x202D ; break;
				case 'n': ch16 = 0x202E ; break;
			}
			break;
		}
	}
	return(ch16);
}

UWORD	conv16(ch16,flag,buffer) /*convert a 16-bit character into 8-bit */
UWORD	ch16,flag;	/* flag bit8 means auto-increment buffer address */
BYTE	*buffer;
{
	BYTE	code ;
	BYTE	nbytes = 1;

    if (flag & 0x0F)		/* not a VT52 */
	*buffer = (BYTE) ch16 ;	/* just return it for today */
    else
     {
	code = ch16 >> 12 ;	/* hi byte is control code */
	switch(code)
	  {
		case 0: *buffer = (BYTE) ch16 ; break;
		case 2: *buffer = 0x1b ;
			*(buffer+1) = (BYTE) ch16 ;
			nbytes++;
			break;
		case 3: *buffer = 0x1b ;
			*(buffer+1) = 'Y' ;
			*(buffer+2) = (BYTE) ch16 + 0x20 ;
/***blotz**what col**	*(buffer+3) = (BYTE) ????? + 0x20 ; *******blotz****/
			nbytes += 3;
			break;
		case 4: *buffer = 0x1b ;
			*(buffer+1) = 'Y' ;
/***blotz**what row**	*(buffer+2) = (BYTE) ????? + 0x20 ; *******blotz****/
			*(buffer+3) = (BYTE) ch16 + 0x20 ;
			nbytes += 3;
			break;
	       default: *buffer = (BYTE) ch16 ; break;
	  }
     }
    if (flag & 0x80)	/* if auto-increment buffer address */
	buffer += nbytes ;
    return( nbytes ); 
}

/****************************************************************/
/*      c_getset               					*/
/*								*/
/*	Common table get/set code.				*/
/*								*/
/****************************************************************/


VOID getset(sp,tp,sz)
REG CTE		*sp;	/* our source table */
REG CTE		*tp;	/* our destination table */
REG WORD	sz;
{
	/*
	 *	According to the get/set specification
	 *	we must return whole fields ONLY if the
	 *	buffer given us is less than our table size.
	 *	So you get the creepy code below... it is
	 *	reasonably efficient, the alternatives were
	 *	worse (unneeded tests after we copied all we could,
	 *	artificial constructs).
	 */
	switch(sz)
	{
		default: 
			tp->CT_pcframe = sp->CT_pcframe;
		case 31:
		case 30:
		case 29:
		case 28:
			tp->CT_conv16 = sp->CT_conv16;
		case 27:
		case 26:
		case 25:
		case 24:
			tp->CT_conv8 = sp->CT_conv8;
		case 23:
		case 22:
		case 21:
		case 20:
			tp->CT_mucol = sp->CT_mucol;
		case 19:
		case 18:
			tp->CT_murow = sp->CT_murow;
		case 17:
		case 16:
			tp->CT_serial = sp->CT_serial;
		case 15:
		case 14:
		case 13:
		case 12:
			tp->CT_buttons = sp->CT_buttons;
		case 11:
			tp->CT_nfkys = sp->CT_nfkys;
		case 10:
			tp->CT_country =sp->CT_country;
		case 9:
		case 8: 
			tp->CT_extp = sp->CT_extp;
		case 7: 
			tp->CT_attrp = sp->CT_attrp;
		case 6: 
			tp->CT_planes = sp->CT_planes;
		case 5: 
			tp->CT_flags = sp->CT_flags;
		case 4: 
			tp->CT_cols = sp->CT_cols;
		case 3:
		case 2: 
			tp->CT_rows = sp->CT_rows;
		case 1:
		case 0: 
			break;
	}
}
/************************************RFW*************************************/

/* Is the mode a graphic mode, keyed by the screen mode number */

MLOCAL BYTE isgrph[] = { 0, 0, 0, 0, 1, 1, 1, 0,
			 1, 0, 0, 0, 0, 1, 1, 1 }; /* KJ changed [8] from 0 to 1 */

VOID cga_init(g)	/* initilize the 6845 and crt controller board*/

BYTE	g;		/* keyed like pcdos int10 set screen mode function */ 
{

	WORD modep;	/* the magic base port for type of board */
	BYTE	h;	/* index into array for type of setup */
	BYTE	i;	/* index into array for each datem */
	BYTE 	j;	/* value to output before initializing board type */

	static BYTE mode_sets[] = {0x2c,0x28,0x2d,0x29,0x2a,0x2e,0x1e,0x29,0x0a};

			/* index register values for initialization */
	static BYTE video_params[5][16] = {

	/* the color card has 3 basic setups */
 
	{0x38,0x28,0x2d,0xa,0x1f,0x6,0x19,0x1c, /* 40X25 Alpha-numeric */
	 0x2,0x7,0x6,0x7,0x0,0x0,0x0,0x0},

	{0x71,0x50,0x5a,0xa,0x1f,0x6,0x19,0x1c, /* 80x25 Alpha-numeric */
	 0x2,0x7,0x6,0x7,0x0,0x0,0x0,0x0},

	{0x38,0x28,0x2d,0xa,0x7f,0x6,0x64,0x70, /* 320X200 graphic */
	 0x2,0x1,0x0,0x7,0x0,0x0,0x0,0x0},

	{0x61,0x50,0x52,0xf,0x19,0x6,0x19,0x19, /* 80x25 b&w card or Hercules*/
	 0x2,0xd,0xb,0xc,0x0,0x0,0x0,0x0},

	{0x35,0x2d,0x2e,0x7,0x5b,0x2,0x57,0x57, /* 720 x 348 graphic Hercules*/
	 0x2,0x3,0x0,0x0,0x0,0x0,0x0,0x0,}
	};

/* If this is a text screen, then zero it. */

	if(!isgrph[g]) _bzero(screenAD,GRAPHSZ);

	if ((g == 7) || (g == 8))
	{
	 modep = MONOPORT;	 	/* use 0x3b4 as the base address */
	 j = (g == 7) ? 0x20 : 0x02;	/* 7 -> Textmode, 8 -> Graphicsmode  */ 
	 OUTP ( modep+0xb, 1);		/* Hercules configurationsswitch, for
					setting graphic mode bit in DMC port */
	}
	else 
	{
	 j = 0;			/* color cards always set in graphic mode */
	 modep = COLORPORT;	/* use 0x3d4 as the base address */ 
	}
 
	OUTP(modep + 4,j);	/* reset the mode register on video adapter*/ 

	h = 3;		/* decide the table values to use based on g */ 
	if (g <=1) h = 0;
	else if ((g == 2)||(g == 3)) h = 1;
	else if ((g > 3) && (g != 7)) h = 2;
	if (g == 8) h = 4;		/* KJ  Hercules in graphic mode */

	for (i = 0; i< sizeof(video_params[h]); i++) {
		OUTP(modep, i); 	/* output the index reg */
		OUTP(modep +1, video_params[h][i]); /* output the data */ 
	}

	OUTP(modep + 4,mode_sets[g]); /* output the standard mode reg values */
	if (g == 6) OUTP(modep + 5, 0x3f); 
	else OUTP(modep + 5, 0x30);
} 
/********************************END RFW*************************************/

/*****************************************************************************
*  EGA card to a specific mode. The mode is as in the
*	PC/AT(w/EGA) Int 10 call.
******************************************************************************/

#define	PRT_MISCELLANEOUS	E_MOR
#define	PRT_FEATURE		E_FCR
#define	ADR_SEQUENCER		E_SEQ_A
#define	PRT_SEQUENCER		E_SEQ_D
#define	ADR_CRT			E_CC_A
#define	PRT_CRT			E_CC_D
#define	PRT_GRX1		E_GC_P1
#define	PRT_GRX2		E_GC_P2
#define	ADR_GRAPHICS		E_GC_A
#define	PRT_GRAPHICS		E_GC_D
#define	ADR_ATTRIBUTE		E_ATT_C
#define	PRT_ATTRIBUTE		E_ATT_C

BYTE DAT_ADDR[12] = { 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 };

BYTE DAT_MISCELLANEOUS[12] = { 0x23, 0x23, 0x23, 0x23, 0x23, 0x23,
			       0x23, 0xA6, 0x23, 0x23, 0xA2, 0xA7 };

#define	DAT_FEATURE	0x00
#define	DAT_GRX1	0x00
#define	DAT_GRX2	0x01

BYTE DAT_SEQUENCER[12][5]   = { 0x03, 0x0B, 0x03, 0x00, 0x03,
				0x03, 0x0B, 0x03, 0x00, 0x03,
				0x03, 0x01, 0x03, 0x00, 0x03,
				0x03, 0x01, 0x03, 0x00, 0x03,
				0x03, 0x0B, 0x03, 0x00, 0x02,
				0x03, 0x0B, 0x03, 0x00, 0x02,
				0x03, 0x01, 0x01, 0x00, 0x06,
				0x03, 0x00, 0x03, 0x00, 0x03,
				0x03, 0x0B, 0x0F, 0x00, 0x06,
				0x03, 0x01, 0x0F, 0x00, 0x06,
				0x03, 0x05, 0x0F, 0x00, 0x00,
				0x03, 0x05, 0x0F, 0x00, 0x00 };

BYTE DAT_CRT1[12][12] = {
/*0*/	0x37, 0x27, 0x2D, 0x37, 0x31, 0x15, 0x04, 0x11, 0x00, 0x07, 0x06, 0x07,
/*1*/	0x37, 0x27, 0x2D, 0x37, 0x31, 0x15, 0x04, 0x11, 0x00, 0x07, 0x06, 0x07,
/*2*/	0x70, 0x4F, 0x5C, 0x2F, 0x5F, 0x07, 0x04, 0x11, 0x00, 0x07, 0x06, 0x07,
/*3*/	0x70, 0x4F, 0x5C, 0x2F, 0x5F, 0x07, 0x04, 0x11, 0x00, 0x07, 0x06, 0x07,
/*4*/	0x37, 0x27, 0x2D, 0x37, 0x30, 0x14, 0x04, 0x11, 0x00, 0x01, 0x00, 0x00,
/*5*/	0x37, 0x27, 0x2D, 0x37, 0x30, 0x14, 0x04, 0x11, 0x00, 0x01, 0x00, 0x00,
/*6*/	0x70, 0x4F, 0x59, 0x2D, 0x5E, 0x06, 0x04, 0x11, 0x00, 0x01, 0x00, 0x00,
/*7*/	0x60, 0x4F, 0x56, 0x3A, 0x51, 0x60, 0x70, 0x1F, 0x00, 0x0D, 0x0B, 0x0C,
/*D*/	0x37, 0x27, 0x2D, 0x37, 0x30, 0x14, 0x04, 0x11, 0x00, 0x00, 0x00, 0x00,
/*E*/	0x70, 0x4F, 0x56, 0x2D, 0x5E, 0x06, 0x04, 0x11, 0x00, 0x00, 0x00, 0x00,
/*F*/	0x60, 0x4F, 0x56, 0x1A, 0x50, 0xED, 0x70, 0x1F, 0x00, 0x00, 0x00, 0x00,
/*10*/	0x5B, 0x4F, 0x53, 0x17, 0x50, 0xBA, 0x6C, 0x1F, 0x00, 0x00, 0x00, 0x00
};

BYTE DAT_CRT2[12][13] = {
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x14, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x14, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x28, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x28, 0x08, 0xE0, 0xF0, 0xA3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x14, 0x00, 0xE0, 0xF0, 0xA2, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x14, 0x00, 0xE0, 0xF0, 0xA2, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE0, 0x23, 0xC7, 0x28, 0x00, 0xDF, 0xEF, 0xC2, 0xFF,
0x00, 0x00, 0x00, 0x00, 0x5E, 0x2E, 0x5D, 0x28, 0x0D, 0x5E, 0x6E, 0xA3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE1, 0x24, 0xC7, 0x14, 0x00, 0xE0, 0xF0, 0xE3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0xE0, 0x23, 0xC7, 0x28, 0x00, 0xDF, 0xEF, 0xE3, 0xFF,
0x00, 0x00, 0x00, 0x00, 0x5E, 0x2E, 0x5D, 0x14, 0x0D, 0x5E, 0x6E, 0x8B, 0xFF,
0x00, 0x00, 0x00, 0x00, 0x5E, 0x2B, 0x5D, 0x14, 0x0F, 0x5F, 0x0A, 0x8B, 0xFF
};

BYTE DAT_GRAPHICS[12][9] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0E, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0F, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x0F, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0A, 0x00, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0F, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0F, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x07, 0x0F, 0xFF
};

BYTE DAT_ATT1[12][12] = {
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x13, 0x15, 0x17, 0x02, 0x04, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
	0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x10, 0x18, 0x18, 0x18,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x10, 0x11, 0x12, 0x13,
	0x00, 0x08, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x04, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00
};

BYTE DAT_ATT2[12][8] = {
	0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x08, 0x00, 0x0f, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x03, 0x00,
	0x17, 0x17, 0x17, 0x18, 0x01, 0x00, 0x01, 0x00,
	0x18, 0x18, 0x18, 0x17, 0x0E, 0x00, 0x0F, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x0f, 0x00,
	0x14, 0x15, 0x16, 0x17, 0x01, 0x00, 0x0F, 0x00,
	0x00, 0x18, 0x00, 0x00, 0x0B, 0x00, 0x05, 0x00,
	0x04, 0x07, 0x00, 0x00, 0x0B, 0x00, 0x05, 0x00
};

VOID video_init(mode)
WORD mode;
{
    WORD i, gsize, omode;

    if(c_hardware){ cga_init(mode); return; }

    omode = mode;
    if(mode > 7){
	if(mode < 13 || mode > 16) return;
	mode -= 5;
	}

    if(!isgrph[omode]){
	video_init(14);
	get_chrom(mode);
	}

    screenAD = baseaddr[gsize=DAT_ADDR[mode]];

    load_port(ADR_SEQUENCER,0,PRT_SEQUENCER,1);

    for(i=1; i<5; ++i)
	load_port(ADR_SEQUENCER,i,PRT_SEQUENCER,DAT_SEQUENCER[mode][i]);

    OUTP(PRT_MISCELLANEOUS,DAT_MISCELLANEOUS[mode]);

    load_port(ADR_SEQUENCER,0,PRT_SEQUENCER,DAT_SEQUENCER[mode][0]);

    for(i=0; i<12; ++i)
	load_port(ADR_CRT,i,PRT_CRT,DAT_CRT1[mode][i]);

    for(i=0; i<13; ++i)
	load_port(ADR_CRT,i+12,PRT_CRT,DAT_CRT2[mode][i]);

    i = INP(PRT_FEATURE);		/* Set up the attribute register */

    for(i=0; i<12; ++i)
	load_port(ADR_ATTRIBUTE,i,PRT_ATTRIBUTE,DAT_ATT1[mode][i]);

    for(i=0; i<8; ++i)
	load_port(ADR_ATTRIBUTE,i+12,PRT_ATTRIBUTE,DAT_ATT2[mode][i]);

    OUTP(ADR_ATTRIBUTE,0);

    OUTP(PRT_GRX1,DAT_GRX1);
    OUTP(PRT_GRX2,DAT_GRX2);

    for(i=0; i<9; ++i)
	load_port(ADR_GRAPHICS,i,PRT_GRAPHICS,DAT_GRAPHICS[mode][i]);

    if(!isgrph[omode]) _bzero(screenAD,SCRNSZ);

    i = INP(PRT_FEATURE);
    OUTP(PRT_ATTRIBUTE,0x20);

}

VOID load_port(port1,data1,port2,data2)
WORD port1, data1, port2, data2;
{
    OUTP(port1,data1);
    if(port2) OUTP(port2,data2);
}

/* Get the ROM character set into Block 0. If mode == 7, then get the
   monochrome character set, else get the color character set.
*/

VOID get_chrom(mode)
WORD mode;
{
    REG WORD *src, *dst;
    REG WORD numwords, numchars, i;

    dst = (WORD *)baseaddr[0];
    numchars = 256;

    if(mode == 7){
	numwords = 7;
	src = &chsets[4376];
	}
    else{
	numwords = 4;
	src = &chsets[6320];
	}

    while(numchars--){
	for(i=0; i<numwords;) dst[i++] = *src++;
	dst += 16;
	}

    load_port(ADR_SEQUENCER,0,PRT_SEQUENCER,1);
    load_port(ADR_SEQUENCER,3,PRT_SEQUENCER,0);
    load_port(ADR_SEQUENCER,0,PRT_SEQUENCER,3);

}
