h56155
s 00000/00000/00068
d D 1.2 83/01/28 14:13:00 tes 2 1
c initial_internal_update
e
s 00068/00000/00000
d D 1.1 83/01/28 13:08:20 tes 1 0
c date and time created 83/01/28 13:08:20 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine txclip (linein, delta, start, stop)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#          COPYRIGHT (C) 1981 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: clip a text extent line and set the string index       #
#                                                                      #
#     Input Parameters:                                                #
#            linein - world coordinates of input line                  #
#            delta  - distance of one character cell along line        #
#                                                                      #
#     Output Parameters:                                               #
#            start  - starting index of text string                    #
#            stop   - ending index of text string                      #
#                                                                      #
#     Routines Called:                                                 #
#            lnclip - clip a line to the current extents               #
#                                                                      #
########################################################################
real linein(1), delta
integer start, stop

real delta2, dx, dy, pnt1(2), pnt2(2)
logical qp1, qp2, qgone

   # Initialize the starting index to 0, no output
   start = 0
   pnt1(1) = linein(1)   # Make copies of the position for clipping
   pnt1(2) = linein(2)
   pnt2(1) = linein(3)
   pnt2(2) = linein(4)

   # Transform and clip the line ('linein') to determine if there is
   #   to be any text clipped
   call lnclip (pnt1, pnt2, qp1, qp2, qgone)

   # Determine if any of the string is visible (qgone == .true.)
   if (!qgone) {
      start = 1
     
      # If the first point has moved recalculate the starting index
      if (qp1) {
	 dx = pnt1(1) - linein(1)
	 dy = pnt1(2) - linein(2)
	 delta2 = sqrt (dx*dx + dy*dy)
	 start = (delta2/delta) + 2
	 }
     
      # If the second point has moved recalculate the ending index
      if (qp2) {
         dx = pnt2(1) - linein(1)
	 dy = pnt2(2) - linein(2)
	 delta2 = sqrt (dx*dx + dy*dy)
	 stop = delta2/delta
	 }
      }
   return
end

E 1
