h49738
s 00005/00004/00380
d D 1.19 83/03/14 11:49:28 mjb 19 18
c changed increment of angle on pies to 1 degree
e
s 00013/00013/00371
d D 1.18 83/03/06 23:31:48 mrk 18 17
c changed MINUS to NEGATIVE to avoid collisions
e
s 00003/00001/00381
d D 1.17 83/03/03 19:39:21 mrk 17 16
c default color is 1, set tic color to line color
e
s 00001/00002/00381
d D 1.16 83/03/03 18:35:57 mrk 16 15
c better rounding of pie slices
e
s 00003/00001/00380
d D 1.15 83/03/03 01:59:30 tes 15 14
c fixed problem of viewports other than default and square
e
s 00005/00005/00376
d D 1.14 83/03/02 22:06:04 mrk 14 13
c removed commented out calls to gzemfl
e
s 00000/00001/00381
d D 1.13 83/03/02 17:51:01 mrk 13 12
c reference to muldiv in genarc not needed
e
s 00003/00003/00379
d D 1.12 83/03/02 17:13:46 mrk 12 11
c modified to allow 16 pie slices
e
s 00061/00019/00321
d D 1.11 83/03/02 11:30:33 tes 11 10
c modified pie generation for speedup on 8086
e
s 00208/00175/00132
d D 1.10 83/02/27 17:54:01 tes 10 9
c modified code to speedup output...real to integer
e
s 00254/00214/00053
d D 1.9 83/02/23 15:20:17 mrk 9 8
c integer arc generation
e
s 00001/00008/00266
d D 1.8 83/02/18 13:03:02 mrk 8 7
c changes to gzemfl interface that scratch array is integer
e
s 00010/00008/00264
d D 1.7 83/02/17 12:43:49 mrk 7 6
c change to sincos interface for that function
e
s 00023/00020/00249
d D 1.6 83/02/10 15:31:57 mrk 6 5
c moved a division outside of loop
e
s 00215/00004/00054
d D 1.5 83/02/10 13:53:56 mrk 5 4
c changes to improve performance, does not call gppisl any more
e
s 00002/00002/00056
d D 1.4 83/02/07 19:51:02 mrk 4 3
c screwed up the abs stuff
e
s 00002/00002/00056
d D 1.3 83/02/07 15:16:41 mrk 3 2
c fix problem when slice total equals 0
e
s 00002/00004/00056
d D 1.2 83/01/28 13:52:52 tes 2 1
c initial_internal_update
e
s 00060/00000/00000
d D 1.1 83/01/28 13:02:31 tes 1 0
c date and time created 83/01/28 13:02:31 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpgrpi (count, data)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: display a data set as a pie chart                      #
#                                                                      #
#     Input Parameters:                                                #
#            count - number of data items                              #
#            data  - real array containing data                        #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gptxat - set the correct text environment                 #
D 9
#            gppisl - display a pie slice                              #
#                                                                      #
E 9
I 9
#            genarc -                                                  #
E 9
########################################################################
I 9
define(`PLUS',1)
D 18
define(`MINUS',-1)
E 18
I 18
define(`NEGATIVE',-1)
E 18
I 10
define(`EXPLODExDISTANCE',2000)   # explode distance of 20 %
E 10
E 9
integer count
real data(1)

D 9
integer kpass, i
D 2
real stangl, total, x, enangl, value

PLOTxREALS PLOTxGETREAL
E 2
I 2
D 5
real stangl, total, x, enangl, value, gtreal 
E 5
I 5
real stangl, total, sumtot, x, enangl, value, gtreal 
integer j, k, l, ixplod, ifill, iflclr, kount, just, idir, length, 
	fillem, iout
integer gr2chr, kerror
real diffx, diffy, xc, yc, radius, xpxlfc, ypxlfc, txtwid, txthgt,
     averag, xmidl, ymidl, xs, ys, factor, degree, angle, tran1, tran2,
     savx, savy, longax, axfact, xaxfac, yaxfac, widsav, hgtsav, xcentr,
D 6
     ycentr
E 6
I 6
D 7
     ycentr, xarc, yarc
E 7
I 7
     ycentr, xarc, yarc, sin1, cos1
E 7
E 6
E 5
E 2
 
I 5
integer contrl(5),  # gzddop control parameter array
	intin(1),   # Argument for gzddop
        intout(1),  # Dummy argument for gzddop
	ptsout(1),  # Argument for gzddop
        txtstr(16), # Array used to pass labels to routine 'text'
	ptsin(148)  # Array used to pass polygon to device
 
D 8
real scrtch(8)     # Scratch array used by gzemfl for filling
                    #    to xarray/yarray)

E 8
real xarray(74), yarray(74)
 
E 9
I 9
D 10
integer i, j, k, l, xsign, ysign, isign1, isign2, temp
integer ixplod, ifill, iflclr, kpass, iout, fillem, kerror, length,
E 10
I 10
SHORTINT xsign, ysign, isign1, isign2
D 11
integer i, j, k, l, temp
E 11
I 11
integer i, j, k, l, temp, vwlng, vwlngx, vwlngy
E 11
integer ixplod, ifill, iflclr, iout, fillem, kerror, length,
E 10
	just, idir, txtstr(16), xc, yc, kount, ival1, ival2, 
D 11
	rastmn, pixlmn, factor, xmid, ymid, xcent, ycent
E 11
I 11
	factor, xmid, ymid, xcent, ycent
E 11
integer contrl(5), intin(1), ptsin(150), intout(1), ptsout(1)
I 11
integer rastmx, pixlmx
E 11
integer gr2chr, muldiv
I 10
D 11
integer xratio, yratio, sum, max, angle, jmax, arcray(16)
E 11
I 11
integer vwrtio, xratio, yratio, sum, max, angle, jmax, arcray(16)
E 11
integer stangl, enangl, averag
E 10

real gtreal
D 10
real stangl, enangl, total, value, sumtot, averag, x, angle
E 10
I 10
D 11
real total, value, x
E 11
I 11
D 19
real total, value, x, vwlmax
E 19
I 19
real total, value, x, vwlmax, round
E 19
E 11
E 10

E 9
E 5
include(`pltcom')
D 9
 
I 5
D 8
# The following equivelences were made to reduce code space:
#      txtstr(1) = scrtch(1) # Equivalence two scratch arrays to save space
equivalence (txtstr(1), scrtch(1))
 
E 8
E 5
DxB write (DEBUGxUNIT, 100) count, data(1)
DxB 100 format (' gpgrpi:', i5, f10.5)
 
   call gptxat (PIExTEXTxATT)
 
   stangl = 0.0
   total = 0.0
   do kpass=1, 2 {
      for (i=1; i<=count; i=i+1) {
D 2
         x = PLOTxGETREAL(data(i))
E 2
I 2
D 4
         x = gtreal (data, i-1)
E 4
I 4
         x = abs(gtreal (data, i-1))
E 4
E 2
         if (kpass == 1) {
D 3
            total = total + x
E 3
I 3
D 4
            total = total + abs(x)
E 4
I 4
            total = total + x
E 4
E 3
            }
         else    {
D 5
            enangl = stangl + (x/total)*6.28318  # 2*PI
E 5
I 5
            enangl = stangl + x*sumtot
E 5
            value = x
            if (npltyp == 0) value = value/total
E 9
D 5
            call gppisl (stangl, enangl, value, i)
E 5
I 5

D 9
            ixplod = 0    # Set attributes to 0 in case greater than 15
            ifill = 0
            iflclr = 1
            if (i <= 15) {
               ixplod = npslcx(i)      # Slice explode status
               ifill = npslcf(i)       # Slice fill pattern
               iflclr = npslcc(i)      # Slice fill color
               }
   
	     averag = stangl + (enangl - stangl)/2.
D 7
	     xmidl = radius*cos (averag)
	     ymidl = radius*sin (averag)
E 7
I 7
	     call sincos (averag, sin1, cos1)
	     xmidl = radius*cos1
	     ymidl = radius*sin1
E 7
	     xs = .15*xmidl
	     ys = .15*ymidl
             if (ixplod != 0)# This slice exploded, shift the arc center out.
                factor = .15
             else
                factor = .0075
E 9
D 10

E 10
I 10
# set the text environment for a pie chart
E 10
D 9
             xc = xcentr + factor*xmidl
             yc = ycentr + factor*ymidl
 
             xmidl = xmidl/xaxfac + xc
             ymidl = ymidl/yaxfac + yc
E 9
I 9
call gptxat (PIExTEXTxATT)
E 9

I 11
# to obtain a circular pie we must take a number of different environmentals
# into consideration. The environmentals include:
#    - the current viewport extents
#    - the pixel aspect ratio
#    - the pixel size aspect ratio
#
# The viewport controls the maximum radius we may use. The length of the
# shorter viewport edge controls the radius. This will insure that the arc
# will not extend outside the addressable display area.
#
# To obtain a 1:1 aspect ratio the number of rasters and the pixel size (in
# microns) must be considered. The ratios for x and y are:
#
#   xrast = ((number of rasters on x)/(number of rasters on longest axis))
#   yrast = ((number of rasters on y)/(number of rasters on longest axis))
#
#   xpixl = ((size of one pixel in microns on x)/(size of largest pixel))
#   ypixl = ((size of one pixel in microns on y)/(size of largest pixel))
#
#   xratio = xrast*xpixl
#   yratio = yrast*ypixl
#
# To obtain the correct point from the above we simply use the following
# equation:
#
#   x = x/xratio
#   y = y/yratio
#
# The radius is obtained by using the minimum of the following:
#
#   radius1 = ((x viewport length)/(longest viewport length))*xratio
#   radius2 = ((y viewport length)/(longest viewport length))*yratio
#
# the 20% of the minimum of radius1 and radius2 is used as the arc radius
#
# To implement the above in integer we use a factor of 1000 to prevent too 
# great a round off in the calculations

E 11
D 7
             degree = .0872663    #  5 degrees in radians( 5.*(6.28318/360.))
E 7
I 7
D 9
             degree =5.    #  5 degrees in radians( 5.*(6.28318/360.))
E 9
I 9
D 10
stangl = 0.0
E 10
I 10
# initialize the arc center depending upon the current viewport
xcent = xvwlng/2. + xvwmin
ycent = yvwlng/2. + yvwmin

# get the minimum pixel and raster size
D 11
rastmn = min0(nxrast, nyrast)
pixlmn = min0(npxlx, npxly)
E 11
I 11
rastmx = max0 (nxrast, nyrast)
pixlmx = max0 (npxlx, npxly)
vwlmax = amax1 (xvwlng, yvwlng)
E 11

D 11
# premultiply the pixel ratios
xratio = muldiv (muldiv (1000, rastmn, nxrast), pixlmn, npxlx)
yratio = muldiv (muldiv (1000, rastmn, nyrast), pixlmn, npxly)
E 11
I 11
xratio = muldiv (muldiv (1000, nxrast, rastmx), npxlx, pixlmx)
yratio = muldiv (muldiv (1000, nyrast, rastmx), npxly, pixlmx)
vwlngx = muldiv (ifix (32767.*(xvwlng/vwlmax)), xratio, 1000)
vwlngy = muldiv (ifix (32767.*(yvwlng/vwlmax)), yratio, 1000)
E 11

I 11
D 15
vwlng = min0 (vwlngx, vwlngy)
E 15
I 15
# we divide by vwlmax/32767 to adjust for viewports which are smaller than
# the full screen
vwlng = min0 (vwlngx, vwlngy)*(vwlmax/32767.)
E 15
vwrtio = muldiv (1000, vwlng, 32767)

E 11
# 1. pass through the input data array and obtain the total
D 19
# 2. pass through the data and map each data element to a 5 degree arc multiple
E 19
I 19
# 2. pass through the data and map each data element to a 1 degree arc multiple
E 19
#    and build an arc array
# 3. insure the sum of all of the parts is 360; if not make the largest sector
#    larger by the difference of the total and 360
E 10
total = 0.0
I 10
for (i=1; i<=count; i=i+1) {
   total = total + abs(gtreal(data, i-1))
   }
if (total == 0.0) return
sum = 0
max = 0
I 19
round = .5
E 19
for (i=1; i<=count; i=i+1) {
   x = abs(gtreal(data, i-1))
D 16
   angle = (x/total)*360.
   angle = (angle/5)*5
E 16
I 16
D 19
   angle = (ifix((x/total)*360.+2.5)/5)*5
E 16
   if (angle < 5) angle = 5
E 19
I 19
   angle = max0 (1, ifix((x/total)*360. + round))
E 19
   if (max < angle) {
      jmax = i
      max = angle
      }
   arcray(i) = angle
   sum = sum + angle
I 19
   round = abs (round - .5)    # Put in a fudge factor on every other one
E 19
   }
E 10
E 9
E 7

D 9
             # Kount is the number of iterations
             kount = ((enangl-stangl)/degree)+1
             angle = stangl       # Set angle to the start angle
             if (kount == 1) kount = 2              # Arc less than 5 degrees
             for (k=1; k<=kount; k=k+1) {           # Build the arc
                if (k == kount) angle = enangl
D 6
                xarray(k) = radius*cos(angle)/xaxfac + xc
                yarray(k) = radius*sin(angle)/yaxfac + yc
E 6
I 6
D 7
                xarray(k) = xarc*cos(angle) + xc
                yarray(k) = yarc*sin(angle) + yc
E 7
I 7
		call sincos (angle, sin1, cos1)
                xarray(k) = xarc*cos1 + xc
                yarray(k) = yarc*sin1 + yc
E 7
E 6
                angle = angle + degree
                }
 
             if (k < 73) {    # Make data include the center point
                xarray(k) = xc
                yarray(k) = yc
                k = k + 1
                xarray(k) = xarray(1)
                yarray(k) = yarray(1)
                }
             else
                k = k - 1
 
             call gpsatt (SETxFILLxCOLORxINDEX, iflclr, iout)
E 9
I 9
D 10
do kpass = 1, 2 {
   for (i=1; i<=count; i=i+1)  {
      x = abs(gtreal(data, i-1))
      if (kpass == 1)   total = total + x   # Total up the pie slices
      else   {
	 enangl = stangl + x*sumtot
E 10
I 10
if (sum < 360) {
   arcray(jmax) = max + (360 - sum)
   }
E 10
E 9

D 9
             # Need to determine if the device can do the desired polygon
             # fill pattern by mapping the FILL INTERIOR STYLE and the 
             # FILL STYLE INDEX to the user's choice of (0-7)
E 9
I 9
D 10
         value = x   # Determine proper label
	 if (npltyp == 0)  value = value/total
E 10
I 10
stangl = 0
E 10
E 9

D 9
             fillem = NO  # Start by saying the device can not do the fill
E 9
I 9
D 10
	 ixplod = 0
	 ifill = 0
	 iflclr = 0
	 if (i <= 15)  {
	    ixplod = npslcx(i)   # Slice explode status
	    ifill = npslcf(i)    # Slice fill pattern
	    iflclr = npslcc(i)   # Slice fill color
	    }
	 if (ixplod != 0)  # This slice exploed, shift the arc center out
	    factor = 1500
	 else
	    factor = 75
E 10
I 10
# output a pie sector for each data element
for (i=1; i<=count; i=i+1)  {
   enangl = stangl + arcray(i)
E 10
E 9
D 6
             iout = -1    # Just in case nothing is returned by the driver
E 6

D 6
             if (ifill > SOLID)  {  # Use a fill pattern or hatch
                call gpsatt (SETxFILLxINTERIORxSTYLE, PATTERN, iout)
                if (iout == PATTERN) {
	           fillem = YES  # The device can do this fill
	           }
                else {
	           iout = -1
	           call gpsatt (SETxFILLxINTERIORxSTYLE, HATCH, iout)
	           if (iout == HATCH)  fillem = YES
E 6
I 6
D 9
	     if (nfill == YES)  {
                iout = -1    # Just in case nothing is returned by the driver
                if (ifill > SOLID)  {  # Use a fill pattern or hatch
                   call gpsatt (SETxFILLxINTERIORxSTYLE, PATTERN, iout)
                   if (iout == PATTERN) {
	              fillem = YES  # The device can do this fill
	              }
                   else {
	              iout = -1
	              call gpsatt (SETxFILLxINTERIORxSTYLE, HATCH, iout)
	              if (iout == HATCH)  fillem = YES
                      }
                   call gpsatt (SETxFILLxSTYLExINDEX, ifill-1, iout)
E 6
                   }
D 6
                call gpsatt (SETxFILLxSTYLExINDEX, ifill-1, iout)
                }
             else  {  # Use a hollow or solid fill
                call gpsatt (SETxFILLxINTERIORxSTYLE, ifill, iout)
                if (iout == ifill)  fillem = YES # The device does this fill
                }
 
E 6
I 6
                else  {  # Use a hollow or solid fill
                   call gpsatt (SETxFILLxINTERIORxSTYLE, ifill, iout)
                   if (iout == ifill)  fillem = YES # The device does this fill
                   }
                } 
E 6
             # Fill slice of pie
             if (nfill == YES & fillem == YES) { # The device can do it
                # Convert points from 0-1 to 32k space and put into ptsin array
                j = 1
                do l = 1, k  {
	           call gpn2dc (xarray(l), yarray(l), ptsin(j))
	           j = j + 2
	           }
                contrl(1) = FILLxAREA
                contrl(VERTICESxIN) = k
                call gzddop (contrl, intin, ptsin, intout, ptsout)
                }
             else {   # Emulate the pie slice
D 8
                call gzemfl (k, xarray, yarray, scrtch, ifill, iflclr)
E 8
I 8
                call gzemfl (k, xarray, yarray, txtstr, ifill, iflclr)
E 8
                }
E 9
I 9
D 10
	 averag = stangl + (enangl - stangl)/2.
	 call genarc (averag, ymid, xmid, ysign, xsign)
E 10
I 10
   value = abs(gtreal(data, i-1))   # Determine proper label
   if (npltyp == 0)  value = value/total
E 10

D 10
	 temp = muldiv(xmid, factor, 10000)
	 if (xsign == MINUS) temp = -temp
	 xc = xcent + temp
	 temp = muldiv(ymid, factor, 10000)
	 if (ysign == MINUS) temp = -temp
	 yc = ycent + temp
E 10
I 10
   ixplod = 0
   ifill = 0
D 17
   iflclr = 0
E 17
I 17
   iflclr = 1
E 17
D 12
   if (i <= 15)  {
E 12
I 12
   if (i <= 16)  {
E 12
      ixplod = npslcx(i)   # Slice explode status
      ifill = npslcf(i)    # Slice fill pattern
      iflclr = npslcc(i)   # Slice fill color
      }
   if (ixplod != 0)  # This slice exploed, shift the arc center out
      factor = EXPLODExDISTANCE
   else
      factor = 75
E 10

I 10
   averag = stangl + (enangl - stangl)/2
   call genarc (averag, ymid, xmid, ysign, xsign)
E 10

D 10
	 # Kount is the number of iterations
	 kount = (enangl - stangl)/5 + 1
	 angle = stangl                   # Set angle to the start angle
	 if (kount == 1)  kount = 2       # The are is less than 5 degrees
E 10
I 10
D 11
   temp = muldiv(muldiv(xmid, factor, 10000), xratio, 1000)
E 11
I 11
   temp = muldiv (muldiv (xmid, factor, 10000), vwrtio, xratio)
E 11
D 18
   if (xsign == MINUS) temp = -temp
E 18
I 18
   if (xsign == NEGATIVE) temp = -temp
E 18
   xc = xcent + temp
D 11
   temp = muldiv(muldiv(ymid, factor, 10000), yratio, 1000)
E 11
I 11

   temp = muldiv (muldiv (ymid, factor, 10000), vwrtio, yratio)
E 11
D 18
   if (ysign == MINUS) temp = -temp
E 18
I 18
   if (ysign == NEGATIVE) temp = -temp
E 18
   yc = ycent + temp
E 10

D 10
	 j = 1
	 for  (k=1; k<=kount; k=k+1)   {
	    if (k == kount)   angle = enangl
	    call genarc (angle, ival1, ival2, isign1, isign2)
E 10

D 10
	    temp = muldiv( muldiv(ival2, rastmn, nxrast), pixlmn, npxlx)
	    if (isign2 == MINUS)  temp = -temp
	    ptsin(j) = xc + temp
E 10
I 10
   # Kount is the number of iterations
   kount = (enangl - stangl)/5 + 1
   angle = stangl                   # Set angle to the start angle
   if (kount == 1)  kount = 2       # The are is less than 5 degrees
E 10

D 10
            temp =   muldiv( muldiv(ival1, rastmn, nyrast), pixlmn, npxly)
	    if (isign1 == MINUS)  temp = -temp
	    ptsin(j+1) = yc + temp
E 10
I 10
   j = 1
   for  (k=1; k<=kount; k=k+1)   {
      if (k == kount)   angle = enangl
      call genarc (angle, ival1, ival2, isign1, isign2)
  
D 11
      temp = muldiv(ival2, xratio, 1000)
E 11
I 11
      temp = muldiv (ival2, vwrtio, xratio)
E 11
D 18
      if (isign2 == MINUS)  temp = -temp
E 18
I 18
      if (isign2 == NEGATIVE)  temp = -temp
E 18
      ptsin(j) = xc + temp
E 10

D 10
	    angle = angle + 5.
	    j = j + 2
	    }
E 10
I 10
D 11
      temp = muldiv(ival1, yratio, 1000)
E 11
I 11
      temp = muldiv (ival1, vwrtio, yratio)
E 11
D 18
      if (isign1 == MINUS)  temp = -temp
E 18
I 18
      if (isign1 == NEGATIVE)  temp = -temp
E 18
      ptsin(j+1) = yc + temp
E 10

D 10
	 if (k < 73)  {  # Make data include the center point
	    ptsin(j) = xc
	    ptsin(j+1) = yc
	    k = k + 1
	    j = j + 2
	    ptsin(j) = ptsin(1)
	    ptsin(j+1) = ptsin(2)
	    }
	 else
	    k = k - 1
E 10
I 10
      angle = angle + 5
      j = j + 2
      }
E 10

D 10
         call gpsatt (SETxFILLxCOLORxINDEX, iflclr, iout)
E 10
I 10
   if (k < 73)  {  # Make data include the center point
      ptsin(j) = xc
      ptsin(j+1) = yc
      k = k + 1
      j = j + 2
      ptsin(j) = ptsin(1)
      ptsin(j+1) = ptsin(2)
      }
   else {
      k = k - 1
      }
E 10

D 10
         # Need to determine if the device can do the desired polygon
         # fill pattern by mapping the FILL INTERIOR STYLE and the 
         # FILL STYLE INDEX to the user's choice of (0-7)
E 10
I 10
   call gpsatt (SETxFILLxCOLORxINDEX, iflclr, iout)
E 10

D 10
         fillem = NO  # Start by saying the device can not do the fill
E 10
I 10
   # Need to determine if the device can do the desired polygon
   # fill pattern by mapping the FILL INTERIOR STYLE and the 
   # FILL STYLE INDEX to the user's choice of (0-7)
E 10

D 10
	 if (nfill == YES)  {
            iout = -1    # Just in case nothing is returned by the driver
            if (ifill > SOLID)  {  # Use a fill pattern or hatch
               call gpsatt (SETxFILLxINTERIORxSTYLE, PATTERN, iout)
               if (iout == PATTERN) {
	          fillem = YES  # The device can do this fill
	          }
               else {
	          iout = -1
	          call gpsatt (SETxFILLxINTERIORxSTYLE, HATCH, iout)
	          if (iout == HATCH)  fillem = YES
                  }
               call gpsatt (SETxFILLxSTYLExINDEX, ifill-1, iout)
               }
            else  {  # Use a hollow or solid fill
               call gpsatt (SETxFILLxINTERIORxSTYLE, ifill, iout)
               if (iout == ifill)  fillem = YES # The device does this fill
               }
            } 
         # Fill slice of pie
         if (nfill == YES & fillem == YES) { # The device can do it
            contrl(1) = FILLxAREA
            contrl(VERTICESxIN) = k
            call gzddop (contrl, intin, ptsin, intout, ptsout)
E 10
I 10
   fillem = NO  # Start by saying the device can not do the fill

   if (nfill == YES)  {
      iout = -1    # Just in case nothing is returned by the driver
      if (ifill > SOLID)  {  # Use a fill pattern or hatch
         call gpsatt (SETxFILLxINTERIORxSTYLE, PATTERN, iout)
         if (iout == PATTERN) {
            fillem = YES  # The device can do this fill
	    }
         else {
	    iout = -1
	    call gpsatt (SETxFILLxINTERIORxSTYLE, HATCH, iout)
	    if (iout == HATCH)  fillem = YES
E 10
            }
D 10
         else {   # Emulate the pie slice
            call gzemfl (k, ptsin, txtstr, ifill, iflclr)
            }
E 10
I 10
         call gpsatt (SETxFILLxSTYLExINDEX, ifill-1, iout)
         }
      else  {  # Use a hollow or solid fill
         call gpsatt (SETxFILLxINTERIORxSTYLE, ifill, iout)
         if (iout == ifill)  fillem = YES # The device does this fill
         }
      }

   # Fill slice of pie
D 14
#   if (nfill == YES & fillem == YES) { # The device can do it
E 14
I 14
   if (nfill == YES & fillem == YES) { # The device can do it
E 14
      contrl(1) = FILLxAREA
      contrl(VERTICESxIN) = k
      call gzddop (contrl, intin, ptsin, intout, ptsout)
D 14
#   }
#   else {   # Emulate the pie slice
#      call gzemfl (k, ptsin, txtstr, ifill, iflclr)
#      }
E 14
I 14
      }
   else {   # Emulate the pie slice
      call gzemfl (k, ptsin, txtstr, ifill, iflclr)
      }
E 14
E 10
E 9
 
D 9
             # Position for label
 
             call imove (ABSOLUTE, xmidl, ymidl)
             call idraw (RELATIVE, xs, ys)
             call imove (RELATIVE, xs/2., ys/2.)
 
             # Justify the labels vertically centered and horizontally 
	     # left or right depending upon which quadrant we're in. 
	     # Left for quadrants I & IV, right for quadrants II & III.
 
             txtjv = 1    # Center justify the text
             # If the label is on the right side
D 7
             if (averag < 1.57 | averag > 4.85) {
E 7
I 7
             if (averag < 90.  | averag > 270.) {
E 7
                txtjh = 0
                just = 4
                idir = 1
                }
             else {  # Justify it for the left side of the pie
                txtjh = 2
                just = 6
                idir = -1
                }
E 9
I 9
D 10
         # Position for label
	 j = muldiv( muldiv(xmid, rastmn, nxrast), pixlmn, npxlx)
	 temp = j
	 if (xsign == MINUS)  temp = -j
         ptsin(1) = xc + temp
E 10
I 10
   # Position for label
D 11
   j = muldiv(xmid, xratio, 1000)
E 11
I 11
   j = muldiv (xmid, vwrtio, xratio)
E 11
   temp = j
D 18
   if (xsign == MINUS)  temp = -j
E 18
I 18
   if (xsign == NEGATIVE)  temp = -j
E 18
   ptsin(1) = xc + temp
E 10
E 9

D 9
             # Convert value to characters, either percentage or actual value
E 9
I 9
D 10
	 temp = muldiv(j, 15, 100)
	 if (xsign == MINUS)  temp = -temp
	 ptsin(3) = ptsin(1) + temp
E 10
I 10
   temp = muldiv(j, 15, 100)
D 18
   if (xsign == MINUS)  temp = -temp
E 18
I 18
   if (xsign == NEGATIVE)  temp = -temp
E 18
   ptsin(3) = ptsin(1) + temp
E 10

D 10
	 l = muldiv( muldiv(ymid, rastmn, nyrast), pixlmn, npxly)
	 temp = l
	 if (ysign == MINUS)  temp = -l
	 ptsin(2) = yc + temp
E 10
I 10
D 11
   l = muldiv(ymid, yratio, 1000)
E 11
I 11
   l = muldiv (ymid, vwrtio, yratio)
E 11
   temp = l
D 18
   if (ysign == MINUS)  temp = -l
E 18
I 18
   if (ysign == NEGATIVE)  temp = -l
E 18
   ptsin(2) = yc + temp
  
   temp = muldiv(l, 15, 100)
D 18
   if (ysign == MINUS)  temp = -temp
E 18
I 18
   if (ysign == NEGATIVE)  temp = -temp
E 18
   ptsin(4) = ptsin(2) + temp
E 10

D 10
	 temp = muldiv(l, 15, 100)
	 if (ysign == MINUS)  temp = -temp
	 ptsin(4) = ptsin(2) + temp
E 10
I 10
   # Draw the label tick     
I 17
   call gpsatt (SETxPOLYLINExCOLORxINDEX, nlcolr, iout)

E 17
   contrl(1) = POLYLINE
   contrl(VERTICESxIN) = 2
   call gzddop (contrl, intin, ptsin, intout, ptsout)
E 10

D 10
	 contrl(1) = POLYLINE
	 contrl(VERTICESxIN) = 2
	 # Draw the explosion piece
	 call gzddop (contrl, intin, ptsin, intout, ptsout)
E 10
I 10
   # Justify the labels vertically centered and horizontally 
   # left or right depending upon which quadrant we're in. 
   # Left for quadrants I & IV, right for quadrants II & III.
   temp = muldiv(j, 22, 100)
D 18
   if (xsign == MINUS)   temp = -temp
E 18
I 18
   if (xsign == NEGATIVE)   temp = -temp
E 18
   zxabsl = (float(ptsin(1) + temp)- xvwmin) / xvwlng
E 10

D 10
         # Justify the labels vertically centered and horizontally 
	 # left or right depending upon which quadrant we're in. 
	 # Left for quadrants I & IV, right for quadrants II & III.
 	 temp = muldiv(j, 22, 100)
	 if (xsign == MINUS)   temp = -temp
 	 zxabsl = (float(ptsin(1) + temp)- xvwmin) / xvwlng

 	 temp = muldiv(l, 22, 100)
	 if (ysign == MINUS)   temp = -temp
 	 zyabsl = (float(ptsin(2) + temp)- yvwmin) / yvwlng
E 10
I 10
   temp = muldiv(l, 22, 100)
D 18
   if (ysign == MINUS)   temp = -temp
E 18
I 18
   if (ysign == NEGATIVE)   temp = -temp
E 18
   zyabsl = (float(ptsin(2) + temp)- yvwmin) / yvwlng
E 10
E 9
 
D 9
             if (npltyp == 0) {
                length = gr2chr (100.*value+.05, txtstr, 10, 1, kerror)
                length = length + 1
                txtstr(length) = PERCENT
                }
             else
                length = gr2chr (value, txtstr, 10, 2, kerror)
E 9
I 9
D 10
         txtjv = 1    # Center justify the text
E 10
I 10
   txtjv = 1    # Center justify the text
E 10
E 9

D 9
             # Now due to the special space that pies are calulated
             # in, we must put the character size back into 0-1 space for
             # the entire screen, that is remove the viewport transformation
             widsav = zchwdt
             hgtsav = zchhgt
             zchwdt = txtwid
             zchhgt = txthgt
E 9
I 9
D 10
         # If the label is on the right side
         if (averag < 90.  | averag > 270.) {
            txtjh = 0
            just = 4
            idir = 1
            }
         else {  # Justify it for the left side of the pie
            txtjh = 2
            just = 6
            idir = -1
            }
E 10
I 10
   # If the label is on the right side
   if (averag < 90  | averag > 270) {
      txtjh = 0
      just = 4
      idir = 1
      }
   else {  # Justify it for the left side of the pie
      txtjh = 2
      just = 6
      idir = -1
      }
E 10
E 9

D 9
             call text (length, txtstr)      # Output the data value
E 9
I 9
D 10
         # Convert value to characters, either percentage or actual value
E 10
I 10
   # Convert value to characters, either percentage or actual value
E 10
 
D 10
         if (npltyp == 0) {
            length = gr2chr (100.*value+.05, txtstr, 10, 1, kerror)
            length = length + 1
            txtstr(length) = PERCENT
            }
         else
            length = gr2chr (value, txtstr, 10, 2, kerror)
E 10
I 10
   if (npltyp == 0) {
      length = gr2chr (100.*value+.05, txtstr, 10, 1, kerror)
      length = length + 1
      txtstr(length) = PERCENT
      }
   else {
     length = gr2chr (value, txtstr, 10, 2, kerror)
     }
E 10
E 9

D 9
             # Now restore the correct character sizes for the current viewport
             zchwdt = widsav
             zchhgt = hgtsav
E 9
I 9
D 10
         call text (length, txtstr)      # Output the data value
E 10
I 10
   call text (length, txtstr)      # Output the data value
E 10

D 10
         # Determine where label is to be positioned
         if (i <= 15) {
            j = i + 15
E 10
I 10
   # Determine where label is to be positioned
D 12
   if (i <= 15) {
      j = i + 15
E 12
I 12
   if (i <= 16) {
      j = i + 16
E 12
E 10
E 9
          
D 9
             # Determine where label is to be positioned
             if (i <= 15) {
                j = i + 15
          
                # Now save this ndc position for later time
                zpspos(i) = zxabsl*tran1 + (length+1)*idir*zchwdt 
                zpspos(j) = zyabsl*tran2
                npslcj(i) = just
                }
 
E 5
            stangl = enangl
E 9
I 9
D 10
            # Now save this ndc position for later time
            zpspos(i) = zxabsl+ (length+1)*idir*zchwdt 
            zpspos(j) = zyabsl
            npslcj(i) = just
E 9
            }
D 9
         }
D 3
      if (total == 0.0) total = 1.0
E 3
I 3
D 5
      if (total == 0.0)  return
E 5
I 5
      if (kpass == 2)   {  # Prepare to return
         # Restore the viewing transform
	 xvwlng = savx
	 yvwlng = savy
	 return
E 9
I 9
 
         stangl = enangl
E 9
	 }
E 10
I 10
      # Now save this ndc position for later time
      zpspos(i) = zxabsl+ (length+1)*idir*zchwdt 
      zpspos(j) = zyabsl
      npslcj(i) = just
E 10
I 9
      }
D 10
   if (kpass == 2)  {   # Prepare to return	
      return
      }
   if (total == 0.0)  return   # If abs of slices is 0, get out
E 9

D 9
      if (total == 0.0)  return  # On first pass sum, bail out
E 9
I 9
   sumtot = 360. / total
   xcent = xvwlng/2. + xvwmin
   ycent = yvwlng/2. + yvwmin
   rastmn = min0(nxrast, nyrast)
   pixlmn = min0(npxlx, npxly)
E 10
I 10
 
   stangl = enangl
E 10
   }
E 9

D 7
      sumtot = 6.28318/total   # number of radians in a pie
E 7
I 7
D 9
      sumtot = 360./total   # number of radians in a pie
E 7
      savx = xvwlng
      savy = yvwlng
      longax = amax1 (xvwlng, yvwlng)
E 9
I 9
return
end
subroutine genarc (angle, ival1, ival2, isign1, isign2)
D 10
real angle
integer ival1, ival2, isign1, isign2
E 10
I 10
integer angle
integer ival1, ival2
SHORTINT isign1, isign2
E 10
E 9

D 9
      diffx = xvwlng/longax    # Put space into 0 - 1 space
      diffy = yvwlng/longax
E 9
I 9
define(`FORWARD',1)
define(`REVERSE',0)

D 10
integer i, inext, index, kquad, start, stop, vwlng
real diff, slope, curang
integer table(19), sinsgn(4), cossgn(4), sindir(4), cosdir(4)
E 10
I 10
SHORTINT i, inext, index, kquad, sinsgn(4), cossgn(4), sindir(4), cosdir(4)
D 11
integer diff, slope, curang, start, stop, vwlng, table(19)
E 11
I 11
integer diff, slope, curang, start, stop, table(19)
E 11
E 10
D 13
integer muldiv
E 13

include(`pltcom')

data table/0, 571, 1138, 1696, 2241, 2770, 3277, 3759, 4212, 4634, 
	   5020, 5368, 5675, 5939, 6158, 6330, 6454, 6528, 6553/

D 18
data sinsgn /PLUS, PLUS, MINUS, MINUS/
data cossgn /PLUS, MINUS, MINUS, PLUS/
E 18
I 18
data sinsgn /PLUS, PLUS, NEGATIVE, NEGATIVE/
data cossgn /PLUS, NEGATIVE, NEGATIVE, PLUS/
E 18
data sindir /FORWARD, REVERSE, FORWARD, REVERSE/
data cosdir /REVERSE, FORWARD, REVERSE, FORWARD/

   curang = angle
D 10
   if (curang >= 360.) curang = 0.  # Get back in 0-360 range
   kquad = curang / 90.             # determine quadrand for sign, dir
   curang = curang - kquad*90.
E 10
I 10
   if (curang >= 360) curang = 0  # Get back in 0-360 range
   kquad = curang / 90            # determine quadrand for sign, dir
   curang = curang - kquad*90
E 10
   kquad = kquad + 1
E 9
   
D 9
      xvwlng = longax
      yvwlng = longax
E 9
I 9
D 10
   index = curang /5.
E 10
I 10
   index = curang /5
E 10
E 9

D 9
      # In order to make pies round, must modify the scale factors to
      # Use the size of a pixel to scale properly
      factor = amax0 (npxlx, npxly)  # Determine which pixel is bigger
      xpxlfc = float(npxlx) / factor
      ypxlfc = float(npxly) / factor
 
      # Need to determine x and y scale factors to put the pie into
      # a unity aspect ratio since the device interface is 32K in x and y
      axfact = amax0 (nxrast, nyrast)  # Determine longest axis
      xaxfac = float(nxrast) / axfact * xpxlfc
      yaxfac = float(nyrast) / axfact * ypxlfc
E 9
I 9
   if (sindir(kquad) == FORWARD) {
      i = index + 1
      inext = index + 2
      }
   else  {
     i = 19 - index
     inext = i - 1
     }
E 9

D 9
      # The radius will be 20% of the available space
      radius = 0.2*amin1(diffx*xaxfac,diffy*yaxfac) 
E 9
I 9
   diff =  curang - 5*index
E 9

D 9
      # calculate some values that will be needed later
      txtwid = zchwdt*savx/longax
      txthgt = zchhgt*savy/longax
      tran1 = longax/savx
      tran2 = longax/savy
      xcentr = diffx / 2.0
      ycentr = diffy / 2.0
I 6
      xarc = radius / xaxfac
      yarc = radius / yaxfac
E 9
I 9
   # Determine the sine using a little linear algebra
   start = table(i)
   stop = table(inext)
D 10
   slope = (stop-start)/5.
E 10
I 10
   slope = (stop-start)/5
E 10
   ival1 = slope*diff + start
D 11
   vwlng = min1(xvwlng, yvwlng)
   ival1 = muldiv(ival1, vwlng, 32767)
E 11
   isign1 = sinsgn(kquad)
   
   if (cosdir(kquad) == FORWARD) {
      i = index + 1
      inext = index + 2
E 9
E 6
E 5
E 3
      }
I 9
   else  {
     i = 19 - index
     inext = i - 1
     }

   # Determine the cosine using a little linear algebra
   start = table(i)
   stop = table(inext)
D 10
   slope = (stop-start)/5.
E 10
I 10
   slope = (stop-start)/5
E 10
   ival2 = slope*diff + start
D 11
   ival2 = muldiv(ival2, vwlng, 32767)
E 11
   isign2 = cossgn(kquad)
E 9
D 10
   return
E 10
I 10

return
E 10
end
E 1
