h04840
s 00005/00005/00270
d D 1.10 83/03/17 20:58:34 mrk 10 9
c bug in fill stuff
e
s 00037/00051/00238
d D 1.9 83/03/12 18:49:21 mrk 9 8
c chnage the emulated fill patterns
e
s 00015/00015/00274
d D 1.8 83/03/01 19:43:28 mrk 8 7
c reversed horizontal fill and vertical fill numbers
e
s 00007/00007/00282
d D 1.7 83/02/25 19:40:32 tes 7 6
c changed name of solvit to slvit2---conflict in gzemfl solvit
e
s 00002/00002/00287
d D 1.6 83/02/25 18:46:49 tes 6 5
c added common variable "slope" to "polygn" in filbar
e
s 00009/00000/00280
d D 1.5 83/02/19 16:00:44 mrk 5 4
c made changes to diagonal fill for 32k limit
e
s 00001/00001/00279
d D 1.4 83/02/18 12:15:33 mrk 4 3
c removed a doubly defined local
e
s 00206/00029/00074
d D 1.3 83/02/17 12:33:21 mrk 3 2
c created bar specific fill 
e
s 00000/00000/00103
d D 1.2 83/01/28 13:48:26 tes 2 1
c initial_internal_update
e
s 00103/00000/00000
d D 1.1 83/01/28 13:01:15 tes 1 0
c date and time created 83/01/28 13:01:15 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpbar (x, y, xlen, ylen)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Display a bar at the indicated point                   #
#                                                                      #
#     Input Parameters:                                                #
#            x - x position of lower left corner of bar in world space #
#            y - y position of lower left corner of bar in world space #
#            xlen - length of bar in x                                 #
#            ylen - length of bar in y                                 #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device driver control                            #
#                                                                      #
########################################################################
real x, y, xlen, ylen

D 3
integer contrl(6), opcd, intin(1), ptsin(4), idummy(1), ptsout(1), 
	nxy1(2), nxy2(2)
real xarray(5), yarray(5), scrtch(8),
     x1, x2, y1, y2, xry1, xry2, xry3, xry4, xry5, yry1, yry2,
     yry3, yry4, yry5, temp
E 3
I 3
integer contrl(6), opcd, intin(1), ptsin(10), idummy(1), ptsout(1), 
	nxy1(2), nxy2(2), i
real x1, x2, y1, y2, temp
E 3

include(`pltcom')

# The following equivalences were made to reduce amount of code produced
#   opcd   = contrl(OPCODE)
D 3
#   nxy1(1) = ptsin(1)
#   nxy2(1) = ptsin(3)
#   xry1,xry2,xry3,xry4,xry5 = xarray(1..5)
#   yry1,yry2,yry3,yry4,yry5 = yarray(1..5)
E 3
#
D 3
equivalence (opcd, contrl(OPCODE)),
	    (nxy1(1), ptsin(1)), (nxy2(1), ptsin(3)),
	    (xry1,xarray(1)), (xry2,xarray(2)), (xry3,xarray(3)),
	    (xry4,xarray(4)), (xry5,xarray(5)), (yry1,yarray(1)),
	    (yry2,yarray(2)), (yry3,yarray(3)), (yry4,yarray(4)),
	    (yry5,yarray(5))
E 3
I 3
equivalence (opcd, contrl(OPCODE))
E 3

   x1 = x
   y1 = y
   x2 = x + xlen
   y2 = y + ylen

   # If corners are reversed, turn them around so x1, y1, is lower left
   if (x1 > x2)  {
      temp = x1
      x1 = x2
      x2 = temp
      }
   if (y1 > y2)  {
      temp = y1
      y1 = y2
      y2 = temp
      }

   #  Clip the bar to the graph extents, put out a partial bar if possible
   #  This is done by comparing the bar corners to the clipping edges
   x1 = amax1( zxleft, x1)
   y1 = amax1( zybotm, y1)
   x2 = amin1( zxrght, x2)
   y2 = amin1( zytop, y2)
   if (x1 > x2 | y1 > y2)  return  # The bar was totally clipped

I 3
   call gpn2dc (x1, y1, nxy1)  # convert to 32k space
   call gpn2dc (x2, y2, nxy2)

E 3
   if (nbarcp == YES & nbrcpf == YES)  {  # The device has bars, use them
D 3
      call gpn2dc (x1, y1, nxy1)  # convert to 32k space
      call gpn2dc (x2, y2, nxy2)
E 3
      #  contrl(OPCODE) = GENERALIZEDxDRAWINGxPRIMITIVE
      opcd = GENERALIZEDxDRAWINGxPRIMITIVE
      contrl(VERTICESxIN) = 2
      contrl(6) = BAR  # Yup, thats what we want

I 3
      ptsin(1) = nxy1(1)
      ptsin(2) = nxy1(2)
      ptsin(3) = nxy2(1)
      ptsin(4) = nxy2(2)
E 3
      call gzddop (contrl, intin, ptsin, idummy, ptsout)
      }
   else  {   # Use emulation
D 3
      nclip = NO   # The bar clipping was done above
      xry1 = x1
      xry2 = x2
      xry3 = x2
      xry4 = x1
      xry5 = x1
      yry1 = y1
      yry2 = y1
      yry3 = y2
      yry4 = y2
      yry5 = y1
      call gzemfl (5, xarray, yarray, scrtch, nbstyl, nbcolr)
E 3
I 3
      # Set the current line type to solid
      call gpsatt (SETxPOLYLINExLINETYPE, 1, i)

      # Set the line color
      call gpsatt (SETxPOLYLINExCOLORxINDEX, nbcolr, i)

      if (nbstyl > 0)   {  # Need to fill the bar
	 call filbar (nxy1(1), nxy1(2), nxy2(1), nxy2(2))
         }

      # Outine the bar at the end
      opcd = POLYLINE
      contrl(VERTICESxIN) = 5
      ptsin(1) = nxy1(1)
      ptsin(2) = nxy1(2)
      ptsin(3) = nxy2(1)
      ptsin(4) = nxy1(2)
      ptsin(5) = nxy2(1)
      ptsin(6) = nxy2(2)
      ptsin(7) = nxy1(1)
      ptsin(8) = nxy2(2)
      ptsin(9) = nxy1(1)
      ptsin(10) = nxy1(2)
      call gzddop (contrl, intin, ptsin, idummy, ptsout)
E 3
      }

   return
end
I 3
subroutine filbar (xbot, ybot, xtop, ytop)
integer xbot, ybot, xtop, ytop
D 4
integer xincmt, yincmt, ipat, intcpt, j
E 4
I 4
D 9
integer xincmt, yincmt, ipat, j
E 9
I 9
D 10
integer xincmt, yincmt, ipat, j, pattrn(7)
E 10
I 10
integer xincmt, yincmt, ipat, j, pattrn(7), uplimt
E 10
E 9
E 4
integer incmnt, start, stop, nxtfil, x1, x2, y1, y2, xinc, yinc
integer contrl(5), intin(1), ptsin(4), intout(1), ptsout(1)
integer p1, p2, p3, p4
E 3

I 3
D 6
integer kfill, intcpt
E 6
I 6
integer kfill, intcpt, slope
E 6
include(`pltcom')
D 6
common /polygn/ kfill, intcpt
E 6
I 6
common /polygn/ kfill, intcpt, slope
E 6

# In order to reduce code size, the following eqivalences were made
#    ptsin(1) = p1
#    ptsin(2) = p2
#    ptsin(3) = p3
#    ptsin(4) = p4
equivalence (ptsin(1),p1), (ptsin(2),p2), (ptsin(3),p3), (ptsin(4),p4)

I 9
data pattrn / 0, 256, 512, 768, 256, 512, 768/

E 9
define(`FILLx0', 0)
define(`FILLx1', 1)
define(`FILLx2', 2)
define(`FILLx3', 3)
define(`FILLx4', 4)
define(`FILLx5', 5)
define(`FILLx6', 6)
define(`FILLx7', 7)
define(`ENDxFILL', 23)
define(`NEXTxFILL', 22)
define(`ABSOLUTE', 1)
define(`HOLLOW', 0)
I 5
D 10
define(`UPPERxLIMIT',32255)
E 10
E 5

kfill = min0(nbstyl,7)   # 7 fills max

D 9
# Set up for the fills
incmnt = 512   # 64 line on the screen
xincmt = 32767/nxrast  # Number of 32k units in a raster
yincmt = 32767/nyrast
E 9
I 9
incmnt = pattrn(kfill)
I 10
uplimt = 32767 - incmnt
E 10
nxtfil = 0
if (kfill > 4)    nxtfil = 3   # Pattern has two passes
if (kfill > 1)    kfill = 2    # Always start with +45 degrees

E 9
contrl(OPCODE) = POLYLINE
contrl(VERTICESxIN) = 2   # Always 2 points

D 9
NEXTxFILL  nxtfil = 0

xinc = 0  # Most fills use these increments
E 9
I 9
NEXTxFILL xinc = 0  # Most fills use these increments
E 9
yinc = incmnt

D 9
goto (FILLx1, FILLx2, FILLx3, FILLx4, FILLx5, FILLx6, FILLx7), kfill
E 9
I 9
D 10
goto (FILLx1, FILLx2, FILLx3), kfill
E 10
x1 = xbot
I 10
goto (FILLx1, FILLx2, FILLx3), kfill
E 10
E 9

FILLx1   continue     # Solid fill , determine shortest direction
I 9
   xincmt = 32767/nxrast  # Number of 32k units in a raster
   yincmt = 32767/nyrast
E 9
   incmnt = min0 (xincmt, yincmt)
D 8
   if ((ytop-ybot)/yincmt > (xtop-xbot)/xincmt)   { # Fill using vertical fill
E 8
I 8
D 9
   if ((ytop-ybot)/yincmt < (xtop-xbot)/xincmt)   { # Fill using horizontal fill
E 8
      kfill = FILLx3
      go to FILLx3
      }
D 8
   kfill = FILLx2  # Let fall through for horizontal
E 8
I 8
   kfill = FILLx2  # Let fall through for vertical
E 8

D 8
FILLx2   continue   # Horizontal fill
   start = ybot
   stop = ytop
   x1 = xbot
   y1 = ybot
   x2 = xtop
   y2 = ybot
   xinc = 0 
   yinc = incmnt
   go to    ENDxFILL

FILLx3    continue   # Vertical fill
E 8
I 8
FILLx2   continue   # Vertical fill
E 8
   start = xbot
   stop = xtop
   x1 = xbot
E 9
   y1 = ybot
D 9
   x2 = xbot
   y2 = ytop
   xinc = incmnt
D 8
   yinc = 0
E 8
I 8
   yinc = 0 
E 9
I 9
   if ((ytop-ybot)/yincmt < (xtop-xbot)/xincmt) { # Fill using horizontal fill
      start = ybot
      stop = ytop
      x2 = xtop
      y2 = ybot
      xinc = 0
      yinc = incmnt
      }
   else { # Vertical fill
      start = xbot
      stop = xtop
      x2 = xbot
      y2 = ytop
      xinc = incmnt
      yinc = 0 
      }
E 9
   go to    ENDxFILL

D 9
FILLx3    continue   # Horizontal fill
   start = ybot
   stop = ytop
   x1 = xbot
   y1 = ybot
   x2 = xtop
   y2 = ybot
   xinc = 0
   yinc = incmnt
E 8
   go to    ENDxFILL
E 9

D 9
FILLx4   continue   # +45 degree fill
FILLx5   continue   # -45 degree fill
   if (kfill == FILLx5)   {
E 9
I 9
FILLx2   continue   # +45 degree fill
FILLx3   continue   # -45 degree fill
   if (kfill == FILLx3)   {
E 9
      intcpt = ybot + xbot 
      y1 = ybot
      y2 = ybot - (xtop - xbot)
      }
   else  {
      intcpt = ybot - xtop
      y1 = ybot - (xtop - xbot)
      y2 = ybot
      }
   start = -(ytop - ybot)
   stop = xtop - xbot
D 9
   x1 = xbot
E 9
   x2 = xtop
   go to    ENDxFILL

D 9
FILLx6   continue     # Horizontal and vertical
   kfill = FILLx3
   nxtfil = FILLx2
   go to FILLx3

FILLx7   continue     # +45 and -45 fill
    kfill = FILLx4
    nxtfil = FILLx5
    go to FILLx4

E 9
ENDxFILL  continue

for (ipat=start+incmnt; ipat <= stop; ipat=ipat+incmnt) {

   intcpt = intcpt + incmnt   # use if need to figure with

   x1 = x1 + xinc
   y1 = y1 + yinc
   x2 = x2 + xinc
   y2 = y2 + yinc

   p1 = x1
   p2 = y1
   p3 = x2
   p4 = y2

D 9
   if (kfill == FILLx4)   {  # A diagonal hatch fill
E 9
I 9
   if (kfill == FILLx2)   {  # A diagonal hatch fill
E 9
      # Need to check all the y coordinates to make sure they are within 
      # the bar y limits
      if (y1 < ybot)  { # fix this x and y
D 7
	 call solvit (p1, p2, ybot)
E 7
I 7
	 call slvit2 (p1, p2, ybot)
E 7
	 }
      if (y2 > ytop)  { # fix this x and y
D 7
	 call solvit (p3, p4, ytop)
E 7
I 7
	 call slvit2 (p3, p4, ytop)
E 7
	 }
I 5
D 10
      if (y2 > UPPERxLIMIT)  {  # Need to fix up point to keep less than 32k
E 10
I 10
      if (y2 > uplimt)  {  # Need to fix up point to keep less than 32k
E 10
	 x2 = p3
	 y2 = p4
	 }
E 5
      }
D 9
   if (kfill == FILLx5)    { # The other diagonal hatch fill
E 9
I 9
   if (kfill == FILLx3)    { # The other diagonal hatch fill
E 9
      if (y2 < ybot)  { # fix this x and y
D 7
	 call solvit (p3, p4, ybot)
E 7
I 7
	 call slvit2 (p3, p4, ybot)
E 7
	 }
      if (y1 > ytop)  { # fix this x and y
D 7
	 call solvit (p1, p2, ytop)
E 7
I 7
	 call slvit2 (p1, p2, ytop)
E 7
I 5
	 }
D 10
      if (y1 > UPPERxLIMIT)  {  # Need to fix up point to keep less than 32k
E 10
I 10
      if (y1 > uplimt)  {  # Need to fix up point to keep less than 32k
E 10
	 x1 = p1
	 y1 = p2
E 5
	 }
      }
   if (j == 1)   {  # Need to flip the points around to reduce draw time
      j = p1
      p1 = p3
      p3 = j
      j = p2
      p2 = p4
      p4 = j
      j = 0
      }
   else   j = 1   # Flip them next time

   # draw the fill line
   call gzddop (contrl, intin, ptsin, intout, ptsout)
   }

if (nxtfil !=0) { 
D 9
   kfill = nxtfil
E 9
I 9
   kfill = 3
   nxtfil = 0
E 9
   go to NEXTxFILL   # Some patterns take two passes
   }

return
end
D 7
subroutine solvit (x1, y1, yval)
E 7
I 7
subroutine slvit2 (x1, y1, yval)
E 7
integer x1, y1, yval

D 7
integer nfill, intcpt
common /polygn/ nfill, intcpt
E 7
I 7
integer nfill, intcpt, slope
common /polygn/ nfill, intcpt, slope
E 7

   y1 = yval
D 9
   if (nfill == FILLx4)   x1 = yval - intcpt
E 9
I 9
   if (nfill == FILLx2)   x1 = yval - intcpt
E 9
   else                   x1 = -yval + intcpt
   return
end
E 3
E 1
