h64788
s 00013/00007/00479
d D 1.19 83/03/29 11:49:40 mjb 19 18
c fixed title placement problems
e
s 00034/00032/00452
d D 1.18 83/03/28 16:57:22 mjb 18 17
c 
e
s 00000/00000/00484
d D 1.17 83/03/28 13:42:57 mjb 17 16
c 
e
s 00005/00003/00479
d D 1.16 83/03/16 17:50:49 mjb 16 15
c put in flag to tell which viewport in for y tic labeling
e
s 00000/00000/00482
d D 1.15 83/03/15 13:08:49 mjb 15 14
c fixed bugs with labeling legends and calculating ranges
e
s 00004/00001/00478
d D 1.14 83/03/11 12:24:28 mjb 14 13
c fixed bar width problem
e
s 00002/00001/00477
d D 1.13 83/03/09 20:03:19 mjb 13 12
c fixed a divide by zero
e
s 00000/00000/00478
d D 1.12 83/03/09 14:27:52 mjb 12 11
c 
e
s 00005/00004/00473
d D 1.11 83/03/08 21:10:21 mjb 11 10
c fixed up reverse labeling
e
s 00015/00012/00462
d D 1.10 83/03/08 18:43:37 mjb 10 9
c 
e
s 00002/00001/00472
d D 1.9 83/03/08 17:03:30 mjb 9 8
c 
e
s 00007/00001/00466
d D 1.8 83/03/08 13:41:08 mjb 8 7
c 
e
s 00015/00004/00452
d D 1.7 83/03/07 23:15:19 mjb 7 6
c fixed axis edit bugs, tick labeling bugs, menu.tex
e
s 00001/00001/00455
d D 1.6 83/03/07 06:58:21 mjb 6 5
c 
e
s 00055/00042/00401
d D 1.5 83/03/07 00:09:43 mjb 5 4
c 
e
s 00000/00000/00443
d D 1.4 83/03/04 13:44:53 mjb 4 3
c 
e
s 00001/00001/00442
d D 1.3 83/03/03 22:31:45 mjb 3 2
c 
e
s 00036/00026/00407
d D 1.2 83/03/03 17:37:15 mjb 2 1
c fixed bugs with x/y plotting and logarithmic axis stuff
e
s 00433/00000/00000
d D 1.1 83/03/02 22:26:16 mjb 1 0
c date and time created 83/03/02 22:26:16 by mjb
e
u
mjb
tes
U
t
T
I 1
D 16
subroutine grapha 
E 16
I 16
subroutine grapha (ytdism)
E 16
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set graph attributes via users values                  #
#                                                                      #
#     Input Parameters:                                                #
D 16
#            None                                                      #
E 16
I 16
#            ytdism - y axis tick distance multiplier                  #
E 16
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################
I 16
real ytdism
E 16

D 5
integer i, j, k, icurve, itemp, color
E 5
I 5
D 10
integer i, j, k, ibar, icurve, itemp, iclust, color
E 10
I 10
integer i, j, k, ibar, icurve, itemp, iclust, color, tmxpts
E 10
E 5

D 7
SHORTINT istitl, deflt
E 7
I 7
SHORTINT istitl, deflt, idreal, dpreal
E 7
integer gimnmx

D 14
real rtemp1, rtemp2, rmin, rmax, chrsiz, xlegnd, ylegnd, xcentr
E 14
I 14
real rtemp1, rtemp2, rmin, rmax, chrsiz, xlegnd, ylegnd, xcentr, bmax
E 14

include(`gattcom')

# Assumptions:
#   - the common block 'gphcom' has been updated and properly set for
#     outputting a graph       

icurve = 0
do i = 1, 5 {   
   if (bgddef(i) > 0) icurve = icurve + 1 # Determine number of curves
   ntpray(i) = bgddef(i)                  # initialize integer version of 
   }                                      # number of points per curve
I 2
if (bgadfg(1) == BIGY & bgaxis(1) != BIGP) {
   icurve = icurve - 1
   }
E 2

D 2
# determine maximum number of points
maxpts = max0 (ntpray(1), ntpray(2), ntpray(3), ntpray(4), ntpray(5))
E 2
I 2
maxpts = 0
if (icurve > 0) {
   # determine maximum number of points
   maxpts = max0 (ntpray(1), ntpray(2), ntpray(3), ntpray(4), ntpray(5))
E 2

D 2
if (bgadfg(1) == BIGY) {   # If using curve data for independent axis
   maxpts = ntpray(bgadcv) # use its number of points for maxpts
   }
E 2
I 2
   # If using curve data for independent axis
   if (bgadfg(1) == BIGY & bgaxis(1) != BIGP) {
      maxpts = ntpray(bgadcv)           # use its number of points for maxpts
      }
E 2

D 2
# determine minimum number of points for stacking purposes
if (bgstfg(1) == BIGY) {   # maxpts will be minimum pts 
E 2
I 2
   # determine minimum number of points for stacking purposes
   if (bgstfg(1) == BIGY) {   # maxpts will be minimum pts 
      do i = 1, 5 {
         if (ntpray(i) != 0)
            maxpts = min0 (maxpts, ntpray(i))
         }
      }
   
   # convert/unpack graph data to real 
   j = 1
   k = 1
E 2
   do i = 1, 5 {
D 2
      if (ntpray(i) != 0)
         maxpts = min0 (maxpts, ntpray(i))
E 2
I 2
      if (bgddef(i) > 0) {
         call cvreal (ntpray(i), bgdta1(j), zydata(k))
         }
      k = k + 75
      j = j + 375
E 2
      }
D 2
   }
E 2
I 2
   }        # END of icurve test
E 2

D 2
# convert/unpack graph data to real 
j = 1
k = 1
do i = 1, 5 {
   if (bgddef(i) > 0) {
      call cvreal (ntpray(i), bgdta1(j), zydata(k))
      }
   k = k + 75
   j = j + 375
   }

E 2
rmin = 0.   # Initialize axis extents
rmax = 0.
zdmin = 0.
zdmax = 0.
I 10
iclust = 1
E 10
D 2

# Specify x and y axis ranges

E 2
I 2
   
   # Specify x and y axis ranges
   
E 2
D 9
if (maxpts > 0) {  # Make sure at least one curve defined
E 9
I 9
D 10
if (maxpts > 1) {  # Make sure at least one curve defined
E 10
I 10
if (maxpts > 0) {  # Make sure at least one curve defined
E 10
E 9

   if (bgigfg(1) == BIGY) {          # Gridding on/off
      itemp = bgigst
      color = bgigcl
      if (bgbard(1) == BIGV) 
         call xgrid (2, color, itemp)
      else 
	 call ygrid (2, color, itemp)
      }
   if (bgdgfg(1) == BIGY) {          # Gridding on/off
      itemp = bgdgst
      color = bgdgcl
      if (bgbard(1) == BIGV) 
         call ygrid (2, color, itemp)
      else 
	 call xgrid (2, color, itemp)
      }

   rtemp1 = 0.0
   if (bgblfg(1) == BIGY) {            # user has defined a baseline
      call cvreal (1, bgblin, rtemp1)  # set the baseline
      call baslin (rtemp1, ON)
      }

   if (bgbard(1) == BIGH) {
      call bardir (1)        # Specify bar direction if specified
      }

   # determine default min, max for DEPENDENT axis                

   call gfmnmx 
   # rtemp1 contains current baseline
   if (zdmin > rtemp1) { 
      zdmin = rtemp1 
      }

   # Specify default tic values for (dependent) axis
D 5
   call neatic (zdmin, zdmax, 10, zdmin, zdmax, glabel(2))
E 5
I 5
D 10
   if (bgdatp <= 3) {
E 10
I 10
   if (bgdatp <= 3 | maxpts == 1) {
E 10
      call neatic (zdmin, zdmax, 10, zdmin, zdmax, glabel(2))
      }
E 5

   deflt = YES                          # Initialize default conditions flag
   if (bgdatp != 1) deflt = NO

   # If user defines min max values etc. for dependent axis use them
   if (bgdstr(1) != NUL) { 
      deflt = NO
      call cvreal (1, bgdstr, zdmin) 
      } 
   if (bgdend(1) != NUL) {
      deflt = NO
      call cvreal (1, bgdend, zdmax)  
      }

   # Set the axis range
   if (bgbard(1) == BIGV) call yrange (zdmin, zdmax)
   else                   call xrange (zdmin, zdmax)

   # Set the dependent axis tic positions
   zdstic = zdmin
   zdetic = zdmax

   # If user defines increment for axis use it to determine number of labels
   # and adjust range if not a "neat" increment
D 5
   if (bgdinc(1) != NUL) {
E 5
I 5
   if (bgdinc(1) != NUL & bgdatp <= 3) {
E 5
      deflt = NO
      call cvreal (1, bgdinc, rtemp1)
      if (rtemp1 != 0) {
D 11
         rtemp2 = ((zdmax-zdmin) / abs(rtemp1)) + 1.
E 11
I 11
         rtemp2 = abs(((zdmax-zdmin) / abs(rtemp1))) + 1.
E 11
         glabel(2) = rtemp2
         if (float(glabel(2)) < rtemp2) {
            zdetic = zdmin + rtemp1 * float(glabel(2))
	    zdmax = zdetic
	    glabel(2) = glabel(2) + 1
	    }
	 }
      else {
	 glabel(2) = 0
	 }
      }

   # determine whether to use real labeling or not
I 7
   dpreal = YES
E 7
   if ((zdmax >= 5.0 & deflt == YES) | bgdatp == 2 | bgdatp == 4) {
I 7
      dpreal = NO
E 7
      if (bgbard(1) == BIGV) call yreal (1)
      else call xreal (1)
      }

   # determin default min, max for INDEPENDENT axis

   deflt = YES                      # Initialize default conditions flag
   if (bgnatp != 1 | bgadfg(1) == BIGY) deflt = NO

   rmin = 1.0
   rmax = maxpts
I 5
   glabel(1) = maxpts
E 5
   if (bgadfg(1) == BIGY & bgaxis(1) != BIGP) {   # using curve data instead
      itemp = bgddef(bgadcv)
      i = (bgadcv-1) * 75 + 1
      call minmax (itemp, zydata(i), rmin, rmax)
      }
	 
I 14
   bmax = rmax                  # Save "real" data max for bar width calc.

E 14
I 5
   iclust = bgclus
I 9
D 10
   iclust = max0 (1, iclust)
E 10
E 9
   # Determin actual number of clusters
   ibar = 0
   do i = 1, 5
      if (bgcvtp(i) == BAR & bgddef(i) > 0) ibar = ibar + 1

   iclust = gimnmx (ibar, 1, iclust)
D 6
   call clustr (itemp)               # set the cluster factor
E 6
I 6
   call clustr (iclust)               # set the cluster factor
E 6

E 5
   # Specify default tic/label values for x (independent) axis
D 3
   if (maxpts <= 12) {
E 3
I 3
D 5
   if (maxpts <= 12 | (bgaxis(1) != BIGP & bgnatp == 6)) {
E 3
      call neatic (rmin, rmax, maxpts, rmin, rmax, glabel(1))
E 5
I 5
D 13
   if (bgaxis(1) == BIGN & bgnatp < 4 & ibar == 0) {
E 13
I 13
   if (bgaxis(1) == BIGN & bgnatp < 4 & 
      (ibar == 0 | (ibar > 0 & maxpts == 1))) {
E 13
      if (maxpts <= 12) {
         call neatic (rmin, rmax, maxpts, rmin, rmax, glabel(1))
         }
      else {
         call neatic (rmin, rmax, 10, rmin, rmax, glabel(1))
         }
E 5
      }
D 5
   else {
      call neatic (rmin, rmax, 10, rmin, rmax, glabel(1))
E 5
I 5
   
I 10
   tmxpts = maxpts
   if (maxpts == 1) tmxpts = 3

E 10
   # Set the independent axis tic positions before we "push" out axis range
   zstart = rmin
   zperid = rmax
   zistic = rmin
   zietic = rmax

   if (ibar > 0 & ((bgnatp != 4 & bgnatp != 5 & bgaxis(1) == BIGN) |
       bgaxis(1) == BIGP)) { 
      # We had at least one bar curve
D 10
      rtemp1 = (rmax-rmin) / float(maxpts-1)
E 10
I 10
      rtemp1 = (rmax-rmin) / float(tmxpts-1)
E 10
      rmin = rmin - rtemp1
      rmax = rmax + rtemp1
E 5
      }

   if (bgaxis(1) == BIGN) {            # NUMERIC CASE

      # If user defines min max values etc. for independent axis use them
I 5

E 5
      if (bgnatp != 6) {
         if (bgnstr(1) != NUL) { 
            deflt = NO
            call cvreal (1, bgnstr, rmin) 
I 5
            zstart = rmin
	    zistic = rmin
E 5
            } 
         if (bgnend(1) != NUL) {
            deflt = NO
            call cvreal (1, bgnend, rmax)  
I 5
            zperid = rmax
	    zietic = rmax
E 5
            }
D 5
	 zstart = rmin
	 zperid = rmax
E 5
	 }
      
      if (bgnatp == 6) {                # Yearly labels special case
	 zstart = 1.0                   # initialize defaults
D 10
	 glabel(1) = maxpts
E 10
I 10
	 glabel(1) = tmxpts
E 10
D 5
	 zperid = maxpts
E 5
         if (bgnstr(1) != NUL) { 
            call cvreal (1, bgnstr, zstart) 
            } 
         if (bgnend(1) != NUL) {
            call cvreal (1, bgnend, zperid)  
            }
I 5
         else {
D 10
	    zperid = zstart + maxpts - 1
E 10
I 10
	    zperid = zstart + tmxpts - 1
E 10
	    }
E 5
         if (bgninc(1) != NUL) {
            call cvreal (1, bgninc, rtemp1)
	    if (rtemp1 != 0) {
D 11
               rtemp2 = ((zperid-zstart) / abs(rtemp1)) + 1.
E 11
I 11
               rtemp2 = abs(((zperid-zstart) / abs(rtemp1))) + 1.
E 11
	       glabel(1) = rtemp2
	       if (float(glabel(1)) < rtemp2) {
		  rtemp2 = rtemp1 * float(glabel(1))
D 5
	          zietic = rmin + rtemp2
E 5
		  zperid = zstart + rtemp2
		  glabel(1) = glabel(1) + 1
	          }
D 5
	       rmax = glabel(1)
E 5
I 5
	       rmax = glabel(1) 
	       zietic = rmax
	       if (ibar > 0)      # We have a bar chart
		  rmax = rmax + 1.0
E 5
	       }
            else {
	       glabel(1) = 0
	       }  
            }
         }
      }
D 5
   if (bgaxis(1) == BIGP) {            # PERIODIC CASE
E 5
I 5
   else if (bgaxis(1) == BIGP) {            # PERIODIC CASE
E 5

      zstart = 1.0
      if (bgpatp <= 2) { # Initialize for default days (7)
	 zperid = 7.
D 10
         zpnum = float(maxpts) / 7.
E 10
I 10
         zpnum = float(tmxpts) / 7.
E 10
         }
      else if (bgpatp == 3 | bgpatp == 4) { # Initialize for default days (5)
	 zperid = 5.
D 10
         zpnum = float(maxpts) / 5.
E 10
I 10
         zpnum = float(tmxpts) / 5.
E 10
         }
      else if (bgpatp == 5 | bgpatp == 6) { # Initialize for default months
	 zperid = 12.
D 10
         zpnum = float(maxpts) / 12.
E 10
I 10
         zpnum = float(tmxpts) / 12.
E 10
         }
      else if (bgpatp == 7) { # Initialize for default quarterly
	 zperid = 4.
D 10
         zpnum = float(maxpts) / 4.
E 10
I 10
         zpnum = float(tmxpts) / 4.
E 10
         }
              
      if (bgpstr(1) != NUL) {            # If user specified start period
         call cvreal (1, bgpstr, zstart) 
	 }
      if (bgpnum(1) != NUL) {            # If user specified number of periods
	 call cvreal (1, bgpnum, zpnum)
	 }

       rmax = zpnum * zperid
I 5
       zietic = rmax
I 7
       if (ibar > 0)      # We have a bar chart
	  rmax = rmax + 1.0
E 7
E 5
       }

D 5
   # Set the independent axis tic positions before we "push" out axis range
   zistic = rmin
   zietic = rmax

E 5
   # If user defines increment for axis use it to determine number of labels
   # and adjust last tic position if not a "neat" increment
D 2
   if (bgninc(1) != NUL & bgaxis(1) != BIGP & bgnatp != 6) {
E 2
I 2
   if (bgninc(1) != NUL & bgaxis(1) != BIGP & bgnatp < 4) {
E 2
      deflt = NO
      call cvreal (1, bgninc, rtemp1)
      if (rtemp1 != 0) {
D 11
         rtemp2 = ((rmax-rmin) / abs(rtemp1)) + 1.
E 11
I 11
         rtemp2 = abs(((rmax-rmin) / abs(rtemp1))) + 1.
E 11
         glabel(1) = rtemp2
         if (float(glabel(1)) < rtemp2) {
            zietic = rmin + rtemp1 * float(glabel(1))
	    zperid = zietic
	    glabel(1) = glabel(1) + 1
	    }
	 }
      else {
	 glabel(1) = 0
	 }
      }

   # Set the axis range based on whether we have bar graphs, and indent flag

   if ((bgaxis(1) == BIGP & bgpain(1) == BIGY) | 
       (bgaxis(1) == BIGN & bgnain(1) == BIGY & 
D 5
       (bgnatp != 5 | bgnatp != 4))) {
E 5
I 5
       bgnatp != 5 & bgnatp != 4)) {
E 5
      rtemp1 = .10 * (rmax - rmin)
      rmin = rmin - rtemp1
      rmax = rmax + rtemp1
      }

D 5
   # We wait until graph extents are calculated before calling axis range 
   # routines (need to determine if bars are needed and default bar widths)
E 5
I 5
   # Set independent axis range here
E 5

I 5
   if (bgbard(1) == BIGV) call xrange (rmin, rmax)
   else                   call yrange (rmin, rmax)

E 5
   # determine whether to use real labeling or not
I 7
   idreal = YES
E 7
D 11
   if (deflt == YES | bgnatp == 2 | bgnatp == 4 | bgnatp == 6) {
E 11
I 11
   if ((deflt == YES | bgnatp == 2 | bgnatp == 4 | bgnatp == 6) &
      maxpts != 1) {
E 11
I 7
      idreal = NO
E 7
      if (bgbard(1) == BIGV) call xreal (1)
      else call yreal (1)
      }

   }                   # END OF MAXPTS LOOP

   # * Specify all Title etc. attributes

   do i = 1, 5 {
      gfont(i) = bgtfnt(i)
      zchrsz(i) = bgtsiz(i)
      gcolor(i) = bgtclr(i)
      }

   rtemp1 = 100.0                  # Initialize rtemp1 to top of graph
   rtemp2 = amax1 (zchrsz(1), 5.0) # Initialize rtemp2 to Title size
   chrsiz = 2.0 
   
   # check for a TITLE string
   if (istitl(bgtitl) > 0) {        # If title set x,y postions
      ytitle(1) = rtemp1 - rtemp2 - rtemp2*.30
      ytitle(2) = ytitle(1) - zchrsz(2) - rtemp2*.40
      chrsiz = zchrsz(1)
      rtemp1 = ytitle(1)
      }
   else {
      rtemp2 = amax1(zchrsz(2), 5.0) # If no title treat Subtitle as Title    
      ytitle(2) = rtemp1 - rtemp2 - rtemp2*.30
      }
   
   if (istitl(bgsitl) > 0) {         # Check for Sub - Title
      chrsiz = zchrsz(2)
      rtemp1 = ytitle(2)
      }
D 19
  
   rtemp2 = amax1(chrsiz*.40, 2.5)# Specify current y maximum for graph extents
   rtemp1 = rtemp1 - rtemp2       # based on last chrsiz of the last title and 
E 19
I 19

   if (istitl(bgdtit) > 0) {            # Check for Dependent - Title
      ytitle(4) = rtemp1 - chrsiz - rtemp2*.30               
      rtemp2 = amax1(zchrsz(3)*.40, 2.5)
      rtemp1 = ytitle(4) - rtemp2
      if (rtemp1 > 90.0) ytitle(4) = 90.0 + rtemp2
      }
   else {
      rtemp2 = amax1(chrsiz*.40, 5.0)
      rtemp1 = rtemp1 - rtemp2
      }
				  # Specify y axis extents
                                  # based on last chrsiz of the last title and 
E 19
   zymax = amin1 (rtemp1, 90.)    # its position with a minimum of at least 90.  
   # Determine placement of x - axis based on character size
   rtemp1 = amax1 (zchrsz(3), 3.0)
   ytitle(3) = rtemp1 + rtemp1*.40 + 2.
   
   xtitle(4) = 3.0
   
D 19
   rtemp2 = zchrsz(3)*.40            # determine placement of y axis title
   ytitle(4) = zymax + amax1 (rtemp2, zchrsz(5), 3.0)
                                     # based on y axis char size and label size

E 19
   # Calculate all graph extents base on various character sizes etc.

   rtemp1 = zchrsz(5)             # Calculate x minimum for graph extents      
   if (gfont(5) == 1) {           # We have a hardware font
      itemp = zchrsz(5)           # calulate xmin based on actual hardware
      call qsthsz(itemp, i, j)    # j contains realized text height
D 16
      rtemp1 = float(i) / 327.68 # Percentage of screen 32767/100
E 16
I 16
      rtemp1 = float(i) / 327.68  # Percentage of screen 32767/100
      rtemp1 = rtemp1 * ytdism    # Take into account viewport percentage
E 16
      }

D 7
   i = 4                          
   rtemp2 = abs(rmax)
   if (bgbard(1) == BIGH) rtemp2 = zdmax
E 7
I 7
   i = 1                          
   rtemp2 = abs(zdmax)            # Maximum dependent data value
   if (bgbard(1) == BIGV & dpreal == YES) i = 4
   if (bgbard(1) == BIGH) {
      rtemp2 = abs(rmax)
      if (idreal == YES) i = 4
      }

E 7
   while (rtemp2 > 1.0) {           # y data value, get number of chars needed
      i = i + 1
      rtemp2 = rtemp2 / 10.0
      }

   # determine space needed on y axis
   rtemp1 = rtemp1 * float(i) + 2.0  # Add two for tics position space
   
   zxmin = amax1 (10.0, rtemp1)       # allow at least 5 char labels
   
   zxmax = 90.                        # current x max is set to 90.
   
   # Calculate y minimum for graph extents based on x-axis title postion
   rtemp1 = ytitle(3) + zchrsz(5)*.40 + zchrsz(5) + 1.6 
   zymin = amax1 (10.0, rtemp1)
   
   zxmin = amin1 (70., zxmin)
   zymin = amin1 (40., zymin)      # Make sure at least a small graph is seen
   zymax = amax1 (60., zymax)
   
   call grext (zxmin, zxmax, zymin, zymax)

   # Determine x center point of graph to center "x" titles on
   xcentr = (zxmax-zxmin)/2. + zxmin
   xtitle(1) = xcentr
   xtitle(2) = xcentr
   xtitle(3) = xcentr

D 18
   # Set the legend positions based on graph extents (6.25 % from upper left)
E 18
I 18
   if (maxpts > 0) {
      # Set the legend positions based on graph extents (6.25 % from upper left)
E 18

D 18
   rtemp1 = zxmax - zxmin          # Calculate percent of screen on x axis
   rtemp2 = zymax - zymin          # Calculate percent of screen on y axis

   if (bglgfg(1) == BIGY) {
      xlegnd = zlegxy(1)
      if (zlegxy(1) == 0.0) {              # in a default condition
         xlegnd = zxmin + .0625*(rtemp1)
E 18
I 18
      rtemp1 = zxmax - zxmin          # Calculate percent of screen on x axis
      rtemp2 = zymax - zymin          # Calculate percent of screen on y axis
   
      if (bglgfg(1) == BIGY) {
         xlegnd = zlegxy(1)
         if (zlegxy(1) == 0.0) {              # in a default condition
            xlegnd = zxmin + .0625*(rtemp1)
            }
         ylegnd = zlegxy(2)
         if (zlegxy(2) == 0.0) {              # In a default condition
            ylegnd = zymax - .0625*(rtemp2)
            }
         call legend (xlegnd, ylegnd, icurve, gfont(4), zchrsz(4), gcolor(5))
E 18
         }
D 18
      ylegnd = zlegxy(2)
      if (zlegxy(2) == 0.0) {              # In a default condition
         ylegnd = zymax - .0625*(rtemp2)
E 18
I 18
   
      # Determine bar width based on cluster factor x axis extents (rtemp1)
      if (bgbarw(1) == NUL) {    # need to set a default bar width
   
         # If horizontal bars use y axis extents
         if (bgbard(1) == BIGH) rtemp1 = rtemp2
   
         # If axis is indented decrease percent of viewport by 16%
         if ((bgaxis(1) == BIGN & bgnain(1) == BIGY) | 
         (bgaxis(1) == BIGP & bgpain(1) == BIGY)) rtemp1 = rtemp1 - 16.
   
         rtemp1 = rtemp1 / float(tmxpts + 1)
         rtemp1 = rtemp1 * .80 / float(iclust)
         rtemp1 = rtemp1 * abs(bmax - zistic) / abs(zietic - zistic)
E 18
         }
D 18
      call legend (xlegnd, ylegnd, icurve, gfont(4), zchrsz(4), gcolor(5))
      }

D 5
   itemp = bgclus
   # Determin actual number of clusters
   j = 0
   do i = 1, 5
      if (bgcvtp(i) == BAR & bgddef(i) > 0) j = j + 1

   itemp = gimnmx (j, 1, itemp)
   call clustr (itemp)               # set the cluster factor
   
E 5
D 8
   # Determine bar width based on cluster factor x axis extents
E 8
I 8
   # Determine bar width based on cluster factor x axis extents (rtemp1)
E 8
   if (bgbarw(1) == NUL) {    # need to set a default bar width
I 8

      # If horizontal bars use y axis extents
      if (bgbard(1) == BIGH) rtemp1 = rtemp2

      # If axis is indented decrease percent of viewport by 16%
E 8
I 2
      if ((bgaxis(1) == BIGN & bgnain(1) == BIGY) | 
      (bgaxis(1) == BIGP & bgpain(1) == BIGY)) rtemp1 = rtemp1 - 16.
I 8

E 8
E 2
D 10
      rtemp1 = rtemp1 / float(maxpts + 1)
E 10
I 10
      rtemp1 = rtemp1 / float(tmxpts + 1)
E 10
D 5
      rtemp1 = rtemp1 * .80 / float(itemp)
E 5
I 5
      rtemp1 = rtemp1 * .80 / float(iclust)
I 14
      rtemp1 = rtemp1 * abs(bmax - zistic) / abs(zietic - zistic)
E 14
E 5
      }
   else {
      call cvreal (1, bgbarw, rtemp1)
      }
   call barwid (rtemp1)
E 18
I 18
      else {
         call cvreal (1, bgbarw, rtemp1)
         }
      call barwid (rtemp1)
      } 
E 18
D 5

   # Set independent axis range here

D 2
   if (j > 0) {               # We had at least one bar curve
E 2
I 2
   if (j > 0 & ((bgnatp != 4 | bgnatp != 5) & bgaxis(1) != BIGP)) { 
      # We had at least one bar curve
E 2
      rtemp1 = (rmax-rmin) / float(maxpts-1)
      rmin = rmin - rtemp1
      rmax = rmax + rtemp1
      }

   if (bgbard(1) == BIGV) call xrange (rmin, rmax)
   else                   call yrange (rmin, rmax)
E 5

   return
end
E 1
