/************************************************************************/
/*				yyparse.c				*/
/*      parser for yacc output                                          */
/************************************************************************/

/************************************************************************/   
/*                              contents                                */    
/*                                                                      */    
/*    yyParse		Master parse routine.				*/
/*  * yyA<nnn>		Action functions created from user action code. */
/*									*/
/* * Local to this file.                                                */  
/*                                                                      */ 
/************************************************************************/ 
    
    
/************************************************************************/ 
/*                              history                                 */ 
/*                                                                      */ 
/* 85Nov22 CrT  Below fouled up YYACCEPT/YYERROR.  Fixed.               */ 
/* 85Nov18 CrT	User action chunks are now placed in functions rather	*/
/*              than switch cases.  The functions are accessed by an    */ 
/*              array of function pointers.  This is because many       */ 
/*              compilers have low limits on the size of functions,     */ 
/*              switch statements, and the number of cases in a         */ 
/*              switch statement.  In addition, some compilers implement*/ 
/*              switch statements with a cascade of comparisons rather  */ 
/*		than a jump table.  This required making yypvt global	*/
/*		instead of being private to yyParse.			*/
/*									*/
/* 81Aug27 RBD	Modified for use with DECUS LEX 			*/
/*              Variable "yylval" resides in yylex(), not in yypars();  */ 
/*              Therefore, is defined "extern" here.                    */ 
/*                                                                      */ 
/*              Also, the command line processing for the Decus version */ 
/*              has been changed.  A new switch has been added to allow */ 
/*              specification of the "table" file name(s), and unused   */ 
/*              switch processing removed.                              */ 
/*                               NOTE                                   */ 
/*              This probably won't run on UNIX any more.               */ 
/*                                                                      */ 
/* 7?????? SCJ  Created.                                                */ 
/*                                                                      */ 
/*                              credits                                 */ 
/*      CrT=CrT                                                         */  
/*      RBD=Bob Denny                                                   */  
/*      SCJ=Steven C Johnson.                                           */  
/*      SG =Scott Guthery                                               */  
/************************************************************************/ 

# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)


YYSTYPE yyv[YYMAXDEPTH];        /* Runtime stack.              */
int	yydebug   = 0;		/* 1 for debugging.	       */
int	yychar	  = -1; 	/* Current input token number. */
int	yynerrs   = 0;		/* Number of errors.	       */
short	yyerrflag = 0;		/* Error recovery flag.        */
YYSTYPE *yypvt;

yyparse() {
    short	       yys[ YYMAXDEPTH ];
    short	       yyj, yym;
    register short     yystate, *yyps, yyn;
    register YYSTYPE   *yypv;
    register short     *yyxi;

    yystate   =  0;
    yychar    = -1;
    yynerrs   =  0;
    yyerrflag =  0;
    yyps      = &yys[-1];
    yypv      = &yyv[-1];

yystack:    /* Put a state and value onto the stack: */

    if (yydebug)   printf( "state %d, char 0%o\n", yystate, yychar );

    if (++yyps> &yys[YYMAXDEPTH]) {
	yyerror( "yacc stack overflow" );
	return 1;
    }
    *yyps = yystate;
    ++yypv;

#ifdef UNION
   yyunion(yypv, &yyval);
#else
   *yypv = yyval;
#endif

yynewstate:

    yyn = yypact[ yystate ];

    if (yyn <= YYFLAG)	 goto yydefault;	/* Simple state. */

    if (yychar < 0)   if ((yychar = yylex())  <  0)   yychar = 0;

    if ((yyn += yychar) < 0   ||   yyn >= YYLAST)   goto yydefault;

    if (yychk[ yyn = yyact[ yyn ] ]   ==   yychar) {

	/* Valid shift: */
	yychar = -1;

#ifdef UNION
	  yyunion(&yyval, &yylval);
#else
      yyval = yylval;
#endif

	yystate = yyn;
	if (yyerrflag > 0)   --yyerrflag;
	goto yystack;
    }

yydefault:
    /* Default state action: */

    if ((yyn = yydef[ yystate ])   ==	-2) {

	if (yychar < 0)   if ((yychar = yylex())  <  0)    yychar = 0;

	/* Look through exception table: */

	for (
	    yyxi = yyexca
	    ;
	    (*yyxi != (-1))   ||   (yyxi[1] != yystate)
	    ;
	    yyxi += 2
	);						/* VOID    */

	for (yyxi += 2;   *yyxi >= 0;	yyxi += 2) {

	     if (*yyxi == yychar)   break;
	}

	if ((yyn = yyxi[1])   <   0)   return  0;	/* Accept. */
    }

    if (!yyn) {

	/* Error.   Attempt to resume parsing: */

	switch (yyerrflag) {

	case 0:   /* Brand new error. */

	    yyerror( "syntax error" );
yyerrlab:
	    ++yynerrs;

	case 1:
	case 2: /* Incompletely recovered error. Try again: */

	    yyerrflag = 3;

	    /* Find a state where "error" is a legal shift action: */

	    while (yyps >= yys) {

		yyn = yypact[ *yyps ] + YYERRCODE;

		if (
		    yyn >= 0
		    &&
		    yyn < YYLAST
		    &&
		    yychk[ yyact[ yyn ]] == YYERRCODE
		) {
		    yystate = yyact[ yyn ];  /* Simulate a shift of "error" */
		    goto yystack;
		}
		yyn = yypact[ *yyps ];

		/* The current yyps has no shift onn "error", pop stack */

		if (yydebug) {
		    printf(
			"Error recovery pops state %d, uncovers %d\n",
			*yyps,
			yyps[-1]
		    );
		}
		--yyps;
		--yypv;
            }

	    /* There is no state on the stack with an error shift. Abort. */

yyabort:
	    return(1);


	case 3:  /* No shift yet; clobber input char: */
	    if (yydebug) {
		printf( "error recovery discards char %d\n", yychar );
	    }
	    if (yychar == 0)   goto yyabort; /* Don't discard EOF, quit. */
	    yychar = -1;
	    goto yynewstate;   /* Try again in the same state. */
	}
    }

    /* Reduction by production yyn: */

    if (yydebug)   printf( "reduce %d\n", yyn );
    yyps -= yyr2[ yyn ];
    yypvt = yypv;
    yypv -= yyr2[ yyn ];

#ifdef UNION
   yyunion(&yyval, &yypv[1]);
#else
   yyval = yypv[1];
#endif

   yym	= yyn;

   /* Consult goto table to find next state: */
   yyn = yyr1[	yyn ];
   yyj = yypgo[ yyn ] + *yyps + 1;

   if (
       yyj >= YYLAST
       ||
       yychk[ yystate = yyact[yyj] ] != -yyn
   ) {
       yystate	= yyact[ yypgo[ yyn ]];
   }

#ifdef OLD
   /* Invoke desired action: */
   switch (yym) {
/*    %A					*/
   }
#else
    /* Invoke appropriate action function for this reduction: */
    switch ((*(yyActionIndex[ yym ]))()) {
    case 0: return 0;	/* YYERROR  action  */
    case 1: return 1;	/* YYACCEPT action  */
    default: ;
    }
#endif
 
   goto yystack;  /* Stack new state and value. */

}

/***********************************************************************/
/* Null action function:					       */
/***********************************************************************/ 
yyANop() { return -1; }
 
/***********************************************************************/
/* Action functions constructed from user-supplied action code chunks: */ 
/***********************************************************************/ 
$A

 
