/************************************************************************/
/*                              y1.c                                    */  
/*  YACC source file #1 (of 4).                                         */  
/************************************************************************/  
   
/************************************************************************/  
/*                              contents                                */  
/*                                                                      */  
/*    y1ArrayFill	Set elements 0 through n-1 to c.		*/
/*  * y1CharCopy        Copy str q into p, returning next free char ptr.*/
/*  * y1CheckEmpty	Mark nonterminals which derive the empty string.*/
/*    y1Closure 	Generate the closure of state i.		*/
/*    y1Error           Write out fatal error comment.                  */
/*  * y1First		Compute an array with the FIRSTS of nonterminals*/
/*    y1GetChar 	Get one input char.				*/
/*  * y1Lookahead       Return lookahead set.                           */
/*  * y1MakeStates      Generate the states.                            */
/*    main								*/
/*  * y1PrintLookahead	Print lookahead.				*/
/*    y1PutItem 							*/
/*  * y1PutRest 	Put out other arrays, copy the parsers. 	*/
/*  * y1SetUnion	A gets union of A and B.			*/
/*    y1State		Sort last state, check it, return state #.	*/
/*  * y1Summary 	Write the summary on the terminal.		*/
/*    y1SymbolName	Return a pointer to the name of symbol i.	*/
/*    y1UngetChar	Unget one char. 				*/
/*    y1WriteItem	Creates output string for item pointed to by pp.*/
/*  * y1Yield           List productions YIELDING each nonterminal.     */
/*									*/
/* * Local to this file.                                                */
/*									*/
/************************************************************************/
   
/************************************************************************/  
/*                              history                                 */  
/*                                                                      */  
/* 85Nov14 CrT  Global variable names decrypted.                        */
/* 85Nov13 CrT	Give plaintiff routine in error messages.		*/
/* 85Nov11 CrT  Function names decrypted. Still unique in first 6 chars.*/
/* 85Nov10 CrT	y1.c reconstructed from 18 (!) subfiles.  Cosmetics.	*/
/* 83Dec25 SG	Questions and suggestions on the IBM PC version of YACC */
/*              can be directed to Scott Guthery, 11100 Leafwood Lane,  */ 
/*              Austin, Texas,  78750.  Telephone: 512 258-1342.        */ 
/*                                                                      */ 
/* 83Dec25 SG   Added #ifdef UNION entries in yypars.c so that YACC     */ 
/*              can be used with C compilers that do not support the    */ 
/*              assignment of unions and structures.  If you use        */ 
/*              the %union construct (see LANDY.Y for example) and your */ 
/*              C compiler doesn't support union assignment, then       */ 
/*              you have to write a routine                             */ 
/*                           yyunion(to, from)                          */ 
/*                           YYSTYPE *to, *from;                        */ 
/*              which achieves the assignment of the %union.  If your   */ 
/*              C compiler does support structure and union assignment  */ 
/*              then undefine UNION in yypars.c.                        */ 
/*                                                                      */ 
/* 83Dec25 SG   Adapted YACC for IBM PC using the DeSmet C compiler.    */ 
/*                                                                      */ 
/* 83Apr12 RBD  Add symbolic exit status.                               */  
/* 83Apr12 RBD	Additions and minor changes for running YACC under	*/
/*              VAX-11 C.  The newer versions of the files in this      */ 
/*              UIC are the proper ones, and should run OK under        */ 
/*              RSX & RT.  I have not purged the old ones because       */ 
/*              I have not tested the new ones.                         */ 
/*                                                                      */ 
/* 82Mar22 RBD  Minor changes to accommodate the new DECUS library and  */ 
/*              compiler. Command file changed to take advantage of the */ 
/*              '-m' switch to disable the preprocessor phase of the    */ 
/*              compiler, since MP is used.  'iovtoa()' changed to      */ 
/*              'fgetname()'.  ODL slightly changed.  Added header to   */ 
/*              output file to tell the name of the input file and the  */ 
/*              date and time of generation.                            */ 
/*                                                                      */ 
/* 81Aug28 RBD  Changed to make debug code conditionally compile.       */
/*                                                                      */ 
/* 81Aug28 RBD	All of the debug stuff has been turned off. This makes	*/
/*              for a much easier to read YACC.OUT file.                */ 
/*                                                                      */ 
/* 81Aug28 RBD	The options accepted by Yacc have been changed. The	*/
/*              changes were all in YSETUP.2C. See the docs.            */ 
/*                                                                      */ 
/* 81Aug28 RBD  In using YACC with Forsythe's LEX, the variable         */ 
/*              "yylval" was found to be declared in both YACC's        */ 
/*              output c source (yypars()) and in LEX. Apparently, the  */ 
/*              UNIX LEX assumes that yylval is in YACC. Because LEX    */ 
/*              sees so much use with other than YACC, we chose to      */ 
/*              leave yylval declared in LEX. So the YACC module        */ 
/*              YSETUP.2C was modified to emit "extern YYSTYPE yylval"  */ 
/*              when compiled by the Decus compiler or MP processor.    */ 
/*                                                                      */ 
/* 81Aug28 RBD  Much has happened since the last entry. Yacc has been   */ 
/*              brought up on RSX-11M, along with changes in the        */ 
/*              command string outlined below.                          */ 
/*                                                                      */ 
/* 80Dec18 RBD	Add conditional code for Decus for tempfile deletion.	*/
/* 80Dec06 RBD  Original code broken out of y1.c.                       */ 
/* 80Dec05 RBD	MP has been fixed. Note the 'beauty' prettyprinter	*/
/*              was distributed in this UIC, but it's been deleted.     */ 
/*                                                                      */ 
/* 80Dec04 RBD  Include files and their names need looking at.          */ 
/* 80Dec04 RBD  MP preprocessor inserts a ' ' at the beginning of       */ 
/*              a text substitution. Otherwise, it looks like it        */ 
/*              does the right stuff!                                   */ 
/* 80Dec04 RBD  Variable declarations inside statements exist.          */ 
/*                                                                      */ 
/* 7?????? SCJ	Created.						*/
/*                                                                      */  
/*                                                                      */  
/*                              credits                                 */
/*      CrT=CrT                                                         */
/*      RBD=Bob Denny                                                   */ 
/*      SCJ=Steven C Johnson.                                           */ 
/*      SG =Scott Guthery                                               */ 
/*									*/
/************************************************************************/



#include "c8stdio.h"
#include "system.h"
#include "dtxtrn.h"
                          


# define EMPTY	  1
# define WHOKNOWS 0
# define OK	  1


/* The default actions of states. */
extern int   y3DefaultAction[ MAXsTATES ];

/* Character stack shared by y1GetChar and y1UngetChar: */
static char   y1GetStack[ 30 ],   *y1TopStack = y1GetStack;



 
/* Lookahead computations: */
                                                   
/********************************************************/
/* Size of lookahead sets in words. Lookahead sets are	*/
/* represented by bit vectors with one bit for each	*/
/* terminal in the grammar -- this makes set unions a	*/
/* simple matter of ORing two bit vectors together. On	*/
/* large grammars, YACC spends most of its time doing	*/
/* set unions.						*/
/********************************************************/
int y1MaxLookaheadSet;

struct looksets y1LookaheadSet [ MAXy1lOOKAHEADsETS ];

/* Next lookahead set to allocate: */
static int y1NextLookaheadSet  = 0;

/* Flag to suppress lookahead computations: */
int y1NoLookahead = FALSE;

/* Temporary storage for lookahead computations: */
static struct looksets y1ClosureSet;


 
/* Working set computations: */
                                                   
struct wset y1WorkingSet[ MAXy1wORKINGsET];
struct wset *y1ThisWorkingSet;
                                                   

 
/* State information: */
                                                   
/* Number of states so far: */
int y1NextState = 0;

/* States generated by terminal gotos: */
int y1TerminalState[	MAXtERMINALsTATES    ];

/* States generated by nonterminal gotos: */
int y1NonterminalState[ MAXnONTERMINALsTATES ];

/* Type information about the states: */
int y1StateType[   MAXsTATES ];

/* Index to the stored goto table: */
int y1GotoIndex[   MAXsTATES ];

/* [Non/]term generation lists overflow chain:	*/
static int y1Link[ MAXsTATES ];

/* State-description pointers: */
struct item *y1StateItem[ MAXsTATES +2 ];

 
 
/* Storage for the actions in the parser: */
                                                   
/* Action table storage: */
int y1Action[ MAXaCTIONS ];

/* Next free action table position: */
int *y1NextAction = y1Action;


 
/* Other storage areas: */
                                                   
/* Scratch area andexed variously by terms+y2NextTerminal or states: */
int y1Temp[ MAXy1TEMP ];

/* Current input line number: */
int y1LineNumber = 1;

/* Signal to y1Error(): If y1ErrorsFatal, errors are fatal: */
static int y1ErrorsFatal = TRUE;

/* Number of errors: */
int y1Errors = 0;

 
                                                   
/* Storage for information about the nonterminals: */
                                                   
/* Productions yielding each nonterminal (Ptrs):*/
static int **y1YieldedBy[	   MAXnONTERMINALsTATES +2 ];

/* FIRST sets for nonterminals: */
static struct looksets *y1FirstOf[ MAXnONTERMINALsTATES +2 ];

/* Nonterminals nontrivially deriving <empty>: */
static int y1YieldsEmpty[	   MAXnONTERMINALsTATES +1 ];


 
/* Storage for statistics: */
                                                   
static struct wset * y1LastWorkingSet	     = y1WorkingSet;
int		     y1GotoEntries	     =		  0;
int		     y1GotosSavedByDefault   =		  0;

int		     y1ShiftEntries	     =		  0;
int		     y1Exceptions	     =		  0;
static int	     y1ClosuresDone	     =		  0;

int		     y1ShiftReduceConflicts  =		  0;
int		     y1ReduceReduceConflicts =		  0;
static	    *	     y1Nexty2PoolLoc	     =	     y2Pool;


 

 
/************************************************************************/
/*    y1ArrayFill	Set elements 0 through n-1 to c 		*/
/************************************************************************/
y1ArrayFill( v, n, c )
int *v,n,c;
{
    register int i;
    for( i = n;   i--;	)   v[i] = c;
}

/************************************************************************/
/*    y1CharCopy    Copy string q into p, returning next free char ptr. */ 
/************************************************************************/ 
static char *y1CharCopy( p, q )
char *p, *q; 
{ 
    while (*p++ = *q++); 
  
    return( --p ); 
} 
  
  
/************************************************************************/
/*    y1CheckEmpty	Mark nonterminals which derive the empty string.*/
/************************************************************************/
static y1CheckEmpty() {

    /****************************************************************/
    /* Mark nonterminals which derive the empty string. 	    */
    /* Look for nonterminals which don't derive any token strings.  */
    /****************************************************************/

    register i, *p;


 
    /************************************************************/
    /* First, use the array y1YieldsEmpty to detect productions */
    /* that can NEVER be reduced:				*/
    /************************************************************/


 
    y1ArrayFill( y1YieldsEmpty, y2LastNonterminal+1, WHOKNOWS );

    /* Now, look at productions, marking    */
    /* nonterminals which derive something: */

more:
    FORaLLpRODUCTIONS(0,i) {

        /***********************************************************/
	/* Check nonterminal defined by this production.  If we    */
	/* already know that nonterminal derives the empty string, */
	/* skip to next production:				   */
        /***********************************************************/
	if( y1YieldsEmpty[ *y2Production[i] - FIRSTnONTERMINAL ] ) continue;

        /************************************************/
	/* Scan RHSide of production. Stop if we reach	*/
	/* a nonterminal not known to derive something: */
        /************************************************/
	for (p = y2Production[i] +1;   *p >= 0;   ++p) {
	    if (
		*p >= FIRSTnONTERMINAL
		&&
		y1YieldsEmpty[ *p-FIRSTnONTERMINAL ] == WHOKNOWS
	    ) {
		break;
	    }
        }

	/* See if we reached end of production: */
	if (*p < 0)  {

	     /*********************************************************/
             /* Reached end of rule without finding any problematical */
	     /* entries, so production can be derived. Mark as safe:  */
	     /*********************************************************/
             y1YieldsEmpty[ *y2Production[i]-FIRSTnONTERMINAL ] = OK;

	     /* This may make something else safe, so start over: */
             goto more;
	 }
    }

    /********************************************************************/
    /* We have now marked all nonterminals known to generate something. */
    /* If any do NOT generate something, issue a warning message:	*/
    /********************************************************************/

    /* Make the useless-nonterminal errors nonfatal so we get all of them: */
    y1ErrorsFatal = FALSE;

    FORaLLnONTERMINALS(i) {

	/* Ignore the %start nonterminal, which is special: */
        if (!i)   continue;

	/* All the rest should derive something: */
        if ( y1YieldsEmpty[ i ] != OK ) {

	    y1Error(
		"y1CheckEmpty: nonterminal %s never derives any token string",
		y2NonterminalState[i].name
	    );
	}
    }
    y1ErrorsFatal = TRUE;

    /* Quit if there are any useless nonterminals: */
    if (y1Errors) {
	y1Summary();
	exit(EX_ERR);
    }


 
    /******************************************************************/
    /* Now figure out which nonterminals can derive the empty string: */
    /******************************************************************/


 
    /* Set y1YieldsEmpty to WHOKNOWS: */
    y1ArrayFill( y1YieldsEmpty, y2LastNonterminal+1, WHOKNOWS );

    /* Loop as long as we keep finding empty nonterminals: */

again:
    FORaLLpRODUCTIONS(1,i) {

        if (y1YieldsEmpty[ *y2Production[i]-FIRSTnONTERMINAL ] == WHOKNOWS) {

            /*****************************************************/
	    /* Found a production not known to be empty.	 */
	    /* See if all items on RHSide are known to be empty: */
            /*****************************************************/

            for (p = y2Production[ i ] +1;  *p >= FIRSTnONTERMINAL;  ++p) {

                if (y1YieldsEmpty[ *p - FIRSTnONTERMINAL ]  !=  EMPTY)   break;

            }
 
	    if (*p < 0) {

                /* We have a nontrivially empty nonterminal: */
		y1YieldsEmpty[ *y2Production[ i ] - FIRSTnONTERMINAL ] = EMPTY;

		/* This rule may make another empty, so start over: */
		goto again;
	    }
	}
    }
}

/************************************************************************/
/*    y1Closure 	Generate the closure of state i 		*/
/************************************************************************/
y1Closure( i )	/* Called from y1StateGen and y3Output. */
int i;
{
    /************************************************************************/
    /* An "item" of a grammar G is a production of G with a dot at	    */
    /* some position of the right side.  The the production		    */
    /*									    */
    /*	   a : x y z							    */
    /*									    */
    /* generates the items						    */
    /*									    */
    /*	   a :.x y z							    */
    /*	   a : x.y z							    */
    /*	   a : x y.z							    */
    /*	   a : x y z.							    */
    /*									    */
    /*	...								    */
    /*									    */
    /* If i is a set of items for a grammar G, then the set of items	    */
    /* CLOSURE(i) is constructed from i by the rules			    */
    /* 1.  Every item in i is in CLOSURE(i)				    */
    /* 2.  If "a : x.y z" is in CLOSURE(i) and "b : w" is a production,     */
    /*	   add "b : .w" to i.						    */
    /*									    */
    /*	(Following Aho & Ullman PRIMCIPLES OF COMPILER DESIGN p205-206.) CrT*/
    /************************************************************************/

    int                     c, ch, work, k;
    register struct wset    *u, *v;
    int 		    *pi;
    int 		    **s, **t;
    struct item 	    *q;
    register struct item    *p;
    int 		    num;
 

    ++y1ClosuresDone;

    /* First, copy kernel of state i to y1WorkingSet: */

    y1ThisWorkingSet = y1WorkingSet;
    FORaLLiTEMS(i,p,q) {

        y1ThisWorkingSet->pitem  = p->pitem;

	/* This item must get closed. */
	y1ThisWorkingSet->flag	 = TRUE;

	/* Copy the set over: */
        FORaLLlOOKAHEADwORDS(k) {
	    y1ThisWorkingSet->ws.lset[k] = p->look->lset[k];
	}
 
	NEXTwORKINGsET( y1ThisWorkingSet );
    }

    /* Loop until no items remain to be closed: */
    for (work = TRUE;	work; )  {

        work = FALSE;

	FORaLLwORKINGsETS( y1WorkingSet, u ) {

	    /* Find an item with the close flag set: */
            if (!u->flag) continue;

	    /* Found one. Dot is before c: */
	    c = *(u->pitem);

	    /* Only interesting case is where dot is before a nonterminal: */
	    if (c < FIRSTnONTERMINAL)  {

		/* Dot is before a terminal in this item: */
                u->flag = FALSE;
		continue;
	    }

	    /* Compute the lookahead: */

            y1ArrayFill( y1ClosureSet.lset, y1MaxLookaheadSet, 0 );

	    /* Find items involving c: */
	    FORaLLwORKINGsETS(u,v)  {

		if (v->flag   &&   *(pi=v->pitem) == c) {
		    v->flag = FALSE;

                    if (y1NoLookahead)   continue;

		    while ((ch = *++pi)  >  0)	{

                        if (ch < FIRSTnONTERMINAL) {
			    /* Terminal symbol: */
			    SETBIT( y1ClosureSet.lset, ch );
			    break;
			 }

			 /* Nonterminal symbol: */
			 num = ch-FIRSTnONTERMINAL;
			 y1SetUnion( y1ClosureSet.lset, y1FirstOf[num]->lset );
			 if (!y1YieldsEmpty[ num ])   break;
		    }
		    if (ch <= 0)   y1SetUnion( y1ClosureSet.lset, v->ws.lset );
		}
	    }

	    /* Now loop over productions derived from c: */

	    c -= FIRSTnONTERMINAL;    /* c is now nonterminal number */

	    t  = y1YieldedBy[ c+1 ];
	    for (s = y1YieldedBy[ c ];	 s < t;   ++s) {

		/* Put these items into the closure: */
		FORaLLwORKINGsETS(y1WorkingSet,v)  {

                    /* Is the item there? */
		    if (v->pitem == *s) {

                        /* Yes, it is there: */
			if (y1NoLookahead)   goto nexts;
			if (y1SetUnion( v->ws.lset, y1ClosureSet.lset )) {
			    v->flag = work = TRUE;
			}
			goto nexts;
		    }
		}

		/*  Not there; make a new entry: */
		if (y1ThisWorkingSet-y1WorkingSet+1 >= MAXy1wORKINGsET)  {
		    y1Error( "y1Closure: Working set overflow" );
		}
		y1ThisWorkingSet->pitem  = *s;
		y1ThisWorkingSet->flag	 = TRUE;
		if (!y1NoLookahead) {
		    work = TRUE;
		    FORaLLlOOKAHEADwORDS(k) {
			y1ThisWorkingSet->ws.lset[k] = y1ClosureSet.lset[k];
		    }
                }
		NEXTwORKINGsET( y1ThisWorkingSet );
nexts:		;
	    }

	}
    }

    /* We have computed closure. Flags are reset. Return: */
    if (y1LastWorkingSet < y1ThisWorkingSet)  {
	y1LastWorkingSet = y1ThisWorkingSet;
    }
 
#ifdef debug
    if (y2OutputFD != NULL)  {
	fprintf(
	    y2OutputFD,
	    "\nState %d, y1NoLookahead = %d\n",
	    i,
	    y1NoLookahead
	);
	FORaLLwORKINGsETS(y1WorkingSet,u) {
	    if (u->flag)   fprintf( y2OutputFD, "flag set!\n");
	    u->flag = FALSE;
	    fprintf( y2OutputFD, "\t%s", y1WriteItem(u->pitem));
	    y1PrintLookahead( &u->ws );
	    fprintf( y2OutputFD,  "\n" );
	}
    }
#endif
}


/************************************************************************/
/*    y1Error           Write out fatal error comment.                  */ 
/************************************************************************/ 
y1Error( s, a1 )        /* Called from everywhere. */ 
char *s; 
{ 
    ++y1Errors;
    fprintf(   stderr,	 "\nFATAL ERROR: "	       );
    fprintf(   stderr,	 s, a1			       );
    fprintf(   stderr,	 ", line %d\n", y1LineNumber   );

    if (!y1ErrorsFatal)   return;

    y1Summary(); 

    exit(EX_ERR); 
} 
  
/************************************************************************/
/*    y1First           Compute an array with the FIRST of nonterminals */ 
/************************************************************************/ 
y1First() {     /* Called only from main. */ 

   register *p, **s, i, **t, ch, changes; 
  
   /**************************************************************/
   /* For each nonterminal NT defined by the grammar, we want to */
   /* figure out which terminals can occur first in a string	 */
   /* defined by NT.  This is a simple matter of enumerating	 */
   /* all terminals which occur at the start of a production	 */
   /* defining NT, and then adding in the recursively computed	 */
   /* FIRSTs of all nonterminals starting NT productions:	 */
   /**************************************************************/

   y1LastWorkingSet = &y1WorkingSet[ y2LastNonterminal ];

   /********************************************************************/
   /* Do the first pass, finding for each nonterminal NT all terminals */
   /* occurring at the start of a production defining NT:	       */
   /********************************************************************/

   FORaLLnONTERMINALS(i) {

	/* Allocate a set to hold FIRST of this nonterminal: */
        y1ArrayFill( y1WorkingSet[i].ws.lset, y1MaxLookaheadSet, 0 );

	/* Iterate over the list of productions defining our nonterminal: */
        t = y1YieldedBy[ i+1 ];
	for (s = y1YieldedBy[i];   s < t;   ++s ) {
  
            /*************************************************************/
	    /* If this rule starts with a terminal, add it to our FIRST  */
	    /* set.  If the rule starts with a nonterminal that can	 */
	    /* derive the empty string, then look at the next entry:	 */
            /*************************************************************/

            for (p = *s;   (ch = *p) > 0;   ++p) { 
  
		if (ch < FIRSTnONTERMINAL) {

                    /* Found a terminal, add it to FIRST set: */
                    SETBIT( y1WorkingSet[i].ws.lset, ch );
		    break;

                } else { 

                    /* Found a nonterminal.  Finished with this rule */
		    /* unless the nonterminal can derive <empty>:    */
		    if (!y1YieldsEmpty[ ch-FIRSTnONTERMINAL ])	 break;
                } 
            } 
        } 
    } 
  
    /****************************************************************/
    /* Do the second pass, adding to FIRST(NT) FIRST(NT') for all   */
    /* nonterminals NT' which occur first in a rule defining NT:    */
    /****************************************************************/

    for (changes = TRUE;   changes;  ) {
	changes = FALSE;

        FORaLLnONTERMINALS(i) {

	    /* Iterate over the set of productions defining nonterminal i: */
            t = y1YieldedBy[i+1];
	    for (s = y1YieldedBy[i];   s < t;	++s) {

                /************************************************************/
		/* If this production starts with a nonterminal NT, collect */
		/* its FIRST set.  As before, if NT can derive the empty    */
		/* string then we have to collect FIRST of the following    */
		/* item also:						    */
                /************************************************************/

                for (p = *s;   (ch = (*p-FIRSTnONTERMINAL)) >= 0;   ++p) {
		    changes |= y1SetUnion(
			y1WorkingSet[i].ws.lset,
			y1WorkingSet[ch].ws.lset
		    );
		    if (!y1YieldsEmpty[ ch ])	break;
                } 
            } 
        } 
    } 
  
    /********************************************************/
    /* Finished! Now index the results for later reference, */
    /* simultaneously merging identical lookahead sets:     */
    /********************************************************/

    FORaLLnONTERMINALS(i) y1FirstOf[i] = y1Lookahead( &y1WorkingSet[i].ws );
#ifdef debug 
    if (y2OutputFD != NULL) {
	FORaLLnONTERMINALS(i)  {
	    fprintf( y2OutputFD,  "\n%s: ", y2NonterminalState[i].name );
	    y1PrintLookahead( y1FirstOf[i] );
	    fprintf( y2OutputFD,  " %d\n", y1YieldsEmpty[i] );
        } 
    } 
#endif 
} 
  
/************************************************************************/
/*    y1GetChar         Get one input char                              */ 
/************************************************************************/ 
y1GetChar( iop )                /* Called from everywhere */ 
FILE iop; 
{ 
    if (y1TopStack == y1GetStack)   return  getc(iop)	 ;
    else                            return  *--y1TopStack; 
}

/************************************************************************/
/*    y1Lookahead	Return lookahead set				*/
/************************************************************************/
static struct looksets *y1Lookahead( p	)
struct looksets *p;	      /* Called from: y1First, y1PutItem, y1State */
{
    /* Decide if the lookahead set pointed to by p is known. */
    /* Return pointer to a permanent location for the set.   */

    register struct looksets *q;
    int 		     j,  *w;
    register		     *u, *v;

    /* Over all known lookahead sets q, see if q == p: */
    for( q = &y1LookaheadSet[ y1NextLookaheadSet ];   q-- > y1LookaheadSet; ) {

        u = p->lset;
	v = q->lset;

        w = &v[ y1MaxLookaheadSet ];

	/* Match all pair of corresponding words in p and q: */
        while (v < w)   if (*u++ != *v++) goto more;

	/* P matches q -- return q */
	return( q );
more:	;
    }

    /* P is different from all known lookahead sets -- enter it: */
    q = &y1LookaheadSet[ y1NextLookaheadSet++ ];

    /* Check for too many lookahead sets: */
    if (y1NextLookaheadSet >= MAXy1lOOKAHEADsETS) {
	y1Error("y1Lookahead: Too many lookahead sets");
    }
 
    /* Copy p to permanent storage location: */
    FORaLLlOOKAHEADwORDS(j) {
	q->lset[j] = p->lset[j];
    }
    return( q );
}

/************************************************************************/
/*    y1MakeStates      Generate the states.                            */ 
/************************************************************************/  
static y1MakeStates() { 	 /* Called only from main. */
    int i, j;  
    register c;  
    register struct wset *p, *q;  
   
    /********************************************************************/
    /* Running your eye over a yacc grammar, you can imagine the parser */
    /* proceeding methodically through the appropriate rules, looking	*/
    /* always for the next token in the current rule.  In fact, however,*/
    /* one may have several rules which begin identically (say), so the */
    /* parser must keep track of where it is in all the grammar rules	*/
    /* which >might< turn out to be the right one.  Thus, at any given	*/
    /* time, the parser is in effect in a set of states rather than a	*/
    /* single state.  In this routine we precompute all valid sets of	*/
    /* states which the parser might wind up in.  This is a simple	*/
    /* matter of starting at the root nonterminal of the grammar and	*/
    /* proceeding all possible directions simultaneously... :-)      CrT*/
    /********************************************************************/

    /* Initialize */  
   
    y1NextState = 0;
   /**************************************************************************/
   /* This is funny from the standpoint of portability. 		     */
   /* It represents the magic moment when the y2Pool array, which has	     */
   /* been holding the productions, starts to hold item pointers, of a	     */
   /* different type... 						     */
   /* Someday, alloc should be used to allocate all this stuff. For now, we  */
   /* accept that if pointers don't fit in integers, there is a problem. SCJ.*/
   /**************************************************************************/
   
   y1StateItem[ 0 ]  = y1StateItem[ 1 ] = (struct item *) y2FreePool;

   y1ArrayFill( y1ClosureSet.lset, y1MaxLookaheadSet, 0 );

   y1PutItem( y2Production[ 0 ]+1, &y1ClosureSet );

   /* Start state expansion at the root nonterminal: */
   y1StateType[ 0 ]  = MUSTdOsTATE;
   y1NextState	     = 1;
   y1StateItem[ 2 ]  = y1StateItem[ 1 ];
   
   y1ArrayFill( y1Action, MAXaCTIONS, 0 );
   
   /* Now, the main state generation loop: */  
   
more:  
   FORaLLsTATES(i) {

	/* Find a state which needs expanding: */
        if (y1StateType[i] != MUSTdOsTATE)   continue;

	/* Mark it as done: */
        y1StateType[ i ] = DONEsTATE;

	/* Erase our scratchpad set: */
        y1ArrayFill( y1Temp, y2LastNonterminal+1, 0 );
   
        /* Take state i, close it, and do gotos: */  
	y1Closure(i);

        /*************************************************************/
	/*"For item set i and grammar symbol x, GOTO(i,x) is defined */
	/* to be the closure of the set of all items 'a : bx.c' such */
	/* that 'a : b.xc' is in i..."                               */
	/*	Aho & Ullman PRINCIPLES OF COMPILER DESIGN p207.  CrT*/
        /*************************************************************/

        FORaLLwORKINGsETS(y1WorkingSet,p) {
   
            /* Generate goto's: */  
            if (p->flag)   continue;  
	    p->flag = TRUE;
            c       = *(p->pitem);  
   
            if (c <= 1) {  
		if (y1StateItem[i+1]-y1StateItem[i] <= p-y1WorkingSet)	{
		    y1StateType[i] = MUSTlOOKaHEADsTATE;
                }  
                continue;  
            }  
   
            /* Do a goto on c: */  
	    FORaLLwORKINGsETS(p,q) {
                if (c == *(q->pitem)) {  

                    /* This item contributes to the goto: */  
                    y1PutItem( q->pitem + 1, &q->ws );  
		    q->flag = TRUE;
                }  
            }  
   
	    if (c < FIRSTnONTERMINAL) {
                y1State(c);  /* Register new state */  
            } else {  
		y1Temp[c-FIRSTnONTERMINAL] = y1State(c);
            }  
        }  
#ifdef debug  
	if (y2OutputFD != NULL) {
	    fprintf( y2OutputFD,  "%d: ", i );
	    FORaLLnONTERMINALS(j) {
		if (y1Temp[j]) {
		    fprintf(
			y2OutputFD,
			"%s %d, ",
			y2NonterminalState[j].name,
			y1Temp[j]
		    );
                }  
            }  
	    fprintf( y2OutputFD, "\n");
        }  
#endif  
	y1GotoIndex[i] = y3PackState( &y1Temp[1], y2LastNonterminal-1 ) - 1;
   
        /* We have done one goto; Do some more: */  
        goto more;  
    }  
    /* No more to do: Stop. */  
}  
   
   
/************************************************************************/
/*	main								*/
/************************************************************************/
main( argc, argv )
int argc;
char *argv[];
{
    /* Initialize and read productions: */
    puts("\ry2Initialize...      \r");
    y2Initialize(argc,argv);

    /* Process input file, stashing results in appropriate the tables: */
    puts("\ry2yyParse...         \r"); 
    y2yyParse();

    /* Build yyActionIndex[] so parser can find user action chunks: */
    puts("\ry3ActionIndex...     \r");
    y3ActionIndex();

    /* Figure how many words a set of terminals requires, taking */
    /* into account bits per word and number of terminals:	 */
    y1MaxLookaheadSet = NWORDS(y2NextTerminal);

    /* Find all productions defining each nonterminal: */
    puts("\ry1Yield...           \r");
    y1Yield();

    /* Figure out which nonterminals can match the empty string: */
    puts("\ry1CheckEmpty...      \r");
    y1CheckEmpty();

    /* Make a table of FIRSTs of nonterminals: */
    puts("\ry1First...           \r");
    y1First();

    /* Generate the states: */
    puts("\ry1MakeStates...      \r");
    y1MakeStates();

    /* Write the states and the tables: */
    puts("\ry3PutStates...       \r");
    y3PutStates();

    puts("\ry3Gotos...           \r");
    y3Gotos();

    puts("\ry3HideProductions... \r");
    y3HideProductions();

    puts("\ry1Summary...         \r");
    y1Summary();

    puts("\ry4Optimize...        \r");
    y4Optimize();

    puts("\ry1PutRest...         \r");
    y1PutRest();

    puts("\rDone.                \r");
    exit(EX_SUC);
}


/************************************************************************/
/*    y1PutRest 	 Put out other arrays, copy the parsers.	 */
/************************************************************************/
static y1PutRest() {		 /* Called only from main. */
    register c, i, j;

    y2InputFD = fopen( PARSER, "r" );
    if (y2InputFD == NULL) {
	y1Error( "y1PutRest: Cannot find parser file '%s'", PARSER );
    }
 
    y3PutArray( "yyr1", y2ProductionProperties, y2ThisProduction );

    y1ArrayFill( y1Temp, y2ThisProduction, 0 );
    FORaLLpRODUCTIONS( 1,i )   y1Temp[i] = y2Production[i+1]-y2Production[i]-2;
    y3PutArray( "yyr2", y1Temp, y2ThisProduction );

    y1ArrayFill( y1Temp, y1NextState, -1000 );
    FORaLLtERMINALS(i) {
	for(j = y1TerminalState[i];   j != 0;	j = y1Link[j]) {
	    y1Temp[j] = y2Terminal[i].value;
	}
    }
    FORaLLnONTERMINALS(i) {
	for (j = y1NonterminalState[i];   j != 0;   j = y1Link[j]) {
	    y1Temp[j] = -i;
	}
    }
    y3PutArray( "yychk", y1Temp, y1NextState );

    y3PutArray( "yydef", y3DefaultAction, y1NextState );

    /* Copy parser text: */
    while ((c = y1GetChar(y2InputFD))	!=   EOF) {
	if (c == '$') {
	    if ((c = y1GetChar(y2InputFD)) != 'A')   putc( '$', y2ytabcFD );
	    else {
		/* Copy actions: */
		y2ActionFD = fopen( ACTNAME, "r" );
		if (y2ActionFD == NULL)   {
		    y1Error( "y1PutRest: Cannot reopen action tempfile" );
		}
		while( (c=y1GetChar(y2ActionFD) ) != EOF ) putc( c, y2ytabcFD );
		fclose(y2ActionFD);
		ZAPFILE(ACTNAME);
		c = y1GetChar(y2InputFD);
	    }
	}
	putc( c, y2ytabcFD );
    }
    fclose( y2ytabcFD );
}

/************************************************************************/
/*    y1PrintLookahead	Print lookahead.				*/
/************************************************************************/
static y1PrintLookahead( p )	    /* Called from y1Closure, y1First */
struct looksets *p;
{
    register j, *pp;
    pp = p->lset;

    if (pp == 0)   fprintf( y2OutputFD, "\tNULL" );
    else {
	fprintf( y2OutputFD, " { " );
	FORaLLtERMINALS(j) {
	    if (GETBIT(pp,j))	fprintf( y2OutputFD,  "%s ", y1SymbolName(j) );
	}
	fprintf( y2OutputFD,  "}" );
    }
}

/************************************************************************/
/*    y1PutItem 							*/
/************************************************************************/
y1PutItem( ptr, lptr )		/* Called from y1MakeStates, y3Output	*/
int *ptr;
struct looksets *lptr;
{
    register struct item *j;

#ifdef debug
    if (y2OutputFD != NULL) {
	fprintf(
	    y2OutputFD,
	    "y1PutItem(%s), state %d\n",
	    y1WriteItem(ptr),
	    y1NextState
	);
    }
#endif
    j = y1StateItem[ y1NextState+1 ];
    j->pitem = ptr;
    if (!y1NoLookahead)   j->look = y1Lookahead( lptr );
    y1StateItem[ y1NextState+1 ]  = ++j;

    if (((int *)j)  >	y1Nexty2PoolLoc) {
	y1Nexty2PoolLoc = (int *)j;
	if( y1Nexty2PoolLoc >=	&y2Pool[MAXy2POOL] ) {
	    y1Error( "y1PutItem: Out of state space" );
	}
    }
}


/************************************************************************/
/*    y1SetUnion	A gets union of A and B.			*/
/************************************************************************/
static y1SetUnion( a, b )      /* Called by y1First, y1Closure, y1State. */
register *a, *b;
{
    /***************************************************/
    /* Set a to the union of a and b.		       */
    /* Return 1 if b is not a subset of a, 0 otherwise.*/
    /***************************************************/

    register i, x, sub;

    sub = 0;
    FORaLLlOOKAHEADwORDS(i) {
	*a = (x = *a)|*b++;
	if (*a++ != x)	 sub = 1;
    }
    return   sub;
}


/************************************************************************/
/*    y1State		Sort last state, check it, return state #.	*/
/************************************************************************/
y1State( c )		/* Called in y3Output, y1MakeStates		*/
int c;
{
    /* Sort last state, and see if it equals earlier ones. return state #: */

    int size1,size2;
    register i;
    int *s;							 /*01*/
    struct looksets *ss;					 /*01*/
    int s__;							 /*01*/
    struct item *p1, *p2, *k, *l, *q1, *q2;

    p1 = y1StateItem[y1NextState];
    p2 = y1StateItem[y1NextState+1];

    if (p1==p2)   return(0); /* Null state. */

    /* Sort the items: */
    for (k = p2-1;   k > p1;   k--) {
	/* Make k the biggest: */
	for (l = k-1;	l >= p1;   --l)   {
	    if (l->pitem > k->pitem) {
		s = k->pitem;
		k->pitem = l->pitem;
		l->pitem = s;
		ss = k->look;
		k->look = l->look;
		l->look = ss;
	    }
	}
    }

    /* Figure size of state: */
    size1 = p2 - p1;

    for (
	i =   (c >= FIRSTnONTERMINAL)	?   y1NonterminalState[ c-FIRSTnONTERMINAL ]   :   y1TerminalState[ c ]
	;
	i != 0
	;
	i = y1Link[i]
    ) {
	/* Get ith state */
	q1    = y1StateItem[ i	 ];
	q2    = y1StateItem[ i+1 ];
	size2 = q2 - q1;

	if (size1 != size2)   continue;
	k   = p1;

	for (l = q1;   l < q2;	 l++) {
	    if (l->pitem != k->pitem)	break;
	    ++k;
	}
	if (l != q2)   continue;

	/* Found it: */

	/* Delete last state: */
	y1StateItem[y1NextState+1] = y1StateItem[y1NextState];

	/* Fix up lookaheads: */
	if (y1NoLookahead)   return(i);
	for (l = q1 , k = p1;	l < q2;   ++l, ++k) {
	    FORaLLlOOKAHEADwORDS(s__) y1ClosureSet.lset[s__] = l->look->lset[s__];

	    if (y1SetUnion( y1ClosureSet.lset, k->look->lset )) {
		y1StateType[i] = MUSTdOsTATE;

		/* Register the new set: */
		l->look = y1Lookahead( &y1ClosureSet );
	    }
	}
	return	 i;
    }

    /* State is new: */
    if (y1NoLookahead)		 y1Error( "y1State: Yacc state/y1NoLookahead error" );
    y1StateItem[ y1NextState+2 ] = p2;
    if (y1NextState+1 >= MAXsTATES)   y1Error("y1State: Too many states" );

    if (c >= FIRSTnONTERMINAL) {
	y1Link[ y1NextState ]	 = y1NonterminalState[ c-FIRSTnONTERMINAL ];
	y1NonterminalState[ c-FIRSTnONTERMINAL ] = y1NextState;
    } else {
	y1Link[ y1NextState ] = y1TerminalState[ c ];
	y1TerminalState[ c ] = y1NextState;
    }
    y1StateType[y1NextState]=MUSTdOsTATE;
    return  y1NextState++;
}


/************************************************************************/
/*    y1Summary         Write the summary on the terminal.              */ 
/************************************************************************/
static y1Summary() {	/* Called in y1CheckEmpty, y1Yield, y1Error, main */


    if (y2OutputFD != NULL) {
	fprintf(
	    y2OutputFD,
	    "\n%d/%d terminals, %d/%d nonterminals\n",
	    y2NextTerminal,
	    MAXtERMINALsTATES,
	    y2LastNonterminal,
	    MAXnONTERMINALsTATES
	);
	fprintf(
	    y2OutputFD,
	    "%d/%d grammar rules, %d/%d states\n",
	    y2ThisProduction,
	    MAXpRODUCTIONS,
	    y1NextState,
	    MAXsTATES
	);
	fprintf(
	    y2OutputFD,
	    "%d shift/reduce, %d reduce/reduce conflicts reported\n",
	    y1ShiftReduceConflicts,
	    y1ReduceReduceConflicts
	);
	fprintf(
	    y2OutputFD,
	    "%d/%d working sets used\n", y1LastWorkingSet-y1WorkingSet,
	    MAXy1wORKINGsET
	);
	fprintf(
	    y2OutputFD,
	    "memory: states,etc. %d/%d, parser %d/%d\n",
	    y1Nexty2PoolLoc-y2Pool,
	    MAXy2POOL,
	    y1NextAction-y1Action,
	    MAXaCTIONS
	);
	fprintf(
	    y2OutputFD,
	    "%d/%d distinct lookahead sets\n",
	    y1NextLookaheadSet,
	    MAXy1lOOKAHEADsETS
	);
	fprintf( y2OutputFD, "%d extra closures\n", y1ClosuresDone - 2*y1NextState );
	fprintf(
	    y2OutputFD,
	    "%d shift entries, %d exceptions\n",
	    y1ShiftEntries,
	    y1Exceptions
	);
	fprintf( y2OutputFD, "%d goto entries\n", y1GotoEntries );
	fprintf( y2OutputFD, "%d entries saved by goto default\n", y1GotosSavedByDefault );
    }
    if (y1ShiftReduceConflicts || y1ReduceReduceConflicts) {
	fprintf( stdout,"\nconflicts: ");
	if (y1ShiftReduceConflicts)   fprintf( stdout, "%d shift/reduce" , y1ShiftReduceConflicts );
	if (y1ShiftReduceConflicts && y1ReduceReduceConflicts) fprintf( stdout, ", " );
	if (y1ReduceReduceConflicts)   fprintf( stdout, "%d reduce/reduce" , y1ReduceReduceConflicts );
	fprintf( stdout, "\n" );
    }

    fclose( y2TempFileFD );
    if (y2DefineFD != NULL)   fclose( y2DefineFD );
}


/************************************************************************/
/*    y1SymbolName	Return a pointer to the name of symbol i.	*/
/************************************************************************/
char *y1SymbolName( i ) 	/* Called from all over */
int i;
{
    char *cp;

    cp	= (i>=FIRSTnONTERMINAL) ? y2NonterminalState[i-FIRSTnONTERMINAL].name : y2Terminal[i].name ;

    if (*cp == ' ')   ++cp;

    return   cp;
}

/************************************************************************/
/*    y1UngetChar	Unget one char. 				*/
/************************************************************************/
y1UngetChar(c, iop)		/* Called from all over.		*/
char c;
FILE iop; /* WARNING: iop ignored ... y1UngetChar's are multiplexed!!! */
{
    *y1TopStack++ = c;
}

/************************************************************************/
/*    y1WriteItem	Creates output string for item pointed to by pp.*/
/************************************************************************/
char *y1WriteItem(pp)	/* Called from: y1Closure, y1PutItem,		*/
int *pp;		/*		y3HideProductions, y3WriteState */
{
    static char   sarr[ISIZE];
    char          *q;
    int 	  i;
    int 	  *p;

    for (p = pp;   *p > 0;   ++p);
    p = y2Production[-*p];
    q = y1CharCopy( sarr, y2NonterminalState[*p-FIRSTnONTERMINAL].name );
    q = y1CharCopy( q, " : " );

    loop {
	*q++ = ++p==pp ? '_' : ' ';
	*q = '\0';
	if ((i = *p)   <=   0)	 break;
	q = y1CharCopy( q, y1SymbolName(i) );
	if (q > &sarr[ISIZE-30])   y1Error( "y1WriteItem: Item too big" );
    }

    if ((i = *pp)   <	0) {
	/* An item calling for a reduction: */
	q = y1CharCopy( q, "    (" );
	sprintf( q, "%d)", -i );
    }
    return( sarr );
}

/************************************************************************/
/*    y1Yield           List productions yielding each nonterminal.     */ 
/************************************************************************/ 
static y1Yield() {     /* Called only by main.				*/

    /********************************************/ 
    /* First stage of grammar processing:	*/
    /* For each nonterminal NT, find all the	*/
    /* alternate rules defining NT.		*/
    /* y1YieldedBy[] points to these lists.	*/
    /* pyield[] has the lists: the		*/
    /* total size is only MAXpRODUCTIONS+1	*/
    /********************************************/ 

    static int *pyield[ MAXpRODUCTIONS ];
    register **pmem;
    register c, j, i; 
  

    pmem = pyield; 
  
    /*****************************************************/
    /* Want to identify all undefined nonterminals, not  */
    /* just first, so make errors nonfatal for now:	 */
    /*****************************************************/
    y1ErrorsFatal = FALSE;
  
    /* Tackle all nonterminals sequentially: */
    FORaLLnONTERMINALS(i) {

	/* Figure internal name for this nonterminal: */
	c = i + FIRSTnONTERMINAL;

	y1YieldedBy[ i ]    = pmem;

	/* Check all productions in memory: */
	FORaLLpRODUCTIONS(0,j) {

            /********************************************************/
	    /* The nonterminal defined by a rule is the first entry */
	    /* in it.  Remember this rule if it defines our current */
	    /* nonterminal:					    */
            /********************************************************/
	    if (*y2Production[j] == c)	 *pmem++ =  y2Production[j]+1;
        } 

	/* If we found no rules defining this nonterminal, complain: */
        if (y1YieldedBy[i] == pmem) {
	    y1Error(
		"y1Yield:  Nonterminal %s not defined!",
		y2NonterminalState[ i ].name
	    );
        } 
    } 

    /* Leave pointer to remaining free memory: */
    y1YieldedBy[i] = pmem;

    /* Errors are again fatal until further notice: */
    y1ErrorsFatal = TRUE;

    /* Quit if there were any undefined nonterminals: */
    if (y1Errors) {
        y1Summary(); 
        exit(EX_ERR); 
    } 

    /* Just for fun, check that we found exactly as many rules as expected: */
    if (pmem != &pyield[ y2ThisProduction ]) {
	y1Error(
	    "y1Yield: Internal Yacc error: pyield %d",
	    pmem-&pyield[y2ThisProduction]
	);
    } 
} 
  
/************************************************************************/
/*                              y2.c                                    */  
/*  YACC source file #2 (of 4).                                         */  
/*  Scanner, parser and symbol table code.				*/
/************************************************************************/   
    
/************************************************************************/   
/*                              contents                                */    
/*                                                                      */    
/*  * y2CpyAction       Copy C action to the next ; or closing }        */ 
/*  * y2CpyCode         Copy code between %{ and %} to output.          */ 
/*  * y2CpyUnion        Copy a union declaration to output.             */ 
/*  * y2Define          Define s to be a terminal or nonterminal.       */ 
/*  * y2EnterSymbol     Store id or literal in y2Text[], return address.*/ 
/*  * y2FindName        Identify terminal/nonterminal.                  */ 
/*  * y2GetToken                                                        */ 
/*    y2Initialize      Initialize parser, then call y2yyParse.         */ 
/*  * y2SkipComment     Skip over comments.                             */ 
/*  * y2TypeOf          Determine the type of a symbol.                 */ 
/*  * y2Usage                                                           */ 
/*  * y2WriteDefines    Post declarations: write out the defines        */ 
/*    y2yyParse         Kludged YACC input parser.                      */ 
/*                                                                      */ 
/* * Local to this file.                                                */  
/*                                                                      */ 
/************************************************************************/ 
    
    
/************************************************************************/ 
/*                              history                                 */ 
/*                                                                      */ 
/* 85Nov22 CrT  Below fouled up YYACCEPT/YYERROR.  Fixed.               */ 
/* 85Nov18 CrT	User action chunks are now placed in functions rather	*/
/*		than switch cases.  The functions are accessed by an	*/
/*              array of function pointers.  This is because many       */ 
/*              compilers have low limits on the size of functions,     */ 
/*              switch statements, and the number of cases in a         */ 
/*              switch statement.  In addition, some compilers implement*/ 
/*              switch statements with a cascade of comparisons rather  */ 
/*              than a jump table.                                      */ 
/* 85Nov17 CrT  I had a } wrong in y2Define.  Fixed.                    */ 
/* 85Nov17 CrT  Changed 'begin:' to 'start:' in y2GetToken, because     */ 
/*              BDS C treats 'begin's as '{'s, with confusing results.  */ 
/*              (This problem reported by Robert A. McIvor in '79.)     */ 
/* 85Nov15 CrT  Global variable names decrypted.                        */ 
/* 85Nov13 CrT  Give plaintiff routine in error messages.               */ 
/* 85Nov12 CrT  Function names decrypted. Still unique in first 6 chars.*/ 
/* 85Nov10 CrT  y2.c reconstructed from 12 subfiles.  Cosmetics.        */ 
/* 83Dec23 SG   Adapted for IBM PC/XT & DeSmet C compiler               */ 
/* 83May15 SG   Fixed up option flag handling for RT-11.                */ 
/* 83Apr12 RBD  Make filename[] size per #define'd                      */ 
/*              FNAMESIZE so VAX filenames won't blow out.              */ 
/*              Conditionalize time handling for banner.                */ 
/*              Make filespec buffer static for safety,                 */ 
/*              since global "infile" is pointed to it.                 */ 
/* 82Mar22 RBD  Added header line, changes for 'new' DECUS library      */ 
/*                                                                      */ 
/* 81Aug27 RBD  Modified for use with DECUS LEX                         */ 
/*              Variable "yylval" resides in yylex(), not in yypars();  */ 
/*              Therefore, is defined "extern" here.                    */ 
/*                                                                      */ 
/*              Also, the command line processing for the Decus version */ 
/*              has been changed.  A new switch has been added to allow */ 
/*              specification of the "table" file name(s), and unused   */ 
/*              switch processing removed.                              */ 
/*                               NOTE                                   */ 
/*              This probably won't run on UNIX any more.               */ 
/*                                                                      */ 
/* 7?????? SCJ  Created.                                                */ 
/*                                                                      */ 
/*                              credits                                 */ 
/*      CrT=CrT                                                         */  
/*      RBD=Bob Denny                                                   */  
/*      SCJ=Steven C Johnson.                                           */  
/*      SG =Scott Guthery                                               */  
/************************************************************************/ 

  
 
/* Token types returned by yacc's input scanner: */
# define IDENTIFIER   257  /* Identifier NOT followed by colo.		*/
# define MARK	      258  /* %%					*/
# define TERMINAL     259  /* %0 or %term or %token			*/
# define LEFT	      260  /* %< or %left				*/
# define RIGHT	      261  /* %> or %right				*/
# define BINARY       262  /* %2 or %binary or %nonassoc		*/
# define PREC	      263  /* %= or %prec				*/
# define LCURLY       264  /* %{					*/
# define C_IDENTIFIER 265  /* An IDENTIFIER followed by a colon.	*/
# define NUMBER       266  /* A number					*/
# define START	      267  /* %start					*/
# define TYPEDEF      268  /* %type					*/
# define TYPENAME     269  /*						*/
# define UNION	      270  /* %union					*/
# define ENDFILE	0  /*						*/
                          

/* Arguments for y2Define: */
#define TYPEtERMINAL	0
#define TYPEnONTERMINAL 1
#define TYPEpREC	2


 
/* Communication variables between various I/O routines: */
                                                          
static int   y2InputNumberValue;	    /* Value of an input number. */
static char  y2InputTokenText[ NAMEsIZE ];  /* Input token name.	 */
                                                          

 
/* Storage for names: */
                                                          
static char  y2Text[ MAXy2TEXT ];   /* Contains text of all names.	 */
static char *y2TextFree = y2Text;   /* Remaining free space in y2Text[]. */
static int   y2NumberOfDefinedSymbolsWritten = 3;


 
/* Storage for user-declared types ("<...>" commands): */

/* Pointers to names of types, secreted in y2Text: */
static char *  y2TypeName[ MAXtYPES ];

static int     y2NumberOfTypesDefined;

 
 
/* Symbol tables for tokens and nonterminals: */
                                                          
/* Table giving external name and internal number for each terminal: */
struct toksymb y2Terminal[	     MAXtERMINALsTATES ];

/* Bit vectors giving associativity and precedence of each terminal: */
int	       y2TerminalProperties[ MAXtERMINALsTATES ];
int y2NextTerminal = 0;

/* Table giving external name and internal number for nonterminals: */
struct ntsymb y2NonterminalState[ MAXnONTERMINALsTATES ];
int y2LastNonterminal = -1;

static int y2RootNonterminal;	/* "%start" symbol.			 */
                                                          

 
/* Next internal terminal number to assign: */
static int y2NextTerminalNumber = 0;	/* y2Initialize sets it to 0400 */
                                                          

 
/* Input and output file descriptors: */
                                                          
FILE * y2InputFD;		/* Yacc input file.			*/
FILE * y2ActionFD;		/* File to saving actions in.		*/
FILE * y2DefineFD;		/* File for # defines.			*/
FILE * y2ytabcFD;		/* y.tab.c file.			*/
FILE * y2TempFileFD;		/* Temp. file to pass 2.		*/
FILE * y2OutputFD;		/* y.output file.			*/
                                                          

 
/************************************************************************/
/*                                                                      */
/* Storage for grammar rules. Grammar rules are packed sequentially	*/
/* into y2Pool[].   y2Production[i] points to the start of the ith	*/
/* grammar rule.  A grammar rule consists of a sequence of positive	*/
/* integers terminated by a negative integer.  The positive integers	*/
/* are parts of the rule, the negative integer is -i.  Positive 	*/
/* integers less than FIRSTnONTERMINAL are terminals, others are	*/
/* nonterminals -- subtracting FIRSTnONTERMINAL gives the correct	*/
/* offset into y2NonterminalState[].   The first entry in the rule is	*/
/* the LHS -- the nonterminal being defined -- and the remainder give	*/
/* the right hand side. 						*/
/*                                                                      */
/* Actions are always fired at the end of a rule.  (Input rules with	*/
/* actions in the middle are split into multiple rules.)  When actions	*/
/* are encountered, a switch case labeled with the rule number is	*/
/* generated, and the RULEhASaCTION bit for that rule set.  Thus, when	*/
/* we later generate code reducing this rule, we need only check the	*/
/* RULEhASaCTION and, if set, synthesize a call from the rule number.	*/
/*									*/
/************************************************************************/

/* Buffer to pack productions into: */
int y2Pool[ MAXy2POOL ];

/* Pointer to start of free space in y2Pool: */
int *y2FreePool = y2Pool;

/* Count of number of productions in currently in y2Pool: */
int y2ThisProduction= 1;

/* Pointers into y2Pool, giving the start of each production in it: */
int *y2Production[ MAXpRODUCTIONS ];

/* The production precedence levels.  Same bit	*/
/* vector format as y2TerminalProperties:	*/
int y2ProductionProperties[ MAXpRODUCTIONS ] ;


 

 
 
 
 
/************************************************************************/
/*    y2CpyAction       Copy C action to the next ; or closing }        */
/************************************************************************/
static y2CpyAction( offset )	       /* Called only from y2yyParse */
int offset;		      /* Number of arguments seen in production */
{
    int braceDepth, c, match, j, s, tok;
       
#ifdef OLD
    /* Create a "case...:" for the impending action: */
    fprintf( y2ActionFD, "\ncase %d:", y2ThisProduction );
#else 
    /* Create a function for the impending action: */
    fprintf( y2ActionFD, "static yyA%03d() {", y2ThisProduction );
#endif 
    /* Pass current line number to output: */
    fprintf(   y2ActionFD,   "\n# line %d\n",	y1LineNumber   );
       
    braceDepth = 0;
       
lup:
    c = y1GetChar( y2InputFD );

swtch:
    switch( c ) {
       
    case ';':
	if (braceDepth == 0) {
	    putc( c , y2ActionFD );
	    goto cpyActEnd;
         } 
	 goto lcopy;
       
    case '{':
	braceDepth++;
	goto lcopy;
       
    case '$':
	s   = 1;
	tok = -1;
	c   = y1GetChar( y2InputFD );

        if (c == '<') {

            /* Type description: */
	    y1UngetChar( c, y2InputFD );
	    if (y2GetToken() != TYPENAME) {
		y1Error( "y2CpyAction: Bad syntax on $<ident> clause" );
	    }
	    tok = y2InputNumberValue;
	    c	= y1GetChar( y2InputFD );
	}
	if (c == '$') {
	    fprintf( y2ActionFD, "yyval");
	    if (y2NumberOfTypesDefined) {

		/* Put out the proper name: */
		if (tok < 0) {
		    tok = y2TypeOf( *y2Production[ y2ThisProduction ] );
		}
                fprintf( y2ActionFD, ".%s", y2TypeName[tok] );
            } 
	    goto lup;
	}
	if (c == '-') {
	    s = -s;
	    c = y1GetChar( y2InputFD );
	}
	if (isdigit( c )) {

	    /* Handle a $3 type action argument: */

	    /* Collect the numerical value in j: */
            j = 0;
	    while (isdigit( c )) {
		j = j * 10   +	 c - '0';
		c = y1GetChar( y2InputFD );
            } 
	    j = j * s	-   offset;

	    /* Can't refer to part of rule not seen yet: */
            if (j > 0)  y1Error( "y2CpyAction: Illegal use of $%d", j+offset );

	    /* Compile code for $n variable reference: */
            fprintf( y2ActionFD, "yypvt[-%d]", -j );

	    /* Special code if we are stacking unions instead of ints: */
            if (y2NumberOfTypesDefined) {

		/* Put out the proper name: */

		if (j+offset <= 0   &&	 tok < 0) {
		    y1Error(
			"y2CpyAction: Must specify type of $%d",
			j+offset
		    );
		}
		if (tok < 0)   {
		    tok = y2TypeOf(
			y2Production[ y2ThisProduction ][ j+offset ]
		    );
                }
                fprintf( y2ActionFD, ".%s", y2TypeName[tok] );
	    }
	    goto swtch;
	}
	putc( '$' , y2ActionFD );
	if (s < 0)   putc( '-', y2ActionFD );
	goto swtch;
       
    case '}':
	if (--braceDepth)   goto lcopy;
	putc( c, y2ActionFD );
	goto cpyActEnd;

    case '/':
	/* Look for comments: */
	putc( c , y2ActionFD );
	c = y1GetChar( y2InputFD );
	if (c != '*')	goto swtch;
       
	/* It really is a comment: */
       
	putc( c , y2ActionFD );
	c = y1GetChar( y2InputFD );
	while (c != EOF) {
	    while (c == '*') {
		putc( c , y2ActionFD );
		if ((c = y1GetChar( y2InputFD ))   ==	'/')   goto lcopy;
            } 
	    putc( c , y2ActionFD );
	    if (c == '\n')   ++y1LineNumber;
	    c = y1GetChar( y2InputFD );
	}
	y1Error( "y2CpyAction: EOF inside comment" );
       
    case '\'':
	/* Character constant: */
	match = '\'';
	goto string;
       
    case '"':
	/* Character string: */
	match = '"';
       
string: 
       
	putc( c, y2ActionFD );
	while (c = y1GetChar( y2InputFD )) {
	    if (c == '\\') {
		putc( c , y2ActionFD );
		c = y1GetChar(y2InputFD);
		if (c == '\n')	 ++y1LineNumber;
	    } else if( c==match ) {
		goto lcopy;
	    } else if( c=='\n' ) {
		y1Error( "y2CpyAction: Newline in string or char constant" );
	    }
	    putc( c , y2ActionFD );
	}
	y1Error( "y2CpyAction: EOF in string or character constant" );
       
    case EOF:
	/* EOF: */
	y1Error( "y2CpyAction: Action does not terminate" );
       
    case '\n':
	++y1LineNumber;
	goto lcopy;
    }
       
lcopy: 
    putc( c, y2ActionFD );
    goto lup;

 
cpyActEnd:
#ifdef OLD
    /* Wrap up this "case" in the action switch statement: */
    fprintf( y2ActionFD, " break;" ); 
#else
    /* Wrap up this action fn: */
    fprintf( y2ActionFD, "\n    return -1;\n}\n\n" );
#endif
}

 
/************************************************************************/
/*    y2CpyCode         Copy code between \{ and \} to output.          */ 
/************************************************************************/ 
static y2CpyCode() {

    int c; 

    c = y1GetChar( y2InputFD );

    if (c == '\n') { 
	c = y1GetChar( y2InputFD );
	y1LineNumber++;
    } 

    /* Pass line number to output file: */
    fprintf( y2ytabcFD, "\n# line %d\n", y1LineNumber );

    /* Copy the code over: */
    while (c != EOF) {
        if (c == '\\') { 
	    if ((c = y1GetChar(y2InputFD))   ==   '}')	 return;
	    else				      putc('\\', y2ytabcFD );
        } 
        if (c == '%') { 
	    if ((c = y1GetChar(y2InputFD))   ==   '}')	 return;
	    else				      putc('%', y2ytabcFD );
        } 
	putc( c , y2ytabcFD );
	if (c == '\n')	 ++y1LineNumber;
	c = y1GetChar(y2InputFD);
    } 
    y1Error( "y2CpyCode: EOF before %%}" );
}
  

/************************************************************************/
/*    y2CpyUnion        Copy a union declaration to output.             */
/************************************************************************/
static y2CpyUnion() {	       /* Called only from y2yyParse */

    /**********************************************/
    /* Copy the union declaration to the output.  */
    /* Copy also to the .h file if one requested. */
    /**********************************************/

    int level, c;

    /* Pass input line number to output for debugging purposes: */
    fprintf( y2ytabcFD, "\n# line %d\n", y1LineNumber );

    fprintf( y2ytabcFD, "\n#define UNION 1\n");
    fprintf( y2ytabcFD, "typedef union " );
    if (y2DefineFD)   fprintf( y2DefineFD, "\ntypedef union " );
       
    level = 0;
    loop {
	if ((c = y1GetChar( y2InputFD ))   ==	EOF) {
	    y1Error( "y2CpyUnion: EOF encountered while processing %%union" );
	}
	putc( c, y2ytabcFD );
	if (y2DefineFD)   putc( c, y2DefineFD );
       
	switch (c) {
	case '\n':	++y1LineNumber; 			break;
	case '{':	++level;				break;
	case '}':
	    if (!--level) {

		/* We are finished copying: */
		fprintf( y2ytabcFD, " YYSTYPE;\n" );
		if (y2DefineFD) {
		    fprintf(
			y2DefineFD,
			" YYSTYPE;\nextern YYSTYPE yylval;\n"
		    );
		}
		return;
	    }
	}
    }
}
 

/************************************************************************/
/*    y2Define          Define s to be a terminal or nonterminal.       */ 
/************************************************************************/ 
y2Define( t, s )	/* Called by y2FindName and y2Initialize */
int             t; 
register char  *s; 
{ 
    /*****************************************************/ 
    /* Define s to be a    terminal if t=TYPEtERMINAL	 */
    /*		   or a nonterminal if t=TYPEnONTERMINAL */
    /*		   or a (???--CrT)     t=TYPEpREC	 */
    /*****************************************************/ 

    register val; 
           
    if (t != TYPEtERMINAL) {
	if (++y2LastNonterminal >= MAXnONTERMINALsTATES) {
	    y1Error(
		"y2Define  Too many nonterminals, limit %d",
		MAXnONTERMINALsTATES
	    );
        } 
	y2NonterminalState[ y2LastNonterminal ].name = y2EnterSymbol(s);

	return( FIRSTnONTERMINAL + y2LastNonterminal );
    }

    /* Must be a terminal */
    if (++y2NextTerminal >= MAXtERMINALsTATES)	 {
	y1Error( "y2Define: Too many terminals, limit %d",MAXtERMINALsTATES);
    }
    y2Terminal[ y2NextTerminal ].name  = y2EnterSymbol(s);
           
    /* Establish value for token: */ 
           
    if (s[0] == ' '   &&   s[2] == '\0') { 
  
        /* Single character literal: */ 
        val = s[1]; 
  
    } else if (s[0] != ' '   ||   s[1] != '\\') {

        val = y2NextTerminalNumber++;

    } else {

        /* Escape sequence: */ 
        if (s[3] == '\0' ) { 
  
            /* Single character escape sequence: */ 
            switch ( s[2] ) { 
                /* Character which is escaped: */ 
            case  'n':      val = '\n';             break; 
            case  'r':      val = '\r';             break; 
            case  'b':      val = '\b';             break; 
            case  't':      val = '\t';             break; 
            case  'f':      val = '\f';             break; 
            case '\'':      val = '\'';             break; 
            case  '"':      val =  '"';             break; 
            case '\\':      val = '\\';             break; 
            default: 
		y1Error( "y2Define: Invalid escape" );
            }  
  
        } else if (s[2] <= '7'   &&   s[2] >= '0') { 
  
            /* \nnn sequence: */ 
            if ( 
                s[3] < '0' 
                || 
                s[3] > '7' 
                || 
                s[4] < '0' 
                || 
                s[4] > '7' 
                || 
                s[5] != '\0' 
            ) { 
		y1Error( "y2Define Illegal \\nnn construction" );
            } 
  
            /****************************************************************/ 
	    /* CrT: Naive code to translate \nnn to octal char is:	    */
            /* val = 64 * (s[2]-'0')   +   8 * (s[3]-'0')   +   (s[4]-'0'); */ 
            /* Factoring the '0's out for speed (?!?!!??) gives SCJ's:      */ 
            /****************************************************************/ 
	    val = 64 * s[2]   +   8 * s[3]   +	 s[4]	-   73 * '0';
	    if (val == 0)   y1Error( "y2Define: '\\000' is illegal" );
        } 
    }
    y2Terminal[ y2NextTerminal ].value	    = val;
    y2TerminalProperties[ y2NextTerminal ]  = 0;

    return   y2NextTerminal;
} 
  

/************************************************************************/
/*    y2EnterSymbol     Store id or literal in y2Text[], return address.*/
/************************************************************************/
static char *y2EnterSymbol( s )    /* Called by y2Define and y2GetToken */
register char *s;
{
    char *temp;
          
    temp = y2TextFree;
    do {
	if (y2TextFree >= &y2Text[ MAXy2TEXT ]) {

            y1Error( "y2EnterSymbol: Too many chars in id's and literals" );

        } else {

            *y2TextFree++ = *s;

        }
    } while (*s++);

    return  temp;
}
 

/************************************************************************/
/*      y2FindName                                                      */ 
/************************************************************************/ 
static y2FindName( t, s )	    /* Called only from y2yyParse	*/
int	       t;	/* TYPEtERMINAL, TYPEnONTERMINAL or TYPEpREC.	*/
register char *s; 
{ 
    int i; 
           
    /* Handle literals: */
    if (s[0] == ' ')   t = TYPEtERMINAL;
  
    /* May be a terminal: */
    FORaLLtERMINALS(i) {
	if (!strcmp( s, y2Terminal[i].name ))	return i;
    } 

    /* May be a nonterminal: */
    FORaLLnONTERMINALS(i) {
	if (!strcmp( s, y2NonterminalState[i].name )) {
	    return i+FIRSTnONTERMINAL;
	}
    } 

    /* Identifiers in "%prec id" statements should be predeclared: */
    if (t == TYPEpREC) {
	y1Error( "y2FindName: %s should have been defined earlier", s );
    }
  
    /* Create an entry for undefined name: */
    return   y2Define( t, s );
} 
  

/************************************************************************/
/*	y2GetToken							*/
/************************************************************************/
static y2GetToken() {		/* Called from y2yyParse, y2CpyAction	*/

    static int  peekline;

    register    len;
    register	base;
    register	c;

    int         match;
    int 	percentCommand;
    int 	i;

start:
    percentCommand  = FALSE;
    y1LineNumber   += peekline;
    peekline	    = 0;
    c		    = y1GetChar( y2InputFD );

    /* Skip any leading whitespace: */
    while (
	c == ' '
	||
	c == '\n'
	||
	c == '\t'
	||
	c == '\f'
	||
	c == '\r'
    ) {
	if (c == '\n')	 ++y1LineNumber;
	c = y1GetChar( y2InputFD );
    }

    /* Skip comments: */
    if (c == '/') {
	/* Skip comment: */
	y1LineNumber += y2SkipComment();
	goto start;
    }
          
    /* We have nonwhitespace noncomment: decide what kind of token: */
    switch (c) {

    case EOF:
	/* EOF: */
	return	 ENDFILE;

    case '{':
	/* Action: */
	y1UngetChar( c, y2InputFD );
	return( '=' );

     case '<':
	/* Get, and look up, a type name (union member name): */
	len = 0;
	while (
	    (c = y1GetChar( y2InputFD ))   !=	'>'
	    &&
	    c >= 0
	    &&
	    c != '\n'
	) {
	    y2InputTokenText[ i ] = c;

	    /* Truncate too-long type names: */
            if (++len >= NAMEsIZE)   --len;
	}

	/* Check for '>' missing: */
        if (c != '>')   y1Error( "y2GetToken: Unterminated < ... > clause" );

	/* Tie off name: */
        y2InputTokenText[ len ] = '\0';

	/* If typename already entered, don't enter it again: */
        for (i = 1;   i <= y2NumberOfTypesDefined;   ++i) {
	    if (!strcmp( y2TypeName[i], y2InputTokenText )) {
		y2InputNumberValue = i;
		return( TYPENAME );
            } 
	}

	/* Enter typename: */
	y2TypeName[ y2InputNumberValue = ++y2NumberOfTypesDefined ]   = (
	    y2EnterSymbol( y2InputTokenText )
	);
 
        return   TYPENAME;

    case '"':
    case '\'':
	match		    = c;
	y2InputTokenText[0] = ' ';
	len		    = 1;
	loop {

	    c = y1GetChar( y2InputFD );

            if (c == '\n'   ||   c == EOF) {
		y1Error( "y2GetToken: Illegal or missing ' or \"" );
	    }
	    if (c == '\\') {

		c = y1GetChar( y2InputFD );
		y2InputTokenText[i] = '\\';
		if( ++len >= NAMEsIZE ) --len;

	    } else if( c == match ) {

                break;

            }
	    y2InputTokenText[len] = c;
	    if (++len >= NAMEsIZE )   --len;
	}
	break;
          
    case '%':
    case '\\':
          
	switch (c = y1GetChar( y2InputFD ))  {

        case '%':
	case '\\':	return	 MARK	 ;
	case '0':	return	 TERMINAL;
	case '<':	return	 LEFT	 ;
	case '2':	return	 BINARY  ;
	case '>':	return	 RIGHT	 ;
	case '=':	return	 PREC	 ;
	case '{':	return	 LCURLY  ;
	default:
	    percentCommand = TRUE;
	}
          
    default:
          
	if (isdigit( c )) {

            /* Number: */
	    y2InputNumberValue	= c - '0';
	    base		=   (c == '0')	 ?   8	 :   10;

	    for (
		c = y1GetChar( y2InputFD );
		isdigit( c );
		c = y1GetChar( y2InputFD )
	    ) {
		y2InputNumberValue = y2InputNumberValue * base	 +   (c - '0');
            } 
	    y1UngetChar( c, y2InputFD );
	    return   NUMBER;

        } else if (

            !islower( c )
	    &&
	    !isupper( c )
	    &&
	    c != '_'
	    &&
	    c != '.'
	    &&
	    c != '$'

        ) {

            return   c;

        } else {

            len = 0;

            while (
		islower( c )
		||
		isupper( c )
		||
		isdigit( c )
		||
		c == '_'
		||
		c == '.'
		||
		c == '$'
	    ) {
		if (percentCommand && isupper(c)) {
		    c  +=  'a' - 'A';
		}
                y2InputTokenText[ len ] = c;
		if (++len >= NAMEsIZE)	 --len;
		c = y1GetChar( y2InputFD );
            } 
	}

	y1UngetChar( c, y2InputFD );
    }
          
    y2InputTokenText[ len ] = '\0';
          
    if (percentCommand) {
	/* Find a reserved word: */
	if (!strcmp(y2InputTokenText,"term"    ))   return( TERMINAL );
	if (!strcmp(y2InputTokenText,"token"   ))   return( TERMINAL );
	if (!strcmp(y2InputTokenText,"left"    ))   return( LEFT     );
	if (!strcmp(y2InputTokenText,"nonassoc"))   return( BINARY   );
	if (!strcmp(y2InputTokenText,"binary"  ))   return( BINARY   );
	if (!strcmp(y2InputTokenText,"right"   ))   return( RIGHT    );
	if (!strcmp(y2InputTokenText,"prec"    ))   return( PREC     );
	if (!strcmp(y2InputTokenText,"start"   ))   return( START    );
	if (!strcmp(y2InputTokenText,"type"    ))   return( TYPEDEF  );
	if (!strcmp(y2InputTokenText,"union"   ))   return( UNION    );

	y1Error(
	    "y2GetToken: Invalid escape, or illegal reserved word: %s",
	    y2InputTokenText
	);
    }
          
    /* Look ahead to distinguish IDENTIFIER from C_IDENTIFIER: */
          
    c = y1GetChar( y2InputFD );
    while (
	c == ' '
	||
	c == '\t'
	||
	c == '\n'
	||
	c == '\f'
	||
	c == '/'
    ) {
	if( c == '\n' ) {
	    ++peekline;
	} else if( c == '/' ) {
	    /* Look for comments: */
	    peekline += y2SkipComment();
	}
	c = y1GetChar( y2InputFD );
    }

    if (c == ':')   return C_IDENTIFIER;

    y1UngetChar( c, y2InputFD );

    return   IDENTIFIER;
}


/************************************************************************/
/*	y2Initialize							*/
/************************************************************************/
y2Initialize( argc, argv )	/* Called once from main at startup    */
int   argc; 
char *argv[];  
{ 
    char filename[	FNAMESIZE ];
    char inputFilename[ FNAMESIZE ];
    char *cp;
    int  i;
    int  makeHFile;
    int  makeIFile;

    makeHFile	= FALSE;
    makeIFile	= FALSE;

    y2OutputFD	= NULL;
    y2DefineFD	= NULL;

    /* Handle all commandline switches: */
    for (i = 1;   --argc   &&   argv[i][0] == '-';   i++) {

        while (*++(argv[i])) { 
            switch( toupper( *argv[i] )) { 
	    case 'I':		    makeIFile++;	continue;
	    case 'H':		    makeHFile++;	continue;
            default: 
		fprintf(stderr, "y2Initialize: Bad option: %c\n", *argv[i]);
                y2Usage(); 
            }  
        } 
    }
           
    /* Catch no filename given: */
    if (!argc)	 y2Usage();
  
    /************************************************************************/ 
    /* Now open the input file with a default extension of ".Y",            */ 
    /* then replace the period in argv[1] with a null, so argv[1]           */ 
    /* can be used to form the table, defs and info filenames.              */ 
    /************************************************************************/ 
           
    /* Find the input filename: */
    cp = argv[i]; 
  
    /* Scan past '.' or to null: */ 
    while (*cp++ != '.'   &&   *cp);
  
    /* Make our own copy: */
    strcpy( filename, argv[i] );

    /* Make sure "filename" copy has ".Y" extention	*/
    /* and	   , argv[] copy has   no extention:	*/
    if (!*cp)    strcat( filename, ".Y"    );   /* Add default ".y" */
    else	 *(argv[i]-1) = '\0';		/* Null the period: */

    /* Open the xxx.y input file: */
    strcpy( inputFilename, filename );
    if ((y2InputFD = fopen( filename, "r" ))   ==   NULL) {
	y1Error( "y2Initialize: Cannot open input file \"%s\"", filename );
    } 
  
    /* If -h option specified, create a xxx.h file to #define the tokens: */
    if (makeHFile) {
	strcpy( filename, argv[i] );
	strcat( filename, ".H"	  );
  
	if ((y2DefineFD = fopen( filename, "w" ))   ==	 NULL)	 {
	    y1Error( "y2Initialize: Cannot open defs file\"%s\"", filename);
	}
    } 
           
    /* If -i option specified, create a xxx.i file to hold the	*/
    /* human-readable description of the parser:		*/
    if (makeIFile) {
	strcpy( filename, argv[i] );
	strcat( filename, ".I"	  );
  
	if ((y2OutputFD = fopen( filename, "w" ))   ==	 NULL)	 {
	    y1Error( "y2Initialize: Cannot open info file\"%s\"", filename);
	}
    } 
  
    /* Create the xxx.c file containing the parser proper: */
    strcpy( filename, argv[i] );
    strcat( filename, ".C"    );
  
    if ((y2ytabcFD = fopen(filename, "w"))   ==   NULL)   {
	y1Error( "y2Initialize: Cannot open table file\"%s\"", filename);
    }
  
    /* Open a temporary(?) file for gotos: */
    if ((y2TempFileFD = fopen( TEMPNAME, "w" ))   ==   NULL)   {
	y1Error( "y2Initialize: Cannot open temp file"	 );
    }
  
    /* Open a file to copy the user-supplied rule-action code into. */
    /* (We add calling machinery as we go along.)		    */
    if ((y2ActionFD = fopen( ACTNAME, "w" ))   ==   NULL) {
	y1Error( "y2Initialize: Cannot open action file" );
    }
  
    /* Put out a header line at the beginning of the 'table' file: */
    /* CrT: What is "CSD"? Capricious Software Demolition :-) ?    */
    fprintf(
	y2ytabcFD,
	"\n/* Created by CSD_YACC (IBM PC) from \"%s\" */\n",
	inputFilename
    );
  
    /* Complete the initialization: */
  
    y2TextFree	 = y2Text;
  
    /* End token is 0: */
    y2Define( 0,"$end" ); 
  
    /* Other noncharacter terminal tokens start at 257: */
    y2NextTerminalNumber  = 0400;
  
    /* Define remaining special tokens: */
    y2Define( 0, "error"   ); 
    y2Define( 1, "$accept" ); 
  
    /* y2Pool is empty: */
    y2FreePool = y2Pool;
}
          

/************************************************************************/ 
/*      y2SkipComment   Skip over comments.                             */ 
/************************************************************************/  
static y2SkipComment() {	/* Called only from y2GetToken		*/
    
    register c;
    register linesSkipped;

    linesSkipped =0;
    
    /* y2SkipComment is called after reading a '/': */ 
            
    if (y1GetChar( y2InputFD )	 !=   '*')  {
	y1Error( "y2SkipComment: Illegal comment" );
    }
    
    for (c = y1GetChar( y2InputFD );   c != EOF;   c = y1GetChar( y2InputFD )){
    
        while (c == '*') {  
    
	    if ((c = y1GetChar( y2InputFD ))   ==   '/')   return linesSkipped;
        }  
	if (c == '\n')	 ++linesSkipped;
    }

    y1Error( "y2SkipComment: EOF inside comment" );

    /* NOTREACHED */  
} 
  

/************************************************************************/
/*      y2TypeOf        Determine the type of a symbol.                 */ 
/************************************************************************/ 
static y2TypeOf( t )	       /* Called only by y2CpyAction		*/
int t; 
{ 
    register v; 
  
    if (t >= FIRSTnONTERMINAL)	{
	v = y2NonterminalState[ t - FIRSTnONTERMINAL ].tvalue;
    } else {
	v = TYPE( y2TerminalProperties[ t ] );
    }
  
    if (v <= 0) { 
        y1Error( 
	    "y2TypeOf: Must specify type for %s",
	    (
		(t >= FIRSTnONTERMINAL)
		?
		y2NonterminalState[ t-FIRSTnONTERMINAL ].name
		:
		y2Terminal[ t ].name
	    )
        ); 
    } 
    return   v; 
} 
  
  
/************************************************************************/
/*	y2Usage 							*/
/************************************************************************/ 
static y2Usage() {		/* Called only by y2Initialize		*/
   
    fprintf( stderr, "\nCDS_YACC:\n"				  );
    fprintf( stderr, "   yacc -hi infile\n\n"                     ); 
    fprintf( stderr, "Switches:\n"                                ); 
    fprintf( stderr, "   -h   Create definitions header file\n"   ); 
    fprintf( stderr, "   -i   Create parser description file\n\n" ); 
    fprintf( stderr, "Default input file extension is \".Y\"\n"   ); 
    fprintf( stderr, "Defs file same name, \".H\" extension.\n"   ); 
    fprintf( stderr, "Info file same name, \".I\" extension.\n"   ); 
   
    exit(EX_ERR);  
}  
   

/************************************************************************/
/*    y2WriteDefines    Post declarations: write out the defines        */ 
/************************************************************************/ 
static y2WriteDefines() {	/* Called only by y2yyParse		*/
  
    /********************************************************************/
    /* Write out the defines.  We do this at the end of the declaration */
    /* section.  If a %{ ... %} section is encountered we write all	*/
    /* pending declarations out to give the C code access to them.	*/
    /* Thus, we may not be writing ALL existing declarations this call: */
    /********************************************************************/

    register int  i, c; 
    register char *cp; 
           
    /* For all declarations not yet written out: */
    for (i = y2NumberOfDefinedSymbolsWritten;   i <= y2NextTerminal;   ++i) {
  
	cp = y2Terminal[i].name;
	if (*cp == ' ')   ++cp;  /* Literals. */
           
	/* Ignore defined strings with special characters in them: */
        for (   ;   c = *cp;   ++cp) {
	    if (!islower(c)  &&  !isupper(c)  &&  !isdigit(c)  &&  c != '_') {
                goto nodef; 
            } 
        } 
           
	/* Write out the #define: */
        fprintf(
	    y2ytabcFD,
	    "# define %s %d\n",
	    y2Terminal[i].name,
	    y2Terminal[i].value
	);

 
	/* If a .h file was requested, write to it also: */
        if (y2DefineFD != NULL) {
            fprintf( 
		y2DefineFD,
                "# define %s %d\n", 
		y2Terminal[i].name,
		y2Terminal[i].value
            ); 
        } 
nodef:  ; 
    } 
    y2NumberOfDefinedSymbolsWritten = y2NextTerminal+1;
} 
  

/************************************************************************/
/*	y2yyParse	Kludged YACC input parser.			*/
/************************************************************************/
y2yyParse() {		 /* Called only from main. */
 
    int  token;
    int  j;
    int  c;
    int *p;
    char actionName[8];
    int  typeOfEmpty;

    int  associativity = 0;
    int  type	       = 0;
    int  precedence    = 0;

    /* "Sorry -- no yacc parser here..... we must bootstrap somehow..."  */

    /* Handle the declaration section ended by a %% MARKer: */
    for (token = y2GetToken();     token != MARK   &&   token != ENDFILE;   ) {
  
	switch (token) {
  
        case LCURLY: 
	    /* Copy some literal C code across. Give it definitions to date: */
            y2WriteDefines(); 
            y2CpyCode(); 
	    token = y2GetToken();
            continue;  
            
        case UNION: 
            /* Copy the union declaration to the output: */  
            y2CpyUnion(); 
	    token = y2GetToken();
            continue;  
            
        case ';': 
	    token = y2GetToken();
            break; 
           
        case START: 
	    /* Handle a %start declaration: */
            if ((token = y2GetToken())   !=   IDENTIFIER) {
		y1Error( "y2yyParse: Bad %%start construction" );
            }  
	    y2RootNonterminal	= (
		y2FindName( TYPEnONTERMINAL, y2InputTokenText )
	    );
            token       = y2GetToken();
            continue; 
           
        case TYPEDEF: 
	    /* Handle a %token declaration: */
            if ((token = y2GetToken())   !=   TYPENAME) {
		y1Error( "y2yyParse: Bad syntax in %%type" );
            } 
	    type  = y2InputNumberValue;
  
	    /* Handle IDENTIFIER string following the %token: */
            loop {
  
		switch (token = y2GetToken()) {
  
		case ',':				 continue;
		case ';':	token = y2GetToken();	    break;
   
                case IDENTIFIER: 
  
		    /* Look up token, creating new entry if necessary: */
                    token = y2FindName( TYPEnONTERMINAL, y2InputTokenText );

		    /* Handle terminals and nonterminals separately: */
                    if (token < FIRSTnONTERMINAL) {
  
                        /* Terminal: */

                        /* See what it is declared as: */
                        j = TYPE( y2TerminalProperties[ token ] );
  
			/* OK if no type yet or same type: */
                        if (j == 0   ||   j == type) {

			    SETtYPEtO( y2TerminalProperties[token], type );

                        } else { 
                            y1Error( 
				"y2yyParse: Type redeclaration of token %s",
				 y2Terminal[token].name
                            ); 
                        } 
  
                    } else { 
  
			/* Nonterminal: */

			/* See what it is was previously declared as: */
                        j   = y2NonterminalState[
			    token - FIRSTnONTERMINAL
			].tvalue;
  
			/* No type or matching type ok: */
                        if (j == 0   ||   j == type) {

			    y2NonterminalState[
				token - FIRSTnONTERMINAL
			    ].tvalue = type;

                        } else { 
			    y1Error(
				"y2yyParse: Redeclaration of nonterminal %s",
				y2NonterminalState[
				    token - FIRSTnONTERMINAL
				].name
                            ); 
			}
                    } 
                    continue; 
  
                default: 
                    break; 
                } 
                break; 
            }  
            continue; 
           
        case LEFT: 
        case BINARY: 
	case RIGHT:	      ++precedence;	/* Fall into TERMINAL: */

	case TERMINAL:
	    /* Nonzero means new precedence and associativity: */
	    associativity = token - TERMINAL;
	    type  = 0;
  
            /* Get identifiers so defined: */ 
           
	    token = y2GetToken();

	    if (token == TYPENAME) {
  
                /* There is a type defined: */ 
		type	= y2InputNumberValue;
		token	= y2GetToken();
            }  

            loop {
  
		switch (token) {

                case ',':       token = y2GetToken();        continue;
		case ';':					break;

                case IDENTIFIER: 
		    j = y2FindName( TYPEtERMINAL, y2InputTokenText );

		    if (associativity) {

			if (ASSOCIATIVITY( y2TerminalProperties[j] )) {
                            y1Error( 
				"y2yyParse: Redeclaration of precedence of %s",
				y2InputTokenText
                            ); 
                        } 
			SETaSSOCIATIVITYtO(   y2TerminalProperties[j], associativity);
			SETpRECEDENCElEVELtO( y2TerminalProperties[j], precedence);
                    } 
  
		    if (type) {
			if (TYPE( y2TerminalProperties[j] )) {
                            y1Error( 
				"y2yyParse: Redeclaration of type of %s",
				y2InputTokenText
                            ); 
                        } 
			SETtYPEtO( y2TerminalProperties[j], type );
                    } 
  
		    if ((token = y2GetToken())	 ==   NUMBER) {
			y2Terminal[j].value = y2InputNumberValue;
			if (j < y2NumberOfDefinedSymbolsWritten   &&   j > 2) {
                            y1Error( 
				"y2yyParse: Must define type # of %s earlier",
				y2Terminal[j].name
                            ); 
                        } 
			token = y2GetToken();
                    } 
                    continue; 
                } 
                break; 
            }  
            continue; 
           
        default: 
	    printf(  "y2yyParse: Unrecognized character: %o\n", token);
	    y1Error( "y2yyParse: Syntax error" );
        } 
    } 
           


    /******************************/
    /* End of declaration section */
    /******************************/

    if (token == ENDFILE)  y1Error( "y2yyParse: Unexpected EOF before %%" );
  
    /* Token is MARK (%%), wrap up declaration section stuff: */
           
    y2WriteDefines(); 
           
    fprintf( y2ytabcFD,"#define yyclearin yychar = -1\n" );
    fprintf( y2ytabcFD,"#define yyerrok yyerrflag = 0\n" );
#ifdef XYZZY 
    fprintf( y2ytabcFD,"extern int yychar;\nextern short yyerrflag;\n" );
#endif 
    fprintf(
	y2ytabcFD,
	"#ifndef YYMAXDEPTH\n#define YYMAXDEPTH 150\n#endif\n"
    );
    if (!y2NumberOfTypesDefined) {
	fprintf(
	    y2ytabcFD,
	    "#ifndef YYSTYPE\n#define YYSTYPE int\n#endif\n"
	);
    } 
  
#ifdef unix  
    fprintf( y2ytabcFD,  "YYSTYPE yylval, yyval;\n" );
#else      
    fprintf( y2ytabcFD, "extern YYSTYPE yylval;  /*CSD & DECUS LEX */\n");
    fprintf( y2ytabcFD, "YYSTYPE yyval;          /*CSD & DECUS LEX */\n");
#endif     
  
    /* Set up to start parsing the rules ("productions"): */
    y2Production[ 0 ]	 = y2FreePool;
  
    /* If no %start declaration is made, the first nonterminal is used: */
  
    *y2FreePool++ = FIRSTnONTERMINAL;
    *y2FreePool++ = y2RootNonterminal;
    *y2FreePool++ = 1;
    *y2FreePool++ = 0;
  
    y2Production[1]    = y2FreePool;
  
    /* Copy any %{...%} code between the %% and the first rule: */
    while ((token = y2GetToken())   ==	 LCURLY)   y2CpyCode();
  
    if (token != C_IDENTIFIER) {
	y1Error( "y2yyParse: Bad syntax on first rule" );
    }
    if (!y2RootNonterminal) {
	y2Production[0][1] = y2FindName(TYPEnONTERMINAL,y2InputTokenText);
    }
           
    /* Now read all rules in the grammar: */
    while (token != MARK   &&	token != ENDFILE) {
  
        /* Process a rule: */ 
           
	if	 (token == '|'		 ) {
  
	    /* Copy over LHS of previous production: */
	    *y2FreePool++ = *y2Production[ y2ThisProduction-1 ];
  
	} else if (token == C_IDENTIFIER) {
  
	    /* Copy internal ID# for LHS nonterminal to first slot in rule: */
            *y2FreePool   = y2FindName( TYPEnONTERMINAL, y2InputTokenText );
	    if (*y2FreePool < FIRSTnONTERMINAL)  {
	       y1Error( "y2yyParse: Terminal illegal on LHS of grammar rule" );
	    }
	    ++y2FreePool;
  
        } else { 
  
	    y1Error( "y2yyParse: Illegal rule: missing semicolon or | ?" );
  
        } 
           
        /* Read rule body: */ 
	token = y2GetToken();
  
more_rule:  
	while (token == IDENTIFIER) {
  
	    *y2FreePool = y2FindName( TYPEnONTERMINAL, y2InputTokenText );
  
	    /* Grammar rules inherit the associativity and  */
	    /* precedence of any embedded terminals:	    */
            if (*y2FreePool < FIRSTnONTERMINAL) {
		y2ProductionProperties[ y2ThisProduction ]  = (
		    y2TerminalProperties[ *y2FreePool ]
		);
            }
  
	    ++y2FreePool;
	    token = y2GetToken();
        } 
  
	/* Handle "%prec" commands: */
        if (token == PREC) {
	    if (y2GetToken() != IDENTIFIER)   {
		y1Error( "y2yyParse: Illegal %%prec syntax" );
	    }

	    /* Look up terminal specified in %prec: */
            j   = y2FindName( TYPEpREC, y2InputTokenText );

	    /* Make sure it is not a nonterminal: */
            if (j >= FIRSTnONTERMINAL) {
                y1Error( 
		    "y2yyParse: Nonterminal %s illegal after %%prec",
		    y2NonterminalState[ j-FIRSTnONTERMINAL ].name
                ); 
            } 

	    /* Let current rule inherit specified precedence: */
	    y2ProductionProperties[ y2ThisProduction ] = (
		y2TerminalProperties[ j ]
	    );
            token = y2GetToken();
        } 
  
	/* Handle actions: */
        if (token == '=') {
            int RHSItems;

	    /* Remember that this rule has an action: */
            y2ProductionProperties[ y2ThisProduction ]   |= RULEhASaCTION;

	    /* Figure number of items seen so far on right-hand side */
	    /* of grammar rule (for check $n args in actions):	     */
	    RHSItems  =  y2FreePool  -	y2Production[ y2ThisProduction ]  -1;

	    /* Copy action code to output, handling $ variables: */
            y2CpyAction( RHSItems );

	    /* Check for more rule after the action: */
            if ((token = y2GetToken())   ==   IDENTIFIER) {
  
		/* Action within rule. Split it into two rules: */
		sprintf( actionName, "$$%d", y2ThisProduction );
  
		/* Create a nonterminal: */
		j = y2FindName(TYPEnONTERMINAL,actionName);
  
  
                /*******************************************************/ 
		/* The current rule will become rule number	       */
		/* y2ThisProduction+1.	Move the contents down, and    */
		/* make room for the null:			       */
                /*******************************************************/ 
  
		for (
		    p  = y2FreePool;
		    p >= y2Production[ y2ThisProduction ];
		    p--
		) {
		    p[2] = *p;
		}
                y2FreePool += 2;
  
                /* Enter null production for action: */ 
		p	= y2Production[ y2ThisProduction ];
                *p++    = j; 
		*p++	= -y2ThisProduction;
           
                /* Update the production information: */ 

		/* Current rule does NOT have an action after all: */
		y2ProductionProperties[ y2ThisProduction+1 ] = (
		    y2ProductionProperties[ y2ThisProduction ] & ~RULEhASaCTION
		);

		/* But added null production DOES have an action: */
		y2ProductionProperties[ y2ThisProduction   ] =	RULEhASaCTION;
           
		/* Check for too productions: */
		if (++y2ThisProduction >= MAXpRODUCTIONS)   {
		    y1Error( "y2yyParse: More than %d rules", MAXpRODUCTIONS );
		}
		y2Production[ y2ThisProduction ]    = p;
           
                /* Make the action appear in the original rule: */ 
		*y2FreePool++ = j;
  
                /* Get some more of the rule: */ 
                goto more_rule; 
            }  
        } 
           
	/* Handle end of rule: */
        while (token == ';')    token = y2GetToken();
           
	*y2FreePool++ = -y2ThisProduction;
           
        /* Check that default action is reasonable: */ 
           
        if ( 
	    y2NumberOfTypesDefined
            && 
	    !(y2ProductionProperties[ y2ThisProduction ] & RULEhASaCTION)
            && 
	    y2NonterminalState[ * /* DeSmet C bug pins the '*' to this line */
		y2Production[ y2ThisProduction ]
		-
		FIRSTnONTERMINAL
	    ].tvalue
	) {
            /* No explicit action, LHS has value: */ 
	    typeOfEmpty = y2Production[ y2ThisProduction ][ 1 ];
  
	    if (typeOfEmpty < 0) {
  
		y1Error("y2yyParse: Must return value, since LHS has a type");

	    } else if (typeOfEmpty >= FIRSTnONTERMINAL ) {
  
		 typeOfEmpty = (
		     y2NonterminalState[ typeOfEmpty-FIRSTnONTERMINAL ].tvalue
		 );
            } else { 
  
		 typeOfEmpty = TYPE( y2TerminalProperties[typeOfEmpty] );
            } 
  
	    if (
		typeOfEmpty
		!=
		y2NonterminalState[ * /* DeSmet C bug keeps '*' from moving */
		    y2Production[ y2ThisProduction ]
		    -
		    FIRSTnONTERMINAL
		].tvalue
	    ) {
		y1Error("y2yyParse: Default action has potential type clash");
	    }
        } 

	/* Check for too many productions: */
	if (++y2ThisProduction >= MAXpRODUCTIONS)  {
	     y1Error( "y2yyParse: more than %d rules", MAXpRODUCTIONS );
	}
  
	y2Production[ y2ThisProduction ]	   = y2FreePool;
	y2ProductionProperties[ y2ThisProduction ] =   0;
    } 
  

    /*********************/
    /* End of all rules: */
    /*********************/

    /* Properly terminate the last line: */ 
    fprintf(y2ActionFD, "/* End of actions. */");
    fclose( y2ActionFD );
    fprintf( y2ytabcFD, "# define YYERRCODE %d\n", y2Terminal[2].value );
  
    /* Copy anything remaining to the output code file: */
    if (token == MARK) {
	fprintf( y2ytabcFD, "\n#line %d\n", y1LineNumber );
  
	while ((c = y1GetChar( y2InputFD ))   !=   EOF)   putc( c, y2ytabcFD );
    } 
    fclose( y2InputFD );

    /* All finished with input! Now return and start analysing grammar: */
}
           
/************************************************************************/
/*                              y3.c                                    */ 
/*  YACC source file #3 (of 4).                                         */ 
/************************************************************************/    
     
/************************************************************************/    
/*                              contents                                */    
/*                                                                      */    
/*    y3ActionIndex     Write out the array of action-function pointers.*/
/*  * y3AGoto		Write the gotos for one nonterminal.		*/
/*    y3Gotos		Write the gotos for all nonterminals.		*/
/*    y3HideProductions Free up mem[] and y1Action[] for optimizer.	*/
/*    y3PackState	Pack state i from y1Temp into y1Action. 	*/
/*    y3PutArray        Write out an array.                             */
/*    y3PutStates	Write the states and tables.			*/
/*  * y3ShiftReduce	Decide a shift/reduce conflict by precedence.	*/
/*  * y3WrtAction	Write out state i.				*/
/*  * y3WrtState	Write state i.					*/
/*                                                                      */
/* * Local to this file.                                                */ 
/*									*/
/************************************************************************/    
    
    
/************************************************************************/
/*                              history                                 */    
/*                                                                      */    
/* 85Nov19 CrT	y3ActionIndex.						*/
/* 85Nov15 CrT	Global variable names decrypted.			*/
/* 85Nov13 CrT	Give plaintiff routine in error messages.		*/
/* 85Nov12 CrT	Function names decrypted. Still unique in first 6 chars.*/
/* 85Nov11 CrT	y3.c reconstructed from  9 subfiles.  Cosmetics.	*/
/* 81Aug28 RBD  Modified to make debug code conditionally compile.      */ 
/* 7?????? SCJ  Created.                                                */ 
/*                                                                      */ 
/*                              credits                                 */ 
/*      CrT=CrT                                                         */ 
/*      RBD=Bob Denny                                                   */  
/*      SCJ=Steven C Johnson.                                           */  
/*      SG =Scott Guthery                                               */  
/************************************************************************/ 
  
   

                                                                  
/* The number of the last reduction of a state: */
static int y3LastReduction;

/* The default actions of states: */
int y3DefaultAction[MAXsTATES];

/************************************************************************/
/*    y3ActionIndex	Write out the array of action-function pointers.*/
/************************************************************************/
y3ActionIndex() {
    int i;
 
    /* First, declare all action functions: */

    /* Declare the default (null) action: */
    fprintf( y2ytabcFD, "\nint yyANop();" );

    /* Declare all action functions created from user-supplied code chunks: */
    FORaLLpRODUCTIONS(0,i)  {
        if (y2ProductionProperties[ i ]   &   RULEhASaCTION) { 
            fprintf( y2ytabcFD, "\nint yyA%03d();", i ); 
        } 
    } 

    /* Now declare and initialize yyActionIndex[]: */
    fprintf( y2ytabcFD, "\n\n/* Table with an action function per rule: */" );
    fprintf(
	y2ytabcFD,
        "\nstatic (*(yyActionIndex[%d]))() = {",
	y2ThisProduction
    );
    FORaLLpRODUCTIONS(0,i)  {
        if (y2ProductionProperties[ i ]   &   RULEhASaCTION) { 
	    fprintf( y2ytabcFD, "\n    yyA%03d", i );
	} else {
	    fprintf( y2ytabcFD, "\n    yyANop"	   );
	}
	if (i < y2ThisProduction-1)   fprintf( y2ytabcFD, "," );
    }
    fprintf( y2ytabcFD, "\n};\n\n" );
}

/************************************************************************/
/*    y3AGoto		Write the gotos for one nonterminal.		*/
/************************************************************************/
static y3AGoto( c )	       /* Called only from y3Gotos */
int c;
{
    int 	i, work, cc;
    struct item *p, *q;
  
  
    /* First, find nonterminals with gotos on c: */
  
    y1ArrayFill( y1Temp, y2LastNonterminal+1, 0 );

    y1Temp[ c ] = 1;
  
    for (work = 1;   work;   )	 {
	work = 0;

	FORaLLpRODUCTIONS(0,i) {

	    if ((cc = y2Production[ i ][ 1 ] - FIRSTnONTERMINAL)   >=	0) {

                /* cc is a nonterminal: */

		if (y1Temp[ cc ]) {

		    /* cc has a goto on c: */

		    /* Thus, the left side of production i does too: */
		    cc = *y2Production[ i ] - FIRSTnONTERMINAL;

		    if (y1Temp[cc] == 0) {
			work	  = 1;
			y1Temp[cc] = 1;
		    }
		}
            } 
	}
    }
  
    /* "Now, we have y1Temp[c] = 1 if a goto on c in closure of cc" :-) */
  
#ifdef debug 
    if (y2OutputFD != NULL) {

	fprintf( y2OutputFD, "%s: gotos on ", y2NonterminalState[c].name );

	FORaLLnONTERMINALS(i) {
	    if (y1Temp[i]) {
		fprintf( y2OutputFD, "%s ", y2NonterminalState[i].name);
	    }
        }
	fprintf( y2OutputFD, "\n");
    }
#endif 

    /* Now, go through and put gotos into y1StateType: */
  
    y1ArrayFill( y1StateType, y1NextState, 0 );

    FORaLLsTATES(i) {

	FORaLLiTEMS(i,p,q) {

	    if ((cc = *p->pitem)   >=	FIRSTnONTERMINAL) {

		if (y1Temp[cc -= FIRSTnONTERMINAL]) {

		    /* goto on c is possible: */
		    y1StateType[ i ]	= y1Action[ y1GotoIndex[ i ] +c ];
		    break;
		}
            } 
	}
    }
}
 
/************************************************************************/
/*    y3Gotos           Write the gotos for all nonterminals.           */
/************************************************************************/
y3Gotos() {		/* Called only from main. */
    int   i, j, k, best, count, cbest, times;
  
    /* Mark begining of gotos: */
    fprintf( y2TempFileFD, "$\n" );

    for (i = 1;   i <= y2LastNonterminal;   ++i) {

	y3AGoto( i );
  
	/* Find the best one to make default: */
  
	best	= -1;
	times	= 0;
  
	for (j = 0;   j <= y1NextState;   ++j) {

	    /* Is j the most frequent? */
	    if (y1StateType[ j ]   ==	 0)   continue;
	    if (y1StateType[ j ]   == best)   continue;
  
	    /* Is y1StateType[j] the most frequent? */
  
	    count   = 0;
	    cbest   = y1StateType[ j ];
  
	    for (k = j;   k <= y1NextState;   ++k) {

		if (y1StateType[ k ]   ==   cbest)   ++count;
  
	    }
	    if (count > times) {
		best	= cbest;
		times	= count;
	    }
	}

	/* Best is now the default entry: */

	y1GotosSavedByDefault += (times-1);

	for (j = 0;   j <= y1NextState;   ++j) {

	    if (y1StateType[ j ] != 0	&&   y1StateType[ j ] != best) {

		fprintf( y2TempFileFD, "%d,%d,", j, y1StateType[j] );
		y1GotoEntries += 1;
	    }
	}

	/* Now, the default: */

	y1GotoEntries += 1;
	fprintf( y2TempFileFD, "%d\n", best );
    }
}
 
/************************************************************************/
/*    y3HideProductions Free up mem[] and y1Action[] for optimizer.	    */
/************************************************************************/
y3HideProductions() {		/* Called only from main. */

    /********************************************************************/
    /* In order to free up the mem and y1Action arrays for the optimizer,   */
    /* and still be able to output yyr1, etc., after the sizes of	*/
    /* the action array is known, we hide the nonterminals		*/
    /* derived by productions in y2ProductionProperties:				*/
    /********************************************************************/

    register i, j;
          
    j		= 0;
    y2ProductionProperties[0]	= 0;

    FORaLLpRODUCTIONS(1,i) {
	if ( !(y2ProductionProperties[i] & RULEhASbEENrEDUCED) ) {
	    ++j;

	    if (y2OutputFD != NULL) {
		fprintf(
		    y2OutputFD,
		    "Rule not reduced:   %s\n",
		    y1WriteItem( y2Production[i] )
		);
            } 
	}
	y2ProductionProperties[i] = *y2Production[i] - FIRSTnONTERMINAL;
    }
    if (j)  fprintf( stdout, "%d rules never reduced\n", j );
}
 
/************************************************************************/
/*    y3PackState	Pack state i from y1Temp into y1Action. 	     */
/************************************************************************/ 
y3PackState( p, n )     /* Called only from y1MakeStates        */ 
int *p; 
{ 
    int off; 
    register *pp, *qq, *rr; 
    int *q, *r; 
           
    /****************************************************/ 
    /* We don't need to worry about checking because we */ 
    /* will only look for entries known to be there.	*/
    /****************************************************/ 
  
    /* Eliminate leading and trailing 0's: */ 
           
    q   = p+n; 
  
    for (pp=p, off=0;   *pp==0 && pp<=q;   ++pp, --off); 
  
    if (pp > q)   return(0);  /* no actions */ 
  
    p   = pp; 
           
    /* Now, find a place for the elements from p to q, inclusive: */ 
           
    r	= &y1Action[ MAXaCTIONS -1 ];
  
    for (rr = y1Action;   rr <= r;   ++rr, ++off) {
  
        /* Try rr: */ 
        for (qq=rr, pp=p;   pp <= q;   ++pp, ++qq) { 
  
            if (*pp != 0 ) { 
                if (*pp != *qq   &&   *qq != 0)   goto nextk; 
            }  
        } 
           
        /* We have found an acceptable k: */ 
           
#ifdef debug  
	if (y2OutputFD != NULL) {
	     fprintf(y2OutputFD,"off = %d, k = %d\n",off,rr-y1Action);
	}
#endif     
  
        for (qq=rr, pp=p;   pp <= q;   ++pp, ++qq) { 
  
            if (*pp) { 
		if (qq > r   )	 {
		    y1Error( "y3PackState: Action table overflow" );
		}
                if (qq > y1NextAction)   y1NextAction = qq;
                *qq = *pp; 
            }  
        } 
  
#ifdef debug  
	if (y2OutputFD != NULL) {
	    for (pp = y1Action;   pp <= y1NextAction;	pp += 10) {
		fprintf( y2OutputFD, "\t");
                for (qq = pp;   qq <= pp+9;   ++qq) { 
		    fprintf( y2OutputFD, "%d ", *qq );
                } 
		fprintf( y2OutputFD, "\n" );
            }  
        } 
#endif     
  
        return   off; 
           
nextk:  ; 
    } 
  
    y1Error( "y3PackState: No space in action table" );
  
    /* NOTREACHED */ 
} 
  
/************************************************************************/
/*    y3PutArray        Write out an array.                             */ 
/************************************************************************/ 
y3PutArray( s, v, n )           /* Called only from y1Others */ 
char *s; 
int  *v, n; 
{ 
    register i; 
           
    fprintf( y2ytabcFD, "\nshort %s[] = {\n", s );
  
    for (i = 0;   i < n;   ) { 
  
	if (i % 10   ==   0)   fprintf( y2ytabcFD, "\n" );
  
	fprintf( y2ytabcFD, "%4d", v[i] );
  
	if (++i == n)	fprintf( y2ytabcFD, "\n};\n" );
	else		fprintf( y2ytabcFD, ","      );
    } 
} 
  
/************************************************************************/
/*    y3PutStates       Write the states and tables.                    */
/************************************************************************/
y3PutStates() { 	/* Called only from main. */

    int 		 i, k, c;
    register struct wset *u, *v;
          
    fprintf( y2ytabcFD, "\nshort yyexca[] = {\n" );
          
    FORaLLsTATES(i) {
          
	/* Write the stuff for state i: */
	y1NoLookahead = !(y1StateType[i]==MUSTlOOKaHEADsTATE);
	y1Closure(i);
          
	/* Write actions: */
	y1NoLookahead = 1;
	y1ArrayFill( y1Temp, y2NextTerminal+y2LastNonterminal+1, 0 );

	FORaLLwORKINGsETS(y1WorkingSet,u)  {
          
	    c = *( u->pitem );

	    if (c > 1	&&   c < FIRSTnONTERMINAL   &&	 y1Temp[ c ] == 0) {

		FORaLLwORKINGsETS(u,v) {

		    if (c == *(v->pitem)) {
			y1PutItem( v->pitem+1, (struct looksets *)0 );
		    }
		}
		y1Temp[ c ]  = y1State( c );

	    } else if( c > FIRSTnONTERMINAL && !y1Temp[ (c -= FIRSTnONTERMINAL) + y2NextTerminal ]) {

		y1Temp[ c+y2NextTerminal ] = y1Action[y1GotoIndex[i]+c];
            } 
	}
          
	if (i == 1)   y1Temp[ 1 ] = ACCEPTaCTION;
          
	/* We have the shifts;	Look at the reductions: */
          
	y3LastReduction = 0;

	FORaLLwORKINGsETS(y1WorkingSet,u) {

	    c = *( u->pitem );

	    if (c <= 0) {

		/* Reduction: */
		y3LastReduction = -c;

		FORaLLtERMINALS(k) {

		    if (GETBIT(u->ws.lset,k)) {

			if (y1Temp[ k ] == 0)  {

			    y1Temp[ k ] = c;

			} else if( y1Temp[k]<0 ) {

			    /* Reduce/reduce conflict: */
			    if (y2OutputFD != NULL) {
				fprintf(
				    y2OutputFD,
				    "\n%d: reduce/reduce conflict (red'ns %d and %d ) on %s",
				    i,
				    -y1Temp[k],
				    y3LastReduction,
				    y1SymbolName(k)
				);
			    }

			    if (-y1Temp[k] > y3LastReduction)	y1Temp[k] = -y3LastReduction;
			    ++y1ReduceReduceConflicts;

			} else {

			    /* Potential shift/reduce conflict: */
			    y3ShiftReduce( y3LastReduction, k, i );
			}
		    }
		}
	    }
	}
	y3WrtAction(i);
    }
    fprintf( y2ytabcFD, "\n};\n" );
          
    fprintf( y2ytabcFD, "# define %s %d\n", "YYNPROD", y2ThisProduction );
}
 
/************************************************************************/
/*      y3ShiftReduce   Decide a shift/reduce conflict by precedence.   */ 
/************************************************************************/ 
y3ShiftReduce(r,t,s)            /* Called only from y3PutStates */ 
int r, t, s; 
{ 
    /*****************************************************/ 
    /* Decide a shift/reduce conflict by precedence.     */ 
    /* r is a rule number, t a token number.             */ 
    /* The conflict is in state s.                       */ 
    /* y1Temp[t] is changed to reflect the action.	  */
    /*****************************************************/ 
           
    int lp,lt, action; 
           
    lp	= y2ProductionProperties[ r ];
    lt	= y2TerminalProperties[ t ];
  
    if ( 
	! PRECEDENCElEVEL(lt)
        || 
	! PRECEDENCElEVEL(lp)
    ) { 
  
        /* Conflict: */ 
	if (y2OutputFD != NULL) {
            fprintf( 
		y2OutputFD,
                "\n%d: shift/reduce conflict (shift %d, red'n %d) on %s", 
                s, 
		y1Temp[t],
                r, 
                y1SymbolName(t) 
            ); 
        } 
	++y1ShiftReduceConflicts;
        return; 
    } 
  
    if (PRECEDENCElEVEL(lt) == PRECEDENCElEVEL(lp)) {
  
	action = ASSOCIATIVITY(lt);
  
    } else if( PRECEDENCElEVEL(lt) > PRECEDENCElEVEL(lp) ) {
  
        /* Shift: */ 
	action = RIGHTaSSOCIATIVE;
  
    } else { 
  
        /* Reduce: */ 
	action = LEFTaSSOCIATIVE;
    } 
           
    switch (action) { 
  
    case BINARYaSSOCIATIVE:
        /* Error action: */ 
	y1Temp[t] = ERRORaCTION;
        return; 
           
    case LEFTaSSOCIATIVE:
        /* Reduce: */ 
	y1Temp[t] = -r;
        return; 
    } 
} 
  
  
/************************************************************************/
/*	y3WrtAction	Write out state i.				*/
/************************************************************************/
static y3WrtAction( i ) 	/* Called only from y3PutStates */
int i;
{
    /* Write out state i.  y1Temp has the actions, y3LastReduction the default: */
    int p, p0, p1;
    int ntimes, tred, count, j;
    int flag;
          
    /* Find the best choice for y3LastReduction: */
          
    y3LastReduction = 0;
    ntimes  = 0;

    FORaLLtERMINALS(j) {

	if (y1Temp[ j ] 	    >=	 0)   continue;
	if (y1Temp[ j ] + y3LastReduction   ==	 0)   continue;

	/* Count the number of appearances of y1Temp[j]: */

	count		= 0;
	tred		= -y1Temp[ j ];
	y2ProductionProperties[tred]   |= RULEhASbEENrEDUCED;

	FORaLLtERMINALS(p) {
	    if (y1Temp[ p ] + tred   ==   0)   ++count;
	}

	if (count > ntimes) {
	    y3LastReduction = tred;
	    ntimes = count;
	}
    }
          
    /**********************************************************************/
    /* For error recovery, arrange that, if there is a shift on the error */
    /* recovery token, `error', that the default be the error action:	  */
    /**********************************************************************/

    if (y1Temp[ 1 ]   >   0)   y3LastReduction = 0;
          
    /* Clear out entries in y1Temp which equal y3LastReduction: */

    FORaLLtERMINALS(p)	 if (y1Temp[ p ] + y3LastReduction   ==   0)   y1Temp[ p ] = 0;
          
    y3WrtState( i );

    y3DefaultAction[ i ] = y3LastReduction;
    flag	=	0;

    FORaLLtERMINALS(p0) {

	if (p1 = y1Temp[ p0 ]) {

            if (p1 < 0) {

                p1 = -p1;
		goto exc;

	    } else if( p1 == ACCEPTaCTION ) {

		p1 = -1;
		goto exc;

	    } else if( p1 ==	ERRORaCTION ) {

		p1 = 0;
		goto exc;
exc:      
		if (flag++ == 0)   fprintf( y2ytabcFD, "-1, %d,\n", i );
		fprintf( y2ytabcFD, "\t%d, %d,\n", y2Terminal[p0].value, p1 );
		++y1Exceptions;

            } else {
		fprintf( y2TempFileFD, "%d,%d,", y2Terminal[p0].value, p1 );
		++y1ShiftEntries;
            } 
	}
    }

    if (flag) {
	y3DefaultAction[ i ] = -2;
	fprintf( y2ytabcFD, "\t-2, %d,\n", y3LastReduction );
    }
    fprintf( y2TempFileFD, "\n" );
    return;
}
 
/************************************************************************/
/*	y3WrtState	Write state i.					*/
/************************************************************************/
static y3WrtState( i )	       /* Called only from y3WrtAction */
int i;
{
    register	      j0,j1;
    register struct   item *pp, *qq;
    register struct   wset *u;
          
    if (y2OutputFD == NULL)   return;
    fprintf( y2OutputFD, "\nstate %d\n", i );

    FORaLLiTEMS( i, pp, qq ) {
	fprintf( y2OutputFD, "\t%s\n", y1WriteItem(pp->pitem) );
    }
 
    if (y1StateType[i] == MUSTlOOKaHEADsTATE) {

	/* Print out empty productions in closure: */
	FORaLLwORKINGsETS( y1WorkingSet+(y1StateItem[i+1]-y1StateItem[i]), u ){

	    if( *(u->pitem) < 0 )  {
		fprintf( y2OutputFD, "\t%s\n", y1WriteItem(u->pitem) );
	    }
	}
    }
          
    /* Check for state equal to another: */
          
    FORaLLtERMINALS(j0) {

	if (j1 = y1Temp[ j0 ]) {

	    fprintf( y2OutputFD, "\n\t%s  ", y1SymbolName(j0) );

	    if (j1 <= 0) {
		fprintf( y2OutputFD, "reduce %d",-j1 );
	    } else {

		/* Shift, error, or accept: */
		if	(j1 == ACCEPTaCTION ) fprintf( y2OutputFD, "accept"  );
		else if (j1 ==	ERRORaCTION ) fprintf( y2OutputFD, "error"   );
		else			 fprintf( y2OutputFD, "shift %d", j1 );
	    }
	}
    }
          
    /* Write the final production: */
          
    if (y3LastReduction)  {
	fprintf( y2OutputFD, "\n\t.  reduce %d\n\n", y3LastReduction );
    } else {
	fprintf( y2OutputFD, "\n\t.  error\n\n" 		     );
    }
          
    /* Now, output nonterminal actions: */
          
    j1	= y2NextTerminal;

    for (j0 = 1;   j0 <= y2LastNonterminal;   ++j0) {
	if (y1Temp[ ++j1 ])  {
	    fprintf(
		y2OutputFD,
		"\t%s  goto %d\n",
		y1SymbolName( j0+FIRSTnONTERMINAL),
		y1Temp[j1]
	    );
	}
    }
}
          
/************************************************************************/
/*				y4.c					*/
/*  YACC source file #4 (of 4). 					*/
/************************************************************************/    
     
/************************************************************************/    
/*				contents				*/
/*									*/
/*									*/
/*  * y4PutParser	Write out the parser: yyact, yypact, yypgo.	*/
/*  * y4PutArray	y4PutParser helper.				*/
/*    y4Optimize							*/
/*  * y4EnterGoto	Enter goto on nonterminal i into array a.	*/
/*  * y4GetNumber	Read and convert an integer from stdin. 	*/
/*  * y4NextI		Find the next i.				*/
/*  * y4OptSummary	Summarize optimizer performance.		*/
/*  * y4StoreState	Enter state i into the a array. 		*/
/*									*/
/* * Local to this file.						*/
/*									*/
/************************************************************************/
    
    
/************************************************************************/   
/*                              history                                 */    
/*                                                                      */    
/* 85Nov15 CrT  Global variable names decrypted.                        */
/* 85Nov13 CrT	Give plaintiff routine in error messages.		*/
/* 85Nov12 CrT	Function names decrypted. Still unique in first 6 chars.*/
/* 85Nov11 CrT	y4.c reconstructed from  8 subfiles.  Cosmetics.	*/
/* 80Dec18 RBD	ZAPFILE not used for decus compiler, fmkdl() used.	*/
/* 80Dec06 RBD	Broken out of y4.c, impure data in y4imp.c.		*/
/* 7?????? SCJ	Created.						*/
/*                                                                      */ 
/*                              credits                                 */ 
/*      CrT=CrT                                                         */ 
/*      RBD=Bob Denny                                                   */  
/*      SCJ=Steven C Johnson.                                           */  
/*      SG =Scott Guthery                                               */  
/************************************************************************/ 

   
                  
#define yypact y1Temp
#define y4Greed  y1StateType
                  
#define NOMORE -1000
                  
static int * y4GGreed = y1LookaheadSet[0].lset;
static int * y4pgo    = y1WorkingSet[0].ws.lset;
static int * yypgo  = &y2NonterminalState[0].tvalue;
                  
static int y4MaxSpread = 0;	    /* Maximum spread of any entry.		    */
static int y4MaxOffset = 0;	    /* Maximum offset into y1Action array.		   */
static int *y4FreePool	= y2Pool;
static int *y4LastAction;

/* Debug switch for nextI. Set to TRUE for debugging printouts. */
static int y4DebugNext	 = 0;

/* Debugging switch for action optimization. Set to: */
/*     0 for no debugging printouts.                 */
/*     1 for no debugging printouts.		     */
/*     2 for general narration.                      */
/*     3 for narration plus complete table dump.     */

static int y4DebugActions    = 0;

/************************************************************************/ 
/*    y4PutParser	Write out the parser: yyact, yypact, yypgo.	*/
/************************************************************************/
static y4PutParser() {		/* Called only by y4Optimize	*/

    fprintf( y2ytabcFD, "# define YYLAST %d\n", y4LastAction-y1Action+1 );
          
    y4PutArray( "yyact" ,   y1Action, (y4LastAction-y1Action)+1 );
    y4PutArray( "yypact",  y1GotoIndex, y1NextState	);
    y4PutArray( "yypgo" , y4pgo, y2LastNonterminal+1  );
}
 
/************************************************************************/
/*	y4PutArray	y4PutParser helper.				*/
/************************************************************************/
y4PutArray( s, v, n )		/* Called only by y4PutParser. */
char *s;
int  *v, n;
{
    register i;
          
    fprintf( y2ytabcFD, "short %s[]={\n", s );

    for (i = 0;   i < n;   ) {

	if (i % 10   ==   0)   fprintf( y2ytabcFD, "\n"    );

	fprintf( y2ytabcFD, "%4d", v[i] );

	if (++i == n)	       fprintf( y2ytabcFD, " };\n" );
	else		       fprintf( y2ytabcFD, ","	   );
    }
}

/************************************************************************/
/*    y4Optimize	Read the arrays from tempfile, set parameters.	*/
/************************************************************************/
y4Optimize() {		/* Called only from main. */
           
    register i, *p, j, k, *q; 
           
    /* Read the arrays from tempfile and set parameters: */ 
  
    if ((y2InputFD = fopen(TEMPNAME,"r"))   ==	 NULL) {
	y1Error( "y4Optimize: Cannot open tempfile" );
    } 
  
    y4pgo[0]	  = 0;
    yypact[0]   = 0; 
    y1NextState      = 0;
    y2LastNonterminal	  = 0;
  
    loop {
  
        switch (y4GetNumber()) { 
  
	case '\n':	yypact[++y1NextState] = (--y4FreePool) - y2Pool;     continue;
        case ',':                                               continue; 
        case '$':                                               break; 
        default: 
	    y1Error( "y4Optimize: Bad tempfile(1)" );
        } 
        break; 
    } 
           
    yypact[ y1NextState ]    = yypgo[0]  = (--y4FreePool) - y2Pool;
           
    loop {
  
        switch (y4GetNumber()) { 
  
	case '\n':	yypgo[++y2LastNonterminal]= y4FreePool-y2Pool;		  continue;
        case '\r':                                              continue; 
        case ',' :                                              continue; 
        case -1  :      /* EOF */                               break; 
        default: 
	    y1Error( "y4Optimize: Bad tempfile(2)" );
        } 
        break; 
    } 
           
    yypgo[ y2LastNonterminal-- ]  = (--y4FreePool) - y2Pool;
  
    for (i = 0;   i < y1NextState;   ++i) {
        k = 32000; 
        j = 0; 
	q = y2Pool + yypact[i+1];
	for (p = y2Pool + yypact[i];   p < q;	p += 2) {
  
            if (*p > j)   j = *p; 
            if (*p < k)   k = *p; 
        } 
  
        if (k <= j) { 
  
            /***********************************************/ 
            /* Nontrivial situation.                       */ 
            /* Temporarily, kill this for compatibility    */ 
            /* j -= k;  j is now the range                 */ 
            /***********************************************/ 
  
	    if (k > y4MaxOffset)   y4MaxOffset = k;
        } 
	y4Greed[i]    = (yypact[ i+1 ] - yypact[ i ])	+   2 * j;
  
	if (j > y4MaxSpread)   y4MaxSpread = j;
    } 
           
    /* Initialize y4GGreed table: */
           
    for (i = 1;   i <= y2LastNonterminal;   ++i) {
  
	y4GGreed[i] = 1;
        j = 0; 
  
        /* Minimum entry index is always 0: */ 
	q = y2Pool + yypgo[i+1] -1;
  
	for (p = y2Pool + yypgo[ i ];	p < q;	 p += 2) {
  
	    y4GGreed[i] += 2;
  
            if (*p > j)   j = *p; 
        } 
	y4GGreed[ i ] = y4GGreed[ i ]	+   2 * j;
  
	if (j > y4MaxOffset)   y4MaxOffset = j;
    } 
           
    /* Prepare to put the shift actions into the y1Action array: */
           
    for (i = 0;   i < MAXaCTIONS;   ++i)   y1Action[i] = 0;
    y4LastAction = y1Action;
           
    for (i = 0;   i < y1NextState;   ++i) {
  
	if (y4Greed[ i ] == 0	&&   y4DebugActions > 1) {
  
	    fprintf( y2ytabcFD, "State %d: null\n", i );
        } 
	y1GotoIndex[i] = YYFLAG1;
    } 
           
    while ((i = y4NextI())   !=   NOMORE) { 
  
        if (i >= 0)   y4StoreState(  i ); 
        else          y4EnterGoto(  -i ); 
           
    } 
           
    if (y4DebugActions > 2) {
  
	/* Print y1Action array: */
	for (p = y1Action;   p <= y4LastAction;   p += 10) {
  
	    fprintf( y2ytabcFD, "%4d  ", p-y1Action );
  
	    for (i = 0;   i < 10;   ++i)   fprintf( y2ytabcFD, "%4d  ", p[i] );
  
	    fprintf( y2ytabcFD, "\n" );
        } 
    } 
  
    /* Write out the output appropriate to the language: */ 
    y4PutParser(); 
           
    y4OptSummary(); 
           
    fclose( y2InputFD );
  
    ZAPFILE(TEMPNAME); 
} 

/************************************************************************/
/*	y4EnterGoto	Enter goto on nonterminal i into array y1Action.       */
/************************************************************************/
y4EnterGoto( i )	/* Called only from y4Optimize. */
int i;
{
    register *p, *r, *s, *q1, *q2;
          
    y4GGreed[ i ] = 0;
          
    q2	= y2Pool + yypgo[i+1] - 1;
    q1	= y2Pool + yypgo[i  ]	 ;
          
    /* Find a place for it: */
          
    for (p = y1Action;	 p < &y1Action[MAXaCTIONS];   ++p) {

	if (*p)   continue;

	for (r = q1;   r < q2;	 r += 2) {

	    s = p + *r +1;

	    if (*s)   goto nextgp;

	    if (s > y4LastAction) {
		if ((y4LastAction = s) > &y1Action[ MAXaCTIONS ])   {
		    y1Error( "y4EnterGoto: Array y1Action[] overflowed(1)" );
		}
            } 
	}

        /* We have found a spot: */
          
	*p  = *q2;

	if (p > y4LastAction) {

	    if ((y4LastAction = p)   >	 &y1Action[ MAXaCTIONS ]) {
		y1Error( "y4EnterGoto: Array y1Action[] overflowed(2)" );
	    }
	}

	for (r = q1;   r < q2;	 r += 2) {

	    s  = p + *r + 1;
	    *s = r[ 1 ]    ;
	}
          
	y4pgo[ i ]    = p - y1Action;

	if (y4DebugActions > 1) {
	    fprintf(
		y2ytabcFD,
		"Nonterminal %d, entry at %d\n",
		i,
		y4pgo[i]
	    );
	}
	goto nextgi;
nextgp: ;

    }
    y1Error( "y4EnterGoto: Cannot place goto %d\n", i );
          
nextgi:   
    ;
}
 
/************************************************************************/
/*	y4GetNumber	Read and convert an integer from stdin. 	*/
/************************************************************************/
static y4GetNumber() {		/* Called only from y4Optimize. */
    register s, val, c;
          
   /*********************************************************/
   /* Read and convert an integer from the standard input.  */
   /* Return the terminating character. 		    */
   /* Blanks, tabs, and newlines are ignored.		    */
   /*********************************************************/

   s	= 1;
   val	= 0;
          
   while  ((c = y1GetChar( y2InputFD ))   !=   EOF) {

	if	(isdigit( c ))	  val = val * 10   +   (c - '0');
	else if ( c == '-'   )	  s   = -1			;
	else if ( c == '\r'  )	  continue			;
	else			  break 			;

    }

    *y4FreePool++ = s * val;

    if (y4FreePool > &y2Pool[ MAXy2POOL ])   y1Error( "y4GetNumber: Out of space" );

    return   c;
}
 
/************************************************************************/
/*	y4NextI 	Find the next i.				*/
/************************************************************************/
static y4NextI() {	/* Called only from y4Optimize. */
    register i, max, maxi;
          
    max = 0;
          
    for (i = 1;   i <= y2LastNonterminal;   ++i){

	if( y4GGreed[i] >= max ) {

	    max     = y4GGreed[i];
	    maxi    = -i;
	}
    }
          
    for (i = 0;   i < y1NextState;   ++i) {

	if (y4Greed[ i ]   >=	max) {

	    max     = y4Greed[i];
	    maxi    = i;
	}
    }
          
    if (y4DebugNext    )   fprintf( y2ytabcFD, "nxti = %d, max = %d\n", maxi, max );
    if (max == 0)   return NOMORE;
    else	    return maxi  ;
}
 
/************************************************************************/
/*    y4OptSummary      Summary optimizer performance.                  */
/************************************************************************/
static y4OptSummary() { 	/* Called only from y4Optimize. */

    register int i, *p;
          
    if (y2OutputFD == NULL)   return;
          
    i	= 0;

    for (p = y4LastAction;   p >= y1Action;   --p) {

	if (*p == 0)   ++i;
    }

    fprintf(
	y2OutputFD,
	"Optimizer space used: input %d/%d, output %d/%d\n",
	y4FreePool-y2Pool+1,
	MAXy2POOL,
	y4LastAction - y1Action +1,
	MAXaCTIONS
    );
    fprintf(   y2OutputFD,   "%d table entries, %d zero\n",   (y4LastAction-y1Action)+1,   i);

    fprintf(
	y2OutputFD,
	"maximum spread: %d, maximum offset: %d\n",
	y4MaxSpread,
	y4MaxOffset
    );
    fclose( y2OutputFD );
}
 
/************************************************************************/
/*	y4StoreState	Enter state i into the y1Action array.		       */
/************************************************************************/
static y4StoreState( i )	/* Called only from y4Optimize. */
int i;
{
    register *r, *s, n, flag, j, *q1, *q2;
          
    y4Greed[ i ]  = 0;
          
    q2	= y2Pool + yypact[ i+1 ];
    q1	= y2Pool + yypact[ i   ];

    /* Find an acceptable place: */
          
    for (n = -y4MaxOffset;   n < MAXaCTIONS;   ++n) {

	flag = 0;

	for (r = q1;   r < q2;	 r += 2) {

	    if ((s = *r + n + y1Action)   <   y1Action)   goto nextn;

	    if (*s == 0)	   ++flag;
	    else if (*s != r[1])   goto nextn;
	}
          
        /********************************************/
	/* Check that the position equals another   */
	/* only if the states are identical:	    */
        /********************************************/

	for (j = 0;   j < y1NextState;	 ++j) {

	    if (y1GotoIndex[ j ] == n) {

		if (flag)   goto nextn;  /* We have some disagreement. */

		if (yypact[ j+1 ] + yypact[i]	==   yypact[j] + yypact[i+1]) {

		    /* States are equal: */
		    y1GotoIndex[ i ] = n;

		    if (y4DebugActions > 1) {
			fprintf(
			    y2ytabcFD,
			    "State %d: entry at %d equals state %d\n",
			    i,
			    n,
			    j
			);
		    }
		    return;
		}

		/* We have some disagreement: */
		goto nextn;
	    }
	}
          
	for (r = q1;   r < q2;	 r += 2) {

	    if ((s = *r + n + y1Action)   >=   &y1Action[ MAXaCTIONS ]) {
		y1Error( "y4StoreState: Out of space in optimizer y1Action[] array" );
	    }

	    if (s > y4LastAction)   y4LastAction = s;

            if (*s != 0   &&   *s != r[1]) {
		y1Error(
		    "y4StoreState: y1Action[] array clobbered, pos'n %d, by %d",
		    s-y1Action,
		    r[1]
		);
	    }
	    *s = r[1];
	}
	y1GotoIndex[ i ] = n;

	if (y4DebugActions > 1)   fprintf( y2ytabcFD, "State %d: entry at %d\n", i, y1GotoIndex[i] );

        return; 
          
nextn:	;
    }
    y1Error( "y4StoreState: Failed to place state %d\n",   i   );
}
