 IDENTIFICATION DIVISION.
 PROGRAM-ID. CBLMRG.
*********************************************
*
*
*
*	RSX VERSION
*
*  MODIFIED ON 13-NOVEMBER-78 BY HARRISON
*	TO INCLUDE A DEFAULT MERGE AND TO
*	ELIMINATE SOME OFFENSIVE LANGUAGE
*
*  MODIFIED ON 5-OCTOBER-78 BY HARRISON
*	TO ACCEPT NEW RMS ODL'S AND OVERLAY
*	OTS
*
*  MODIFIED ON 24-JULY-78 BY HARRISON
*	TO ACCEPT THE COBOL DEBUGGER.
*
*  MODIFIED ON 7-APR-77 BY FRIEDMAN
*	MODIFIED TO MAKE OUTPUT FILE HAVE
*	VARIABLE LENGTH RECORDS.
*
*  MODIFIED ON 3-FEB-77 BY FRIEDMAN
*
*
*********************************************
*	COPYRIGHT (C) 1977
*	DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
*
*	THIS SOFTWARE IS FURNISHED UNDER A LICENSE FOR USE ONLY
*	ON A SINGLE COMPUTER SYSTEM AND MAY BE COPIED ONLY WITH
*	THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS
*	SOFTWARE, OR ANY OTHER COPIES THEREOF, MAY NOT BE
*	PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER PERSON
*	EXCEPT FOR USE ON SUCH SYSTEM AND TO ONE WHO AGREES TO
*	THESE LICENSE TERMS.  TITLE TO AND OWNERSHIP OF THE
*	SOFTWARE SHALL AT ALL TIMES REMAIN IN DIGITAL EQUIPMENT 
*	CORPORATION.
*
*	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE
*	WITHOUT NOTICE AND SHOULD NOT BE CONSTRUED
*	AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
*
*	DIGITAL EQUIPMENT CORPORATION ASSUMES NO RESPONSIBILITY
*	FOR THE USE OR RELIABILITY OF ITS SOFTWARE ON EQUIPMENT
*	WHICH IS NOT SUPPLIED BY DIGITAL EQUIPMENT CORPORATION.
*

 ENVIRONMENT DIVISION.
 CONFIGURATION SECTION.
	SOURCE COMPUTER PDP-11
	OBJECT COMPUTER PDP-11
 INPUT-OUTPUT SECTION.
 FILE-CONTROL.
	SELECT OUTPUT-ODL
		ASSIGN TO "SY: .ODL"
		ORGANIZATION SEQUENTIAL
		ACCESS SEQUENTIAL
		STATUS OUTPUT-STATUS.
	SELECT INPUT-ODL
		ASSIGN TO "SY: .ODL"
		ORGANIZATION SEQUENTIAL
		ACCESS SEQUENTIAL
		STATUS INPUT-STATUS.
 DATA DIVISION.
 FILE SECTION.
 FD OUTPUT-ODL
	RECORD CONTAINS 40 TO 80 CHARACTERS
	LABEL RECORD STANDARD
	DATA RECORD OUT-REC
	VALUE OF ID IS OUTPUT-ODL-NAME.
 01 OUT-REC PIC X(80).
 FD INPUT-ODL
	LABEL RECORD STANDARD
	DATA RECORD IN-REC
	VALUE OF ID IS INPUT-ODL-NAME.
 01 IN-REC PIC X(80).
 WORKING-STORAGE SECTION.
*01 PPN-OR-UIC PIC X(3) VALUE "PPN".
*01 PPN-UIC-FMT PIC X(20) VALUE "[PROJECT,PROGRAMMER]".
 01 PPN-OR-UIC PIC X(3) VALUE "UIC".
 01 PPN-UIC-FMT PIC X(20) VALUE "[GROUP,MEMBER]".
 01 INPUT-PPN-OR-UIC PIC X(50).
 01 INPUT-PPN-REDEF REDEFINES INPUT-PPN-OR-UIC.
	05 FIRST-CHAR PIC X.
	05 FILLER PIC X(49).
 01 OUTPUT-ODL-NAME PIC X(30) VALUE SPACES.
 01 OUTPUT-STATUS PIC X(2).
 01 INPUT-ODL-NAME PIC X(30) VALUE SPACES.
 01 INPUT-STATUS PIC X(2).
 01 TEMP-INPUT-ODL-NAME PIC X(30) VALUE SPACES.
 01 OUTPUT-ODL-ERROR PIC 9(4) COMP.
 01 INPUT-ODL-ERROR PIC 9(4) COMP.
 01 MONTHS PIC X(36)
	VALUE "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC".
 01 MONTHS-REDEF REDEFINES MONTHS.
	05 MONTH-TAB PIC X(3) OCCURS 12.
 01 MERGE-DATE PIC 9(6).
 01 MERGE-DATE-REDEF REDEFINES MERGE-DATE.
	05 MYR PIC X(2).
	05 MMON PIC 9(2).
	05 MDAY PIC X(2).
 01 MERGE-TIME PIC 9(8).
 01 MERGE-TIME-REDEF REDEFINES MERGE-TIME.
	05 MHR PIC X(2).
	05 MMIN PIC X(2).
	05 MSEC PIC X(2).
	05 FILLER PIC X(2).
 01 ODL-HDR.
	05 MG-CN1 PIC X(28) VALUE ";MERGED ODL FILE CREATED ON ".
	05 DD PIC X(2).
	05 FILLER PIC X(1) VALUE "-".
	05 MM PIC X(3).
	05 FILLER PIC X(1) VALUE "-".
	05 YY PIC X(2).
	05 MERGE-CONST2 PIC X(4) VALUE " AT ".
	05 HH PIC X(2).
	05 FILLER PIC X(1) VALUE ":".
	05 MIN PIC X(2).
	05 FILLER PIC X(1) VALUE ":".
	05 SS PIC X(2).
 01 ANS PIC X.
*
* RMS CHANGES 5-OCT-78  - FOR NEW RMS ODL FILES   :AWH
*
 01 RESIDENT-LIBRARY	PIC 9 VALUE 0.
 01 DEFAULT-UIC-TOKEN PIC X VALUE SPACES.
 01 DEFAULT-MERGE	PIC X VALUE SPACES.
 01 DEFAULT-OVERLAY	PIC 9 VALUE 0.
 01 USERS-ODL-FILESPEC	PIC X(30) VALUE SPACES.
*
* CID REFERENCES 31-7-78  :AWH
*
 01 CID-ANS	PIC X.
 01 HDR-ERROR PIC 9(4) COMP VALUE 0.
 01 COBMAIN PIC 9(4) COMP VALUE 0.
 01 COBMAIN-ALREADY PIC 9(4) COMP VALUE 0.
 01 SEMI-COUNT PIC 9(4) COMP VALUE 0.
 01 EQUAL-COUNT PIC 9(4) COMP VALUE 0.
 01 PERIOD-COUNT PIC 9(4) COMP VALUE 0.
 01 COMMA-COUNT PIC 9(4) COMP.
 01 COLON-COUNT PIC 9(4) COMP.
 01 LEFT-BRACKET PIC 9(4) COMP.
 01 RIGHT-BRACKET PIC 9(4) COMP.
 01 PPN-ERROR PIC 9(4) COMP.
 01 MERGED-ODL PIC 9(4) COMP.
 01 OPEN-FLAG PIC 9(4) COMP.
 01 RMS-FROM-LIBRARY PIC 9(4) COMP.
 01 FIELD0 PIC X(50).
 01 FIELD1 PIC X(50).
 01 FIELD2 PIC X(50).
 01 FIELD2-REDEF REDEFINES FIELD2.
	05 FARR PIC X OCCURS 50.
 01 IX1 PIC 9(4) COMP.
 01 PPN-COUNT PIC 9(4) COMP.
 01 KEYWORD PIC X(10).
 01 KEYVALUE PIC X(13).
 01 COBOBJ PIC X(15).
 01 COBKER PIC X(2).
 01 OBJ-STRING PIC X(66) VALUE SPACES.
 01 OBJPTR PIC 9(4) COMP VALUE 1.
 01 OVR-STRING PIC X(50) VALUE SPACES.
 01 OVRPTR PIC 9(4) COMP VALUE 1.
 01 OBJ-LINE.
	05 OBJ-FAC-NAME PIC X(6).
	05 FILLER PIC X(8) VALUE ": .FCTR ".
	05 OBJ-NAMES PIC X(66) VALUE SPACES.
 01 TEMP-OBJ PIC X(30).
 01 TEMP-PTR PIC 9(4) COMP VALUE 0.
01 TEMP-COUNT PIC 9(4) COMP VALUE 0.
01 TEMP-COUNT-2 PIC 9(4) COMP VALUE 0.
01 TEST-OBJ PIC X(50).
 01 TEMP-OVR.
	05 KK PIC X(2).
 	05 CONST PIC X(4) VALUE "OVR$".
 01 TEMP-OVR-PTR PIC 9(4) COMP VALUE 0.
 01 CURR-OBJ-FAC.
	05 CB PIC X(2) VALUE "CB".
	05 OBJ-FAC-COUNT PIC 9(2) DISPLAY VALUE 0.
	05 JDOL PIC X(2) VALUE "J$".
 01 CURR-OVR-FAC.
	05 CB PIC X(2) VALUE "CB".
 	05 OVR-FAC-COUNT PIC 9(2) DISPLAY VALUE 0.
	05 RDOL PIC X(2) VALUE "R$".
 01 OVR-LINE.
	05 OVR-FAC-NAME PIC X(6).
	05 FILLER PIC X(8) VALUE ": .FCTR ".
	05 OVR-NAMES PIC X(66) VALUE SPACES.
* CONST-OBJRT-REC WILL CHANGE IF  DEBUGGER USED - 31-7-78 :AWH
 01 OBJRT-REC.
	05 CONST-OBJRT-REC PIC X(34) VALUE 
		"OBJRT$: .FCTR CBOBJ$-CBOTS$!".
	05 VAR-OBJRT-REC PIC X(46) VALUE
		SPACES.
 01 COBLIB-UIC PIC X(12) VALUE "LB:[1,1]".
 01 COBLIB PIC X(18) VALUE "COBOVR/LB".
 01 COBOVR-NAME PIC X(80) VALUE IS "        .NAME OTS$OV".
 01 CBOVR PIC X(9) VALUE "-(CBOVR$)".
 01 ROOT-REC PIC X(80) VALUE "        .ROOT OBJRT$!".
 01 CBOTS-REC.
	05 CONST-CBOTS-REC PIC X(14) VALUE "CBOTS$: .FCTR ".
	05 VAR-CBOTS-REC PIC X(66) VALUE SPACES.
* CID REFERENCES 31-7-78 :AWH
 01 CID PIC X(10) VALUE IS "CID".
 01 CID-REC.
	05 CONST-CID-REC PIC X(14) VALUE IS "CID$:   .FCTR ".
	05 VAR-CID-REC PIC X(66) VALUE IS SPACES.

 01 RMSREQ-COUNT PIC 9(4) VALUE 0.
 01 RMSREQ-MAX PIC 9(4) VALUE 10.
 01 WORK-RMSREQ.
	05 RMSREQ-SUFF PIC X(2) VALUE "CI".
	05 RMSREQ-OLAY PIC 9 VALUE 0.
	05 RMSREQ-SYNC PIC 9 VALUE 0.
	05 RMSREQ-ORG PIC 9 VALUE 0.
	05 RMSREQ-OPS PIC 9 VALUE 7.
 01 WORK-RMSREQ-INIT PIC X(6) VALUE "CIO007".
 01 RMSREQ-ARRAY.
	05 RMSREQ PIC X(10) OCCURS 10.
*
 01 LOOP-COUNT PIC 9(4) COMP.
*
 01 SEQ-OPS PIC 9 VALUE 0.
 01 REL-OPS PIC 9 VALUE 0.
 01 INDEX-OPS PIC 9 VALUE 0.
 01 COMPOSITE-ORG PIC 9 VALUE 0.
*
 01 SEQ-ORG-CODE PIC 9 VALUE 1.
 01 REL-ORG-CODE PIC 9 VALUE 2.
 01 INDEX-ORG-CODE PIC 9 VALUE 3.
*
 01 WORK-OPS PIC 9.
 01 WORK-VAL PIC 9.
 01 C2 PIC 9 VALUE 2.
*
 01 WORK-B0 PIC 9.
 01 WORK-B1 PIC 9.
 01 WORK-B2 PIC 9.
*
 01 OPS-B0 PIC 9.
 01 OPS-B1 PIC 9.
 01 OPS-B2 PIC 9.
*
 01 RMS-UIC PIC X(10) VALUE "LB:[1,1]".
 01 RMSLIB PIC X(20) VALUE "RMSLIB/LB".
 01 RMS-FCTR.
	05 RMS-FCTR-CONST PIC X(15) VALUE "RMS$:   .FCTR ".
	05 RMS-VAR-STRING PIC X(50) VALUE SPACES.
 01 RMSPTR PIC 9(4) COMP VALUE 1.
 01 RMSROT PIC X(10) VALUE ",RMSTR$".
 01 RMSTR PIC X(7) VALUE SPACES.
 01 SIMPLE-ROOT PIC X(7) VALUE "RMSROT".
 01 INDEXED-ROOT PIC X(7) VALUE "RMSROT".
 01 RMSTR-STRING.
	05 RMSTR-STRING-FIXED PIC X(21) 
		VALUE "RMSTR$: .FCTR RMS$TR-".
	05 RMSTR-STRING-VAR PIC X(10) VALUE SPACES.
 01 NAME-STRING PIC X(20)
	VALUE "        .NAME RMS$TR".
 01 RMS-NEEDED-STRING PIC X(6) VALUE SPACES.
 PROCEDURE DIVISION.
 DECLARATIVES.
 OUTPUT-ODL-USE SECTION.
 USE-1.
	USE AFTER ERROR PROCEDURE ON OUTPUT-ODL.
	IF OPEN-FLAG = 1
		DISPLAY "OPEN UNSUCCESSFUL"
		COMPUTE OUTPUT-ODL-ERROR = 1
	ELSE
		DISPLAY "WRITE ERROR--MUST ABORT"
		GO TO ABORT-EXECUTION.
 INPUT-ODL-USE SECTION.
 USE-2.
	USE AFTER ERROR PROCEDURE ON INPUT-ODL.
	IF OPEN-FLAG = 1
		DISPLAY "OPEN UNSUCCESSFUL"
		COMPUTE INPUT-ODL-ERROR = 1
	ELSE
		DISPLAY "READ ERROR--MUST ABORT"
		GO TO ABORT-EXECUTION.
 END DECLARATIVES.
 MAIN-CONTROL SECTION.
 P1.
*	THIS IS THE MAIN CONTROL SECTION OF THE ODL BIND
*	PROGRAM.  THIS SECTION ASKS THE USER FOR THE NAME OF
*	THE OUTPUT FILE, OPENS IT FOR WRITING, AND THEN ASKS
*	FOR THE NAMES OF THE INPUT ODL FILES TO BE MERGED.
*	ACTUAL MERGING IS DONE BY PERFORMING UTILITY
*	PROCEDURES, OUTSIDE OF THE FLOW OF THIS CONTROL
*	SECTION.
*
 GET-OUTPUT-FILESPEC.
*	THIS PARAGRAPH ASKS THE USER FOR THE FILESPEC
*	OF THE OUTPUT FILE, AND OPENS THE FILE.
	COMPUTE OUTPUT-ODL-ERROR = 0.
	DISPLAY "PLEASE ENTER FILE SPECIFICATION FOR OUTPUT FILE".
	ACCEPT OUTPUT-ODL-NAME.
	COMPUTE OPEN-FLAG = 1.
	OPEN OUTPUT OUTPUT-ODL.
	IF OUTPUT-ODL-ERROR = 1 GO TO GET-OUTPUT-FILESPEC.
	COMPUTE OPEN-FLAG = 0.
*	GET THE DATE AND TIME, AND INSERT INTO THE HEADER RECORD 
*	OF THE OUTPUT FILE.
	ACCEPT MERGE-DATE  FROM DATE.
	ACCEPT MERGE-TIME  FROM TIME.
	MOVE MDAY TO DD OF ODL-HDR.
	MOVE MONTH-TAB(MMON) TO MM OF ODL-HDR.
 	MOVE MYR TO YY OF ODL-HDR.
	MOVE MHR TO HH OF ODL-HDR .
	MOVE MMIN TO MIN OF ODL-HDR.
	MOVE MSEC TO SS OF ODL-HDR.
	WRITE OUT-REC FROM ODL-HDR.

*
* THIS QUESTION ANSWERS MANY OTHERS AND AVOIDS TEDIUM
*

 ASK-DEFAULT-MERGE.
	DISPLAY "DO YOU WANT A DEFAULT MERGE?".
 DEFAULT-MERGE-ANSWER.
	DISPLAY "PLEASE ANSWER Y(ES), N(O), OR H(ELP) "
		WITH NO ADVANCING.
	ACCEPT DEFAULT-MERGE.
	IF DEFAULT-MERGE = "Y"
		MOVE 0 TO MERGED-ODL
		MOVE 0 TO CID-ANS
		GO TO ASK-FOR-COBLIB
	 ELSE IF DEFAULT-MERGE = "N"
		GO TO ASK-FOR-MERGED
	 ELSE IF DEFAULT-MERGE = "H"
		PERFORM HELP-DEFAULT
		GO TO DEFAULT-MERGE-ANSWER.
	GO TO DEFAULT-MERGE-ANSWER.
 ASK-FOR-MERGED.
*	THIS PARAGRAPH ASKS WHETHER THE USER WANTS AN
*	"ABBREVIATED" OR "MERGED" ODL FILE.  AN "ABBREVIATED"
*	ODL FILE CONTAINS INDIRECT REFERENCES TO THE INPUT ODL
*	FILES, I.E., "@INPUT.ODL".  A MERGED ODL FILE CONTAINS
*	AN EXACT COPY OF THE INPUT ODL FILE.

	DISPLAY "DO YOU WANT AN ABBREVIATED OR MERGED ODL FILE?".
	DISPLAY "PLEASE ANSWER A(BBREVIATED), M(ERGED), OR H(ELP) "
		WITH NO ADVANCING.
 MERGED-ANS.
	ACCEPT ANS.
	IF ANS = "M" COMPUTE MERGED-ODL = 1
		ELSE IF ANS = "A" COMPUTE MERGED-ODL = 0
		ELSE IF ANS = "H" PERFORM HELP-A-OR-M
			DISPLAY "PLEASE ANSWER A OR M "
				WITH NO ADVANCING
			GO TO MERGED-ANS
		ELSE
			DISPLAY "PLEASE ANSWER A, M, OR H "
				WITH NO ADVANCING
			GO TO MERGED-ANS.
ASK-FOR-DEBUGGER.
	DISPLAY "DO YOU WANT TO INCLUDE THE COBOL DEBUGGER (CID)?"
	DISPLAY "PLEASE ANSWER Y(ES) OR N(O) " WITH NO ADVANCING.
DEBUGGER-ANS.
	ACCEPT ANS.
	IF ANS = "Y" MOVE 1 TO CID-ANS
	   ELSE IF ANS = "N" MOVE 0 TO CID-ANS
	   ELSE DISPLAY "PLEASE ANSWER Y OR N " WITH NO ADVANCING
		GO TO DEBUGGER-ANS.
	MOVE SPACES TO ANS.
	IF CID-ANS = 1
		STRING COBLIB-UIC DELIMITED BY SPACES
		 CID DELIMITED BY SPACES
		 INTO VAR-CID-REC
		MOVE "OBJRT$: .FCTR CBOBJ$-CID$-CBOTS$!" TO
		 CONST-OBJRT-REC.
 ASK-FOR-COBLIB.
*
*	THIS SECTION ASKS WHETHER THE COBOL OTS SHOULD BE SELECTIVELY
*	LOADED FROM THE COBLIB LIBRARY, OR WHETHER A DEFAULT COBOL 
*	OTS OVERLAY STRUCTURE SHOULD BE USED TO LOAD IN THE ENTIRE 
*	COBOL OTS.
*
**********NOTE... FOR NOW THE LIBRARY IS ALWAYS USED*************

	STRING COBLIB-UIC DELIMITED BY SPACES
		COBLIB DELIMITED BY SPACES
		INTO VAR-CBOTS-REC.

 ASK-FOR-RMSLIB.
*
*	THIS PARAGRAPH ASKS WHETHER THE RMS ROUTINES ARE TO BE LOADED
*	INTO THE TASK IMAGE SELECTIVELY FROM THE RMSLIB OR WHETHER
*	AN OVERLAY STRUCTURE IS TO BE USED TO LOAD THE RMS
*	ROUTINES NEEDED FOR THE TASK.
*


	IF DEFAULT-MERGE = "Y"
		MOVE 0 TO RMS-FROM-LIBRARY
		MOVE 1 TO DEFAULT-OVERLAY
		GO TO GET-INPUT-FILESPEC.
	DISPLAY "DO YOU WANT TO OVERLAY I/O SUPPORT ROUTINES?".
 RMS-LIB-ANS.
	DISPLAY "PLEASE ANSWER Y(ES), N(O), OR H(ELP) "
		WITH NO ADVANCING.
	ACCEPT ANS.
	IF ANS = "Y" COMPUTE RMS-FROM-LIBRARY = 0
		ELSE IF ANS = "N" COMPUTE RMS-FROM-LIBRARY = 1
		ELSE IF ANS = "H" PERFORM HELP-OVERLAY
			GO TO RMS-LIB-ANS
		ELSE GO TO RMS-LIB-ANS.

	IF RMS-FROM-LIBRARY = 1
	STRING RMS-UIC DELIMITED BY SPACES
		RMSLIB DELIMITED BY SPACES
		INTO RMS-VAR-STRING
		GO TO GET-INPUT-FILESPEC.


DEFAULT-RMS-OVERLAY.

* THIS SECTIONS ALLOWS A USER TO SPECIFY HIS HAND TAILORED RMS ODL
* IF HE IS THAT MASOCHISTIC

	DISPLAY "DO YOU WANT TO USE THE DEC SUPPLIED I/O
-		" OVERLAY STRUCTURE".

DEFAULT-ANS.
	DISPLAY "PLEASE ANSWER Y(ES), N(O), OR H(ELP) "
		WITH NO ADVANCING.
	ACCEPT ANS.
	IF ANS = "Y" 
		MOVE 1 TO DEFAULT-OVERLAY
		GO TO GET-INPUT-FILESPEC
	 ELSE IF ANS = "N"
		MOVE 0 TO DEFAULT-OVERLAY
	 ELSE IF ANS = "H"
		DISPLAY " "
		DISPLAY "ANSWER Y(ES)!"
		DISPLAY " "
		DISPLAY "FOR MORE DOCUMENTATION, PLEASE READ
-			" CHAPTER TWO"
		DISPLAY "OF THE COBOL USERS GUIDE."
		GO TO  DEFAULT-ANS
	 ELSE IF ANS = "R"
		MOVE 1 TO RESIDENT-LIBRARY
		MOVE 1 TO DEFAULT-OVERLAY
		GO TO GET-INPUT-FILESPEC
	 ELSE GO TO DEFAULT-ANS.

USERS-OVERLAY.
	DISPLAY "PLEASE ENTER YOUR ODL FILE SPEC: "
		WITH NO ADVANCING.
	ACCEPT USERS-ODL-FILESPEC.
	MOVE SPACES TO FIELD0,FIELD1.
	UNSTRING USERS-ODL-FILESPEC DELIMITED BY "." INTO FIELD0
		FIELD1.
	IF FIELD0 = SPACES OR FIELD1 = SPACES
		DISPLAY "INCOMPLETE FILE SPECIFICATION: ", 
			USERS-ODL-FILESPEC
		MOVE SPACES TO FIELD0, FIELD1
		GO TO USERS-OVERLAY.
	MOVE SPACES TO FIELD0, FIELD1.

*	
 GET-INPUT-FILESPEC.
*	THIS PARAGRAPH GETS THE FILE SPECIFICATION OF THE INPUT ODL 
*	FILE, AND OPENS THE FILE.
	COMPUTE INPUT-ODL-ERROR = 0.
	MOVE SPACES TO TEMP-INPUT-ODL-NAME.
	DISPLAY "PLEASE ENTER FILE SPECIFICATION FOR INPUT ODL FILE".
	ACCEPT TEMP-INPUT-ODL-NAME.
 GET-INPUT-ODL-PPN-OR-UIC.
	MOVE SPACES TO FIELD0, INPUT-PPN-OR-UIC.
	UNSTRING TEMP-INPUT-ODL-NAME DELIMITED BY "]" INTO
		FIELD0 DELIMITER IN DEFAULT-UIC-TOKEN.
	IF DEFAULT-UIC-TOKEN = "]"
		STRING FIELD0 DELIMITED BY SPACES
		"]" DELIMITED BY SIZE
		INTO INPUT-PPN-OR-UIC.
*	SCAN THE FILE SPECIFICATION FOR ".".
	COMPUTE PERIOD-COUNT = 0.
	INSPECT TEMP-INPUT-ODL-NAME TALLYING PERIOD-COUNT
		FOR ALL ".".
	COMPUTE TEMP-PTR = 1.
*	MOVE THE FILE SPECIFICATION TO VALUE OF ID VARIABLE
	MOVE SPACES TO INPUT-ODL-NAME.
	STRING TEMP-INPUT-ODL-NAME DELIMITED BY SPACE
		INTO INPUT-ODL-NAME POINTER TEMP-PTR.
*	IF NO "." WAS PRESENT, APPEND ".ODL" TO THE FILESPEC.
	IF PERIOD-COUNT = 0
		STRING ".ODL" DELIMITED BY SIZE INTO 
		INPUT-ODL-NAME POINTER TEMP-PTR.
	COMPUTE OPEN-FLAG = 1.
	OPEN INPUT INPUT-ODL.
	IF INPUT-ODL-ERROR = 1 GO TO ASK-FOR-MORE.
	COMPUTE OPEN-FLAG = 0.
*	PERFORM UTILITY PROCEDURES TO PROCESS THE INPUT ODL FILES
*
	PERFORM PROCESS-INPUT-ODL.
	IF RMS-FROM-LIBRARY = 0
		PERFORM PROCESS-RMSREQ.
*
 ASK-FOR-MORE.
	DISPLAY "ANY MORE INPUT ODL FILES? ".
GET-ANSWER.
	DISPLAY "PLEASE ANSWER Y(ES) OR N(O) "
		WITH NO ADVANCING.
	ACCEPT ANS.
	IF ANS = "Y" GO TO GET-INPUT-FILESPEC
		ELSE IF ANS = "N" GO TO FINISH-CHECK
			ELSE GO TO GET-ANSWER.
*
 FINISH-CHECK.
*	THIS PARAGRAPH CHECKS TO SEE WHETHER A MAIN PROGRAM
*	HAS BEEN INCLUDED IN THE GENERATED ODL FILE.  IF NOT,
*	A WARNING DIAGNOSTIC IS ISSUED, AND THE USER IS
*	ASKED FOR MORE INPUT ODL FILES.
*
	IF COBMAIN-ALREADY = 0
		DISPLAY "WARNING: NO MAIN PROGRAM SPECIFIED YET"
		DISPLAY
		"THE ODL FILE GENERATED SO FAR IS INCOMPLETE"
		GO TO ASK-FOR-MORE.
*
 FINISH-UP.
	MOVE "CBOBJ$" TO OBJ-FAC-NAME.
	MOVE OBJ-STRING TO OBJ-NAMES.
	WRITE OUT-REC FROM OBJ-LINE.
	IF OVR-STRING NOT = SPACES
		MOVE "CBOVR$" TO OVR-FAC-NAME
		MOVE OVR-STRING TO OVR-NAMES
		WRITE OUT-REC FROM OVR-LINE
	ELSE MOVE SPACES TO CBOVR.
	IF CID-ANS NOT = 0
		WRITE OUT-REC FROM CID-REC.
	WRITE OUT-REC FROM CBOTS-REC.
	WRITE OUT-REC FROM COBOVR-NAME.
	
	MOVE "CNVRT$" TO OVR-FAC-NAME.
	MOVE "LB:[1,1]COBOVR/LB:CONVER" TO OVR-NAMES.
	WRITE OUT-REC FROM OVR-LINE.

	MOVE "LDCVT$" TO OVR-FAC-NAME.
	MOVE "LB:[1,1]COBOVR/LB:LDCVT" TO OVR-NAMES.
	WRITE OUT-REC FROM OVR-LINE.

	MOVE "USRIO$" TO OVR-FAC-NAME.
	MOVE "LB:[1,1]COBOVR/LB:USRSIO" TO OVR-NAMES
	WRITE OUT-REC FROM OVR-LINE.

	MOVE "OTSOV$" TO OVR-FAC-NAME.
	MOVE "OTS$OV-(CNVRT$-(*LDCVT$),*USRIO$)" TO OVR-NAMES.
	WRITE OUT-REC FROM OVR-LINE.

	IF RMS-FROM-LIBRARY = 0 AND RMSREQ-COUNT NOT = 0
		PERFORM RMSREQ-ODL
		WRITE OUT-REC FROM RMS-FCTR
		MOVE "-RMS$" TO RMS-NEEDED-STRING
	ELSE IF RMSREQ-COUNT NOT = 0
		WRITE OUT-REC FROM RMS-FCTR
		MOVE "-RMS$" TO RMS-NEEDED-STRING.
	MOVE SPACES TO OUT-REC.
	STRING OBJRT-REC DELIMITED BY "!"
		RMS-NEEDED-STRING DELIMITED BY SPACES
		INTO OUT-REC.
	WRITE OUT-REC.
	MOVE SPACES TO OUT-REC.
	STRING ROOT-REC DELIMITED BY "!"
		CBOVR DELIMITED BY SPACES
		RMSTR DELIMITED BY SPACES
		",OTSOV$" DELIMITED BY SIZE
		INTO OUT-REC.
	WRITE OUT-REC.
	MOVE "        .END" TO OUT-REC.
	WRITE OUT-REC.
	CLOSE OUTPUT-ODL.
	DISPLAY "ODL FILE MERGE COMPLETE".
	DISPLAY "MERGED ODL FILE IS: " OUTPUT-ODL-NAME.
 STOP-IT.
	STOP RUN.
*
*
*
 PROCESS-INPUT-ODL SECTION.
 P1.
	MOVE SPACES TO COBOBJ COBKER.
	COMPUTE HDR-ERROR = 0.
	COMPUTE COBMAIN = 0.
 READ-INPUT-ODL.
	MOVE SPACES TO IN-REC.
	READ INPUT-ODL AT END GO TO ADD-TO-ODL.
	PERFORM HDR-CHECK.
	IF HDR-ERROR = 1 GO TO CLOSE-INPUT-ODL
	ELSE GO TO READ-INPUT-ODL.
 ADD-TO-ODL.
*	THIS PARAGRAPH IS ENTERED WHEN THE ENTIRE INPUT ODL FILE
*	HAS BEEN SCANNED.
*	ENTRY CONDITIONS:
*	1.  COBMAIN EQUALS 1 IF THE INPUT ODL FILE CONTAINED
*	    A ;COBMAIN HEADER LINE.
*	2.  COBOBJ CONTAINS THE NAME OF THE OBJECT FILE,
*	    ACQUIRED FROM THE ;COBOBJ HEADER LINE.
*	3.  COBKER CONTAINS THE PSECT NAME KERNEL, ACQUIRED
*	FROM THE ;COBKER HEADER LINE.
*
*
	IF COBMAIN = 1 AND COBMAIN-ALREADY
		DISPLAY "THIS ODL FILE CONTAINS A ;COBMAIN LINE"
		DISPLAY "A ;COBMAIN HEADER LINE HAS ALREADY OCCURRED"
		DISPLAY "THIS ODL FILE IS IGNORED"
		GO TO CLOSE-INPUT-ODL.

	IF COBKER = SPACES AND COBOBJ = SPACES
		DISPLAY "NOT STANDARD COBOL ODL FILE"
		DISPLAY "THIS FILE IS IGNORED"
		GO TO CLOSE-INPUT-ODL.
	IF COBMAIN = 1 MOVE COBMAIN TO COBMAIN-ALREADY.
	IF MERGED-ODL = 0 PERFORM MAKE-INDIRECT-REF
		ELSE PERFORM MERGE-INPUT-ODL.
	PERFORM INSERT-OBJ.
	IF COBKER NOT = SPACES
		PERFORM INSERT-OVR.
	IF RMSREQ-COUNT NOT = 0
		PERFORM PROCESS-RMSREQ.
	
 CLOSE-INPUT-ODL.
	CLOSE INPUT-ODL.

 HDR-CHECK SECTION.
 P1.
	MOVE 0 TO SEMI-COUNT EQUAL-COUNT.
	INSPECT IN-REC TALLYING SEMI-COUNT FOR ALL ";"
		EQUAL-COUNT FOR ALL "=".
	IF SEMI-COUNT = 1 AND EQUAL-COUNT = 1
		PERFORM HDR-SCAN1
	ELSE IF SEMI-COUNT = 1
		PERFORM HDR-SCAN2.

 HDR-SCAN1 SECTION.
 P1.
*	THIS SECTION IS EXECUTED IF AN INPUT LINE CONTAINS
*	EXACTLY ONE SEMI-COLON AND ONE EQUAL SIGN.  HERE, WE CHECK
*	TO DETERMINE WHETHER THE LINE IS A ;COBOBJ OR ;COBKER LINE
*	OR A ;RMSREQ LINE.

	UNSTRING IN-REC DELIMITED BY ";" INTO FIELD0 FIELD1.
*	AT THIS POINT, FIELD1 CONTAINS EVERYTHING TO THE RIGHT OF ";"
	UNSTRING FIELD1 DELIMITED BY "=" INTO KEYWORD,FIELD2.
*	AT THIS POINT, FIELD2 CONTAINS EVERYTHING TO THE RIGHT OF "="
	UNSTRING FIELD2 DELIMITED BY " " INTO KEYVALUE.
	IF KEYWORD = "COBOBJ" PERFORM COBOBJ-CHECK
	ELSE IF KEYWORD = "COBKER" PERFORM COBKER-CHECK
	ELSE IF KEYWORD = "RMSREQ" PERFORM RMSREQ-CHECK.


 COBOBJ-CHECK SECTION.
 P1.
*	THIS SECTION DETERMINES WHETHER A COBOBJ HEADER LINE
*	HAS ALREADY BEEN PROCESSED FOR THIS OBJECT FILE.  IF SO,
*	A DIAGNOSTIC IS ISSUED, OTHERWISE, THE COBOBJ NAME IS 
* 	STORED AWAY.
	IF COBOBJ NOT = ALL SPACES
		DISPLAY "MULTIPLE ;COBOBJ HEADER LINE DETECTED"
		DISPLAY "THIS ODL FILE IS IGNORED"
		COMPUTE HDR-ERROR = 1
	ELSE MOVE KEYVALUE TO COBOBJ.
 COBKER-CHECK SECTION.
 P1.
*	THIS SECTION DETERMINES WHETHER A COBKER HEADER LINE
*	HAS ALREADY BEEN PROCESSED FOR THIS OBJECT FILE.  IF SO,
*	A DIAGNOSTIC IS ISSUED, OTHERWISE, THE COBKER
*	NAME IS STORED AWAY.

	IF COBKER NOT = ALL SPACES
		DISPLAY "MULTIPLE ;COBKER HEADER LINE DETECTED"
		DISPLAY "THIS ODL FILE IS IGNORED"
		COMPUTE HDR-ERROR = 1
	ELSE MOVE KEYVALUE TO COBKER.

 RMSREQ-CHECK SECTION.
 P1.
*	THIS SECTION SAVES THE RMSREQ NAME INTO AN ARRAY OF
*	RMSREQ NAMES, AFTER MAKING THE FOLLOWING CHECKS:
*		1.  THE MAXIMUM NUMBER OF RMSREQS HAS NOT BEEN
*		    EXCEEDED.
*		2.  THE RMSREQ NAME IS OF THE FORMAT "RMNXYZ".
*

	IF RMSREQ-COUNT = RMSREQ-MAX
		DISPLAY "MAXIMUM NUMBER OF RMSREQ ENTRIES EXCEEDED"
		DISPLAY "THIS ODL FILE IS IGNORED"
		COMPUTE HDR-ERROR = 1
		GO TO RMSREQ-CHECK-EXIT.
	MOVE KEYVALUE TO WORK-RMSREQ.
	IF RMSREQ-SUFF NOT EQUAL "CI"
		DISPLAY "BAD FORMAT RMSREQ ENTRY"
		DISPLAY "THIS ODL FILE IS IGNORED"
		COMPUTE HDR-ERROR = 1
		GO TO RMSREQ-CHECK-EXIT.
	ADD 1 TO RMSREQ-COUNT.
	MOVE WORK-RMSREQ TO RMSREQ (RMSREQ-COUNT).
 RMSREQ-CHECK-EXIT.
	EXIT.

 INSERT-OBJ SECTION.
 P1.
*	THIS SECTION INSERTS AN OBJECT FILE NAME INTO THE
*	COBOBJ$ .FCTR DIRECTIVE.
*
*	ENTRY CONDITIONS:
*	1.  COBOBJ CONTAINS THE OBJECT FILE NAME.
*
*
*	GET THE PPN (OR UIC) OF THE OBJECT FILE REFERENCED
*	IN THE ODL FILE.
	IF DEFAULT-MERGE = "Y"
		GO TO DEFAULT-PPN.
	DISPLAY "OBJECT PROGRAM REFERENCED IN ODL FILE IS:".
	DISPLAY "     " COBOBJ.
 GET-PPN.
	DISPLAY   "PLEASE ENTER OBJECT FILE DEVICE AND "   
		PPN-OR-UIC 
		" IN THE FORMAT: DEV:" 
		PPN-UIC-FMT.
	ACCEPT INPUT-PPN-OR-UIC.
 DEFAULT-PPN.
	COMPUTE PPN-ERROR = 0.
*	CONSTRUCT THE COMPLETE FILE SPECIFICATION FOR THE OBJECT 
*	FILE.
	COMPUTE TEMP-PTR = 1.
	MOVE SPACES TO TEMP-OBJ.
	IF INPUT-PPN-OR-UIC NOT = SPACES
		STRING INPUT-PPN-OR-UIC DELIMITED BY SPACE 
		INTO TEMP-OBJ POINTER TEMP-PTR
		PERFORM PPN-CHECK.
	IF PPN-ERROR = 1 GO TO GET-PPN.
	STRING COBOBJ DELIMITED BY SPACE INTO TEMP-OBJ
		POINTER TEMP-PTR.
*	COMPUTE THE LENGTH OF THE FILE SPECIFICATION.
	COMPUTE TEMP-PTR = TEMP-PTR - 1.

	IF OBJPTR + TEMP-PTR > 50
		PERFORM NEW-OBJ-FACTOR
	ELSE PERFORM INSERT-OBJ-NAME.

 NEW-OBJ-FACTOR SECTION.
 P1.
*	THIS SECTION FINISHES THE CURRENT OBJECT FILE
*	.FCTR DIRECTIVE, WRITES IT, AND STARTS A NEW
*	OBJECT FILE .FCTR DIRECTIVE.
*
	ADD 1 TO OBJ-FAC-COUNT.
	MOVE CURR-OBJ-FAC TO OBJ-FAC-NAME.
	MOVE OBJ-STRING TO OBJ-NAMES OF OBJ-LINE.
	WRITE OUT-REC FROM OBJ-LINE.

	MOVE SPACES TO OBJ-NAMES OF OBJ-LINE.
	MOVE SPACES TO OBJ-STRING.
	COMPUTE OBJPTR = 1.
	STRING CURR-OBJ-FAC DELIMITED BY SIZE
		INTO OBJ-STRING POINTER OBJPTR.
	PERFORM INSERT-OBJ-NAME.

 INSERT-OBJ-NAME SECTION.
 P1.
*	THIS SECTION INSERTS AN OBJECT FILE NAME INTO THE OBJECT 
*	.FCTR DIRECTIVE.
*
*	ENTRY CONDITIONS:
*	1.  TEMP-OBJ CONTAINS THE OBJECT FILE NAME, LEFT JUSTIFIED,
*	AND SPACE FILLED ON THE RIGHT.
*
	IF OBJPTR NOT = 1 STRING "-" DELIMITED BY SIZE 
		INTO OBJ-STRING POINTER OBJPTR.
	STRING TEMP-OBJ DELIMITED BY SPACES INTO OBJ-STRING 
		POINTER OBJPTR.

 INSERT-OVR SECTION.
 P1.
*	THIS SECTION INSERTS AN OVERLAY FACTOR OF THE FORMAT
*	KKOVR$ INTO THE OVERLAY .FCTR DIRECTIVE.
*
*	ENTRY CONDITIONS:
*	1.  COBKER CONTAINS THE PSECT NAME KERNEL, KK.
*	2.  OVRPTR POINTS TO THE NEXT AVAILABLE POSITION
*	IN THE STRING BEING BUILT.
*
	IF OVRPTR + 7 > 50
		PERFORM NEW-OVR-FACTOR
	ELSE PERFORM INSERT-OVR-NAME.

 NEW-OVR-FACTOR SECTION.
 P1.
*	THIS SECTION FINISHES THE CURRENT OVR .FCTR DIRECTIVE,
*	WRITES IT, AND STARTS A NEW OVR .FCTR DIRECTIVE.

	ADD 1 TO OVR-FAC-COUNT.
	MOVE CURR-OVR-FAC TO OVR-FAC-NAME.
	MOVE OVR-STRING TO OVR-NAMES OF OVR-LINE.
	WRITE OUT-REC FROM OVR-LINE.

	MOVE SPACES TO OVR-NAMES OF OVR-LINE.
	MOVE SPACES TO OVR-STRING.
	COMPUTE OVRPTR = 1.
	STRING CURR-OVR-FAC DELIMITED BY SIZE
			INTO OVR-STRING
		POINTER OVRPTR.
	PERFORM INSERT-OVR-NAME.


 INSERT-OVR-NAME SECTION.
 P1.
*	THIS SECTION INSERTS AN OVERLAY FACTOR NAME INTO THE 
*	OVERLAY .FCTR DIRECTIVE.
*
*	ENTTRY CONDITIONS:
*	1.  COBKER CONTAINS THE PSECT NAME KERNEL.
*	2.  OVRPTR POINTS TO THE NEXT POSITION IN THE OVERLAY
*	STRING BEING BUILT.
*
	IF OVRPTR NOT = 1
	STRING "," DELIMITED BY SIZE INTO OVR-STRING
		POINTER OVRPTR.
	MOVE COBKER TO KK OF TEMP-OVR.
	STRING TEMP-OVR DELIMITED BY SIZE INTO OVR-STRING
		POINTER OVRPTR.
 HDR-SCAN2 SECTION.
 P1.
*	THIS SECTION IS EXECUTED WHEN AN INPUT LINE
*	CONTAINS EXACTLY ONE ";" .  A CHECK IS MADE TO DETERMINE
*	IF THIS LINE IS A ;COBMAIN HEADER LINE.  IF IT IS,
*	THE FLAG COBMAIN IS SET TO 1.
*
	UNSTRING IN-REC DELIMITED BY ";" INTO FIELD0 FIELD1.
*	AT THIS POINT, FIELD1 CONTAINS EVERYTHING TO THE RIGHT OF ";"
	UNSTRING FIELD1 DELIMITED BY " " INTO KEYWORD FIELD2.
	IF KEYWORD = "COBMAIN" COMPUTE COBMAIN = 1.
 PPN-CHECK SECTION.
 P1.
*
*	THIS SECTION CHECKS THE FORMAT OF THE PPN (OR UIC)
*	ENTERED BY THE USER FOR THE OBJECT FILE.
*
*	ENTRY CONDITIONS:
*	1.  TEMP-OBJ CONTAINS THE PPN ENTERED BY THE USER.
*
*	COMPUTE LEFT-BRACKET RIGHT-BRACKET COMMA-COUNT = 0.
*	CHECK THE PPN FOR "[", "]", AND ",".
*	INSPECT TEMP-OBJ TALLYING LEFT-BRACKET FOR ALL "["
*		RIGHT-BRACKET FOR ALL "]"
*		COMMA-COUNT FOR ALL ",".
*
*
*
*
*	EDIT BY DON WATSON    SPR #11-15780
*
*
*	SPR PROBLEM:  DEFAULT PPN CAN NOT BE USED FOR OBJECT FILE
*		      DEVICE AND PPN SPECIFICATION.
*
*
	IF DEFAULT-MERGE = "Y" GO TO PPN-CHECK-EXIT.
	IF LEFT-BRACKET = 0
		AND RIGHT-BRACKET = 0
		AND COMMA-COUNT = 0
		GO TO PPN-CHECK-EXIT.
*
*
*
*
*	END OF EDIT BY DON WATSON
*
*
*
*	IF NOT EXACTLY ONE OF EACH, THEN BAD PPN (OR UIC)
	IF LEFT-BRACKET NOT = 1
		OR RIGHT-BRACKET NOT = 1
		OR COMMA-COUNT NOT = 1
		GO TO PPN-ERROR-EXIT.
*	BREAK THE PPN APART AND CHECK COMPONENTS.
		COMPUTE PPN-COUNT = 0.
	UNSTRING TEMP-OBJ DELIMITED BY "[" INTO FIELD0 FIELD1.
	UNSTRING FIELD1 DELIMITED BY "," INTO FIELD2 COUNT PPN-COUNT
		FIELD0.
	IF PPN-COUNT = 0 GO TO PPN-ERROR-EXIT.
	COMPUTE IX1 = 1.
	PERFORM NUM-CHECK PPN-COUNT TIMES.
	IF PPN-ERROR = 1 GO TO PPN-ERROR-EXIT.
	UNSTRING FIELD0 DELIMITED BY "]" INTO FIELD2 COUNT PPN-COUNT.
	IF PPN-COUNT = 0 GO TO PPN-ERROR-EXIT.
	COMPUTE IX1 = 1.
	PERFORM NUM-CHECK PPN-COUNT TIMES.
	IF PPN-ERROR NOT = 1 GO TO PPN-CHECK-EXIT.
*
*
*
*	THIS IS THE NEW, LESS DEMANDING CHECK.
***
**
*	THIS SECTION CHECKS FOR IMBEDDED SPACES
*
*
*
*	MOVE SPACES TO TEST-OBJ.
*	MOVE TEMP-OBJ TO TEST-OBJ.
*	IF TEST-OBJ NOT = INPUT-PPN-OR-UIC GO TO PPN-ERR-EXIT.
*
*	CHECKS FOR A REASONABLE NUMBER OF COLONS AND SQUARE BRACKETS
*
*	MOVE 0 TO LEFT-BRACKET,RIGHT-BRACKET,COLON-COUNT,PPN-ERROR.
*	INSPECT TEMP-OBJ TALLYING COLON-COUNT FOR  ALL ":",
*		LEFT-BRACKET FOR ALL "[",
*		RIGHT-BRACKET FOR ALL "]".
*	IF COLON-COUNT + LEFT-BRACKET = 0
*		OR RIGHT-BRACKET NOT = LEFT-BRACKET
*		OR RIGHT-BRACKET > 1
*		GO TO PPN-ERR-EXIT.
*
*	CHECKS THE LAST CHARACTER IN THE STRING.
*
	MOVE SPACES TO FIELD2.
*	MOVE 0 TO TEMP-COUNT, TEMP-COUNT-2.
*	UNSTRING TEMP-OBJ DELIMITED BY SPACES INTO FIELD2
*		COUNT IN TEMP-COUNT.
*	IF RIGHT-BRACKET = 1 AND FARR(TEMP-COUNT) NOT = "]"
*		GO TO PPN-ERR-EXIT.
*	IF RIGHT-BRACKET = 0 AND FARR(TEMP-COUNT) NOT = ":"
*		GO TO PPN-ERR-EXIT.
**
**	CHECKS THAT THE SQUARE BRACKETS ARE NOT EMPTY
**
*	COMPUTE TEMP-COUNT-2 = TEMP-COUNT - 1.
*	IF FARR(TEMP-COUNT) = "]" AND FARR(TEMP-COUNT-2) = "["
*		GO TO PPN-ERR-EXIT.
**
**	CHECKS TO SEE IF THERE ARE CHARACTERS BETWEEN :[
**
*	IF RIGHT-BRACKET = 1
*		MOVE SPACES TO FIELD2
*		MOVE 0 TO TEMP-COUNT
*		UNSTRING TEMP-OBJ DELIMITED BY "[" INTO FIELD2
*			COUNT TEMP-COUNT.
*	IF FIELD2 = SPACES OR FARR(TEMP-COUNT) = ":"
*		GO TO PPN-CHECK-EXIT.

 PPN-ERROR-EXIT.
* PPN-ERR-EXIT.
	DISPLAY "BAD FORMAT "
		PPN-OR-UIC
		": "
		TEMP-OBJ.
	COMPUTE PPN-ERROR = 1.
 PPN-CHECK-EXIT.
	EXIT.
 NUM-CHECK SECTION.
 P1.
	IF FARR(IX1) NOT NUMERIC
		COMPUTE PPN-ERROR = 1
		ELSE COMPUTE IX1 = IX1 + 1.
 NUM-CHECK-EXIT.
	EXIT.
 MAKE-INDIRECT-REF SECTION.
 P1.
*	THIS SECTION BUILDS AN INDIRECT REFERENCE TO AN
*	INPUT ODL FILE, AND WRITES IT TO THE MERGED ODL FILE.
*
*	ENTRY CONDITIONS:
*
*		1.  INPUT-ODL-NAME CONTAINS THE FILE SPECIFICATION
*		    OF THE INPUT ODL FILE.
*

	MOVE SPACES TO OUT-REC.
	STRING "@" DELIMITED BY SIZE
		INPUT-ODL-NAME DELIMITED BY SPACE
		INTO OUT-REC.
	WRITE OUT-REC.

 MERGE-INPUT-ODL SECTION.
 P1.
*	THIS SECTION CLOSES AND THEN OPENS THE INPUT ODL
*	FILE (TO "REWIND" IT), AND THEN READS THE ENTIRE 
*	INPUT ODL FILE, WRITING IT TO THE OUTPUT ODL FILE
*	BEING GENERATED.

	CLOSE INPUT-ODL.
	OPEN INPUT INPUT-ODL.
 MERGE-START.
	MOVE SPACES TO IN-REC.
	READ INPUT-ODL AT END GO TO MERGE-DONE.
	WRITE OUT-REC FROM IN-REC.
	GO TO MERGE-START.
 MERGE-DONE.
	EXIT.
*************************
*                        *
* PROCESS-RMSREQ          *
*                         *
***************************
 PROCESS-RMSREQ SECTION.
 P1.
*	THIS SECTION PROCESSES THE RMS REQUIRED FOR THE 
*	CURRENT INPUT ODL FILE.
*	ENTRY CONDITIONS:
*	1.  RMSREQ-COUNT CONTAINS THE NUMBER OF ;RMSREQ HEADER LINES
*	    IN THE INPUT ODL FILE.
*	2.  ARRAY "RMSREQ" CONTAINS THE NAMES OF THE RMSREQS.
*
*	EXIT CONDITIONS:
*	1.  THE RMSREQS HAVE BEEN SCANNED, AND THE OPERATION
*	    SUPPORT CODES FOR EACH RMSREQ HAVE BEEN MERGED INTO
*	    THE GLOBAL VARIABLES SEQ-OPS, REL-OPS, OR INDEX-OPS.
*
*
	COMPUTE LOOP-COUNT = 0.
 PROCESS-RMSREQ-LOOP.
	ADD 1 TO LOOP-COUNT.
	IF LOOP-COUNT GREATER THAN RMSREQ-COUNT 
		GO TO PROCESS-RMSREQ-EXIT.
	MOVE RMSREQ(LOOP-COUNT) TO WORK-RMSREQ.
	PERFORM RMSREQ-OPS-MERGE.
	GO TO PROCESS-RMSREQ-LOOP.
 PROCESS-RMSREQ-EXIT.
	EXIT.

****************************
*				*
* RMSREQ-OPS-MERGE	*
*				*
*********************************

 RMSREQ-OPS-MERGE SECTION.
 P1.
*
*	THIS SECTION MERGES THE OPERATION SUPPORT CODE FOR AN
*	INPUT RMS REQUIREMENT INTO A GLOBAL FOR THE FILE ORGANIZATION
*	FOR THAT REQUIREMENT.
*
*	ENTRY CONDITIONS:
*	1.  WORK-RMSREQ CONTAINS THE RMSREQ NAME WHOSE OPERATION
*	    SUPPORT CODE IS TO BE ANALYZED AND MERGED.
*	2.  GLOBAL VARIABLES CONTAIN THE CURRENT MERGED OPERATION
*	    SUPPORT CODES AS FOLLOWS:
*
*		FILE ORGANIZATION	VARIABLE NAME
*		_________________	_____________
*		SEQUENTIAL		SEQ-OPS
*		RELATIVE		REL-OPS
*		INDEXED			INDEX-OPS
*
	MOVE RMSREQ-OPS OF WORK-RMSREQ TO WORK-OPS.
	DIVIDE WORK-OPS BY C2 GIVING WORK-VAL REMAINDER WORK-B0.
	DIVIDE WORK-VAL BY C2 GIVING WORK-OPS REMAINDER WORK-B1.
	DIVIDE WORK-OPS BY C2 GIVING WORK-VAL REMAINDER WORK-B2.

	IF RMSREQ-ORG OF WORK-RMSREQ EQUAL SEQ-ORG-CODE
		MOVE SEQ-OPS TO WORK-OPS
	ELSE IF RMSREQ-ORG OF WORK-RMSREQ EQUAL REL-ORG-CODE
		MOVE REL-OPS TO WORK-OPS
	ELSE MOVE INDEX-OPS TO WORK-OPS.

	DIVIDE WORK-OPS BY C2 GIVING WORK-VAL REMAINDER OPS-B0.
	DIVIDE WORK-VAL BY C2 GIVING WORK-OPS REMAINDER OPS-B1.
	DIVIDE WORK-OPS BY C2 GIVING WORK-VAL REMAINDER OPS-B2.

	MOVE 0 TO WORK-OPS.
	IF (WORK-B0 NOT EQUAL 0 OR OPS-B0 NOT EQUAL 0)
		ADD 1 TO WORK-OPS.
	IF (WORK-B1 NOT EQUAL 0 OR OPS-B1 NOT EQUAL 0)
		ADD 2 TO WORK-OPS.
	IF (WORK-B2 NOT EQUAL 0 OR OPS-B2 NOT EQUAL 0)
		ADD 4 TO WORK-OPS.

	IF RMSREQ-ORG OF WORK-RMSREQ EQUAL SEQ-ORG-CODE
		MOVE WORK-OPS TO SEQ-OPS
	ELSE IF RMSREQ-ORG OF WORK-RMSREQ EQUAL REL-ORG-CODE
		MOVE WORK-OPS TO REL-OPS
	ELSE MOVE WORK-OPS TO INDEX-OPS.

********************************
*				*
*  RMSREQ-ODL			*
*				*
*********************************

 RMSREQ-ODL SECTION.
 P1.
*
*	THIS SECTION GENERATES THE ODL FOR THE RMS 
*	REQUIREMENTS INTO THE OUTPUT ODL FILE.
*
*	ENTRY CONDITIONS:
*	1.  SEQ-OPS,REL-OPS, AND INDEX-OPS CONTAIN CODES THAT SPECIFY
*	    THE OPERATION SUPPORT REQUIRED FOR SEQUENTIAL, RELATIVE,
*	    OR INDEXED I/O, OR ZERO IF NO SUPPORT IS REQUIRED.

	COMPUTE COMPOSITE-ORG = 0.
	IF SEQ-OPS NOT = 0
		ADD 1 TO COMPOSITE-ORG.
	IF REL-OPS NOT = 0
		ADD 2 TO COMPOSITE-ORG.
	IF INDEX-OPS NOT = 0
		ADD 4 TO COMPOSITE-ORG.

	IF COMPOSITE-ORG NOT = 0
		PERFORM OUTPUT-RMS-ODL.
*
*********************************
*  OUTPUT-RMS-ODL		*
*				*
*********************************

 OUTPUT-RMS-ODL SECTION.
 P1.
*
*	THIS SECTION OUPUTS ODL FOR THE RMS REQUIRED FOR
*	THE TASK IMAGE TO BE BUILT FROM THE ODL FILE.
*
*	ENTRY CONDITIONS:
*
*	1.  COMPOSITE-ORG CONTAINS A CODE THAT IDENTIFIES THE RMS
*	    ODL FILE REQUIRED.  THIS CODE HAS THE FOLLOWING VALUES
*	    AND MEANINGS.
*
*		CODE VALUE		RMS ODL REQUIRED
*		___________		________________
*		   1			SEQUENTIAL
*		   2			RELATIVE
*		   3			SEQUENTIAL,RELATIVE
*		   4			INDEXED
*		   5			SEQUENTIAL,INDEXED
*		   6			RELATIVE,INDEXED
*		   7			SEQUENTIAL,RELATIVE,INDEXED
*

*
*	OUTPUT AN INDIRECT REFERENCE TO THE RMS ROOT ODL FILE
*	UNCONDITIONALLY FIRST.

	IF COMPOSITE-ORG LESS THAN 4
		MOVE SIMPLE-ROOT TO RMSROT
	ELSE MOVE INDEXED-ROOT TO RMSROT.

	MOVE SPACES TO OUT-REC.
*
* ROOT ODL IS NO LONGER USED - AWH 5-OCT-78
*

*	STRING "@" DELIMITED BY SIZE
*		RMS-UIC DELIMITED BY SPACES
*		RMSROT DELIMITED BY SPACES
*		".ODL" DELIMITED BY SIZE
*		INTO OUT-REC.
*	WRITE OUT-REC.
**
**	OUTPUT AN INDIRECT REFERENCE TO THE ODL FILE THAT DESCRIBES
*	THE RMS REQUIRED FOR THE TASK.

*	INITIALIZE THE WORK FIELD FIRST.


* THESE LINES WERE ELIMINATED WHEN THE RMS ODLS CHANGED

*	MOVE WORK-RMSREQ-INIT TO WORK-RMSREQ.
*	MOVE COMPOSITE-ORG TO RMSREQ-ORG OF WORK-RMSREQ.

	IF RESIDENT-LIBRARY = 1
		MOVE "RMS11R" TO WORK-RMSREQ
		GO TO WRITE-RMS-REQ1.
	IF COMPOSITE-ORG GREATER THAN 3 AND DEFAULT-OVERLAY = 1
		 PERFORM IDX-IO
	 ELSE IF DEFAULT-OVERLAY = 1
		MOVE "RMS11S" TO WORK-RMSREQ.
 WRITE-RMS-REQ1.
	MOVE SPACES TO OUT-REC.
	IF DEFAULT-OVERLAY = 1
		STRING "@" DELIMITED BY SIZE
		RMS-UIC DELIMITED BY SPACES
		WORK-RMSREQ DELIMITED BY SIZE
		".ODL" DELIMITED BY SIZE
		INTO OUT-REC
	 ELSE STRING "@" DELIMITED BY SIZE, USERS-ODL-FILESPEC
		 DELIMITED BY SIZE INTO OUT-REC.
	WRITE OUT-REC.

*
*	BUILD THE RMS$: FCTR DIRECTIVE NOW
*

	MOVE "RMSALL" TO WORK-RMSREQ.
	IF CBOVR = SPACES
		STRING RMSROT DELIMITED BY SPACES
		"-" DELIMITED BY SIZE
		WORK-RMSREQ DELIMITED BY SIZE
		INTO RMS-VAR-STRING
	ELSE
		STRING RMSROT DELIMITED BY SPACES
		INTO RMS-VAR-STRING
		MOVE NAME-STRING TO OUT-REC
*		THE NEXT LINE IS COMMENTED OUT BECAUSE IT WASN'T
*		WORKING CORRECTLY AT THE TIME THIS PROGRAM WAS NEEDED
*		FOR COBOL V3.0 DEVELOPMENT.
*		WRITE OUT-REC FROM NAME-STRING
		WRITE OUT-REC
		MOVE WORK-RMSREQ TO RMSTR-STRING-VAR
		MOVE ",RMSTR$" TO RMSTR
		WRITE OUT-REC FROM RMSTR-STRING.
*
* HELP TEXT
*
HELP-TEXT SECTION.

 HELP-DEFAULT.
	DISPLAY " ".
	DISPLAY "ANSWERING Y(ES) WILL PRODUCE A MERGED ODL FILE 
-		" THAT:".
	DISPLAY "	1. REFERS INDIRECTLY TO COMPILER PRODUCED
-		" ODL FILES".
	DISPLAY "	    (ABBREVIATED)".
	DISPLAY " 	2. DOES NOT INCLUDE THE COBOL DEBUGGER".
	DISPLAY "	3. DOES OVERLAY I/O SUPPORT".
	DISPLAY "	4. DOES USE DEC SUPPLIED I/O OVERLAY
-		" DESCRIPTORS".
	DISPLAY "	5. USES THE UIC OF THE COMPILER PRODUCED
-		" ODL AS THE UIC OF THE OBJECT".
	DISPLAY " 	6. USES THE SMALLER I/O OVERLAY STRUCTURE
-		" FOR INDEXED FILE".
	DISPLAY "	   SUPPORT IF THAT SUPPORT IS REQUIRED".
	DISPLAY " ".
	DISPLAY "ANSWERING N(O) WILL ALLOW YOU TO CHOOSE OTHER
-		" OPTIONS".
	DISPLAY " ".

 HELP-SMALLER-OR-LARGER.
	DISPLAY " ".
	DISPLAY "IF YOU ANWSER S(MALLER), MERGE WILL USE THE 9K
-		" RSM OVERLAY DESCRIPTOR.".
	DISPLAY " ".
	DISPLAY "IF YOU ANSWER L(ARGER), MERGE WILL USE THE 12K
-		" RMS OVERLAY DESCRIPTOR.".
	DISPLAY " ".
	DISPLAY "USING THE 12K OVERLAY DESCRIPTOR MAY IMPROVE
-		" PROGRAM".
	DISPLAY "EXECUTION SPEED; HOWEVER, IT MAY CAUSE AN ADDRESS
-		" OVERFLOW DURING".
	DISPLAY "TASK BUILD OF LARGER PROGRAMS.  IN THE LATTER
-		" CASE, RERUN MERGE".
	DISPLAY "AND ANSWER THIS QUESTION S(MALLER).".
	DISPLAY " ".
HELP-A-OR-M.
	DISPLAY " ".
	DISPLAY "AN ABBREVIATED ODL REFERS TO
-			" THE ODL(S) CREATED".
	DISPLAY "BY THE COBOL COMPILER INDIRECTLY.
-			"  THE FILE CREATED".
	DISPLAY "BY MRG IS SHORT, BUT  REQUIRES
-			" THAT THE COMPILER".
	DISPLAY "GENERATED ODL(S) BE AVAILABLE
-			" WHENEVER IT IS USED.".
	DISPLAY " ".
	DISPLAY "A MERGED ODL INCLUDES THE FULL
-		" TEXT OF THE ODL(S)".
	DISPLAY "PRODUCED BY THE COMPILER.  THE
-		" FILE CREATED BY MRG".
	DISPLAY "IS LONGER, BUT THE COMPILER GENERATED
-		" ODL(S) CAN BE".
	DISPLAY "DELETED.".
	DISPLAY " ".


HELP-OVERLAY.
	DISPLAY " ".
	DISPLAY	"IF YOU ANSWER NO, RMSLIB, A LIBRARY
-		" OF I/O ROUTINES".
	DISPLAY "WILL BE INCLUDED IN YOUR TASK
-		" IMAGE.  IF YOUR PROGRAM".
	DISPLAY "IS NOT SO LARGE THAT AN ADDRESS
-		" OVERFLOW IS DETECTED".
	DISPLAY "BY THE TASK BUILDER, IT WILL
-		" RUN FASTER IF YOU DO NOT".
	DISPLAY "OVERLAY I/O.".
	DISPLAY "  ".
	DISPLAY	"IF YOU ANSWER YES, YOU WILL BE
-		" ABLE TO REDUCE YOUR ".
	DISPLAY "PROGRAM SIZE BY USING EITHER
-		" DEC SUPPLIED I/O ".
	DISPLAY "OVERLAY DESCRIPTORS OR YOUR OWN
-		" CUSTOM RMS ODL.".
	DISPLAY " ".

HELP-EXIT.
	EXIT.


* INDEXED I/O
*	TWO SIZES OF RMS OVERLAYS ARE SUPPLIED FOR INDEXED IO.
IDX-IO SECTION.

IDX-IO1.
	IF DEFAULT-MERGE = "Y"
		MOVE "RMS11X" TO WORK-RMSREQ
		GO TO IDX-IO-EXIT.
	DISPLAY "DO YOU WANT THE SMALLER OR THE LARGER IO OVERLAY?".
IDX-IO-ANS.
	DISPLAY "PLEASE ANSWER S(MALLER), L(ARGER), OR H(ELP): "
		WITH NO ADVANCING.
	ACCEPT ANS.
	IF ANS = "S"
		MOVE "RMS11X" TO WORK-RMSREQ
	 ELSE IF ANS = "L" 
		MOVE "RMS12X" TO WORK-RMSREQ
	 ELSE IF ANS = "H"
		PERFORM HELP-SMALLER-OR-LARGER
		GO TO IDX-IO-ANS
	 ELSE GO TO IDX-IO-ANS.
*
IDX-IO-EXIT.
	EXIT.
 ABORT-EXECUTION SECTION.
 P1.
*	THIS SECTION IS EXECUTED IF AN UNRECOVERABLE READ OR
*	WRITE ERROR IS DETECTED.  THE INPUT AND OUTPUT FILES
*	ARE CLOSED, AND EXECUTION IS TERMINATED.

	DISPLAY "WARNING: OUTPUT FILE PROBABLY
-		" INCOMPLETE OR INVALID".
	CLOSE OUTPUT-ODL.
	CLOSE INPUT-ODL.
	STOP RUN.
