/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	unistd.h,v $
 * Revision 4.2.4.15  92/06/05  12:17:31  Mary_Walker
 * 	changes _SC_STREAM_MAX to 13 as it is in osf1.1
 * 	[92/06/01  11:23:55  Mary_Walker]
 * 
 * 	added _SC_STREAM_MAX for posix compliance
 * 	[92/05/29  14:33:17  Mary_Walker]
 * 
 * Revision 4.2.4.14  92/05/19  11:48:44  Stephen_Strange
 * 	Changed definition for getcwd for 1990 POSIX compliance
 * 	[92/05/08  16:54:16  Stephen_Strange]
 * 
 * Revision 4.2.4.13  92/05/18  08:57:40  Shirley_Smith
 * 	Bmerged with ag.latest
 * 	[92/05/15  14:42:56  Shirley_Smith]
 * 
 * 	Removed type-cast on _POSIX_VDISABLE.
 * 	[92/05/15  14:15:20  Shirley_Smith]
 * 
 * Revision 4.2.4.12  92/05/06  12:23:17  Larry_Woodman
 * 	Make the exec() function arguments comply with the posix ansi standard.
 * 	[92/04/24  10:29:54  Larry_Woodman]
 * 
 * Revision 4.2.4.11  92/04/23  13:14:14  Raymond_Glaser
 * 	Remove merge markers ??
 * 	[92/04/23  13:11:44  Raymond_Glaser]
 * 
 * Revision 4.2.4.10  92/04/23  12:59:40  Raymond_Glaser
 * 	Add definition of _SC_TZNAME_MAX for POSIX
 * 	[92/04/23  12:53:27  Raymond_Glaser]
 * 
 * Revision 4.2.4.9  92/04/22  09:34:02  David_Metsky
 * 	Went back to 199009L for _POSIX_VERSION.
 * 	[92/04/22  09:13:18  David_Metsky]
 * 
 * 	Change _POSIX_VERSION back to 198808L because of our version of the
 * 	VSX test suite
 * 	[92/04/08  10:35:47  David_Metsky]
 * 
 * 	Updated _POSIX_VERSION and changed return value for read() and write()
 * 	to ssize_t, which is now defined in types.h
 * 	[92/03/31  18:25:11  David_Metsky]
 * 
 * Revision 4.2.4.8  92/04/10  11:16:37  Stephen_Strange
 * 	POSIX compliance changes for ISO 9945-1 (1990)
 * 	[92/03/30  18:16:42  Stephen_Strange]
 * 
 * Revision 4.2.4.7  92/04/08  12:02:03  David_Metsky
 * 	Change _POSIX_VERSION back to 198808L because of our version of the
 * 	VSX test suite
 * 	[92/04/08  10:35:47  David_Metsky]
 * 
 * 	Updated _POSIX_VERSION and changed return value for read() and write()
 * 	to ssize_t, which is now defined in types.h
 * 	[92/03/31  18:25:11  David_Metsky]
 * 
 * Revision 4.2.4.6  92/03/27  16:56:23  Lai-Wah_Hui
 * 	"Add RT support"
 * 
 * Revision 4.2.4.5  92/03/27  15:37:52  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  14:09:29  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/09  15:14:00  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  17:42:01  Craig_Horman]
 * 
 * Revision 4.2.4.4  92/03/24  14:03:07  Daniel_Eskenazi
 * 	Merged with concurrent edits
 * 	[92/03/23  17:39:13  Daniel_Eskenazi]
 * 
 * 	Modified _SC_PAGESIZE to match Gold definition
 * 	[92/03/16  14:31:42  Daniel_Eskenazi]
 * 
 * 	Added _SC_PAGESIZE for SVID3 Compatibility
 * 	[92/03/13  13:44:33  Daniel_Eskenazi]
 * 
 * Revision 4.2.4.3  92/03/23  16:03:54  Stephen_Strange
 * 	ISO 9945-1 POSIX compliance -- arg types to read() and write() changed.
 * 	[92/03/23  15:19:54  Stephen_Strange]
 * 
 * Revision 4.2.4.2  92/02/12  19:03:40  William_Burns
 * 	Merge from ODE/TIN: revision 3.2.9.2
 * 	date: 92/02/05 14:51:04;  author: devrcs;  state: Exp;  lines added/del: 4/4
 * 	sccs rev: 3.3;  orig date: 92/01/28 16:45:40;  orig author: fred
 * 	Fred Canter - fix execl* function prototypes to make PCTS happy.
 * 	[92/02/12  10:32:40  William_Burns]
 * 
 * Revision 4.2.4.4  92/03/24  14:03:07  Daniel_Eskenazi
 * 	Merged with concurrent edits
 * 	[92/03/23  17:39:13  Daniel_Eskenazi]
 * 
 * 	Modified _SC_PAGESIZE to match Gold definition
 * 	[92/03/16  14:31:42  Daniel_Eskenazi]
 * 
 * 	Added _SC_PAGESIZE for SVID3 Compatibility
 * 	[92/03/13  13:44:33  Daniel_Eskenazi]
 * 
 * Revision 4.2.4.3  92/03/23  16:03:54  Stephen_Strange
 * 	ISO 9945-1 POSIX compliance -- arg types to read() and write() changed.
 * 	[92/03/23  15:19:54  Stephen_Strange]
 * 
 * Revision 4.2.4.2  92/02/12  19:03:40  William_Burns
 * 	Merge from ODE/TIN: revision 3.2.9.2
 * 	date: 92/02/05 14:51:04;  author: devrcs;  state: Exp;  lines added/del: 4/4
 * 	sccs rev: 3.3;  orig date: 92/01/28 16:45:40;  orig author: fred
 * 	Fred Canter - fix execl* function prototypes to make PCTS happy.
 * 	[92/02/12  10:32:40  William_Burns]
 * 
 * Revision 4.2.4.2  92/02/12  19:03:40  William_Burns
 * 	Merge from ODE/TIN: revision 3.2.9.2
 * 	date: 92/02/05 14:51:04;  author: devrcs;  state: Exp;  lines added/del: 4/4
 * 	sccs rev: 3.3;  orig date: 92/01/28 16:45:40;  orig author: fred
 * 	Fred Canter - fix execl* function prototypes to make PCTS happy.
 * 	[92/02/12  10:32:40  William_Burns]
 * 
 * Revision 4.2.2.3  92/03/27  15:25:56  Lai-Wah_Hui
 * 	Add RT support
 * 
 * Revision 4.2.2.2  92/03/27  11:01:49  Lai-Wah_Hui
 * 	Add P1003.4 _SC_
 * 
 * Revision 4.2  91/09/20  05:19:35  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: unistd.h,v $ $Revision: 4.2.4.15 $ (DEC) $Date: 92/06/05 12:17:31 $
 */ 
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */

/*
 * (C) COPYRIGHT International Business Machines Corp. 1985, 1989
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * Copyright (c) 1984 AT&T	
 * All Rights Reserved  
 *
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	
 * The copyright notice above does not evidence any   
 * actual or intended publication of such source code.
 * 
 * unistd.h	1.17  com/inc,3.1,8943 9/22/89 15:13:11
 */

#ifndef _UNISTD_H_
#define _UNISTD_H_

#include <standards.h>
#include <sys/types.h>  /* for time_t and size_t */
#include <sys/access.h>	/* for the "access" function */

/*
 * POSIX requires that certain values be included in unistd.h.  It also
 * requires that when _POSIX_SOURCE is defined only those standard
 * specific values are present.  This header includes all the POSIX
 * required entries.
 */

#ifdef _POSIX_SOURCE
/* Symbolic constants for the "lseek" function: */
#define SEEK_SET 0	/* Set file pointer to "offset" */
#define SEEK_CUR 1	/* Set file pointer to current plus "offset" */
#define SEEK_END 2	/* Set file pointer to EOF plus "offset" */


extern char **environ;          /* Environment description variable */


#ifdef _NO_PROTO

extern int access();
extern unsigned int alarm();
extern int chdir();
extern int chown();
extern int close();
extern char *cuserid();
extern int dup();
extern int dup2();
extern int execl();
extern int execv();
extern int execle(); 
extern int execve();
extern int execlp();
extern int execvp();
extern void _exit();
extern pid_t fork();
extern long fpathconf();
extern char *getcwd();
extern gid_t getegid();
extern char *getenv();
extern uid_t geteuid();
extern gid_t getgid();
extern int getgroups();
extern char *getlogin();
extern int getlogin_r();		/* _POSIX_REENTRANT_FUNCTIONS */
extern pid_t getpgrp();
extern pid_t getpid();
extern pid_t getppid();
extern uid_t getuid();
extern int isatty();
extern int link();
extern off_t lseek();
extern long pathconf();
extern int pause();
extern int pipe();
extern int read();
extern int rename();
extern int rmdir();
extern int setgid();
extern int setpgid();
extern int setsid(); 
extern int setuid();
extern unsigned int sleep();
extern long sysconf();
extern pid_t tcgetpgrp();
extern int tcsetpgrp();
extern char *ttyname();
extern char *ttyname_r();		/* _POSIX_REENTRANT_FUNCTIONS */
extern int unlink();
extern int write(); 

#else		/* POSIX required prototypes */
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif

extern int access(const char *, int );
extern unsigned int alarm(unsigned int );
extern int chdir(const char *);
extern int chown(const char *, uid_t , gid_t );
extern int close(int );
extern char *cuserid(char *);
extern int dup(int );
extern int dup2(int , int );
extern int execl(const char *path, const char *arg, ...);
extern int execv(const char *path, char *const argv[]);
extern int execle(const char *path, const char *arg, ...); 
extern int execve(const char *path, char *const argv[], char *const envp[]);
extern int execlp(const char *file, const char *arg, ...); 
extern int execvp(const char *file, char *const argv[]);
extern void _exit(int );
extern pid_t fork(void);
extern long fpathconf(int , int );
extern char *getcwd(char *, size_t );
extern gid_t getegid(void);
extern char *getenv(const char *);
extern uid_t geteuid(void);
extern gid_t getgid(void);
extern int getgroups(int , gid_t grouplist[]);
extern char *getlogin(void);
extern int getlogin_r(char *, int);		/* _POSIX_REENTRANT_FUNCTIONS */
extern pid_t getpgrp(void);
extern pid_t getpid(void);
extern pid_t getppid(void);
extern uid_t getuid(void);
extern int isatty(int );
extern int link(const char *, const char *);
extern off_t lseek(int , off_t , int );
extern long pathconf(const char *, int );
extern int pause(void);
extern int pipe(int fd[]);
extern ssize_t read(int , void *, size_t);
extern int rename(const char *, const char *);
extern int rmdir(const char *);
extern int setgid(gid_t );
extern int setpgid(pid_t , pid_t );
extern pid_t setsid(void);
extern int setuid(uid_t );
extern unsigned int sleep(unsigned int );
extern long sysconf(int );
extern pid_t tcgetpgrp(int );
extern int tcsetpgrp(int , pid_t );
extern char *ttyname(int );
extern char *ttyname_r(int, char *, int);	/* _POSIX_REENTRANT_FUNCTIONS */
extern int unlink(const char *);
extern ssize_t write(int , const void *, size_t); 
#if defined(__cplusplus)
}
#endif
#endif
#endif		/* !_NO_PROTO	*/

#define STDIN_FILENO	0
#define STDOUT_FILENO	1
#define STDERR_FILENO	2

#define _POSIX_JOB_CONTROL	/* implementation supports job control */
#define _POSIX_SAVED_IDS	/* saved set-user-ID and set-group-ID */
#define _POSIX_VERSION		199009L

#define _POSIX_CHOWN_RESTRICTED	 0 /* chown requires appropriate privileges */
#define _POSIX_NO_TRUNC	     	 0 /* too-long path components gen errors */
#define _POSIX_VDISABLE		0377

#define	_POSIX_THREADS		/* 1003.4a (pthreads) comformant */
#define _POSIX_THREAD_ATTR_STACKSIZE /* support for specifiable stack sizes */
#define	_POSIX_REENTRANT_FUNCTIONS  /* multithreaded 1003.1 interfaces */

#if _POSIX_4SOURCE
/*
 * POSIX 1003.4 Feature Test Macros
 *
 * Based on POSIX 1003.4 Draft 10 (Feb. 6, 1991).
 */

#define _POSIX_4VERSION 199102L
#define _POSIX_ASYNCHRONOUS_IO
#define _POSIX_MEMLK
#define _POSIX_MEMLK_RANGE
#define _POSIX_PRIORITIZED_IO
#define _POSIX_PRIORITY_SCHEDULING
#define _POSIX_TIMERS
#define _POSIX_MAPPED_FILES
#define _POSIX_SHARED_MEMORY_OBJECTS
#define _POSIX_BINARY_SEMAPHORES
#endif /* _POSIX_4SOURCE */

#ifndef NULL
#define NULL	(void *)0
#endif


/* arguments for the sysconf() function */

#define _SC_ARG_MAX		1
#define _SC_CHILD_MAX		2
#define _SC_CLK_TCK		3
#define _SC_JOB_CONTROL		4
#define _SC_NGROUPS_MAX		5
#define _SC_OPEN_MAX		6
#define _SC_SAVED_IDS		8
#define _SC_VERSION		9
#define _SC_STREAM_MAX		13
#define _SC_TZNAME_MAX		14

/* arguments for the pathconf() function */

#define _PC_CHOWN_RESTRICTED	10
#define _PC_LINK_MAX		11
#define _PC_MAX_CANON		12
#define _PC_MAX_INPUT		13
#define _PC_NAME_MAX		14
#define _PC_NO_TRUNC		15
#define _PC_PATH_MAX		16
#define _PC_PIPE_BUF		17
#define _PC_VDISABLE 		18

#endif /* _POSIX_SOURCE */

#ifdef _XOPEN_SOURCE

#define _SC_PASS_MAX		7
#define _SC_XOPEN_VERSION	19

#define _XOPEN_VERSION		3

#define F_ULOCK	0	/* Unlock a previously locked region */
#define F_LOCK	1	/* Lock a region for exclusive use */
#define F_TLOCK	2	/* Test and lock a region for exclusive use */
#define F_TEST	3	/* Test a region for other processes locks */

#endif /* _XOPEN_SOURCE */

#ifdef _AES_SOURCE

#define _SC_ATEXIT_MAX		10
#define _SC_PAGE_SIZE		11
#define _SC_AES_OS_VERSION	12
#define _SC_PAGESIZE		43

#define _AES_OS_VERSION		1

#ifdef _NO_PROTO
extern int fchown();
extern int ftruncate();
extern int readlink();
extern int setgroups();
extern int symlink();
extern int truncate();
#else
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__cplusplus)
extern "C"
{
#endif
extern int fchown(int, uid_t, gid_t);
extern int ftruncate(int, off_t);
extern int readlink(const char *, char *, int);
extern int setgroups(int, gid_t []);
extern int symlink(const char *, const char *);
extern int truncate(const char *, off_t);
#if defined(__cplusplus)
}
#endif
#endif
#endif

#endif 	/* _AES_SOURCE */

#endif /* _UNISTD_H_ */
