/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	mesg.h,v $
 * Revision 4.2.3.3  92/04/24  15:41:14  Thomas_Woodburn
 * 	Changed the in-memory message catalog format to use less memory
 * 	on sparsely-numbered catalogs.
 * 	[92/04/20  07:36:22  Thomas_Woodburn]
 * 
 * Revision 4.2.3.2  92/03/27  15:27:38  Craig_Horman
 * 	Merge with AG
 * 	[92/03/27  14:01:07  Craig_Horman]
 * 
 * 	Merge with BL5
 * 	[92/03/10  11:50:15  Craig_Horman]
 * 
 * 	Added C++ Support
 * 	[92/02/26  16:25:57  Craig_Horman]
 * 
 * Revision 4.2  91/09/20  05:17:49  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*	
 *	@(#)$RCSfile: mesg.h,v $ $Revision: 4.2.3.3 $ (DEC) $Date: 92/04/24 15:41:14 $
 */ 
/*
 */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */


/*
 * COMPONENT_NAME: INC
 *
 * FUNCTIONS: mesg.h
 *
 * ORIGINS: 27
 *
 * This module contains IBM CONFIDENTIAL code. -- (IBM
 * Confidential Restricted when combined with the aggregated
 * modules for this product)
 * OBJECT CODE ONLY SOURCE MATERIALS
 * (C) COPYRIGHT International Business Machines Corp. 1988, 1989
 * All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * (Copyright statements and/or associated legends of other
 * companies whose code appears in any part of this module must
 * be copied here.)
 */

#ifndef _MESG_H_
#define _MESG_H_

#include <nl_types.h>
#include <limits.h>

#define CAT_MAGIC 	505
#define CATD_ERR 	((nl_catd) -1)
#define NL_MAXOPEN	10

struct _message {
	unsigned short 	_set,
			_msg;
	char 		*_text;
	unsigned	_old;
};

struct _header {
	int 		_magic;
	unsigned short	_n_sets,
			_setmax;
	char 		_filler[20];
};

struct _msgptr {
	unsigned short 	_msgno,
			_msglen;
	unsigned long	_offset;
};

struct _catset {
	unsigned short 	_setno,
			_n_msgs;
	struct _msgptr 	*_mp;
	char	**_msgtxt;
	int		_msgs_expanded;
};

#include <stdio.h>

struct catalog_descriptor {
	char		*_mem;
	char		*_name;
	FILE 		*_fd;
	struct _header 	*_hd;
	struct _catset 	*_set;
	int		_setmax;
	int		_count;
	int		_pid;
	int		_n_sets;
	int		_sets_expanded;
};

#if defined(__cplusplus)
extern "C"
{
#endif
extern nl_catd _do_open();
extern struct _catset *_cat_get_catset(nl_catd catd, int setno);
extern struct _msgptr *_cat_get_msgptr(struct _catset *set, int msgno);
#if defined(__cplusplus)
}
#endif

#endif  /* _MESG_H_ */
