/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	aouthdr.h,v $
 * Revision 4.2.2.3  92/05/06  15:00:51  William_Burns
 * 	Fix comments on endifs.
 * 	[92/05/06  09:46:55  William_Burns]
 * 
 * Revision 4.2.2.2  91/12/05  14:59:58  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  19:20:43  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 4.2  91/09/20  05:06:39  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1990 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
/* $Header: /ufs/usr/sde/osf1/rcs/src/usr/include/PMAX/aouthdr.h,v 4.2.2.3 92/05/06 15:00:51 William_Burns Exp $ */

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _AOUTHDR_H
#define _AOUTHDR_H

#if __mips__
/*
 * Values for the magic field in aouthdr
 */
#ifdef __LANGUAGE_C__
#define	OMAGIC	0407
#define	NMAGIC	0410
#define	ZMAGIC	0413
#define SMAGIC  0411
#define	LIBMAGIC	0443
#define	N_BADMAG(x) \
    (((x).magic)!=OMAGIC && ((x).magic)!=NMAGIC && ((x).magic)!=ZMAGIC && \
     ((x).magic)!=LIBMAGIC && ((x).magic)!=SMAGIC)

#endif /* __LANGUAGE_C__ */
#ifdef __LANGUAGE_PASCAL__
#define	OMAGIC	8#407
#define	NMAGIC	8#410
#define	ZMAGIC	8#413
#define SMAGIC  8#411
#define	LIBMAGIC	8#443
#endif /* __LANGUAGE_PASCAL__ */
#endif /* __mips__ */

#ifdef __LANGUAGE_C__
typedef	struct aouthdr {
	short	magic;		/* see above				*/
	short	vstamp;		/* version stamp			*/
	long	tsize;		/* text size in bytes, padded to DW bdry*/
	long	dsize;		/* initialized data "  "		*/
	long	bsize;		/* uninitialized data "   "		*/
#if __u3b
	long	dum1;
	long	dum2;		/* pad to entry point	*/
#endif
	long	entry;		/* entry pt.				*/
	long	text_start;	/* base of text used for this file	*/
	long	data_start;	/* base of data used for this file	*/
#if __mips__
	long	bss_start;	/* base of bss used for this file	*/
	long	gprmask;	/* general purpose register mask	*/
	long	cprmask[4];	/* co-processor register masks		*/
	long	gp_value;	/* the gp value used for this object    */
#endif /* __mips__ */
} AOUTHDR;
#define AOUTHSZ sizeof(AOUTHDR)
#endif /* __LANGUAGE_C__ */

#ifdef __LANGUAGE_PASCAL__
type
  aouthdr = packed record
      magic : short;			/* see magic.h			     */
      vstamp : short;			/* version stamp		     */
      tsize : long;			/* text size in bytes, padded to FW  */
					/* bdry 			     */
      dsize : long;			/* initialized data " " 	     */
      bsize : long;			/* uninitialized data " "	     */
#if __u3b
      dum1 : long;
      dum2 : long;			/* pad to entry point		     */
#endif
      entry : long;			/* entry pt.			     */
      text_start : long;		/* base of text used for this file   */
      data_start : long;		/* base of data used for this file   */
      bss_start : long;			/* base of bss used for this file    */
      gprmask : long;			/* general purpose register mask     */
      cprmask : array[0..3] of long;	/* co-processor register masks	     */
      gp_value : long;			/* the gp value used for this object */
    end {record};
#endif /* __LANGUAGE_PASCAL__ */

/* $Log:	aouthdr.h,v $
 * Revision 4.2.2.3  92/05/06  15:00:51  William_Burns
 * 	Fix comments on endifs.
 * 	[92/05/06  09:46:55  William_Burns]
 * 
 * Revision 4.2.3.2  92/05/06  09:46:55  William_Burns
 * 	Fix comments on endifs.
 * 
 * Revision 4.2.2.2  91/12/05  14:59:58  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  19:20:43  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 3000.5.1.1  91/05/31  18:24:22  bettina
 * fix DFARS in copyright
 * 
 * Revision 3000.5  91/04/08  17:39:39  bettina
 * fix copyright
 * 
 * Revision 3000.4  91/04/08  13:52:20  bettina
 * update copyright
 * 
 * Revision 3000.3  91/02/17  15:26:36  karen
 * SVR4 changes.
 * 
 * Revision 3000.2  90/12/10  13:52:05  zaineb
 * Ansi Changes
 * 
 * Revision 2020.2  90/05/17  18:17:39  chan
 * *** empty log message ***
 * 
 * Revision 2020.1  89/10/06  15:06:41  bettina
 * 2.20
 * 
 * Revision 2010.2  89/09/26  23:32:06  lai
 * added wrapper
 * 
*/
#endif
