	NAME	SPCKEY
	INCLUDE	PAGESIZE.INC
	TITLE	.SPCKEY - Special key code filter
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	FKEYS:WORD,	LSADDR:WORD,	NBUF:BYTE,	TOPLIN:WORD
	EXTRN	MODSIZ:WORD,	SFKEYS:WORD

	PUBLIC	SPKPWR,	SPKSSV,	SPKRES,	SPKSTO,	SPKRCL,	SPK3UP,	SPK3DN
SPKEYS=	7

SPK	LABEL	WORD			; General function table
SPKPWR	DW	118*256			; Reset IRMA		Ctrl-PgDn
SPKSSV	DW	114*256			; Screen save to disk	Ctrl-PrtSc
SPKRES	DW	119*256			; Become resident	Ctrl-Home
SPKSTO	DW	117*256			; Store screen		Ctrl-End
SPKRCL	DW	 79*256			; Recall screen		     End
SPK3UP	DW	 13*256			; Goto Mod-3 TOP	Ctrl-UP^
SPK3DN	DW	 12*256			; Goto Mod-3 BOTTOM	Ctrl-DNv

SPKJTAB	LABEL	WORD
	DW	OFFSET CODE:SRESET	; This table must match the order
	DW	OFFSET CODE:SSAVE	; and length of the SPK table above.
	DW	OFFSET CODE:BERES	;
	DW	OFFSET CODE:STO		;
	DW	OFFSET CODE:RCL		;
	DW	OFFSET CODE:MOD3UP	;
	DW	OFFSET CODE:MOD3DN	;

SMERR$	DB	"Select memory for RECALL ",0
SMEWW$	DB	"Select memory for STORE ",0
SMEXX$	DB	"Memory update in progress ",0

DATA	ENDS

CODE	SEGMENT	PUBLIC
	ASSUME	CS:CODE
	EXTRN	RESET:NEAR,	SAVESC:NEAR,	RESMAN:NEAR,	UPDRST:NEAR
	EXTRN	STORE:NEAR,	RECALL:NEAR,	MESSAGE:NEAR,	BIOSKY:NEAR

	PUBLIC	SPCKEY
SPCKEY	PROC	NEAR
	JC	SPCK0		; No key was gotten, check none
	JMP	XKILL		; 

SPCK0:	XOR	BX,BX		;
	MOV	CX,SPKEYS	; Count of individually decoded functions

SPCK1:	CMP	AX,SPK[BX]	; Is this a match?
	JNZ	SPCK2		; Yes!

	JMP	SPKJTAB[BX]	; Run away to Tahiti if vector table is bogus

SPCK2:	ADD	BX,2		; Point to next item
	LOOP	SPCK1		; Until no items!

SFKCHK:	CMP	AX,84*256	; Is it less than SHIFT F1
	JC	XOK		; Yes, skip the CTRL Fn key check
	CMP	AX,94*256	; Is it less than SHIFT F10 +1
	JNC	FKCHK		; No, check the ctrl function keys 
	JMP	ASFKY		; Yes, add a shift function key 

FKCHK:	CMP	AX,094*256	; Is it less than CTRL F1?
	JC	XOK		; Yes, let it pass
	CMP	AX,104*256	; Is it less then CTRL F10 +1
	JC	AFKY		; Yes, add a function key

XOK:	CMP	NBUF,0		; This is normal
	JZ	XOK1		;

	MOV	NBUF,0		; Force back to the normal screen
	CALL	UPDRST		; And show it all

XOK1:	STC			; Nothing special, return
	RET			; All ok
	PAGE
SRESET:	CALL	RESET		; Poke the slave
	CALL	UPDRST		; Reset screen update routine
	JMP	XKILL		;
	
SSAVE:	CALL	SAVESC		; Dump the screen to disk
	JMP	XKILL		;

BERES:	CALL	RESMAN		; Become resident
	JMP	XKILL		;

STO:	MOV	SI,OFFSET SMEWW$; Write to screen memory
	CALL	SME		; Display select message

	PUSH	AX		;
	MOV	SI,OFFSET SMEXX$;
	MOV	DI,LSADDR	;
	CALL	MESSAGE		;
	POP	AX		; Recover the memory select character

	CALL	STORE		;
	JMP	XKILL		;

RCL:	MOV	SI,OFFSET SMERR$; Read from screen memory
	CALL	SME		; 

	CALL	RECALL		;
	JMP	XKILL		;
	PAGE
MOD3UP:	MOV	TOPLIN,0	; Reset pointer to TOS
	CALL	UPDRST		; Reset screen update
	JMP	XKILL		;

MOD3DN:	MOV	AX,MODSIZ	; Buffer offset to DOWN
	MOV	TOPLIN,AX	; Offset of new top line of screen 
	CALL	UPDRST		;
	JMP	XKILL		;

AFKY:	CALL	UPDRST		; Reset screen update routine

	SUB	AH,94		; Make AH zero based key number
	MOV	BL,AH		; Put in place as a key index
	XOR	BH,BH		;
	SHL	BX,1		; Word size offsets

	MOV	AX,FKEYS[BX]	; Get the key mode and state
	INC	AL		; Move to next state

	SUB	AH,AL		; This will be zero if time to reset
	JNZ	NOFKW		; Not time to wrap function key number

	MOV	AL,AH		; Zero the function key

NOFKW:	MOV	BYTE PTR FKEYS[BX],AL ; Change the function key mode

	JMP	XKILL		; And supress the key

XKILL:	CLC			; Pretend there was no key
	RET			;

ASFKY:	CALL	UPDRST		; Reset screen update routine

	SUB	AH,84		; Make AH zero based key number
	MOV	BL,AH		; Put in place as a key index
	XOR	BH,BH		;
	SHL	BX,1		; Word size offsets

	MOV	AX,SFKEYS[BX]	; Get the key mode and state
	INC	AL		; Move to next state

	SUB	AH,AL		; This will be zero if time to reset
	JNZ	NOSFKW		; Not time to wrap function key number

	MOV	AL,AH		; Zero the function key

NOSFKW:	MOV	BYTE PTR SFKEYS[BX],AL ; Change the function key mode

	JMP	XKILL		; And supress the key

SPCKEY	ENDP

SME	PROC	NEAR		;
	MOV	DI,LSADDR	;
	CALL	MESSAGE		;
	MOV	AH,0		;
	INT	16H		; BIOS keyboard call
	RET			;
SME	ENDP

CODE	ENDS

	END
	