	NAME	INIT
	INCLUDE	PAGESIZE.INC 
	TITLE	.INIT - Set up display and screen segment
;
; 4-27-85 Added support for Hercules Monochrome Graphics card - [KA]
; 2-7-85  Final changes to INIT for IRMAvision - JSC
; 1-22-85 Modified SETMON to include IRMAvision - JSC
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	EQPFLG:WORD,	MONOFLG:BYTE,	CRTBASE:WORD,	PRVATR:BYTE
	EXTRN	CTTCUR:WORD,	COLORS:BYTE,	MONB26:BYTE
	EXTRN	OPSC:DWORD,	PREFLG:BYTE,	VPARM:BYTE,	OTICK:BYTE
	EXTRN	NOFILE:BYTE,	FCB0:BYTE,	SLVERR:BYTE,	FILEBUF:BYTE
	EXTRN	RESFLG:BYTE,	VMODE:BYTE,	OKBD:DWORD,	MEMTAB:BYTE
	EXTRN	LSADDR:WORD,	SCANCK:BYTE,	NBUF:BYTE,	RBUF:BYTE
	EXTRN	MAXMEM:WORD,	TTYPE:BYTE,	HORB26:BYTE,	COMRUN:BYTE
	EXTRN	RESQIK:BYTE,	MACHINE:BYTE,	ATFLAG:BYTE,	ALTEXIT:BYTE
	EXTRN	SCRNMOD:BYTE,	INITMOD:BYTE,	STATLIN:WORD,	SCRN_SEG:WORD
	EXTRN	ALTMOD3:BYTE	; [KA]
	
IVERR$	DB	13,10,"This USER CUSTOMIZED version of E78 requires that"
	DB	13,10,"the IRMAvision display adapter be active.",13,10
	DB	"$"
PATTERN	DB	55H, 0AAH, 0FH, 0F0H, 0FFH, 0, 37H	;Memory check array
NUM_PAT	EQU	$-PATTERN				;Size of PATTERN array	
DATA	ENDS

CSTACK	SEGMENT	STACK 'DGROUP'		; Used internal to E78I
CSTACK	ENDS

MEMTOP	SEGMENT	PUBLIC 'DGROUP'
MEMTOP	ENDS

SCREEN	SEGMENT AT 0B00H		; Dummy segment
SCREEN	ENDS
	
CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	PRINTSC:FAR,	CACHEIN:NEAR,	UPDRST:NEAR,	UPDHBR:NEAR
	EXTRN	SVMODE:NEAR,	TICKER:FAR,	SETTYPE:NEAR,	KYINSTL:NEAR
	EXTRN	COMINIT:NEAR,	IOK:WORD,	RESMAN:NEAR,	IRMAFIL:NEAR
	EXTRN	BEEP:NEAR

	PUBLIC	INIT
INIT	PROC	NEAR
	MOV	AX,DATA		; Set up the segment registers
	MOV	DS,AX		;
	CLI			; Don't allow interrupts yet
	CALL	IV_CHK		; Check for IRMAvision
	STI			; Allow interrupts now
	JNC	INIT0		; No errors, continue
	JMP	INIT9		; Error, exit
	
INIT0:	MOV	AX,0FFFFH	; Point ES to the correct place
	MOV	ES,AX

	MOV	AL,ES:[0EH]	; Load the Machine ID Code from memory address
	MOV	MACHINE,AL	; Save the ID in RAM

	CALL	MACHINE_ID	; Check for Valid machine type

	MOV	AX,CODE		; Setup for fetching header info
	SUB	AX,10H		; Point just before code segment
	MOV	ES,AX		;

	MOV	SLVERR,0	; Clear any previous exit errors.

	MOV	AX,ES:[2]	; Get the maximum memory size
	MOV	MAXMEM,AX	;
	
	PUSH	ES
	CALL	IRMAFIL		; INITIALIZE THE SHIFT KEYS BUFFER
	POP	ES

	CMP	NOFILE,1	; Have files already been turned off?
	JNZ	IN1		; No, this must be first entry
	JMP	NIF		; Yes, we are resident w/o files

IN1:	MOV	NOFILE,1	; Assume no save file supplied

	MOV	CL,ES:[80H]	; Get count of chars on tail
	MOV	NBUF,0		; Init the buffer request count
	XOR	BX,BX		; Init an offset into the command tail

GARGL:	CMP	CL,0		; Are we at the end of the line?
	JZ	EOIL		; Yes, End Of Input Line

	MOV	AL,ES:[81H][BX]	; Get the next character from the input line

GULP:	INC	BX		; Point to next char
	DEC	CL		; Count off the characters
	JZ	EOIL		; If no more chars after this, who cares...

	CMP	AL,'/'		; Is this the start of a switch?
	JNZ	GARGL		; No, try the next character

	MOV	AL,ES:[81H][BX]	; Get the switch character
	SUB	AL,'0'		; Check for less than digit
	JC	GULP		; Is less than digit, not interesting

	CMP	AL,9+1		; Is it above the ASCII digits?
	JNC	GULP		; Yes, not interesting

	MOV	NBUF,AL		; Post the request
	JMP	GULP		; And continue

EOIL:	MOV	AL,ES:[5DH]	; Get first char of %1 filename
	CMP	AL," "+1	; Is it a space or control char?
	JC	NIF		; Yes, do not mess with the file

	XOR	DI,DI		; Main file control block
	MOV	CX,12		; Length of 'important' area
MFCB:	MOV	AL,ES:[DI][5CH]	; Get a byte from the FCB
	MOV	FCB0[DI],AL	; Put it in the internal FCB
	INC	DI		;
	LOOP	MFCB		; Move the important FCB parts (Drive & name)

	MOV	AH,0FH		; DOS open file
	MOV	DX,OFFSET FCB0	;
	INT	21H		;
	CMP	AL,0		; Was this a success?
	JZ	OF1		; Yes, set file positon

	MOV	AH,16H		; DOS CREATE file
	MOV	DX,OFFSET FCB0	;
	INT	21H		; DOS call
	CMP	AL,0		; Test for error
	JZ	OF1		;

	MOV	SLVERR,SE$BF	; Bad file error
	JMP	SHORT NIF	; Continue remainder of init

OF1:	MOV	WORD PTR FCB0[0EH],1 ; Set record length to 1 byte

	MOV	AH,1AH		; Set FTA to FILEBUF
	MOV	DX,OFFSET FILEBUF
	INT	21H		;

	MOV	NOFILE,0	; Enable disk file I/O

	MOV	AX,WORD PTR FCB0[16] ; Position file to END
	MOV	BX,WORD PTR FCB0[18] ;

	MOV	CX,BX		     ; Is this a zero length file?
	OR	CX,AX		     ;
	JZ	NIF		     ; Yes, file position is OK

	SUB	AX,1		     ; Overwrite an existing EOF
	SBB	BX,0		     ;
	MOV	WORD PTR FCB0[33],AX ; by setting random record pointer
	MOV	WORD PTR FCB0[35],BX ; to filesize
	PAGE
NIF:	CLI			; Disable interrupts during INT init

	XOR	AX,AX		; Set ES to point to interrupt vectors
	MOV	ES,AX		;

	MOV	BX,ES:WORD PTR (5*4) ; Get existing print screen routine
	MOV	CX,ES:WORD PTR (5*4+2)
	MOV	WORD PTR OPSC[0],BX ; Save 'em
	MOV	WORD PTR OPSC[2],CX

	MOV	ES:WORD PTR (5*4), OFFSET PRINTSC ; New print screen routine
	MOV	ES:WORD PTR (5*4+2),CS ;  SEG PRINTSC 

	MOV	BX,ES:WORD PTR (1CH*4)	; Existing clock tick service routine
	MOV	CX,ES:WORD PTR (1CH*4+2)
	MOV	WORD PTR OTICK[0],BX
	MOV	WORD PTR OTICK[2],CX

	MOV	ES:WORD PTR (1CH*4),OFFSET TICKER ; Response time timer
	MOV	ES:WORD PTR (1CH*4+2),CS ; SEG TICKER

	STI			; Re-enable interrupts after vector mush

	TEST	RESFLG,255	; Are we somewhat resident?
	JNZ	RESGO		; Yes, do not upset the keyboard vector

	MOV	AH,4		; See if IRMA E78 is already resident
	INT	16H		; PRIMITIVE KEYBOARD INTERRUPT
	XOR	AX,IOK[0]	; Check for exact match of IRMAOk
	XOR	BX,IOK[2]	;
	XOR	CX,IOK[4]	;
	OR	CX,BX		; Accumulate all the answer
	OR	CX,AX		; If CX is zero, E78 is already here...
	JZ	NO2		; If so, use appropriate keyboard

	MOV	BX,ES:WORD PTR (16H*4+0) ; Get address of keyboard handler
	MOV	CX,ES:WORD PTR (16H*4+2) ; (Same as normal bios for non-res)
	MOV	WORD PTR OKBD[0],BX
	MOV	WORD PTR OKBD[2],CX
	JMP	SHORT RESGO	;

NO2:	MOV	WORD PTR OKBD[0],DI ; Get address specified by resident 
	MOV	WORD PTR OKBD[2],SI ;

	MOV	PREFLG,1	; Previous emulator still active flag

	PUSH	ES		; Do not damage whatever is in ES

	MOV	AH,6		; Get pointer to existing buffer table
	INT	16H		; Use the absolute keyboard entry
	MOV	AL,TYPE MEMTE	; Size of MEMTE structure
	MOV	CL,MAXBUF	; Maximum number of screen save buffers
	MUL	CL
	MOV	CX,AX		; CX = (MAXBUF+1) * TYPE MEMTE

	XOR	SI,SI		; Offset into local buffer
	ADD	SI,TYPE MEMTE	; Skip structure 0
	ADD	BX,TYPE MEMTE	; Skip structure 0 in resident also
NO2A:	MOV	AL,ES:[BX]	; Get one byte from the resident
	MOV	MEMTAB[SI],AL	; Into the local storage
	INC	SI		;
	INC	BX		; Point to next entrys
	LOOP	NO2A		; Loop for all nine screen save buffers,
;				; Structure 0 initialized below.
	POP	ES		;

RESGO:	XOR	AX,AX		; Get pointer to video parameter table
	MOV	ES,AX		;

	MOV	BX,ES:[74H]	; Low order piece
	MOV	CX,ES:[76H]	; High order part
	MOV	ES,CX		; VPARM init table is at ES:BX

	MOV	DI,AX		; DI = 0, as index to VPARM destination

	MOV	CX,VPL*CNVPL	; Once per byte of setup table

VPLD:	MOV	AL,ES:[BX][DI]	; Get a system byte
	MOV	VPARM[DI],AL	; And save it away locally
	INC	DI		; Point to next location
	LOOP	VPLD		; Continue VPARM load

	MOV	CX,MAXBUF	; Count of possible screen memorys
	XOR	BX,BX		; Offset into MEMTAB
	ADD	BX,TYPE MEMTE	; Skip structure 0
	XOR	AL,AL		; Count of resident buffers

RALL0:	CMP	MEMTAB.MFLG[BX],0 ; Is this an unallocated buffer
	JZ	RALL1		; Yes, do not count as pre-existing

	INC	AL		; Count the resident buffer

RALL1:	ADD	BX,TYPE MEMTE	; Point to the next memory table entry
	LOOP	RALL0		;

	MOV	RBUF,AL		; Save a copy of the resident buffer count
	CMP	AL,NBUF		; How does this compare with user request?
	JC	NALL
	JMP	QEQPT		; NBUF is equal or less than resident

NALL:	SUB	NBUF,AL		; Remove counts of resident buffers

NALL0:	MOV	BL,NBUF		; Make the segment of a buffer
	XOR	BH,BH		;

	MOV	CL,8		; Multiply BX * 100H
	CMP	INITMOD,2	; Is IRMAvision active ?
	JLE	NALL5		; No, jump
	INC	CL		; Yes, then multiply BX by 512
NALL5:	SHL	BX,CL		; BX is now number of paragraphs req'd
				; for NBUF 4K or 8K buffers
	ADD	BX,MEMTOP	; Segment of top of memory in use
	CMP	BX,MAXMEM	; Compare against physical max
	JNAE	NALL1		; Memory size Ok, allocate the buffers

	DEC	NBUF		; Not enough memory, try one less buffer
	JNZ	NALL0		; Try the process again

	MOV	SLVERR,SE$MEM	; Out of memory, panic
	JMP	QEQPT		; Skip the allocation stuff

NALL1:	XOR	BX,BX		; Offset into allocation table
	ADD	BX,TYPE MEMTE	; Skip structure 0
	MOV	DX,MEMTOP	; Segment of first buffer
	MOV	CX,MAXBUF	; Maximum entrys in table

	MOV	AL,NBUF		; Calculate the total buffer count
	ADD	RBUF,AL		;

NALL2:	CMP	MEMTAB.MFLG[BX],0 ; Is this a free entry?
	JNZ	NALL3		; No, try the next one

	MOV	MEMTAB.MFLG[BX],ME$AVL ; Set the available flag
	MOV	WORD PTR MEMTAB.MEMADR[BX][0],0 ; Offset of buffer 
	MOV	WORD PTR MEMTAB.MEMADR[BX][2],DX; Segment of buffer

	PUSH	ES		; Zero the buffer
	PUSH	CX		; 

	MOV	ES,DX		; Get segment of buffer
	XOR	DI,DI		; Offset within buffer
	MOV	CX,4096		; Number of words in buffer
	CMP	INITMOD,2	; Is IRMAvision active?
	JG	NALL6		; Yes, then 8K buffers in use
	SHR	CX,1		; No, then init 4K buffer
NALL6:	XOR	AX,AX		; A convienient zero

	REP	STOSW		; Null fill the buffer

	POP	CX		; Restore major loop count & ES
	POP	ES		;

	ADD	DX,100H		; Segment of next local 4K buffer
	CMP	INITMOD,2	; Is IRMAvision active?
	JLE	NALL4		; No, jump (stay with 4K buffer)
	ADD	DX,100H		; Segment of next local 8K buffer
NALL4:	DEC	NBUF		; Are there any more buffers?
	JZ	QEQPT		; No, we are done, go find out abt equip.

NALL3:	ADD	BX,TYPE MEMTE	; Point to next table entry
	LOOP	NALL2		;

;	If loop falls through, there is a mistake in the buffer count
;	numbers.  This is not at all fatal however, and is ignored.

QEQPT:	MOV	NBUF,0		; Clear NBUF, don't display screen save memory 
	CMP	RESQIK,0	; Are we going resident immediately
	JNE	QRS		; No.

	INT	11H		; Get equipment flags
	MOV	EQPFLG,AX	; Save the internal copy

	CMP	ALTMOD3,1	; Is this a Hercules card [KA]
	JE	M80		; Force monochrome setup if yes [KA]

	AND	AX,M$IVMD	; Strip out initial video mode
	CMP	AX,V$M80	; Is it monochrome?
	JZ	M80		; Yes, do monochrome setup

	CALL	SETCLR		; No, color setup
	JMP	SHORT ALL	;

M80:	CALL	SETMON		; 
	
ALL:	MOV	AL,0		; Set current display page to zero
	MOV	AH,5		;
	INT	10H		; BIOS video call

	CALL	UPDRST		; Reset the screen update routine

QRS:	MOV	AL,TTYPE	; Get terminal type
	CALL	SETTYPE		; And make sure IRMA knows...

	TEST	RESFLG,0FFH	; If RESIDENT do not re-enter to eat keys!
	JNZ	NOEAT		;

EATCH:	MOV	AH,0BH		; Remove any type ahead
	INT	21H		; DOS character status check
	CMP	AL,0		;
	JZ	NOEAT		; No characters remain to be eaten

	MOV	AH,7		; DOS get character w/o echo
	INT	21H		;
	JMP	EATCH		;

NOEAT:	CALL	KYINSTL		; Enable the super-keyboard

	CMP	RESQIK,0	; Should the RESMAN do his thing?
	JE	NOQRS		; No, skip the call

	CALL	RESMAN		; Set flags to make this thing resident

NOQRS:	CMP	COMRUN,0	; Are COM1: inputs desired?
	JZ	NONCOM		; No, do not turn on the interrupts

	CALL	COMINIT		; Enable comm activity

NONCOM:	CLC			; Clear error indicator
INIT9:	RET
	PAGE
SETCLR	PROC	NEAR		; Set color display parameters
	MOV	MONOFLG,MF$C 	; Color display scan type
	MOV	SCANCK,1	; Require scan checking during update
	
	MOV	AX,CV$SEG	; Set screen segment (ES)
	MOV	ES,AX		;
	MOV	SCRN_SEG,AX	; Store it away for later use also

	MOV	CRTBASE,CRT$C	; Base address of CRT controller

	CALL	CACHEIN		; Save the current screen

	MOV	ALTEXIT,0	; Indicate that init in progress
	MOV	AL,3+128	; 80x25 COLOR - 26 line format
	MOV	VMODE,AL	; Store it for VIDEON
	MOV	MEMTAB.MSMODE[0],AL ; Set store and recall screen mode
	MOV	MEMTAB.MSRMOD[0],0  ; Clear Screen MOD also
	CALL	SVMODE		;
	CMP	AL,26		; Did I get my 26 line or not?
	JE	SETCL0		; Yes, do not turn off HORB26

	MOV	HORB26,1	; Turn off the 26 line jugglers

SETCL0:	MOV	AL,COLORS	; Get default screen color setting
	MOV	PRVATR,AL	; Into main attribute list
	
	CMP	HORB26,0	; Is this a short screen
	JNZ	L0A		; Yes, do not do bar & line 26

	CALL	UPDHBR		; Turn on the horizontal bar

	CMP	LSADDR,((25-1)*80)+1 ; Are we just starting up?
	JAE	L0A		; No, skip status line bump

	ADD	LSADDR,80	; Move the status line down one

	MOV	MONB26,0	; Turn off the monochrome bar faker

L0A:	RET

SETCLR	ENDP

SETMON	PROC	NEAR		; Set color display parameters
	MOV	MONOFLG,MF$M 	; MONO display scan type

; SCANCK is assumed 0 unless preset by the user for some specific reason.
; therefore... DO NOT DISTURB

;	MOV	SCANCK,0	; No scan check required during update
	
	MOV	AX,MC$SEG	; Set screen segment (ES)
	MOV	ES,AX		;
	MOV	SCRN_SEG,AX	; Store it away for later use also
	MOV	CRTBASE,CRT$M	; Base address of CRT controller

	CALL	CACHEIN		; Save the current screen
	MOV	ALTEXIT,0	; Indicate that init in progress
	MOV	AL,INITMOD	; Initialize SCRNMOD to INITMOD
	MOV	SCRNMOD,AL
	MOV	MONB26,0	; Assume IRMAvision - Turn off Horz bar faker
	CMP	SCRNMOD,2	; Are we displaying IRMAvision MOD 2?
	JNE	CKMOD3		; No - check for MOD 3
	MOV	AL,27H		; Put VMODE in AL
	MOV	LSADDR,(26-1)*80+1 ; Init Status line screen address
	JMP	SHORT SMEXIT	; Go set video mode and exit

CKMOD3:	CMP	SCRNMOD,3	; Are we displaying IRMAvision MOD 3?
	JNE	CKMOD4		; No - check for MOD 4
	MOV	AL,67H		; Put VMODE in AL
	MOV	LSADDR,(34-1)*80+1 ; Init Status line screen address
	JMP	SHORT SMEXIT	; Go set video mode and exit

CKMOD4:	CMP	SCRNMOD,4	; Are we displaying IRMAvision MOD 4?
	JNE	CKMOD5		; No - check for MOD 5
	MOV	AL,0A7H		; Put VMODE in AL
	MOV	LSADDR,(45-1)*80+1 ; Init Status line screen address
	JMP	SHORT SMEXIT	; Go set video mode and exit

CKMOD5:	CMP	SCRNMOD,5	; Are we displaying IRMAvision MOD 5?
	JNE	STANDARD	; No - assume standard monochrome
	MOV	AL,0E7H		; Put VMODE in AL
	MOV	LSADDR,(29-1)*132+1 ; Init Status line screen address
	JMP	SHORT SMEXIT	; Go set video mode and exit
STANDARD:
	MOV	MONB26,1	; Turn on Horzontal bar faker
	MOV	LSADDR,(25-1)*80+1 ; Init Status line screen address
	MOV	AL,7		; 80x25 Monochrome - 26 line mode
SMEXIT:	MOV	VMODE,AL	;
	MOV	MEMTAB.MSMODE[0],AL ; Set store and recall screen mode
	MOV	AL,SCRNMOD
	MOV	MEMTAB.MSRMOD[0],AL ; Set Screen MOD for screen 0 also
	MOV	AL,VMODE	; SVMODE needs VMODE in AL on entry
	CALL	SVMODE		;
	CMP	SCRNMOD,0	; Is IRMAvision active?
	JE	SMOUT		; No - exit
	CALL	UPDHBR		; Yes - turn on horizontal bar
SMOUT:
	RET
SETMON	ENDP

MACHINE_ID	PROC	NEAR

	MOV	AL,MACHINE
	CMP	AL,0FCH		; Is this a PC/AT
	JNE	EXIT

	MOV	ATFLAG,0FFH	; Set the AT flag if it is
EXIT:	RET

MACHINE_ID	ENDP
;
; IV_CHK - routine to determine if the IRMAvision board is needed in a
; system. If it is then a check is made for the board.  An error message
; is displayed if this version of E78 uses the IRMAvision board and it 
; is not present.  A simple voting algorithm is used to determine if IV
; is in the PC.  This check is necessary in order to avoid any possible
; damage to the IBM Monochrome display adapter board by initializing the
; 6845 with values that its support circuitry is not designed to handle.
;
IV_CHK	PROC	NEAR		; Check if IRMAvision needed
	CMP	INITMOD,0	; Is IRMAvision active?
	JZ	IV_CHK8		; No, exit
	INT	11H		; Check BIOS Equipment
	CLI			; Do not allow interrupts
	AND	AX,M$IVMD	; Mask Video Display Type bits
	CMP	AX,V$M80	; Is the Monochrome Display active?
	JNZ	IV_ERR		; No, report error
;
; Now check to see if the Monochrome board is an IRMAvision board.
; IRMAvision has exactly 8k memory.
;
	ASSUME	DS:DATA, ES:SCREEN
	MOV	AX,MC$SEG	; Establish screen seg addressability
	MOV	ES,AX
	MOV	DI,8192-1	; Max memory on IV
	MOV	SI,OFFSET PATTERN  ; Memory check pattern
	XOR	AL,AL		; Clear success vote counter
	MOV	CX,NUM_PAT	; Number of patterns to check
IV_CHK1:
	MOV	AH,[SI]		; Get a pattern
	INC	SI
	MOV	ES:[DI],AH	; Put it in IV memory
	MOV	BH,ES:[DI]	; Read it back
	CMP	AH,BH		; Are they the same?
	JNE	IV_CHK2		; No, check next pattern
	INC	AL		; Yes, vote for IV
IV_CHK2:
	LOOP	IV_CHK1		; Check next pattern	
	CMP	AL,NUM_PAT/2+1	; Do we have a majority vote for IV?
	JL	IV_ERR		; No, report error
	INC	DI		; Point just past max IV memory
	MOV	SI,OFFSET PATTERN  ; Memory check pattern
	XOR	AL,AL		; Clear success vote counter
	MOV	CX,NUM_PAT	; Number of patterns to check
IV_CHK3:
	MOV	AH,[SI]		; Get a pattern
	INC	SI
	MOV	ES:[DI],AH	; Put it in IV memory
	MOV	BH,ES:[DI]	; Read it back
	CMP	AH,BH		; Are they the same?
	JE	IV_CHK4		; Yes, check next pattern
	INC	AL		; No, vote for IV
IV_CHK4:
	LOOP	IV_CHK3		; Check next pattern	
	CMP	AL,NUM_PAT/2+1	; Do we have a majority vote for IV?
	JL	IV_ERR		; No, report error
IV_CHK8:
	CLC			; Clear CF to indicate no errors	
	RET

IV_ERR:
	CMP	RESFLG,2	; Is the emulator resident?
	JNE	IV_ERR1		; Report error message thru DOS
	CALL	BEEP		; Else BEEP to indicate error
	JMP	SHORT IV_ERR9	; Set error indicator and exit

IV_ERR1:
	MOV	SLVERR,0	; Clear Global error, we indicate our own
	MOV	DX,OFFSET IVERR$
	MOV	AH,9		; Print error string
	INT	21H		; through DOS
IV_ERR9:
	STC			; Set CF to indicate short exit
	RET
IV_CHK	ENDP

INIT	ENDP
CODE	ENDS
	END
