	NAME	DISKING
	INCLUDE	PAGESIZE.INC
	TITLE	.DISKING - Disk procedures and ops, SAVESC, PUTDSK
SCREEN	SEGMENT AT 0B000H	; Dummy segment
SCREEN	ENDS

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	NOFILE:BYTE,	SLVERR:BYTE,	RESFLG:BYTE
	EXTRN	FILEBUF:BYTE,	FCB0:BYTE
	EXTRN	SCRN_SEG:WORD,	DISLIN:BYTE,	COLROW:WORD
	EXTRN	
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	GETCHAR:NEAR

	PUBLIC	SAVESC
SAVESC	PROC	NEAR
	TEST	NOFILE,1	; Is there anyone to talk to?
	JNZ	SAV20		; No, skip the fun.
	ASSUME	DS:DATA, ES:SCREEN
	MOV	AX,DATA		; Establish segment registers
	MOV	DS,AX
	MOV	AX,SCRN_SEG
	MOV	ES,AX
	XOR	SI,SI		; Offset into screen segment
	MOV	DH,DISLIN	; Number of lines on display
	DEC	DH		; Minus Status line
	
SSC14:	MOV	CX,COLROW	; Number of chars per line
SSC15:	CALL	GETCHAR		; Get a char from ES:[SI]
	PUSH	DX		; Save line count
	CALL	PUTDSK		; Put the char to the disk file
	POP	DX		; Restore line count
	LOOP	SSC15		; Loop for an entire line
	CALL	SCRLF		; Else send <cr><lf>
	DEC	DH		; Decrement line count
	JNZ	SSC14		; If nonzero do next line
	
	RET			; Normal exit

SAV20:	MOV	SLVERR,NF$ND	; No file active, non-fatal error
	TEST	RESFLG,255	; WE ARE RESIDENT?
	JZ	SAV21		; No, the first message was correct...

	MOV	SLVERR,NF$RS	; Not allowed when resident..
SAV21:	RET			; All done..!

SCRLF	PROC	NEAR		; Put a CRLF out to the disk file
	PUSH	DX		;
	PUSH	CX		; Save a few critical registers
	MOV	AL,15Q		; LF
	CALL	PUTDSK		;
	MOV	AL,12Q		; CR
	CALL	PUTDSK		;
	POP	CX		;
	POP	DX		;
	RET			;

SCRLF	ENDP

SAVESC	ENDP
	PAGE
	PUBLIC	PUTDSK
PUTDSK	PROC	NEAR
	MOV	FILEBUF,AL	; Put the character into the file buffer

	MOV	AH,1AH		; Set FTA just in case...
	MOV	DX,OFFSET FILEBUF
	INT	21H		;

	MOV	AH,22H		; DOS random file write
	MOV	DX,OFFSET FCB0	;
	INT	21H		;

	INC	WORD PTR FCB0[33] ; Point to the next record
	JNZ	PUT0		

	INC	WORD PTR FCB0[35] ; Carry.

PUT0:	CMP	AL,0		; Was the write successful?	
	JZ	PUT1		;

	MOV	SLVERR,SE$WE	; Set write error status

PUT1:	RET

PUTDSK	ENDP

CODE	ENDS

	END
