#include <sys/types.h>
#include <sys/param.h>
#include "sainode.h"
#include <sys/sysmacros.h>
#include "dk.h"
#include "phinf.h"


extern struct diskq nrtable[];
/* rtptr - pointer to original table rtable 
   nrtptr - pointer to new table nrtable
 */
struct diskq *
splitq (rtptr, nrtptr)
register struct diskq * rtptr; register struct diskq * nrtptr;
{
	register struct diskq * prvrtptr;
	register short * p;
	register numsec, i,j,k, samehd ;
	int totbyte, rembyte;


	if ( rtptr->bcnt <= BLKSIZE ) {
		*nrtptr = *rtptr;
		nrtptr++;

		if ( nrtptr == ( (struct diskq *)&nrtable[MAXBLK] ))
			return ((struct diskq *)-1);
		return (nrtptr);
	}

	/* check if all sectors lie within same head */
	numsec = (rtptr->bcnt + BLKSIZE-1)/BLKSIZE;
	samehd = 1;
	for ( i=0, k=0; i< numsec; i++) {
		if((rtptr->phyinfo.cylhs[i].cyl == rtptr->phyinfo.cylhs[i+1].cyl) &&
			(rtptr->phyinfo.cylhs[i].head==rtptr->phyinfo.cylhs[i+1].head) && (i< 17)) {
			samehd++;
		}
		else {
			nrtptr->blkno = rtptr->blkno;	
			for (j = 0; j< samehd; j++, k++)  {
				nrtptr->phyinfo.cylhs[j].cyl = rtptr->phyinfo.cylhs[k].cyl;
				nrtptr->phyinfo.cylhs[j].head = rtptr->phyinfo.cylhs[k].head;
				nrtptr->phyinfo.cylhs[j].sect = rtptr->phyinfo.cylhs[k].sect;
			}
			if ( samehd != 18 )  {
				nrtptr->phyinfo.cylhs[samehd].cyl = -1;
				nrtptr->phyinfo.cylhs[samehd].head = -1;
			}


			nrtptr->addr = rtptr->addr;
			totbyte = samehd * BLKSIZE;

			/* incase of parital blk */
			if ( totbyte > rtptr->bcnt )
				nrtptr->bcnt = rtptr->bcnt;
			else
				nrtptr->bcnt = totbyte;

			/* remain count & new offset */
			rtptr->blkno += samehd;
			rtptr->bcnt -= nrtptr->bcnt;
			rtptr->addr += nrtptr->bcnt;
			nrtptr++;
			if ( nrtptr == ( (struct diskq *)&nrtable[MAXBLK] ))
				return ((struct diskq *)-1);

			samehd = 1;
		}
	}

	/* check the last one if partial blk */
	prvrtptr = nrtptr -1 ;

	numsec = prvrtptr->bcnt / BLKSIZE;
	rembyte = prvrtptr->bcnt % BLKSIZE;
	if ( rembyte ) {
		/* create new req */
		nrtptr->blkno = prvrtptr->blkno + numsec;
		nrtptr->phyinfo.cylhs[0].cyl = prvrtptr->phyinfo.cylhs[numsec].cyl;
		nrtptr->phyinfo.cylhs[0].head = prvrtptr->phyinfo.cylhs[numsec].head;
		nrtptr->phyinfo.cylhs[0].sect = prvrtptr->phyinfo.cylhs[numsec].sect;
		nrtptr->phyinfo.cylhs[1].cyl = -1;
		nrtptr->phyinfo.cylhs[1].head = -1;

		nrtptr->addr = prvrtptr->addr + (numsec*BLKSIZE);
		nrtptr->bcnt = rembyte;

		/* fix up the orginial one */

		prvrtptr->phyinfo.cylhs[numsec].cyl = -1;
		prvrtptr->phyinfo.cylhs[numsec].head = -1;
		prvrtptr->bcnt -= rembyte; 

		nrtptr++;
		if ( nrtptr == ( (struct diskq *)&nrtable[MAXBLK] ))
			return ((struct diskq *)-1);

	}
	return (nrtptr);
}



