#setjmp, longjmp
#
#	longjmp(a, v)
#causes a "return(v)" from the
#last call to
#
#	setjmp(v)
#by restoring all the registers and
#adjusting the stack
#
#jmp_buf is set up as:
#
#	_________________
#	|	pc	|
#	-----------------
#	|	d2	|
#	-----------------
#	|	...	|
#	-----------------
#	|	d7	|
#	-----------------
#	|	a2	|
#	-----------------
#	|	...	|
#	-----------------
#	|	a7	|
#	-----------------

	global setjmp,longjmp
	text

setjmp:
	mov.l	4(%sp),%a0	#pointer to jmp_buf
	mov.l	(%sp),(%a0)		#pc
	movm.l	&0xFCFC,4(%a0)	#d2-d7, a2-a7
	clr.l	%d0		#return 0
	rts

longjmp:
	mov.l	4(%sp),%a0	#pointer to jmp_buf
	mov.l	8(%sp),%d0	#value returned
	mov.l	44(%a0),%d1	#load old fp for comparison
	cmp.l	%d1,%fp		#compare current frame ptr & old fp
	beq.b	L1%		#if the same call, don't restore regs
	movm.l	4(%a0),&0xFCFC	#restore d2-d7, a2-a7
L1%:
	mov.l	(%a0),(%sp)		#restore pc of call to setjmp to stack
	tst.l	%d0		#value returned ?= 0
	bne.b	L2%		#no then send it back
	mov.l	&1,%d0		#else make it 1
L2%:	rts
