/* This logical disk device driver is intended for stand-alone use only. */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "sainode.h"
#include "dk.h"
#include "misc.h"
#include "globlvars.h"
#include "maps.h"
#include "vreg.h"
#include "icb.h"
#include "icbcmd.h"
#include "cpu.h"
#include "sysconf.h"
#include "saio.h"
#include "phinf.h"


#define SECTSIZE	1024
#define REQLIMIT	(255 * SECTSIZE)	/* maximum bytes per request */

#define ERRMSG 1
#define PRETTYPRINT

struct devq diskrq = 0;
struct devq *rqptr; 
extern devreq();
extern struct slot_info *dev_slot[4];
struct slot_info *dm_slot;
int intword;
extern int	debugrq;		/* pretty printing for disk requests */


char *dkcodes[] = {				/* from hsdterror.h */
	"can't write to system sector",
	"illegal disk/tape dq command or invalid data in request",
	"invalid sector number",
	"disk not formatted",
	"invalid system sector information in sector 0-17",
	"drive not ready",
	"0",
	"no such logical drive",
	"physical drive out of range",
	"invalid data in reg",
	"illegal byte count in request",
	"skip track table is full",
	"invalid skip track list",
	"hit alternate sector with id = -1 or id contains invalid sector",
	"too many sectors",
	"hit alternate sector",
	"data CRC error",
	"SEEK error during SEEK",
	"ready change, device check error, or cylinder not on",
	"cannot rezero during retry",
	"0",
	"header id error",
	"0",
	"overrun",
	"0",
	"0",
	"0",
	"header search",
	"timeout on r/w",
	"wrong gap on r/w sector or r/w id",
	"abnormal termination",
	"0",
};

 
struct dkinf phydr[MAXDRIVE];

/* always read from logical drive : minor (io->i_unit)
 */

rpopen(io)
struct iob *io;
{
	int pdrive,board;
	
	pdrive = (io->i_unit >> 4) & 0xf;	/* cjk 880603 */
	board = (io->i_unit >> 8) & 0x3;	/* cjk 880603 */

	if((dm_slot = dev_slot[board]) == (struct slot_info *)0)
		return(-1);

	return (0);
}


rpstrategy(io,func) register struct iob *io; 
int func; 
{
	int totcnt;


	totcnt = rpstart(io,func);


	return(totcnt);
}

rpstart(io,func)
register struct iob *io;
int func;
{
	register int	 board;
	int		 i;
	register char 	*cptr;
	register char	blkbuf[SECTSIZE];


/*	HSDT has a maximum limit of 255 sectors per request.		*/
/*	Currently no stand alone code asks for more, so we reject	*/
/*	any requests for more than 255 sectors				*/

	if ( io->i_cc   > REQLIMIT ) {
		printf("rpstart: too many bytes requested (%d).\n", io->i_cc);
		printf("limit is %d bytes per request.\n", REQLIMIT);
		return(-1);
	}

					/* temp kludge */
	if ( io->i_cc & 0x3ff ) {
		printf("rpstart: byte requests must be a multiple of 1024\n");
		return(-1);
	}

	for(i=0,cptr = (char *)&diskrq;i<sizeof diskrq;i++,cptr++)
		*cptr = 0;

	rqptr = &diskrq;

	board = (io->i_unit >> 8) & 0x3;	/* cjk 880603 */

	dm_slot = dev_slot[board];

	rqptr->q_devtype = DISK;
	rqptr->q_cmd = (func == READ) ? LREAD : LWRITE;

	rqptr->q_devnum	=  (io->i_unit & 0xff);	/* ldisk num / cjk 880603 */
	rqptr->q_devun.block =  io->i_bn;	/* logical block to start at */
	rqptr->q_count =  io->i_cc;		/* number of bytes to read   */
	rqptr->q_key = (unsigned)io;
	rqptr->q_extdtb  = XDDFLT;

			/* convert buffer address from logical to physical */

	rqptr->q_mem = (char *)conl2p(io->i_ma);

	/* hsdt can only handle requests to buffers on long word boundaries */

	if ( (int)rqptr->q_mem & 0x3 ) {
		printf("buffer must be on a long word boundary\n");
		return(-1);
	}

	if ( debugrq )		 /* pretty print parts of the  devq struct */
		rqprint(rqptr);

			/* rqptr->rc1 and rqptr->rc2 are both unsigned chars */

	if(((intword = devreq(dm_slot,rqptr)) != 0) || *(short *)&(rqptr->rc1)){

		printf("disk error: iw = %x, unit = %x, bn = %x, rc = %x\n",
		  intword, io->i_unit, io->i_bn + (rqptr->q_count/1024),
		  *(short *)&(rqptr->rc1));

		if ( rqptr->rc1 )
			printf("%s\n",dkcodes[rqptr->rc1 - ERRMSG]);
		if ( rqptr->rc2 )
			printf("%s\n",dkcodes[rqptr->rc2 - ERRMSG]);

		io->i_error = *(short *)&(rqptr->rc1);

		return(-1);
	}

	return(rqptr->q_count);
}


rpinit(drive,type)
register int drive;
{
	return(0);
}


conl2p(addr)
unsigned long addr;
{
	register short *maploc; register short pagenum;

	/*get page number from map */

	maploc = (short *)(SMAP(addr));

	pagenum = (*maploc) & 0x0fff;

	/* physical address at 1k boundary plus offset */

	addr = (pagenum << 12) + (addr & 0x0fff);

	return(addr);
}


rpioctl(pdrive,cmd,addr)
register int pdrive;
register int cmd;
register unsigned addr;
{

	short retcode;
	struct devq *rqptr;
	long *lptr;
	int i;
	char *cptr;
	struct icbcmdhdr ich;
	unsigned int bootsect;

	for(i=0, cptr = (char *) &diskrq; i < sizeof diskrq; i++, cptr++)
		*cptr = 0;
	rqptr = &diskrq;

	rqptr->q_devtype = DISK;
	dm_slot = dev_slot[((pdrive >> 4) & 0x3)];	/* cjk 880603 */
	pdrive &= 0xf;					/* cjk 880603 */

	switch(cmd){

		case INIT:
			rqptr->q_cmd = cmd;
			rqptr->q_devnum = pdrive;
			break;

		case SWAPDEV:
			rqptr->q_cmd = cmd;
			rqptr->q_devnum = pdrive;
			devreq ( dm_slot, rqptr );
			retcode = *(short *)&(rqptr->rc1);
			lptr = (long *)addr;
			*lptr++ = rqptr->q_count;
			*lptr = (long)rqptr->q_mem;
			return(0);
			break;

		case PHSPARE:
			rqptr->q_cmd = cmd;
			rqptr->q_devnum = pdrive;
			lptr = (long *)addr;
			rqptr->q_devun.block = *lptr++;
			rqptr->q_mem = (char *) *lptr++;
			rqptr->q_count = *lptr;
			devreq (dm_slot,  rqptr );
			retcode = *(short *)&(rqptr->rc1);
			return(retcode);
			break;

		case HWSPARE:
			rqptr->q_cmd = cmd;
			rqptr->q_devnum = pdrive;
			rqptr->q_devun.block = *(long *)addr;
			devreq ( dm_slot, rqptr );
			retcode = *(short *)&(rqptr->rc1);
			return(retcode);
			break;

		case NEXTRVSEC:
			rqptr->q_cmd = cmd;
			rqptr->q_devnum = pdrive;
			devreq ( dm_slot, rqptr );
			retcode = *(short *)&(rqptr->rc1);
			if(retcode) return(-1);
			else{
				lptr = (long *)addr;
				*lptr = rqptr->q_devun.block;
				return(0);
			}
			break;

		case UNSPARE:
			rqptr->q_cmd = cmd;
			rqptr->q_devnum = pdrive;
			lptr = (long *)addr;
			rqptr->q_devun.block = *lptr++;
			rqptr->q_count = *lptr;
			rqptr->q_mem = 0;
			devreq (dm_slot,  rqptr );
			retcode = *(short *)&(rqptr->rc1);
			return(retcode);
			break;

		default:
			printf("invalid i/o control call\n");
			return(-1);
			break;
	}
	devreq ( dm_slot, rqptr );
	retcode = *(short *)&(rqptr->rc1);

	if(retcode) return(-1);
	else return(0);

}
