#	%W%
#	.page
#-----------------------------------------------------------------------------
#
#	M I S C
#
#-----------------------------------------------------------------------------

	global	addupc
	global	spl0,spl1,spl2,spl3,spl4,spl5,spl6,spl7
	global	splhi,splx
	global	bcopy,bzero
	global	icbcpy

	text
#-----------------------------------------------------------------------------
#
#	A D D U P C
#
#	update program counter profile
#
#	input parameters:
#		1.  pc
#		2.  &u.u_prof
#		3.  profile increment
#
#-----------------------------------------------------------------------------

#_addupc:
#	movl	a7@(8),a0		| &u.u_prof
#	movl	a7@(4),d0		| pc
#	subl	a0@(8),d0		| pc = pc - offset
#	blts	addret
#	movl	a0@(12),d1		| get scale
#	lsrl	#1,d0			| divide pc by 2
#	lsrl	#1,d1			| and scale
#	mulu	d1,d0			| divide by scaler
#	asrl	#7,d0			| adjust decimal point
#	asrl	#7,d0
#	addql	#1,d0
#	bclr	#1,d0			| word boundary
#	cmpl	a0@(4),d0		| within profile buffer?
#	blts	addret			| no.
#	addl	a0@,d0			| add buffer base
#	movl	d0,a1
#	movl	a7@(12),d0		| profile increment
#
#||||||	addw	d0,a1@			| bump profile

#addret:
#	rts

#-----------------------------------------------------------------------------
#	WARNING, the following assumes fuisui dont change parameters
#
#		the decimal adjust shift can probably be optimized with 'swap'
#
#	A D D U P C
#
#	update program counter profile
#
#	input parameters:
#		1.  pc
#		2.  &u.u_prof
#		3.  profile increment
#
#-----------------------------------------------------------------------------

addupc:
	mov.l	8(%sp),%a0		# &u.u_prof
	mov.l	4(%sp),%d0		# pc
	sub.l	8(%a0),%d0		# pc = pc - offset
	blt.b	addret%
	mov.l	12(%a0),%d1		# get scale
	lsr.l	&1,%d0			# divide pc by 2
	lsr.l	&1,%d1			# and scale
	mulu	%d1,%d0			# divide by scaler
	#	asrl	#7,d0			| adjust decimal point
	#	asrl	#7,d0			|			SLOW
	rol.l	&2,%d0
	mov.l	&3,%d1
	and.w	%d1,%d0
	swap	%d0			# rotate 2; clear;swap does shift 14
	addq.l	&1,%d0
	bclr	&0,%d0			# word boundary
	cmp.l	%d0,4(%a0)		# within profile buffer?
# the following branch is unsigned??
	bgt.b	addret%			# no.
	add.l	(%a0),%d0			# add buffer base
# the following six instructions can be used if
# the addw d0,a0@ potential busserror can be handled
	#	bset	#31,d0			| magic space
	#	movl	d0,a0			| histo slot addr
	#	movw	sp@(14),d0		| prof incr
	#	addw	d0,a0@			| bump profile slot
	#	tstl	_bus_error
	#	bnes	adc_berr
					#| remove if above is used
	mov.l	%d0,%a0			#| histo slot addr
	subq.l	&4,%sp			#| room for suword arg
	subq.l	&2,%a0			#| make prof slot lower two bytes
	mov.l	%a0,-(%sp)			#|
	jsr	fuword			#|
	add.w	22(%sp),%d0		#| bump profile slot
	mov.l	%d0,4(%sp)		#|
	jsr	suword			#|
	addq.l	&8,%sp			#|
	mov.l	&-1,%d1			#|
	cmp.l	%d0,%d1			#|
	beq.b	adc_berr%		#|
addret%:
	rts
adc_berr%:
	clr.l	bus_error
	mov.l	8(%sp),%a0		# prof buf
	clr.l	12(%a0)			# disable profile more or less
	rts
#	.page
#-----------------------------------------------------------------------------
#
#	S Y S T E M    P R I V I L E G E    L E V E L S
#
#-----------------------------------------------------------------------------

spl0:
	mov.w	%sr,%d0		# previous level
	and.w	&0xf8ff,%sr
	rts

spl1:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0100,%d1
	mov.w    %d1,%sr
	rts

spl2:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0200,%d1
	mov.w    %d1,%sr
	rts

spl3:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0300,%d1
	mov.w    %d1,%sr
	rts

spl4:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0400,%d1
	mov.w    %d1,%sr
	rts

splhi:
spl5:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0500,%d1
	mov.w    %d1,%sr
	rts

spl6:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0600,%d1
	mov.w    %d1,%sr
	rts

spl7:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0700,%d1
	mov.w    %d1,%sr
	rts

splx:
	mov.w	6(%sp),%d0
	and.w	&0x0700,%d0
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	%d1,%d0
	mov.w	%d0,%sr
	rts

#------------------------------------------------------------------
#
#	B C O P Y
#
#	bcopy(source, destination, count)
#
#------------------------------------------------------------------

bcopy:
	mov.l	4(%sp),%a0		# source
	mov.l	8(%sp),%a1		# destination
	mov.l	12(%sp),%d0
	beq.b	bc090%			# zero count
	mov.l	%a0,%d1
	or.l	8(%sp),%d1
	and.l	&1,%d1			# word aligned
	beq.b	bc030%

bc005%:
	subq.l	&1,%d0

bc010%:
	mov.b	(%a0)+,(%a1)+
	dbvs	%d0,bc010%
bc090%:
	rts
bc030%:
	mov.l	%d0,%d1
	lsr.l	&5,%d1
	beq.b	bc005%			# less than 32 bytes left
	subq.l	&1,%d1			# don't do last 32 bytes in a page
	beq.b	bc005%
bc050%:					# do move multiple for 3x
	movm.l	&0x3f3c,-(%sp)		# save registers
	mov.l	&32,%d2
	mov.l	%a1,%d3			# d3 tracks a1
	subq.l	&1,%d1			# adjust for -1 termination
bc060%:
	movm.l	(%a0)+,&0x3cf0
	movm.l	&0x3cf0,(%a1)
	add.l	%d2,%d3
	mov.l	%d3,%a1
	dbvs	%d1,bc060%
	movm.l	(%sp)+,&0x3cfc		# restore registers
	mov.l	%d0,%d1
	lsr.l	&5,%d1
	subq.l	&1,%d1			# last 32 bytes of a page
	lsl.l	&5,%d1
	sub.l	%d1,%d0
	bne.b	bc005%			# some less than 32 left
	rts	
	

#------------------------------------------------------------------
#
#	B Z E R O
#
#	bzero(address, count)
#
#------------------------------------------------------------------

bzero:
	mov.l	4(%sp),%d1		# address
	mov.l	8(%sp),%d0		# count
	add.l	%d0,%d1
	mov.l	%d1,%a0
	mov.l	&0,%a1
bz010%:
	mov.l	%a0,%d1
	and.l	&1,%d1
	beq.b	bz020%			# word boundary
	clr.b	-(%a0)
	subq.l	&1,%d0
	bne.b	bz020%
	rts
bz020%:
	mov.l	%d0,%d1
	lsr.l	&5,%d1			# see if 32 bytes left
	beq.b	bz023%			# no
	subq.l	&1,%d1			# don't do last 32 bytes of a page
	beq.b	bz023%
	lsl.l	&5,%d1
	sub.l	%d1,%d0			# adjust # of bytes left
	lsr.l	&5,%d1
	subq.l	&1,%d1
	movm.l	&0xbf00,-(%sp)		# save d0,d2-d7 registers
	clr.l	%d0
	clr.l	%d2
	clr.l	%d3
	clr.l	%d4
	clr.l	%d5
	clr.l	%d6
	clr.l	%d7
bz022%:
	movm.l	&0xbf40,-(%a0)		# use a1,d0,d2-d7
	dbvs	%d1,bz022%
	movm.l	(%sp)+,&0x00fd		# restore regs
bz023%:
	mov.l	%d0,%d1			# check if any long words 
	lsr.l	&2,%d1
	beq.b	bz025%
	subq.l	&1,%d1
bz024%:
	mov.l	%a1,-(%a0)			# clear long words
	dbvs	%d1,bz024%
bz025%:
	and.l	&3,%d0
	beq.b	bz090%			# check if 1 to 3 bytes left
bz030%:
	clr.b	-(%a0)
	subq.l	&1,%d0
	bra.b	bz025%
bz090%:
	rts
#------------------------------------------------------------------
#
#	I C B C P Y
#
#	icbcpy(source, destination, count)
#
#------------------------------------------------------------------

icbcpy:
	mov.l	4(%sp),%a0		# source
	mov.l	8(%sp),%a1		# destination
	mov.l	12(%sp),%d0
	beq.b	ic090%			# zero count
	mov.l	%a0,%d1
	or.l	8(%sp),%d1
	and.l	&1,%d1			# word aligned
	beq.b	ic030%

ic005%:
	subq.l	&1,%d0

ic010%:
	mov.b	(%a0)+,(%a1)+
	nop				# pad for after possible
	nop				# bus error.
	nop
	dbvs	%d0,ic010%
ic090%:
	rts
ic030%:
	mov.l	%d0,%d1
	lsr.l	&5,%d1
	beq.b	ic005%			# less than 32 bytes left
	subq.l	&1,%d1			# don't do last 32 bytes in a page
	beq.b	ic005%
ic050%:					# do move multiple for 3x
	movm.l	&0x3f3c,-(%sp)		# save registers
	mov.l	&32,%d2
	mov.l	%a1,%d3			# d3 tracks a1
	subq.l	&1,%d1			# adjust for -1 termination
ic060%:
	movm.l	(%a0)+,&0x3cf0
	nop				# pad for after possible
	nop				# bus error.
	nop
	movm.l	&0x3cf0,(%a1)
	nop				# pad for after possible
	nop				# bus error.
	nop
	add.l	%d2,%d3
	mov.l	%d3,%a1
	dbvs	%d1,ic060%
	movm.l	(%sp)+,&0x3cfc		# restore registers
	mov.l	%d0,%d1
	lsr.l	&5,%d1
	subq.l	&1,%d1			# last 32 bytes of a page
	lsl.l	&5,%d1
	sub.l	%d1,%d0
	bne.b	ic005%			# some less than 32 left
	rts	

#	.end
