/*
 *	R T B    S T A T U S    R E G
 */

#define IOP_BASE(n)  (0x600000 + (n << 16))

#define RTB(n) (0x60fffc + (n << 16))
#define RTB_I(n) (0x60fffe + (n << 16))
#define RTB_D(n) (0x60fffa + (n << 16))


#define RTB_RCVD 0x8000
#define RTB_PNDG 0x4000
#define RTB_IBUSY(n) ((n >> 15) & 0x1)	/* cpu interrupt iocp, bit set */
#define RTB_OBUSY(n) ((n >> 14) & 0x1)	/* iocp interrupt cpu, bit set */
#define RTB_DBUSY(n) ((n >> 13) & 0x1)


#define RTB_TYPE(n) ((n >> 8) & 0x1f)
#define RTB_TAS 0x0080
#define RTB_PERR 0x0040
#define RTB_PROM 0x0020
#define RTB_SLOT(n) (n & 0x1f)
#define SLOTS 0x20

/*
 *	R T B    I N T E R R U P T    R E G
 */

#define RTB_RST 0x8000
#define RTB_NMI	0x4000
#define RTB_VI  0x2000
#define RTB_CHAN(n) ((n >> 8) & 0x7)
#define RTB_COMM(n) (n & 0xff)

#define SLOTNUM		19
/*
 *	board types
 */

#define MCPU_BDTY	0
#define SCPU_BDTY	1
#define DMC_BDTY	2
#define DTC_BDTY	3
#define ASP_BDTY	4
#define HSDT_BDTY	5

/*
 *	board vectors
 */

#define DTCVEC	av1
#define DMCVEC	av2
#define MCPUVEC	av3
#define ASPVEC	av4
#define SCPUVEC	av5

union rtb {
	struct {
		unsigned short r_stat;
		unsigned short r_int;
	} rtbw;
	struct {
		char r_stathi;
		char r_statlo;
		char r_inthi;
		char r_intlo;
	} rtbb;
};

struct autovec {
	struct autovec *a_next;		/* next */
	union rtb *a_rtb;		/* rtb */
	int (* a_int)();		/* interrupt handler */
	unsigned short boardty;
};

