
#define MAXDRIVE	16	/* Maximum number of drives(4 per board)*/
#define LOGDRIVE	0x10	/* # of logical drive per physical drive */
#define RVDRIVE		1	/* # of reserved drives per physical drive */
#define SECSIZE		0x400	/* # of bytes in a sector */


#define PHYS	2		/* disk r/w command with c,h,s */

/* bit define in dkflag */
#define RAW	0x1
#define OWN	0x2


/* structure of spare table */
struct cylhdsec
{	unsigned short	cyl;	
	unsigned char head;
	unsigned char sect;
	unsigned short	mcyl;	
	unsigned char mhead;
	unsigned char msect;
};

struct logsize
{	unsigned long logsoff;
	unsigned long nblocks;
};


/* struct of logical drive table */
struct logdr
{
	struct logsize dksize[2];
};

struct	logtype {
	uint	ld_strt;/* starting sector # of log drive */
	uint	ld_size;/* size of log drive */
	char	ld_type;/* 1=unix file system */
			/* 2=swap area */
			/* 3=customer data file system */
			/* 4=power fail,memory dump area */
	unsigned char	ld_mirror; /* mirror logical disk num */

	unsigned char	mirtype;	/* 1=master (has mirror drive) */
				/* 2=slave (mirror of other drive) */
	char dum[5];
};

/* information of each disk drive */
struct dkinf
{
	ushort	cyldisk;		/* # of cylinders per disk */
	unsigned char headcyl;		/* # of heads per cylinder */
	unsigned char sechead;		/* # of sectors per head */
	ushort	seccyl;			/* # of sectors per cylinder */
	ushort	bytesec;		/* # of bytes per sector */

	unsigned char inlognum;		/* # of internal log drive */

	struct logsize rvlog;		/* reserved log drive table */
	struct logtype inlog[LOGDRIVE];		/* internal log drive table */


};


struct cyhd {
	short	cyl;
	char	head;
	char	sect;
};

struct diskq {
	int	blkno;
	union{
		struct	cyhd cylhs[18];
		int physblk[18];
	}phyinfo;
	char *addr;
	int	bcnt;
};

/* ****************** */
/* layout of sector 0 */
/* ****************** */


struct sector0
{
	char	id[8];		/* INIT name */
	char	date[8];	/* format date */
	ushort	dummy[4];
	ushort	cyldisk;	/* # of cyls on the disk */
	unsigned char	headcyl;	/* # of heads per cyl */
	unsigned char	sechead;	/* # of sectors per head */
	ushort	seccyl;		/* # of sectors per cyl */
	ushort	bytesec;	/* # of bytes per sector */

	unsigned char	gap[32];	/* timing data */

	unsigned char 	pd_ldmaxnum;	/* max num of log drive */
	unsigned char	pd_ldnum;	/* current num of log drive */
	unsigned char	dum[14];

	uint	nextsec;	/* next log sector num available 
					for disk spare tbl, media list */

	long	unused1[107];
	uint	rv_strt;	/* starting sect # of resversed drive */
	uint	rv_size;	/* length of resvered drive */
	uint	dummy2[2];
	struct	logtype logdrive[LOGDRIVE];
	long	unused2[60];
};

/* *************************** */
/* byte offset into sector 2 for spare information */
#define spr_numoff	4
#define spr_altoff	6
#define spr_addoff	0x20		/* physical sect num */

