#include "iospace.h"
#define RDCMD 3
#define WRCMD 4
#define FMTCMD 0x0d
#define INITCMD 0x0e
#define DISK 1
#define RETRYCOUNT 3
#define TRUE 1
#define FALSE 0
#define ESCAPE 0x1b
#define BUSFLAG (char *)(iospace + 0x800)
#define SECTSIZ 1024
#define TBUFSIZ (30 * SECTSIZ)  /* 30k track buffer */

/* sector id */
struct SectId {
	unsigned short Cylinder;
	unsigned char Head;
	unsigned char Sector;
};

/* disk request buffer */
struct DiskRequest {
	char ReqDevice;	/* z80 device - DISK */
	char ReqOperation; /* operaton */
	char ReqDrive; /* drive #: log/physical */
	char ReqFlag; /* flag byte */
	char *ReqBPAddress; /* bp address */
	unsigned ReqBCount; /* total bytes cnt */
	struct SectId ReqSector; /* block number on unit */
	char *ReqAddress; /* memory address */
	unsigned ReqMemsize; /* byte cnt */
	unsigned ReqChksum;
}; 

/* disk return buffer */
struct DiskReturn {
	char	RetDevice;
	char	RetOperation;
	short	RetCode;
	char *	RetBPAddress;
	unsigned RetBCount;		/* num of bytes performed */
};

/* error structure */
struct ErrInfo {
	unsigned PassNum;
	struct SectId SectNum;
	unsigned ErrType;  /* 0 = compare error */
	unsigned BytNum;  /* or in the case of a disk error -- intword */
	unsigned Pattrn;
	unsigned SoftErrCount; /* number of soft occurrances */
	unsigned HardErrCount; /* number of hard occurrances */
	unsigned BadValue;  /* bad compare value (return code) */
};

struct LogDrvInfo { /* logical drive information */
	unsigned StartSect;
	unsigned SSize;
	unsigned ContSect;
	unsigned ContSize;
};

struct DriveInfo {
	char CoName[5]; /* company name */
	char unused1[5];
	char FmtDate[6]; /* format date */
	char unused2[8];
	unsigned short CylsPerDrive;
	unsigned char HeadsPerCyl;
	unsigned char SctsPerTrack;
	unsigned short SectsPerCyl;
	unsigned short BytesPerSect;
	unsigned char ResDrvs; /* number of reserved logical drives */
	unsigned char LogDrvs; /* number of logical drives */
	char unused3[478]; /* rest of first half k */
	struct LogDrvInfo LogDrive[32]; /* logical drive information */
};

struct SpareInfo { /* sector sparing structure */
	struct SectId BadSect;
	struct SectId AltSect;
};

struct SpareList {
	unsigned TableLength; /* number of sectors in bytes for complete table */
	unsigned SprsAllowed; /* number of spares allowed */
	unsigned short NumSpared; /* number of entries currently in table */
	unsigned SpareStart; /* logical sector number of sparing area */
	unsigned NextSpare; /* next available sector in sparing area */
	char unused1[18];
	struct SpareInfo SpareTable[124];
};


struct BadList {
	char ID[4];
	unsigned NumOfEntries;
	struct SectId BadSctrInfo[254];
}; 
