#include "scsi_ccpu.h"
#include "scsi.h"
#include "disk_struct.h"
#include "scsitape.h"
#include "scsi_dtc.h"
#include "devcmd.h"
#include "scsidata.h"
#include "scsi_ptm.h"
#include "scsi_error.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsiextrn.h"

struct tcmd {
	short opr; int (*io)();
};


extern int tprw(), tapepos(), trwfm();
int tapstatus();
struct tcmd taptbl[] = {
	0,	0,		/* 0 */
	TREAD,	tprw,		/* 1 */
	TWRITE,	tprw,		/* 2 */
	TREW,	tapepos,	/* 3 */
	TWFM,	trwfm,		/* 4 */
	TRFM,	trwfm,		/* 5 */
	TSTATUS,tapstatus,	/* 6 */
	TENS,	tapepos,	/* 7 */
	TERAS,	tapepos,	/* 8 */
	0,	0,		/* 9 */
	0,	0,		/* a */
	0,	0,		/* b */
	0,	0,		/* c */
	TQ11,	tapepos,	/* d */
	TQ24,	tapepos,	/* e */
};

	
taparse(dev)
register struct devq *dev;
{
	register unsigned short intfcard;
	register struct tcmd *p;
	register struct tp *taptr;
	register struct devq *dq;
	register rc;

	/* check to see if the tape is online */

	
	if ( dev->q_devnum >= MAX_TDRIVE ) {
		dev->rc1 = TP_NRDY;
		return(1);
	}
	taptr = &tapdr[dev->q_devnum];

	if ( (taptr->tp_type & TAPEON) == 0 ) {
		/* only check the archive tape drive if it is not online */
		if ( (intfcard = *TP_SR & TP_INFC) != TP_9TRKIF ) {
			if ( setape(dev->q_devnum,0) ) {
				dev->rc1 = TP_NRDY;
				return(1);
			}
		}
	}


	if ( taptr->tp_type & TP_ARCH ) {
		/* ******************** */
		/* archive tape command */
		/* ******************** */
	
		p =  &taptbl[dev->q_cmd];
		/* check for valid tape command */
		if ( (p->opr == 0) || (dev->q_cmd >= TOTPCMD) ) {
			dev->rc1 = TP_ILLCMD;
			return(1);
		}
	
		/* don't allow  a non long word multiple tape blk 
		   or one with a zero length or one of greater than
		   0x40000 bytes 
		*/

		if ( (dev->q_cmd == TPREAD) || (dev->q_cmd == TPWRITE) ) {
			if((dev->q_count & 3) || (dev->q_count == 0)
				|| (dev->q_count > TAPE_MAX_CNT)){
			 	dev->rc1 = TP_CNT;
				return(1);
			}


#ifndef S90
			dev->q_mem = (char *)((int)dev->q_mem >> 2);
#endif
		}

	
		/* setup archive tape cmd code */
		dev->opr = p->opr;
	
		if ( dev->rc1 == TP_HANG ) {
			printf ("p9");
			resetape(0);
			dev->rc1 = TP_RSET;
		}
		dev->q_flag |= NO_WAIT;
		return(0);
	}

	/* not archive, not 9 track */
	dev->rc1 = TP_NRDY;
	return(1);
}

tapstatus(dev)
register struct devq *dev;
{
	tstatus(dev);

	/* *********************** */
	/* get archive tape status */
	/* *********************** */
	*((short *)&dev->sectleft)= *((short *)tapdr[0].tp_stat);

	/* get type of tape in dev->q_count */
	tapetype(dev);

	return(1);
}

tapetype(dev)
register struct devq *dev;
{	register unsigned char type;
	type = tapdr[dev->q_devnum].tp_type;
	if ( type & TP_ARCH )
		dev->q_count = TP_ARCH;
	else if ( type & TP_9TRK )
		dev->q_count = TP_9TRK;
	else
		dev->q_count = 0;
}

prtbl (value, tbl)
register value; char *tbl[];
{	register i;

	for (i=0; i<8; i++) {
		if ( value & 0x80 )
			printf ("%s ", *tbl);
		tbl++;
		value = value << 1;
	}
	printf("\n");
}

ckbyte (dev, status, num, err)
register struct devq *dev;
register unsigned char status; register num; register char *err;
{
	register i;
	for (i=0; i<8; i++) {
		if ( status & 0x80 ) {
			if ( *(err+i) ) {
				if ( num == 0 )
					dev->rc1 = *(err+i);
				else
					dev->rc2 = *(err+i);
				num++;
			}
			if ( num == 2 )
				return (num);
		}
		status = status << 1;
	}
	return (num);
}
