
/*
		SCSI BUS MEMORY MAP



SCSI 1		SCSI 2		READ			WRITE


0xc00021	0xc00041	Transfer counter lo	Transfer counter lo

0xc00023	0xc00043	Transfer counter hi	Transfer counter hi

0xc00025	0xc00045	FIFO			FIFO

0xc00027	0xc00047	Command			Command

0xc00029	0xc00049	Status			Select/Reconnect Bus ID

0xc0002b	0xc0004b	Interrupt Status	Select/Reconnect timeout

0xc0002d	0xc0004d	Sequence Step		Sync. Period

0xc0002f	0xc0004f	FIFO flags		Sync. offset

0xc00031	0xc00051	Configuration		Configuration

0xc00033	0xc00053	NCR reserved		Clock conversion factor

0xc00035	0xc00055	NCR reserved		Test

0xc00081			not used		D/T controller write

*/

struct scsird{
	unsigned char dummy1;
	unsigned char xferlo;
	unsigned char dummy2;
	unsigned char xferhi;
	unsigned char dummy3;
	unsigned char fifo;
	unsigned char dummy4;
	unsigned char command;
	unsigned char dummy5;
	unsigned char status;
	unsigned char dummy6;
	unsigned char interrupt;
	unsigned char dummy7;
	unsigned char seq_step;
	unsigned char dummy8;
	unsigned char fifo_flag;
	unsigned char dummy9;
	unsigned char config;
	unsigned char dummy10;
	unsigned char dummy11;
	unsigned char dummy12;
	unsigned char dummy13;
};

struct scsiwr{
	unsigned char dummy1;
	unsigned char xferlo;
	unsigned char dummy2;
	unsigned char xferhi;
	unsigned char dummy3;
	unsigned char fifo;
	unsigned char dummy4;
	unsigned char command;
	unsigned char dummy5;
	unsigned char bus_id;
	unsigned char dummy6;
	unsigned char sel_rec_timeout;
	unsigned char dummy7;
	unsigned char sync_period;
	unsigned char dummy8;
	unsigned char sync_offset;
	unsigned char dummy9;
	unsigned char config;
	unsigned char dummy10;
	unsigned char clock_conv;
	unsigned char dummy12;
	unsigned char test_reg;
};

#define SCSI_1		(unsigned char *)0xc00020
#define SCSI_2		(unsigned char *)0xc00040


#define DT_CTRL_REG	(unsigned char *)0xc00081	/*write only*/

/* The following are the bit definitions for the d/t control register */

#define MEM_TO_SCSI	1
#define SCSI_TO_MEM	0
#define PERTEC		0
#define QIC02		0x10
#define READ_REMAINDER  2
