/*
	DISK/TAPE return code

	the following is a list of the error
	codes returned by the disk/tape driver 
	in the request buffer (ptr->rc1)
 */

 
#define DER_SYBAD	1		/* can't write to system sector */
#define DER_ILLCMD	2		/* illegal disk command */
#define DER_ISEC	3		/* invalid sector num */
#define DER_UNFORM	4		/* disk not formatted */
#define DER_SYERR	5		/* invalid system sector information */
					/* in sector 0-17 */

#define DER_NRDY	6		/* drive not ready */

#define DER_DEVCK	7		/* device check error */
#define DER_NLOG	8		/* no such logical drive */
#define DER_DRLIMIT	9		/* physical drive out of range */

#define DER_DTYPE	0xa		/* devtype is not disk or tape */
#define DER_CNT		0xb		/* illegal byte count in request */

#define DER_SKFULL	0xc		/* skip track table is full */
#define DER_SKTRK	0xd		/* invalid skip track list */

#define DER_BADALT	0xe		/* hit alternate sector with id 
					   field = -1  */
#define DER_MULS	0xf		/* too many sectors */


/* hard errors start at 010h */
#define DER_ALT		0x10		/* hit alternate sector */

#define DER_CRC		0x11		/* data CRC error */
#define DER_SEEK	0x12		/* error during SEEK */

#define DER_RDYCHG	0x13		/* ready change */

#define DER_REZERO	0x14		/* can't rezero during retry */

#define DER_CYLNON	0x15		/* not on cylinder */

#define DER_IDER	0x16		/* header ID error */

#define DER_OVR		0x18		/* overrun */
#define DER_NWR		0x1a		/* write protected*/
#define DER_MEM		0x1b		/* memory address not a long word 
					   multiple */

#define DER_HDSR	0x1c		/* header search */
#define DER_TIMEOUT	0x1d		/* timeout on rw */
#define DER_ILTIM	0x1e		/* incorrect timing values for 
					   reading/writing a sector or
					   reading/writing a sector id
					   (sector 0 should have the correct
					   timing parameters) */

#define DER_ABNOM	0x1f		/* abnormal termination */
 					/* hsdt board disk interface is hung */


#define RECOVERED_ERR		0x20
#define MEDIUM_ERR		0x21
#define HARDWARE_ERR		0x22
#define ILLEGAL_REQ		0x23
#define ABORTED_CMD		0x24
#define VOLUME_OVRFLOW		0x25
#define MISCMPR			0x26
#define INCORRECT_LENGTH_INDIC	0x27  /* invalid length in a request */
#define ENDOFMEDIA		0x28  /* a request past the end of physical
					media on the disk */
#define CHANNEL_FAILURE		0x29  /* failure of one of the two scsi 
					controller channels */




/* ***************** */
/* tape return code */
/* ***************** */

#define TP_NOTAPE	0x30	/* cartridge not in place */
#define TP_NRDY		0x31	/* tape drive not ready */
#define TP_WPROT	0x32	/* write protected */
#define TP_EOM		0x33	/* end of media */
#define TP_DATER	0x34	/* unrecoverable data err */
				/* or BIE(block in error) not located */
				
#define TP_FMD		0x35	/* file mark detected */
#define TP_NDATA	0x36	/* no data detected */
#define TP_8RETRY	0x37	/* 8 or more retries */
#define TP_BOM		0x38	/* beginning of media */
#define TP_HANG		0x39	/* tape drive is hung */

#define TP_RSET		0x3a	/* tape drive was reset */
#define TP_NONL		0x3b	/* tape not online */
#define TP_OVRUN	0x3c	/* data overrun, tapeblk is bigger than request*/
#define TP_CDATER	0x3d	/* 9 track, error during write operation */
#define TP_ILLCMD	0x3e	/* illegal tape cmd */

#define TP_INVIF	0x3f	/* invalid io interface */
#define TP_ABORT	0x40	/* tape request abort,due to ups */
#define TP_NONINE	0x41    /* no nine track tape on this controller */
#define TP_NOBRST	0x42    /* no burst id detected */
#define TP_DENS		0x43    /* invalid density selection */
#define TP_SPEED	0x44    /* invalid tape speed selection */
#define TP_MODE		0x45    /* invalid tape mode selection */
#define TP_BUSY		0x46	/* tape drive is in the process of performing
				   a read/write request */
#define TP_MEM		0x47	/* invalid main memory address */
#define TP_CNT		0x48	/* invalid byte count in request */
