#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "scsi.h"
#include "scsi_mem_map.h"
#include "commands.h"
#include "vreg.h"
#include "scsiextrn.h"
#include "data_struct.h"
#include "mode_sns_pg.h"
#include "disk_struct.h"
#include "icbcmd.h"
#include "message.h"
#include "scsi_error.h"
#include "scsiversion.h"

extern end;
extern struct devq *getptr();
extern struct free_mem *getmem();
unsigned char req_sense_error_conversion[] = {
		0x00,
		RECOVERED_ERR,
		DER_NRDY,
		MEDIUM_ERR,
		HARDWARE_ERR,
		ILLEGAL_REQ,
		0x00,
		0x00,
		0x00,
		0x00,
		0x00,
		ABORTED_CMD,
		0x00,
		VOLUME_OVRFLOW,
		MISCMPR,	
		INCORRECT_LENGTH_INDIC,
		ENDOFMEDIA,
		CHANNEL_FAILURE,
};
char ver_array[] = {'0','1','2','3','4','5',':','\0','\0','\0','\0','\0','\0','\0'};


initscsi()
{
	register struct devq *bptr, *rptr;
	register struct dev_desc *devptr;
	register unsigned short i;
	register unsigned short intfcard;
	struct bd_desc *bd, *bd_temp;
	struct format_changes *fc;


	/* following is already setup by PROM */
	/* 1. *DTB_IDR = DTC board id #, DMA channel # for HSDT */
	/* 2. *DTC_CRL = enable disk interface card, led light */
	/* 3. *DDC_CR = reset, enable disk data channel */
	/* 4. *DDC_ID0 = setup disk ID0 to 0 */
	/* 5. *DBC_CR = reset all dma */
	/* 6. *DTB_CR = reset DTB function code */
	/* 7. disk timing reg */
	/* 8. vreg information : bd_info, bd_stst, bd_icbint, bc_cpu,
			bd_dtbid, bd_xdtbid */
	/* 9. setup bd vector */

	/* check which kind of interface card */

	bd_temp = *((struct bd_desc **)BDVECT);
	bd = &bddesc;
	bd->bd_info = bd_temp->bd_info;
	bd->bd_stst = bd_temp->bd_stst;
	bd->bd_icbint = bd_temp->bd_icbint;
	bd->bd_cpu = bd_temp->bd_cpu;
	bd->bd_dtbid = bd_temp->bd_dtbid;
	bd->bd_xdtbid = XDTYPDMA | (bd->bd_dtbid-4);
	bd->bd_slot = bd_temp->bd_slot;
	ver_array[VER_SLOT] = VERNUM + 0x30;
	ver_array[VER_SLOT+1] = '.';
	ver_array[VER_SLOT+2] = RELEASE + 0x30;
	ver_array[VER_SLOT+3] = RELEASE1 + 0x30;
	*DTB_IDR=(bd->bd_dtbid << 4) | (bd->bd_xdtbid & XDIDMSK);
	bd->sysinfptr = (long *)ver_array;
	bd->bd_imcptr = (struct icbcmdhdr *)drive_pointer_array;
	bd->bd_dwnld = SCSI_DWNLD;
	*((struct bd_desc **)BDVECT) = bd;
	dtc_ctl = DKINTFEN | PROMOUT | ledoff;
	*DMA_SELECT = BANK;
	dtbbuf = (unsigned char *)DTBBUF;
	dtbarray = (unsigned char *)DTBARRAY;

	intfcard = *TP_SR & TP_INFC;
	/* clear the control register */
	dt_control = 0;
	*DT_CTRL_REG = dt_control;

	if ( intfcard == TP_9TRKIF ){
		bd->bd_ifcard = IFC_TRK9;
		dt_control |= PERTEC;
        	*(DT_CTRL_REG) = dt_control;
	}
	else if ( intfcard & TP_ARIF ){
		bd->bd_ifcard = IFC_ARCH;
		dt_control |= QIC02;
		*(DT_CTRL_REG) = dt_control;
	}
	else
		bd->bd_ifcard = IFC_DWN;
	
	bd->bd_frev	= (VERNUM<<4) | RELEASE | RELEASE1;
	bd->bd_memst	= (char *)0x11000;
	bd->bd_szmem	= 0xf000;
	bd->bd_dvptr	= devdesc;
	irqlevl	= ICBLEVL << 13;


	/* reset both chips */

	for(i=0;i<2;i++)
		reset_chip(i);

	/*reset both busses */
	for(i=0;i<2;i++)
		reset_bus(i);

	/* initialize the free list of queues to talk with the kernel */
	bd->freefst =  nq;
	setbuf (nq, sizeof(nq)>>1, 0 );
	rptr = bd->freefst;

	bptr = 0;
	for (i=0; i< NQNUM; i++) {
		rptr->q_prev = bptr;  	/* current */
		bptr = rptr;
		bptr->q_next = ++rptr;
	}
	bptr->q_next = 0;
		

	/* initialize the keyboard buffer pointer */
	init_q();

	printflag = 0;

	/* initialize the peripipheral device queues */
	for(i=0;i<NUMBER_OF_DEVICES-1;i++)
		periph_que.pt[i].next_periph_ptr = &periph_que.pt[i+1];
	periph_que.pt[NUMBER_OF_DEVICES-1].next_periph_ptr = periph_que.pt;

	for(i=0;i<NUMBER_OF_DEVICES-1;i++)
		periph1_que.pt[i].next_periph_ptr = &periph1_que.pt[i+1];
	periph1_que.pt[NUMBER_OF_DEVICES-1].next_periph_ptr = periph1_que.pt;

	/*initialize the free memory structures */
	init_mem();

	/* send interrupt back to master cpu for download code is running */
	intr_cpu ( IMEMCMD );

/*Check to see if there is a cartrige tape drive connected */

	setape(0,1);

/*and update the device structures */

	devptr = devdesc;
	if ( tapdr[0].tp_type & TAPEON ) {
		devptr->dd_type = DTTAPE;
		devptr->dd_count = 1;
		devptr->dd_un.dd_tape = tapdr;
		bd->bd_devs++;
		devptr++;
	}



/* Now go to see how many disks we have that are connected */

	bd->bd_devs++;
	check_disks(devptr);

/* Program and start the clock */

	prgclk();

}

/* Input: memory pointer
	  short word count
	  data to be placed at pointer
*/
setbuf (ptr, swcnt, data)
register *ptr; 
register int swcnt; 
register unsigned int data;
{
	register short *sptr;

	sptr = (short *)ptr;

	while ( swcnt -- )
		*sptr++ = data;
}


init_mem()
{

	register struct free_mem *p;
	register struct interim_processing_que *ip;
	register struct devq *q;
	register unsigned int numptrs,i;


	ip = &ipque;
	ip->freemem_first=(struct free_mem *)((int)MMU_TABLE_ADDR+sizeof(struct mmutbl));
	p = ip->freemem_first;
	
	numptrs = ((BANK_SIZE - ((int)p&0xffff))/BLKSIZE) -1;

	p->fm = (int *)(p + ((numptrs*sizeof(struct free_mem))>>2));
	for(i=0;i<numptrs-1;i++){
		p->fm_next = p + 1;
		p->fm_next->fm = p->fm + (BLKSIZE>>2);
		p = p->fm_next;
	}
	ip->freemem_last = p;
	p->fm_next = (struct free_mem *)0;
	
	ip->i_p_mmutable = (struct mmutbl *)MMU_TABLE_ADDR;
	ip->i_p_dqfirst = (struct devq *)ip->freemem_first->fm;
	ip->freemem_first = ip->freemem_first->fm_next->fm_next;
	for(i=0,q=ip->i_p_dqfirst;i<((2*BLKSIZE)/sizeof(struct devq))-1;i++){
		initdevq(q);
		q->q_next = q + 1;
		q = q->q_next;
	}
	ip->i_p_dqlast = q;
}

initdevq (dev)
struct devq *dev;
{
	setbuf ( dev, (sizeof (struct devq))>>1, 0 );
}

prbuf ( bufptr, wcnt)
register short *bufptr; register wcnt;
{
	printf("\n");
	while ( wcnt--) 
		printf ("%4x ", (*bufptr++)& 0xffff);
}

check_disks(devptr)
register struct dev_desc *devptr;
{
	register struct dkinf *dkptr;
	register struct devq *dev;
	register int i,k;
	char *save_and_try_later,*busy_ptr;
	struct free_mem *mem;

	data_transfer_mode = ASYNC_SYNC;

	dkptr = phydr;

	periph_que.bus_id = NO_ONE_ON_THE_BUS;
	periph1_que.bus_id = NO_ONE_ON_THE_BUS;

	/* device is disk and seekable */
	devptr->dd_type = DTDISK | DTISK;
	devptr->dd_un.dd_pdisk = (struct pd *)phydr;
	disk_pointer = devptr;


	save_and_try_later = busy_buf;
	dev = getptr();
	mem = getmem();
	printf("drives ");
	for(i=0,k=0;i<SCSI_BUSSES*NUMBER_OF_DEVICES;i++,dkptr++){
		io_counter_array[i] = &dkptr->io_bcnt;
		initdevq (dev);
		dev->q_devnum = i;
		dev->local_mem = mem;
		if(examine_the_drive(dev,dkptr)){
		    if((*(short *)&dev->rc1) == BUSY_STAT) 
			*save_and_try_later++ = i;
		}
		else{
		    printf("%d ",i);
		    devptr->dd_count++ ;
		    async_set(i);
		    k |= BIT(i);
		    if(data_transfer_mode != ASYNC)
			data_transfer_mode = (dkptr->sync_drive) ? SYNC : ASYNC;
		}
	}
	if(save_and_try_later != busy_buf){
		busy_ptr = busy_buf;
		while(busy_ptr != save_and_try_later){
			initdevq (dev);
			dev->q_devnum = *busy_ptr;
			io_counter_array[dev->q_devnum] = &phydr[dev->q_devnum].io_bcnt;
			dev->local_mem = mem;
			dkptr = &phydr[dev->q_devnum];
			if(examine_the_drive(dev,dkptr))
				printf("drive %x still not ready\n",dev->q_devnum);
			else{
		    	    devptr->dd_count++ ;
			    printf("%d ",*busy_ptr);
		    	    async_set(*busy_ptr);
			    k |= BIT(i);
		    	    if(data_transfer_mode != ASYNC)
			        data_transfer_mode = (dkptr->sync_drive) ? SYNC : ASYNC;
			}
			busy_ptr++;
		}
	}
    /* if we have gone thru all of the drives and found them all to support
	synchronous transfers, we must now perform the negotiations with each
	of them.
    */

	if(data_transfer_mode == SYNC){
		for(i=0;i<SCSI_BUSSES*NUMBER_OF_DEVICES;i++){
		    if(k & BIT(i))
			if(sync_set(i))
		/* one of the drives doesn't want to talk synchronously*/
				printf("drive %d only async\n");
		}
	}

	printf("ready\n");
	return_ptr(dev);
	return_mem(dev->local_mem);

}

examine_the_drive(dev,dkptr)
register struct devq *dev;
struct dkinf *dkptr;
{

	dev->q_cmd = REQ_SENSE;
	dev->opr = REQ_SENSE;
	dev->q_count = SENSE_DATA_LENGTH;
	dev->q_flag |= (DK_TO_LOC|WAIT|NO_DISCONNECT);
	dev->q_devtype = DISK;
	req_sense(dev);
	if(*(short *)&dev->rc1 == 0){
		if(diskopen (dev, dkptr))
			return(1);
		drive_pointer_array[dev->q_devnum] = dkptr;
		return(0);
	}
	else{
		drive_pointer_array[dev->q_devnum] = 0;
		return(1);
	}
}
