#include "extern.h"
 /* process the options */
		/* -b: binary display */
		/* -o: octal display */
		/* -d: decimal display */
		/* -x: hexidecimal display */
		/* -h: add the standalone header */
		/* -v: add the version number when you are adding the header */
procopt(ac,av)
register int ac;
register char * av[];
{
	extern int optind;
	extern char *optarg;
	register int c;
	utilname = av[0];
	if( ac < 2 )
		usage();
	while (( c = getopt(ac,av, "bodxhv:")) != EOF )
		switch(c) {
			case 'b':
				baseflag = BIN; /* binary display */
				break;
			case 'd':
				baseflag = DEC; /* decimal display */
				break;
			case 'x':
				baseflag = HEX; /* hexidecimal display */
				break;
			case 'o':
				baseflag = OCT; /* octal display */
				break;
			case 'h':
				headerflag = 1; /* add standalone header */
				break;
			case 'v':
				versionflag = 1; /* add version with header */
				version = optarg;
				break;
			case '?':
			default:
				usage();
		} /* end switch c */
	/* if version was selected but header was not */
	if(versionflag)
	{
		if(!headerflag)
			fprintf(stderr,"%s: Must use -h with -v option\n",
			utilname),usage();
		/* check to see if version is valid */
		uresult=validvers(version);
		if(uresult > 0xffff)
			fprintf(stderr,"%s: Illegal version number; too large: %s\n",
			utilname, uresult), closefile('n');
	}
	/* get the file */
	if (optind != (ac - 1))
		usage();
	filename = av[optind];
	if(access(filename,0))
		fprintf(stderr,"%s: Cannot access file %s\n",
		utilname,filename),usage();
	if(access(filename,2))
		fprintf(stderr,"%s: No write permission on file %s\n",
		utilname,filename),usage();
	if(access(av[optind],4))
		fprintf(stderr,"%s: No read permission on file %s\n",
		utilname,filename),usage();
}
